<?php

namespace Johncms;

class Subscribe
{
    protected $picks;
    
    protected $bans;
    
    protected $time;
    
    private $update = false;
    
    public function __construct() {
        #$container = \App::getContainer();
        #$this->db = $container->get(\PDO::class);
        $systemUser = \App::getContainer()->get(\Johncms\Api\UserInterface::class);
        
        $settings = unserialize($systemUser->set_forum);
        $this->picks = !is_null($settings['pick']) ? $settings['pick'] : [];
        $this->bans = !is_null($settings['ban']) ? $settings['ban'] : [];
        $this->time = $settings['reset'];
    }
    
    public function isBan($ban) {
        return in_array($ban, $this->bans) ? true : false;
    }
    
    public function isPick($pick) {
        return in_array($pick, $this->picks) ? true : false;
    }
    
    private function unBan($pick) {
        $return = [];
        foreach ($this->bans as $value) {
            if ($pick != $value) {
                $return[] = $value;
            } else {
                $this->update = true;
            }
        }
        $this->bans = $return;
    }
    
    private function unPick($ban) {
        $return = [];
        foreach ($this->picks as $value) {
            if ($ban != $value) {
                $return[] = $value;
            } else {
                $this->update = true;
            }
        }
        $this->picks = $return;
    }
    
    public function ban($ban) {
        if (!$this->isBan($ban)) {
            $this->bans[] = $ban;
            $this->update = true;
        }
        if ($this->update & $this->isPick($ban)) {
            $this->unPick($ban);
        }
    }
    
    public function pick($pick) {
        if (!$this->isPick($pick)) {
            $this->picks[] = $pick;
            $this->update = true;
        }
        if ($this->update & $this->isBan($pick)) {
            $this->unBan($pick);
        }
    }
    
    public function reset() {
        $this->time = time();
        $this->update = true;
    }
    
    private function save() {
        $container = \App::getContainer();
        $db = $container->get(\PDO::class);
        $systemUser = $container->get(\Johncms\Api\UserInterface::class);
        
        $settings['ban'] = $this->bans;
        $settings['pick'] = $this->picks;
        $settings['reset'] = $this->time;
        $array = array_merge(unserialize($systemUser->set_forum), $settings);
        $db->prepare('UPDATE `users` SET `set_forum` = ? WHERE `id` = ?')->execute([
                serialize($array),
                $systemUser->id,
        ]);
    }
    
    public function __destruct() {
        if ($this->update) {
            $this->save();
        }
    }
    
    private function getBans() {
        return count($this->bans) > 0 ? ' AND `id` NOT IN(' . implode(', ', $this->bans) . ')' : '';
    }
    
    private function getPicks() {
        return count($this->picks) > 0 ? ' AND `id` IN(' . implode(', ', $this->picks) . ')' : '';
    }
    
    private function getTime() {
        return $this->time;
    }
    
    public function where() {
        return $this->getPicks() . $this->getBans();
    }
    
    public function whereTime() {
        return $this->where() . ' AND `time` > ' . $this->getTime();
    }
}
