<?php

const _IN_JOHNCMS = 1;

$textl = 'История ников';
require('../system/bootstrap.php');
require('../system/head.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

#-----------------------------#

$view = '';

if ($systemUser->id) {
    $idUser = empty($_GET['user']) ? $systemUser->id : (int)$_GET['user'];
    
    $us = Johncms\Doc\NickUser::showNick($idUser);
    
    $listNames = !Johncms\Doc\NickUser::cnt($idUser) 
        ? '<h4 class="rmenu">Список пуст!</h4>'
        : $us->listUserNames($start, $kmess);
    
    $uri = strip_tags($_SERVER['QUERY_STRING']);
    
    if ($rights > 7) {
        $listNames .= '<div class="phdr">'. $tools->image('stack.png', 
            ['width' => '15', 'height' => '12']) .
            '<a href="admin.php?'. $uri .'">Админка</a></div>';
    }
    
    $usName = $us->userName();
    $view .= $us->showMessages();
    $view .= '<div class="phdr">История <b>'. $usName['nick'] .'</b></div>';
    
    if ($idUser != $systemUser->id) {
        $view .= $listNames;
    } else {
        $nickEdit = $us->getUserTime();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $nick = htmlspecialchars(mb_substr(trim($_POST['name']), 0, 25));
            $nickFound = $us->searchNick($nick);
            
            if (isset($_POST['ed']) && $us->setTrackedNick($nick)) {
                $_SESSION['messages'] = '<h4 class="gmenu">'.
                    'Опция отслеживания ника включена!</h4>';
            }
            
            if ($nickEdit) {
                if ($nickFound) {
                    $trackedNick = $us->getTrackedNick();
                    
                    if (!$trackedNick) {
                        $_SESSION['messages'] = include 'inc/tracking.php';
                    } elseif (empty($_SESSION['messages'])) {
                        $_SESSION['messages'] = '<div class="rmenu">Ник <b>'. 
                            $trackedNick .'</b> ещё занят! Контроль включен!'.
                            '<hr /><a style="padding-left:14px; color:red; '.
                            'font-size:9px;" href="index.php?off">Выключить'.
                            '</a></div>';
                    }
                } elseif (mb_strlen($nick) > Johncms\Doc\NickNames::ADM) {
                    $us->setMyNick($nick);
                    $_SESSION['messages'] = '<h4 class="gmenu">'.
                        'Ник успешно изменён!</h4>';
                    
                    if ($idUser > Johncms\Doc\NickNames::ADM) {
                        $them = 'Уведомление о смене ника';
                        $text = 'Пользователь [b]'. $systemUser->name .
                            '[/b] сменил ник на [b]'. $nick .'[/b]';
                        
                        $us->sendSysMail($them, $text);
                    }
                } else {
                    $_SESSION['messages'] = '<h4 class="rmenu">'.
                        'Не допустимая длина ника!</h4>';
                }
            } else {
                $_SESSION['messages'] = '<h4 class="rmenu">'.
                    'Изменение ника не доступно!</h4>';
            }
            
            header('Location: index.php');
            
        } elseif (isset($_GET['change'])) {
            if ($nickEdit) {
                $nick = $systemUser->name;
                $sub = 'hidden';
                $txt = 'hidden';
                $form = 'index.php?'. $uri;
                $view .= include 'inc/nick_edit.php';
            } else {
                $_SESSION['messages'] = '<h4 class="rmenu">'.
                    'Изменение ника не доступно!</h4>';
                header('Location: index.php');
            }
        } elseif (isset($_GET['off']) && $us->delTrackedNick()) {
            $_SESSION['messages'] = '<h4 class="rmenu">Контроль отключен!</h4>';
            header('Location: index.php');
        } elseif ($nickEdit) {
            $view .= '<div class="gmenu">'.
                '<a href="index.php?change">Изменение ника</a></div>';
        }
        
        $view .= $listNames;
    }
} else {
    $view = '<h4 class="rmenu">Только для авторизованных пользователей!</h4>';
}

include 'inc/html.php';

#-----------------------------#
require('../system/end.php');
