<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNADM') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

$config = $container->get('config')['johncms'];

// Проверяем права доступа
if ($systemUser->rights < 9) {
    header('Location: http://johncms.com/?err');
    exit;
}


echo '<div class="mainblok">';
echo '<div class="phdr"><a href="index.php"><b>' . _t('Admin Panel') . '</b></a> | ' . _t('Mail') . '</div>';

$set_mail = $config['mailReg'];
if (isset($_POST['submit'])) {
    /*
    -----------------------------------------------------------------
    Сохраняем настройки системы
    -----------------------------------------------------------------
    */
	$set_mail['cat_friends'] = isset($_POST['cat_friends']) && $_POST['cat_friends'] == 1 ? 1 : 0;
	$set_mail['message_include'] = isset($_POST['message_include']) && $_POST['message_include'] == 1 ? 1 : 0;
    $config['messageTheme'] = isset($_POST['them_message']) ? trim($_POST['them_message']) : '';
    $config['regMessage'] = isset($_POST['reg_message']) ? trim($_POST['reg_message']) : '';

	$config['mailReg'] = $set_mail;

        $configFile = "<?php\n\n" . 'return ' . var_export(['johncms' => $config], true) . ";\n";

   if (!file_put_contents(ROOT_PATH . 'system/config/system.local.php', $configFile)) {
           echo 'ERROR: Can not write system.local.php</body></html>';
           exit;
         }
        echo '<div class="rmenu">' . _t('Settings are saved successfully') . '</div>';
    }


/*
-----------------------------------------------------------------
Форма ввода параметров системы
-----------------------------------------------------------------
*/

if(empty($config['messageTheme']))
	$config['messageTheme'] = _t('Welcome');
if(empty($config['regMessage']))
	$config['regMessage'] = _t('Hi') . ", {LOGIN}\r\n" . _t('We are pleased to see you on our website.') . "\r\n" . _t('Come more often and here it will be pleasant to you.') . "\r\n" . _t('Yours faithfully, administrator.');


echo '<form action="index.php?act=mail" method="post"><div class="menu">';
// Общие настройки
echo '<h3>' . _t('System message upon registration') . '</h3>' . _t('Subject of the system message') . ':<br/>' . 
	'<input type="text" name="them_message" value="' . (!empty($config['messageTheme']) ? htmlentities($config['messageTheme'], ENT_QUOTES, 'UTF-8') : '') . '"/><br/>' .
    _t('Message') . ':<br /><textarea rows="' . $systemUser->getConfig()->fieldHeight . '" name="reg_message">' . (!empty($config['regMessage']) ? htmlentities($config['regMessage'], ENT_QUOTES, 'UTF-8') : '') . '</textarea><br />' .
	'<strong>' . _t('Send a message') . ':</strong><br />' .
	'<input type="radio" value="1" name="message_include" ' . ($set_mail['message_include'] == 1 ? 'checked="checked"' : '') . '/>&#160;' . _t('ON') . '<br />' .
    '<input type="radio" value="0" name="message_include" ' . (empty($set_mail['message_include']) ? 'checked="checked"' : '') . '/>&#160;' . _t('OFF') . '<br />' .
	'<strong>' . _t('Tags') . ':</strong><br />{LOGIN} - ' . _t('Recipient login') . '<br />{TIME} - ' . _t('Current time') . '<br />' .
	'<strong>' . _t('Friends Category') . ':</strong><br />' .
	'<input type="radio" value="1" name="cat_friends" ' . ($set_mail['cat_friends'] == 1 ? 'checked="checked"' : '') . '/>&#160;' . _t('ON') . '<br />' .
    '<input type="radio" value="0" name="cat_friends" ' . (empty($set_mail['cat_friends']) ? 'checked="checked"' : '') . '/>&#160;' . _t('OFF') . '<br />' .
	'<p><input type="submit" name="submit" value="' . _t('Save') . '"/></p></div></form>' .
    '<div class="phdr"><a href="index.php">' . _t('Admin Panel') . '</a></div>';
echo '</div>';
?>