<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

//TODO: Добавить проверку, пустой ли каталог, если нет, выводить предупреждение
//TODO: Добавить рекурсивное удаление

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

$dir_clean = opendir('../files/temp/created_zip');
while ($file = readdir($dir_clean)) {
    if ($file != 'index.php' && $file != '.htaccess' && $file != '.' && $file != '..') {
        $time_file = filemtime('../files/temp/created_zip/' . $file);
        if ($time_file < ($realtime - 300))
            @unlink('../files/temp/created_zip/' . $file);
    }
}
closedir($dir_clean);
$req_down = $db->query("SELECT * FROM `down__files` WHERE `id` = '$id' AND (`type` = 2 OR `type` = 3)  LIMIT 1");
$res_down = $req_down->fetch();
if ($req_down->rowCount() == 0 || !is_file($res_down['dir'] . '/' . $res_down['name']) || $tools->format($res_down['name']) != 'txt' || ($res_down['type'] == 3 && $systemUser->rights < 6 && $systemUser->rights != 4)) {
    require('../system/head.php');
    echo $tools->displayError('File not found<br /><a href="index.php">By category</a>');
    require('../system/end.php');
    exit;
}
if (isset($_GET['more'])) {
    $more = abs(intval($_GET['more']));
    $req_more = $db->query("SELECT * FROM `down__more` WHERE `id` = '$more' LIMIT 1");
    $res_more = $req_more->fetch();
    if (!$req_more->rowCount() || !is_file($res_down['dir'] . '/' . $res_more['name']) || $tools->format($res_more['name']) != 'txt') {
        require('../system/head.php');
        echo $tools->displayError('File not found<br /><a href="index.php">By category</a>');
        require('../system/end.php');
        exit;
    }
    $down_file = $res_down['dir'] . '/' . $res_more['name'];
    $title_pages = $res_more['rus_name'];
    $txt_file = $res_more['name'];
} else {
    $down_file = $res_down['dir'] . '/' . $res_down['name'];
    $title_pages = $res_down['rus_name'];
    $txt_file = $res_down['name'];
}
if (!$_SESSION['down_' . $id]) {
    $db->exec("UPDATE `down__files` SET `field`=`field`+1 WHERE `id`='$id'");
    $_SESSION['down_' . $id] = 1;
}
$file = '../files/temp/created_zip/' . $txt_file . '.zip';
if (!file_exists($file)) {
    require('../downloads/classes/pclzip.lib.php');
    $zip = new PclZip($file);
    function w($event, &$header) {
        $header['stored_filename'] = basename($header['filename']);
        return 1;
    }
    $zip->create($down_file, PCLZIP_CB_PRE_ADD, 'w');
    chmod($file, 0644);
}

require('../system/head.php');
echo '<div class="phdr"><b>' . $tools->checkout($title_pages) . '</b></div>';
echo '<div class="menu"><a href="' . $tools->checkout($file) . '">Download ZIP</a></div>';
echo '<div class="rmenu"><input type="text" value="' . $config['homeurl'] . '/' . $dir_load . '/' . $tools->checkout($file) . '"/><b></b></div>';
echo '<div class="phdr">File will be available for download within 5 minutes</div>';
echo '<p><a href="index.php?act=view&amp;id=' . $id . '">To File</a></p>';
?>