<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */


define('_IN_JOHNCMS', 1);
require('../system/bootstrap.php');


/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\EnvironmentInterface $env */
$env = $container->get(Johncms\Api\EnvironmentInterface::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);



$textl = 'Upload Images';
$headmod = 'upload_img';
require('../system/head.php');
$upload_file_size = 1024;

if (!is_dir(ROOT_PATH . 'files/images/')) {
    mkdir(ROOT_PATH . 'files/images');
}

if ($systemUser->isValid()) {
    if (isset($_POST['submit'])) {
        require_once ('../downloads/classes/class.upload.php');
        $handle = new upload($_FILES['imagefile']);
        if ($handle->uploaded) {
            $name_file = time() . '_' . mt_rand(100, 999);
            $handle->file_new_name_body = $name_file;
            $handle->allowed = array('image/jpeg', 'image/gif', 'image/png');
            $handle->file_max_size = 1024 * $upload_file_size;
            $handle->file_overwrite = true;
            $handle->image_convert = 'jpg';
            $handle->process('../files/images/');
            if ($handle->processed) {
            	$handle->file_new_name_body = $name_file . '_preview';
            	$GetImageSize = GetImageSize('../files/images/' . $name_file . '.jpg');
                $handle->file_overwrite = true;
                $handle->image_resize = true;
               	$handle->image_ratio_crop = true;
               	$x_ratio = 80 / $GetImageSize[0];
            	$y_ratio = 80 / $GetImageSize[1];
				if (($GetImageSize[0] <= 80) && ($GetImageSize[1] <= 80)) {
                	$handle->image_x = $GetImageSize[0];
                	$handle->image_y = $GetImageSize[1];
            	} else if (($x_ratio * $GetImageSize[1]) < 80) {
                	$handle->image_y = ceil($x_ratio * $GetImageSize[1]);
                	$handle->image_x = 80;
            	} else {
                	$handle->image_x = ceil($y_ratio * $GetImageSize[0]);
                	$handle->image_y = 80;
            	}
				$handle->image_convert = 'jpg';
				$handle->process('../files/images/');
				if ($handle->processed) {
        			echo '<div class="mainblok"><div class="phdr"><a href="img.php">Return</a> | <b>Upload Images</b></div>' .
        			'<div class="gmenu"> Image uploaded! Now you can paste it in any message on the site</div>' .
        			'<div class="menu">BBcode: <input type="text" value="[img=' . $name_file . ']" /></div>' .
        			'<div class="phdr"><a href="img.php">Return</a></div>';
				}else
					echo $tools->displayError($handle->error, '<a href="img.php">Back</a>');
			} else
                echo $tools->displayError($handle->error, '<a href="img.php">Back</a>');
			$handle->clean();
		} else {
            echo $tools->displayError('No File Selected', '<a href="img.php">Back</a>');
        }
    } else {
        echo '<div class="mainblok"><div class="phdr"> <a href="/help/?act=tags">ВВcode</a> | <b>Upload Images</b></div>' .
        '<form enctype="multipart/form-data" method="post" action="img.php?img"><div class="list1">' .
        'Choose an image:<br /><input type="file" name="imagefile" value="" />' .
        '<input type="hidden" name="MAX_FILE_SIZE" value="' . (1024 * $upload_file_size) . '" />' . '<br />' .
        '<p><input type="submit" name="submit" value="Upload" /></p></div></form>' .
        '<div class="list2"><small>File Extensions Allowed Are JPG, JPEG, PNG, GIF<br />' .
        'File Should Not Exceed ' . $upload_file_size . 'кб.</small></div>' .
        '<div class="phdr"><b>Image</b></div>';
		$array = glob('../files/images/*preview.jpg');
        $total = count($array);
        $end = $start + $kmess;
        if ($end > $total)
            $end = $total;
        if ($start >= $total) {
            $start = 0;
            $end = $total > $kmess ? $kmess : $total;
        }
        if ($total > 0) {
            for ($i = $start; $i < $end; $i++) {
            	$code = preg_replace('#../files/images/(.+?)_preview.jpg#is', '\1', $array[$i]);
            	echo ($i  % 2) ? '<div class="list2">' : '<div class="list1">';
				echo'<table width="100%" cellspacing="0" cellpadding="0"><tr valign="top"><td>' .
				'<a href="' . str_replace('_preview', '', $array[$i]) . '"><img src="' . $array[$i] . '" alt="+"  /></a></td>' .
    			'<td align="right"><input type="text" value="[img=' . $code . ']" /></td></tr></table></div>';
			}
        } else
            echo '<div class="menu">List is Empty!</div>';
        echo '<div class="phdr">Total ' . $total .  '</div>';
        if ($total > $kmess) {
            echo '<div class="topmenu">' . $tools->displayPagination('img.php?', $start, $total, $kmess) . '</div>';
            echo '<div class="phdr"><form action="img.php" method="post"><input type="submit" value="' . _t('Go to') . ' &gt;&gt;"/></form></div>';
        }

		echo '<div class="phdr"><a href="/help/?act=tags">ВВcode</a></div></div>';
    }
} else {
    header('location: /login.php');
}
require('../system/end.php');