<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

/** @var Johncms\Api\EnvironmentInterface $env */
$env = $container->get(Johncms\Api\EnvironmentInterface::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

$act = isset($_REQUEST['act']) ? trim($_REQUEST['act']) : '';
$headmod = isset($headmod) ? $headmod : '';
$textl = isset($textl) ? $textl : $config['copyright'];
$keywords = isset($keywords) ? htmlspecialchars($keywords) : $config->meta_key;
$descriptions = isset($descriptions) ? htmlspecialchars($descriptions) : $config->meta_desc;

$db->exec("UPDATE `users` SET $sql `total_on_site` = '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '" . $config->botida . "'");
$db->exec("UPDATE `users` SET $sql `total_on_site` = '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '" . $config->botidb . "'");
$db->exec("UPDATE `users` SET $sql `total_on_site` = '$totalonsite', `lastdate` = " . time() . " WHERE `id` = '" . $config->botidc . "'");

echo '<!DOCTYPE html>' .
    "\n" . '<html lang="' . $config->lng . '">' .
    "\n" . '<head>' .
    "\n" . '<meta charset="utf-8">' .
    "\n" . '<meta http-equiv="X-UA-Compatible" content="IE=edge">' .
    "\n" . '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=yes">' .
    "\n" . '<meta name="HandheldFriendly" content="true">' .
    "\n" . '<meta name="MobileOptimized" content="width">' .
    "\n" . '<meta content="yes" name="apple-mobile-web-app-capable">' .
    "\n" . '<meta name="Generator" content="JohnCMS, http://johncms.com">' .
    "\n" . '<meta name="keywords" content="' . $keywords . '">' .
    "\n" . '<meta name="description" content="' . $descriptions . '">' .
    "\n" . '<link rel="stylesheet" href="' . $config->homeurl . '/theme/' . $tools->getSkin() . '/style.css">' .
    "\n" . '<link rel="shortcut icon" href="' . $config->homeurl . '/favicon.ico">' .
    "\n" . '<link rel="alternate" type="application/rss+xml" title="RSS | ' . _t('Site News', 'system') . '" href="' . $config->homeurl . '/rss/rss.php">' .
    "\n" . '<title>' . $textl . '</title>' .
    "\n" . '</head><body>';

// Рекламный модуль
$cms_ads = [];

if (!isset($_GET['err']) && $act != '404' && $headmod != 'admin') {
    $view = $systemUser->id ? 2 : 1;
    $layout = ($headmod == 'mainpage' && !$act) ? 1 : 2;
    $req = $db->query("SELECT * FROM `cms_ads` WHERE `to` = '0' AND (`layout` = '$layout' or `layout` = '0') AND (`view` = '$view' or `view` = '0') ORDER BY  `mesto` ASC");

    if ($req->rowCount()) {
        while ($res = $req->fetch()) {
            $name = explode("|", $res['name']);
            $name = htmlentities($name[mt_rand(0, (count($name) - 1))], ENT_QUOTES, 'UTF-8');

            if (!empty($res['color'])) {
                $name = '<span style="color:#' . $res['color'] . '">' . $name . '</span>';
            }

            // Если было задано начертание шрифта, то применяем
            $font = $res['bold'] ? 'font-weight: bold;' : false;
            $font .= $res['italic'] ? ' font-style:italic;' : false;
            $font .= $res['underline'] ? ' text-decoration:underline;' : false;

            if ($font) {
                $name = '<span style="' . $font . '">' . $name . '</span>';
            }

            @$cms_ads[$res['type']] .= '<a href="' . ($res['show'] ? $tools->checkout($res['link']) : $config['homeurl'] . '/go.php?id=' . $res['id']) . '">' . $name . '</a><br>';

            if (($res['day'] != 0 && time() >= ($res['time'] + $res['day'] * 3600 * 24))
                || ($res['count_link'] != 0 && $res['count'] >= $res['count_link'])
            ) {
                $db->exec('UPDATE `cms_ads` SET `to` = 1  WHERE `id` = ' . $res['id']);
            }
        }
    }
}

// Рекламный блок сайта
if (isset($cms_ads[0])) {
    echo $cms_ads[0];
}

// Выводим логотип и переключатель языков
echo '<table style="width: 100%;" class="logo"><tr>' .
    '<td valign="bottom"><a href="' . $config['homeurl'] . '"><img src="'.$tools->LogoUrl().'"></a></td>' .
    ((!$systemUser->isValid()) && $headmod == 'mainpage' && count($config->lng_list) > 1 ? '<td align="right"><a href="' . $config->homeurl . '/go.php?lng"><b>' . strtoupper($locale) . '</b></a>&#160;<a href="' . $config->homeurl . '/go.php?lng">' . $tools->getFlag($locale) . '</a></td>' : '') .
    '</tr></table>';

// Выводим верхний блок с приветствием
echo '<div class="header"> ' . _t('Hi', 'system') . ', ' . ($systemUser->id ? '<b>' . $systemUser->name . '</b>!' : _t('Guest', 'system') . '!') . '</div>';

/*
-----------------------------------------------------------------
Control Panel by ADEPETER
-----------------------------------------------------------------
*/

echo '<div class="mainblok"><div class="phdr" align="right">' .
    (!$systemUser->isValid() ? '<marquee><span class="silver"><img src="' . $config['homeurl'] . '/images/smileys/user/freaks/mgaul.gif" width="19" height="19" alt="mgaul"/> Welcome to&nbsp;' . $config['copyright'] . '</span></marquee>' : '') .
    (($systemUser->isValid()) && (isset($_GET['err']) || $headmod != "mainpage" || ($headmod == 'mainpage' && $act)) ? '<a href=\'' . $config['homeurl'] . '\'>' . _t('Home', 'system') . '</a> &bull; ' : '') .
	($systemUser->rights >= 1 && $headmod != 'admin' ? '<span class="red"><a href="' . $config['homeurl'] . '/admin/index.php"><strong>Admin CP</strong></a></span> &bull; ' : '') . 
    ($systemUser->id && $headmod != 'office' ? '<a href="' . $config['homeurl'] . '/profile/?act=office">' . _t('My Profile', 'system') . '</a> &bull; ' : '') .
		($systemUser->isValid() && $headmod == 'mainpage' && count($config->lng_list) > 1 ? '<a href="' . $config->homeurl . '/go.php?lng">' . $tools->getFlag($locale) . '</a> &bull; ' : '') .
($systemUser->isValid() && $headmod != 'logout' ? '<span class="silver"><a href="' . $config['homeurl'] . '/exit.php">' . _t('Logout') . '</a></span>' : '') .
'</div></div><div class="maintxt">';


// Рекламный блок сайта
if (!empty($cms_ads[1])) {
    echo '<div class="gmenu">' . $cms_ads[1] . '</div>';
}

if (!$systemUser->id && $headmod != "login" && $headmod != "password" && $headmod != "registration") {
echo '<div class="mainblok"><div class="phdr"><img src="../images/file.png" align="left" alt="file"/>&#160;&#160;<b>' . _t('Login Here') . '</b></div>';

    $error = [];
    $captcha = false;
    $display_form = 1;
    $user_login = isset($_POST['n']) ? $_POST['n'] : null;
    $user_pass = isset($_POST['p']) ? $_POST['p'] : null;
    $user_mem = isset($_POST['mem']) ? 1 : 0;
    $user_code = isset($_POST['code']) ? trim($_POST['code']) : null;

    if ($user_pass && !$user_login) {
        $error[] = _t('You have not entered login', 'system');
    }

    if ($user_login && !$user_pass) {
        $error[] = _t('You have not entered password', 'system');
    }

    if ($user_login && (mb_strlen($user_login) < 2 || mb_strlen($user_login) > 20)) {
        $error[] = _t('Nickname', 'system') . ': ' . _t('Invalid length', 'system');
    }

    if ($user_pass && (mb_strlen($user_pass) < 1)) {
        $error[] = _t('Password', 'system') . ': ' . _t('Invalid length', 'system');
    }

    if (!$error && $user_pass && $user_login) {
        // Запрос в базу на юзера
        $stmt = $db->prepare('SELECT * FROM `users` WHERE `name_lat` = ? LIMIT 1');
        $stmt->execute([$tools->rusLat($user_login)]);

        if ($stmt->rowCount()) {
            $systemUser = $stmt->fetch();

            if ($systemUser['failed_login'] > 2) {
                if ($user_code) {
                    if (mb_strlen($user_code) > 3 && $user_code == $_SESSION['code']) {
                        // Если введен правильный проверочный код
                        unset($_SESSION['code']);
                        $captcha = true;
                    } else {
                        // Если проверочный код указан неверно
                        unset($_SESSION['code']);
                        $error[] = _t('The security code is not correct', 'system');
                    }
                } else {
                    // Показываем CAPTCHA
                    $display_form = 0;
                    echo '<form action="' . ($id ? '?id=' . $id : '') . '" method="post">' .
                        '<div class="menu"><p><img src="captcha.php?r=' . rand(1000, 9999) . '" alt="' . _t('Verification code', 'system') . '"/><br />' .
                        _t('Enter verification code', 'system') . ':<br><input type="text" size="5" maxlength="5"  name="code"/>' .
                        '<input type="hidden" name="n" value="' . htmlspecialchars($user_login) . '"/>' .
                        '<input type="hidden" name="p" value="' . $user_pass . '"/>' .
                        '<input type="hidden" name="mem" value="' . $user_mem . '"/>' .
                        '<input type="submit" name="submit" value="' . _t('Continue', 'system') . '"/></p></div></form>';
                }
            }

            if ($systemUser['failed_login'] < 3 || $captcha) {
                if (md5(md5($user_pass)) == $systemUser['password']) {
                    // Если логин удачный
                    $display_form = 0;
                    $db->exec("UPDATE `users` SET `failed_login` = '0' WHERE `id` = " . $systemUser['id']);

                    if (!$systemUser['preg']) {
                        // Если регистрация не подтверждена
                        echo '<div class="rmenu"><p>' . _t('Sorry, but your request for registration is not considered yet. Please, be patient.', 'system') . '</p></div>';
                    } else {
                        // Если все проверки прошли удачно, подготавливаем вход на сайт
                        if (isset($_POST['mem'])) {
                            // Установка данных COOKIE
                            $cuid = base64_encode($systemUser['id']);
                            $cups = md5($user_pass);
                            setcookie("cuid", $cuid, time() + 3600 * 24 * 365);
                            setcookie("cups", $cups, time() + 3600 * 24 * 365);
                        }

                        // Установка данных сессии
                        $_SESSION['uid'] = $systemUser['id'];
                        $_SESSION['ups'] = md5(md5($user_pass));

                        $db->exec("UPDATE `users` SET `sestime` = '" . time() . "' WHERE `id` = " . $systemUser['id']);
                        $set_user = unserialize($systemUser['set_user']);

                        if ($systemUser['lastdate'] < (time() - 3600) && $set_user['digest']) {
                            header('Location: ' . $config->homeurl . '/index.php?act=digest&last=' . $systemUser['lastdate']);
                        } else {
                            header('Location: ' . $config->homeurl . '/index.php?act=digest&last=' . $systemUser['lastdate']);
                        }

                        echo '<div class="gmenu"><p><b><a href="index.php?act=digest">' . _t('Enter site', 'system') . '</a></b></p></div>';
                    }
                } else {
                    // Если логин неудачный
                    if ($systemUser['failed_login'] < 3) {
                        // Прибавляем к счетчику неудачных логинов
                        $db->exec("UPDATE `users` SET `failed_login` = '" . ($systemUser['failed_login'] + 1) . "' WHERE `id` = " . $systemUser['id']);
                    }

                    $error[] = _t('Authorization failed', 'system');
                }
            }
        } else {
            $error[] = _t('Authorization failed', 'system');
        }
    }

    if ($display_form) {
        if ($error) {
            echo $tools->displayError($error);
        }

				echo '<div class="gmenu"><form method="post"><input type="text" name="n" value="' . htmlentities($user_login, ENT_QUOTES, 'UTF-8') . '" maxlength="28" size="7" class="name"/> <input type="password" name="p" maxlength="25" size="7" class="pass"/><input type="checkbox" name="mem" value="1" checked="checked"/><input type="submit" value="' . _t('Login', 'system') . '"/></form></div>';
				echo '<div class="phdr"><a href="profile/skl.php?continue">' . _t('Forgot password?', 'system') . '</a></div></div>';
				echo '<div class="rmenu"><table width="100%" cellpadding="0" cellspacing="0"><tr><td align="left" valign=""><a href="' . $config['homeurl'] . '/registration/index.php"><img src="/images/ade_reg.png" width="70" height="25" class="left"/></a>&nbsp;</td><td width="auto" align="right" valign="">';
echo '<a href="/help/index.php?act=forum"><img src="/images/ade_rule.png" width="55" height="20" class="right"/></a>';
				echo '</td></tr></table></div>';
			}
		} 

// Фиксация местоположений посетителей
$sql = '';
$set_karma = $config['karma'];

if ($systemUser->id) {
    // Фиксируем местоположение авторизованных
    if (!$systemUser->karma_off && $set_karma['on'] && $systemUser->karma_time <= (time() - 86400)) {
        $sql .= " `karma_time` = " . time() . ", ";
    }

    $movings = $systemUser->movings;

    if ($systemUser->lastdate < (time() - 300)) {
        $movings = 0;
        $sql .= " `sestime` = " . time() . ", ";
    }

    if ($systemUser->place != $headmod) {
        ++$movings;
        $sql .= " `place` = " . $db->quote($headmod) . ", ";
    }

    if ($systemUser->browser != $env->getUserAgent()) {
        $sql .= " `browser` = " . $db->quote($env->getUserAgent()) . ", ";
    }

    $totalonsite = $systemUser->total_on_site;

    if ($systemUser->lastdate > (time() - 300)) {
        $totalonsite = $totalonsite + time() - $systemUser->lastdate;
    }

    $db->query("UPDATE `users` SET $sql
        `movings` = '$movings',
        `total_on_site` = '$totalonsite',
        `lastdate` = '" . time() . "'
        WHERE `id` = " . $systemUser->id);
} else {
    // Фиксируем местоположение гостей
    $movings = 0;
    $session = md5($env->getIp() . $env->getIpViaProxy() . $env->getUserAgent());
    $req = $db->query("SELECT * FROM `cms_sessions` WHERE `session_id` = " . $db->quote($session) . " LIMIT 1");

    if ($req->rowCount()) {
        // Если есть в базе, то обновляем данные
        $res = $req->fetch();
        $movings = ++$res['movings'];

        if ($res['sestime'] < (time() - 300)) {
            $movings = 1;
            $sql .= " `sestime` = '" . time() . "', ";
        }

        if ($res['place'] != $headmod) {
            $sql .= " `place` = " . $db->quote($headmod) . ", ";
        }

        $db->exec("UPDATE `cms_sessions` SET $sql
            `movings` = '$movings',
            `lastdate` = '" . time() . "'
            WHERE `session_id` = " . $db->quote($session) . "
        ");
    } else {
        // Если еще небыло в базе, то добавляем запись
        $db->exec("INSERT INTO `cms_sessions` SET
            `session_id` = '" . $session . "',
            `ip` = '" . $env->getIp() . "',
            `ip_via_proxy` = '" . $env->getIpViaProxy() . "',
            `browser` = " . $db->quote($env->getUserAgent()) . ",
            `lastdate` = '" . time() . "',
            `sestime` = '" . time() . "',
            `place` = " . $db->quote($headmod) . "
        ");
    }
}

// Выводим сообщение о Бане
if (!empty($systemUser->ban)) {
    echo '<div class="alarm">' . _t('Ban', 'system') . '&#160;<a href="' . $config['homeurl'] . '/profile/?act=ban">' . _t('Details', 'system') . '</a></div>';
}

if ($systemUser->rights >= 6) { 
		$total_mod = $db->query("SELECT COUNT(*) FROM `friendssite` WHERE `type`='2'")->fetchColumn();
		if ($total_mod) { 
				echo '<div class="rmenu"><b>Notification</b>:<br/><a href="' . $config['homeurl'] . '/floxymods/friendssite.php?act=mod_site">Sites for moderation</a>&#160;<span class="red">' . $total_mod . '</span></div>';
			} 
		} 

if ($systemUser->rights >= 9) { 
		$total_mod = $db->query("SELECT COUNT(*) FROM `apply_staff` WHERE `type`='2'")->fetchColumn();
		if ($total_mod) { 
				echo '<div class="orange"><b>Notification</b>:<br/><a href="' . config['homeurl'] . '/floxymods/apply_staff.php?act=mod_staff">Staff for moderation</a>&#160;<span class="red">' . $total_mod . '</span></div>';
			} 
		} 

// Ссылки на непрочитанное
if ($systemUser->id) {
    $list = [];
    $new_sys_mail = $db->query("SELECT COUNT(*) FROM `cms_mail` WHERE `from_id`='" . $systemUser->id . "' AND `read`='0' AND `sys`='1' AND `delete`!='" . $systemUser->id . "'")->fetchColumn();

    if ($new_sys_mail) {
        $list[] = '<a href="' . $config['homeurl'] . '/mail/index.php?act=systems">' . _t('System', 'system') . '</a> (+' . $new_sys_mail . ')';
    }

    $new_mail = $db->query("SELECT COUNT(*) FROM `cms_mail`
                            LEFT JOIN `cms_contact` ON `cms_mail`.`user_id`=`cms_contact`.`from_id` AND `cms_contact`.`user_id`='" . $systemUser->id . "'
                            WHERE `cms_mail`.`from_id`='" . $systemUser->id . "'
                            AND `cms_mail`.`sys`='0'
                            AND `cms_mail`.`read`='0'
                            AND `cms_mail`.`delete`!='" . $systemUser->id . "'
                            AND `cms_contact`.`ban`!='1'")->fetchColumn();

    if ($new_mail) {
        $list[] = '<a href="' . $config['homeurl'] . '/mail/index.php?act=new">' . _t('Mail', 'system') . '</a> (+' . $new_mail . ')';
    }

    if ($systemUser->comm_count > $systemUser->comm_old) {
        $list[] = '<a href="' . $config['homeurl'] . '/profile/?act=guestbook&amp;user=' . $systemUser->id . '">' . _t('Guestbook', 'system') . '</a> (' . ($systemUser->comm_count - $systemUser->comm_old) . ')';
    }

    $new_album_comm = $db->query('SELECT COUNT(*) FROM `cms_album_files` WHERE `user_id` = ' . $systemUser->id . ' AND `unread_comments` = 1')->fetchColumn();

    if ($new_album_comm) {
        $list[] = '<a href="' . $config['homeurl'] . '/album/index.php?act=top&amp;mod=my_new_comm">' . _t('Comments', 'system') . '</a>';
    }

if (!file_exists(ROOT_PATH . 'files/users/avatar/' . $systemUser->id . '.png')) {
$list[] = 'Choose your avatar <a href="../help/?act=avatars"><b>Here</b></a><br/>'; 
} 
		
		// Journal forum
if ($systemUser->journal_forum) { 
			$list[] = '<a href="' . $config['homeurl'] . '/forum/journal.php">Forum quoted</a>&#160;<span class="red">' . $systemUser->journal_forum . '</span><br/>';
			} 


    if (!empty($list)) {
        echo '<div class="rmenu">' . _t('Unread', 'system') . ': ' . implode(', ', $list) . '</div>';
    }
}

/*
-----------------------------------------------------------------
FloxyWap Shoutbox
-----------------------------------------------------------------
*/ 

if ($headmod != "online" && $headmod != "digest" &&
$headmod != "birth" &&
$headmod != "admlist" && $headmod != "guest" &&
$headmod != "load" &&
$headmod != "admin" &&
$headmod != "leave" &&
$headmod != "library" &&
$headmod != "users" &&
$headmod != "friend" &&
$headmod != "guestbook" && $headmod != "forumsearch" && $headmod != "news" && $headmod != "userban" && $headmod != "userstop" && $headmod != "userlist" && $headmod != "blogs" &&
$headmod != "cpanel" &&
$headmod != "profile" &&
$headmod != "mail" &&
$headmod != "shoutbox" &&
$headmod != "registration" && $headmod != "login" && $headmod != "exit" && $headmod != "password" && $config['mod_shout'] != 0) {
$cshout = $db->query("SELECT COUNT(*) FROM `shout` WHERE `adm`='0'")->fetchColumn();
if ($systemUser->isValid() || $config['mod_shout'] == 2) {
$token = mt_rand(1000, 100000);
$_SESSION['token'] = $token;
echo '<div class="mainblok"><div class="phdr"><table width="100%" cellpadding="0" cellspacing="0"><tr><td align="left" valign=""><img src="/images/shout.png" width="16" height="16" alt=""/><a href="/shoutbox/index.php">&#160;<b>' . _t('Shoutbox') . '</b></a></td><td width="auto" align="right" valign="">';
if ($systemUser->rights >= 3) {
echo '<a href="/shoutbox/botpanel.php">Spambot</a>&#160;&bull;&#160;<a href="/shoutbox/slavepanel.php">BotGirl</a>&#160;';
} else {
#FOR MEMBERS ONLY
}
echo '</td></tr></table></div>';
if (!$systemUser->isValid()) {
echo '<div class="list1">' . _t('Access to guest is forbidden') . '</div>';
}
elseif ($systemUser->ban['1'] || $systemUser->ban['13']) {
echo '<div class="alert"><font color="red"><b>You are banned..!!</b></font><br/><img src="../images/prvs.gif"/> We are sorry..<br>You are not allowed to post in shout..!!<br/>' . _t('Banned') . '&#160;<a href="' . $set['homeurl'] . '/profile/index.php?act=ban">' . _t('Reasons') . '</a></div>';
} else {
echo '<div class="gmenu"><form name="form_shout" action="/shoutbox/index.php?act=say" method="post">';
echo $bbcode->buttons('form_shout', 'msg');
echo '<textarea rows="' . $systemUser->getConfig()->fieldHeight . '" cols="17" name="msg"></textarea><br/>';
echo '<input type="hidden" name="token" value="' . $token . '"/><input type="submit" title="post message" name="submit" value="Shout"/></input></form></div>';
}
if ($cshout) {
$creq = $db->query("SELECT `shout`.*, `shout`.`id` AS `sid`, `users`.`rights`, `users`.`lastdate`, `users`.`sex`, `users`.`status`, `users`.`datereg`, `users`.`id`
FROM `shout` LEFT JOIN `users` ON `shout`.`user_id` = `users`.`id`
WHERE `shout`.`adm`='0' ORDER BY `time` DESC LIMIT 3");
while ($cres = $creq->fetch()) {
echo ceil(ceil($adepeter / 2) - ($adepeter / 2)) == 0 ? '<div class="list1">' : '<div class="list1">';
// User rights
$rank = array(
0 => '<font color="orange">',
1 => '<font color="#3399ff">',
2 => '<font color="#3399ff">',
3 => '<font color="#3399ff">',
4 => '<font color="#3399ff">',
5 => '<font color="#3399ff">',
6 => '<font color="#3399ff">',
7 => '<font color="green">',
9 => '<font color="cc0000">'
);
if ($cres['user_id']) {
if ($cres['sex'])
echo '<img src="../images/' . ($cres['sex'] == 'm' ? 'm' : 'w') . ($cres['datereg'] > time() - 86400 ? '_new' : '')
. '.png" width="16" height="16" align="left" alt="' . ($cres['sex'] == 'm' ? 'es' : 'eu') . '" />&#160;';
echo '<a href="' . $config['homeurl'] . '/profile/info.php?user=' . $cres['user_id'] . '">' . $rank[$cres['rights']] . '<b>' . $cres['name'] . '</b></a></font>';
echo (time() > $cres['lastdate'] + 300 ? '<span class="red">&nbsp;<img src="/images/offline.gif" width="8" height="10" alt="off"/></span>' : '<span class="green">&nbsp;<img src="/images/online.gif" width="8" height="10" alt="on"/></span>');
echo '<br/>';
}
if (!empty($cres['status']))
$text = htmlentities($cres['text'], ENT_QUOTES, 'UTF-8');
$cpost = $bbcode->adepeter($cpost);
$cpost = str_replace("\r\n", "<br/>", $cpost);
if ($cres['user_id']) {
$cpost = $tools->cleanString($tools->checkout(mb_substr($cres['text'], 0, 200), 1, 1));
$cpost = $tools->smilies($cpost, $cres['rights'] >= 1 ? 1 : 0);
}
// Display text posting
echo $cpost;
if (mb_strlen($cres['text']) > 200)
echo '...<a href="../shoutbox/index.php">More</a>';
echo '</div>';
++$adepeter;
}
} else {
echo '<div class="rmenu">Shout is empty</div>';
}
echo '<div class="phdr"><center><a href="/help/index.php?act=forum">Rules</a> &bull; <a href="/help/index.php?act=tags">Bbcode</a> &bull; <a href="/help/index.php?act=smilies">Emoticons</a></center></div>';
echo '</div>';
}
} 
if (!$systemUser->isValid() && $headmod != "login" && $headmod != "password" && $headmod != "registration") {
echo '<div class="mainblok"><div class="phdr"><b>Welcome to&nbsp;' . $config['copyright'] . '</b></div><div class="gmenu" style="text-align:left">If this is your first visit, be sure to check out the <font color="red">Rules</font> by clicking the link above..<br>You may have to register before you can post.. click the <font color="red">Register</font> link above to proceed..</div></div>';
} 
if (!empty($cms_ads[1])) { 
echo '<div class="mainblok"><div class="phdr">Sponsored by:</div><center>' . $cms_ads[1] . '</center></div>';
} 
?>
