<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Counters $counters */
$counters = $container->get('counters');

$mp = new Johncms\NewsWidget();

// Блок информации
echo '<div class="mainblok"><div class="phdr"><img src="/images/board.png" width="16" height="15" class="left"/>&nbsp;<b>' . _t('Information', 'system') . '</b></div>';
echo $mp->news;
echo '<div class="menu"><a href="news/">' . _t('News archive', 'system') . '</a> (' . $mp->newscount . ')</div>';
   echo '<div class="menu"><a href="help/">' . _t('Information, FAQ', 'system') . '</a></div>'; 
// Ссылка на гостевую
if ($config->mod_guest || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="guestbook/index.php">' . _t('Guestbook', 'system') . '</a> (' . $counters->guestbook() . ')</div>';
}

echo '</div>';

/*
-----------------------------------------------------------------
Hacklord Apply for staff
-----------------------------------------------------------------
*/
if ($headmod == 'mainpage') {
if ($systemUser->isValid() && !isset($systemUser->ban['1']) && !isset($systemUser->ban['11']) && $config['mod_staff'] != 0) {
echo '<div class="mainblok"><div class="phdr"><b>Apply As Administrator Now!!!</b></div>';
echo '<div class="gmenu" style="text-align:left">We are looking some talented members to manage this site forum..<br>If you think you are available,you can Click the button below..</div>';
echo '<div class="phdr"><a href="' .$config['homeurl'] . '/floxymods/apply_staff.php?act=add_staff"><font color="red"><b>Apply For Staff Now.</b></font></a></div></div>';
}
}

/*
-----------------------------------------------------------------
Hacklord Forum search
-----------------------------------------------------------------
*/
if (!$systemUser->isValid() || ($systemUser->id && $config->mod_fsearch != 0)) {
$search_post = isset($_POST['search']) ? trim($_POST['search']) : false;
$search_get = isset($_GET['search']) ? rawurldecode(trim($_GET['search'])) : false;
$search = $search_post ? $search_post : $search_get;
$search_t = isset($_REQUEST['t']);
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>' . _t('Forum') . '&nbsp;search</b></div>' .
'<div class="gmenu"><form action="../forum/search.php" method="post"><p>' .
'<input type="text" value="' . ($search ? $tools->checkout($search) : '') . '" name="search" />' .
'<input type="submit" value="' . _t('Search') . '" name="submit" /><br />' .
'<input name="t" type="checkbox" value="1" ' . ($search_t ? 'checked="checked"' : '') . ' />&nbsp;Search in thread</p></form></div></div>';
}

/*
-----------------------------------------------------------------
Hacklord Newest topic
-----------------------------------------------------------------
*/
$set_forum = unserialize($systemUser->set_forum); 
$setts = $config->newThemes;
if($setts['botalThemes'] > 0 && !$set_forum['seeThemes']) {
$totaled = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='t' and kedit='0' AND `close`!='1'")->fetchColumn();
echo '<div class="mainblok"><div class="phdr"><table width="100%" cellpadding="0" cellspacing="0"><tr><td align="left" valign=""><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>Newest Threads</b></td><td width="auto" align="right" valign="">';
if ($systemUser->isValid() && !isset($systemUser->ban['1']) && !isset($systemUser->ban['11'])) {
echo '<a href="floxymods/fthread.php"><img src="/images/addmore.png" width="16" height="16" class="right"/></a>';
} else {
#FOR MEMBERS ONLY
}
echo '</td></tr></table></div>';
if ($totaled) {
$kreq = $db->query("SELECT * FROM `forum` WHERE `type`='t'" . ($systemUser->rights >= 7 ? '' : " AND `close`!='1'") . " ORDER BY `id` DESC LIMIT $start, " . $setts['botalThemes']);
$i = 0;
while (($kres = $kreq->fetch()) !== false) {
echo $i % 2 ? '<div class="menu">' : '<div class="menu">';
$qq3 = $db->query("SELECT `id`, `refid`, `text` FROM `forum` WHERE `type` = 'r' AND `id` = '" . $kres['refid'] . "' LIMIT 1");
$razdd = $qq3->fetch();
$qq4 = $db->query("SELECT `id`, `text` FROM `forum` WHERE `type`='f' AND `id` = '" . $razdd['refid'] . "' LIMIT 1");
$frmm = $qq4->fetch();
$nikuserr = $db->query("SELECT `from` FROM `forum` WHERE `type` = 'm' AND `close` != '1' AND `refid` = '" . $kres['id'] . "' ORDER BY `time` DESC LIMIT 1");
$namm = $nikuserr->fetch();
$botalPosts = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `refid`='" . $kres['id'] . "'" . ($systemUser->rights >= 7 ? '' : " AND `close` != '1'"));
$colmess1 = $botalPosts->fetchColumn();
$cpgg = ceil($colmess1 / $kmess);
$npp = $db->query("SELECT COUNT(*) FROM `cms_forum_rdm` WHERE `time` >= '" . $kres['time'] . "' AND `topic_id` = '" . $kres['id'] . "' AND `user_id`='$systemUser->id'")->fetchColumn();
// Icons for topic
$icons = array(
($npp ? (!$kres['vip'] ? '<img src="../images/op.gif" alt=""/>' : '') : '<img src="../images/np.gif" alt=""/>'),
($kres['vip'] ? '<img src="../images/pt.gif" alt=""/>' : ''),
($kres['nospam'] ? '<img src="../images/nospam.png" alt=""/>' : ''),
($kres['min_post'] ? '<img src="../images/priv.png" alt=""/>' : ''),
($kres['realid'] ? '<img src="../images/rate.gif" alt=""/>' : ''),
($kres['edit'] ? '<img src="../images/tz.gif" alt=""/>' : '')
);
echo implode('', array_filter($icons));
echo '<a href="'.$config->homeurl.'/forum/' . $tools->rewriteUrl($kres['text']) . '_' . $kres['id'] . '.html">' . $kres['text'] . '</a>&#160;[<span class="red">' . $colmess1 . '</span>]';
if ($cpg > 1) {
echo '<a href="/forum/' . $tools->rewriteUrl($kres['text']) . '_' . $kres['id'] . '_p' . $cpgg . '.html' . ($_SESSION['uppost']) . '">&#160;<img src="/images/viewpost.gif" width="12" height="10"/></a>';
}
echo '<div class="sub">';
echo 'Thread starter:&#160;' . $kres['from'];
if (!empty($namm['from'])) {
echo '<br/>Last post:&#160;<font color="orange">' . $namm['from'] . '</font>';
}
echo '<br/>Time:&#160;<span class="gray">' . $tools->updateTime($kres['time']) . '</span></div>';
echo '</div>';
++$i;
}
unset($_SESSION['fsort_id']);
unset($_SESSION['fsort_users']);
} else {
echo '<div class="rmenu"><p>New Threads Not Available..!!</p></div>';
}
if ($totaled > $setts['botalThemes']) {
echo '<div class="gmenu" align="right"><a href="' . $config['homeurl'] . '/forum/index.php?act=new&amp;do=select" class="pagenav" title="Forum list"/>Show more <img src="/images/viewpost.gif" width="12" height="10"/></a></div>';
}
echo '</div>';
}

/*
-----------------------------------------------------------------
Hacklord Latest topic
-----------------------------------------------------------------
*/

$set_forum = unserialize($systemUser->set_forum);
$settings = $config->lastThemes;
if($settings['totalThemes'] > 0 && !$set_forum['viewThemes']) {
$total = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='t' and kedit='0' AND `close`!='1'")->fetchColumn();
echo '<div class="mainblok"><div class="phdr"><table width="100%" cellpadding="0" cellspacing="0"><tr><td align="left" valign=""><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>Recent Threads</b></td><td width="auto" align="right" valign="">';
if ($systemUser->isValid() && !isset($systemUser->ban['1']) && !isset($systemUser->ban['11'])) {
echo '<a href="floxymods/fthread.php"><img src="/images/addmore.png" width="16" height="16" class="right"/></a>';
} else {
#FOR MEMBERS ONLY
}
echo '</td></tr></table></div>';
if ($total) {
$req = $db->query("SELECT * FROM `forum` WHERE `type`='t'" . ($systemUser->rights >= 7 ? '' : " AND `close`!='1'") . " ORDER BY `time` DESC LIMIT $start, " . $settings['totalThemes']);
$i = 0;
while (($res = $req->fetch()) !== false) {
echo $i % 2 ? '<div class="menu">' : '<div class="menu">';
$q3 = $db->query("SELECT `id`, `refid`, `text` FROM `forum` WHERE `type` = 'r' AND `id` = '" . $res['refid'] . "' LIMIT 1");
$razd = $q3->fetch();
$q4 = $db->query("SELECT `id`, `text` FROM `forum` WHERE `type`='f' AND `id` = '" . $razd['refid'] . "' LIMIT 1");
$frm = $q4->fetch();
$nikuser = $db->query("SELECT `from` FROM `forum` WHERE `type` = 'm' AND `close` != '1' AND `refid` = '" . $res['id'] . "' ORDER BY `time` DESC LIMIT 1");
$nam = $nikuser->fetch();
$colmes = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `refid`='" . $res['id'] . "'" . ($systemUser->rights >= 7 ? '' : " AND `close` != '1'"));
$colmes1 = $colmes->fetchColumn();
$cpg = ceil($colmes1 / $kmess);
$np = $db->query("SELECT COUNT(*) FROM `cms_forum_rdm` WHERE `time` >= '" . $res['time'] . "' AND `topic_id` = '" . $res['id'] . "' AND `user_id`='$systemUser->id'")->fetchColumn();
// Icons for topic
$icons = array(
($np ? (!$res['vip'] ? '<img src="../images/op.gif" alt=""/>' : '') : '<img src="../images/np.gif" alt=""/>'),
($res['vip'] ? '<img src="../images/pt.gif" alt=""/>' : ''),
($res['nospam'] ? '<img src="../images/nospam.png" alt=""/>' : ''),
($res['min_post'] ? '<img src="../images/priv.png" alt=""/>' : ''),
($res['realid'] ? '<img src="../images/rate.gif" alt=""/>' : ''),
($res['edit'] ? '<img src="../images/tz.gif" alt=""/>' : '')
);
echo implode('', array_filter($icons));

echo '<a href="'.$config->homeurl.'/forum/' . $tools->rewriteUrl($res['text']) . '_' . $res['id'] . '.html">' . (empty($res['text']) ? '-----' : $res['text']) . '</a> [' . $colmes1 . ']';
if ($cpg > 1) {
echo '<a href="/forum/' . $tools->rewriteUrl($res['text']) . '_' . $res['id'] . '_p' . $cpg . '.html' . ($_SESSION['uppost']) . ' ">&#160;<img src="/images/viewpost.gif" width="12" height="10"/></a>';
}
echo '<div class="sub">';
echo 'Thread starter:&#160;' . $res['from'];
if (!empty($nam['from'])) {
echo '<br/>Last post:&#160;<font color="orange">' . $nam['from'] . '</font>';
}
echo '<br/>Time:&#160;<span class="gray">' . $tools->updateTime($res['time']) . '</span></div>';
echo '</div>';
++$i;
}
unset($_SESSION['fsort_id']);
unset($_SESSION['fsort_users']);
} else {
echo '<div class="rmenu"><p>Recent Topic List Is Empty!!</p></div>';
}
if ($total > $kmess) {
echo '<div class="gmenu" align="right">' . $tools->displayPagination('index.php?', $start, $total, $kmess) . '</div>';
}
echo '</div>';
}

/*
-----------------------------------------------------------------
Hacklord Forum Structure
-----------------------------------------------------------------
*/
if (!$systemUser->isValid() || ($systemUser->id && $config->mod_cats != 0)) {
if (!$systemUser->id) {
echo '<div class="rmenu"><div style="text-align:left">To start viewing some threads, select the category that you want to visit from the forum structure below..</div></div>';
}
$dreq = $db->query("SELECT * FROM `forum` WHERE `type` = 'f' ORDER BY `realid` ASC");
$i = 0;
while ($fr1 = $dreq->fetch()) {
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>' . $fr1['text'] . '</b></div>';
$pr = $db->query("SELECT `id`, `text`, `soft` FROM `forum` WHERE `type` = 'r' AND `refid` = '" . $fr1['id'] . "'");
$i = 0;
while ($pr1 = $pr->fetch()) {
$coltem = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 't' AND `refid` = '" . $pr1['id'] . "'")->fetchColumn();
echo '<div class="menu"><img src="/images/forum_cat.png" width="14" height="14" class="left"/>&nbsp;<a href="'.$config->homeurl.'/forum/' . $tools->rewriteUrl($pr1['text']) . '_'.$pr1['id'].'.html">' . $pr1['text'] . '</a>';
if ($coltem)
echo '&#160;[<span class="red">'.$coltem.'</span>]';
if (!empty($pr1['soft']))
echo '<div class="sub"><span class="gray">' . $pr1['soft'] . '</span></div>';
echo '</div>';
}
echo '</div>';
++$i;
}
} 

/*
-----------------------------------------------------------------
Hacklord Extra Menus
-----------------------------------------------------------------
*/
if (!$systemUser->isValid() || ($systemUser->id && $config->mod_comz != 0)) {

echo '<div class="mainblok"><div class="phdr"><img src="/images/logox.png" width="16" height="15" class="left"/>&nbsp;<b>' . _t('Useful', 'system') . '</b></div>';

// Ссылка на загрузки
if ($config->mod_down || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="downloads/">' . _t('Downloads', 'system') . '</a> (' . $counters->downloads() . ')</div>';
}

// Ссылка на библиотеку
if ($config->mod_lib || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="library/">' . _t('Library', 'system') . '</a> (' . $counters->library() . ')</div>';
}
					echo'</div>';
} 
////////////////////////////////////////////////////////////
// Блок Сообщества                                        //
////////////////////////////////////////////////////////////
if ($systemUser->isValid() || $config->active) {
    echo '<div class="mainblok"><div class="phdr"><img src="/images/users.png" width="16" height="15" class="left"/>&nbsp;<b>' . _t('Community', 'system') . '</b></div>' .
        '<div class="menu"><a href="users/index.php">' . _t('Users', 'system') . '</a> (' . $counters->users() . ')</div>' .
        '<div class="menu"><a href="album/index.php">' . _t('Photo Albums', 'system') . '</a> (' . $counters->album() . ')</div></div>';
}

/*
-----------------------------------------------------------------
Hacklord Statistic
-----------------------------------------------------------------
*/
if (!$systemUser->isValid() || ($systemUser->id && $config->mod_fstat != 0)) {
$total_cat = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 'f'")->fetchColumn();
$total_sub = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 'r'")->fetchColumn();
$total_thm = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 't'")->fetchColumn();
$total_msg = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 'm'")->fetchColumn();
$total_files = $db->query("SELECT COUNT(*) FROM `cms_forum_files`")->fetchColumn();
echo '<div class="mainblok"><div class="phdr"><img src="../images/rate.gif" width="16" height="16" class="left"/>&nbsp;<b>' . _t('Statistics') . '</b></div><div class="menu">' .
'<font  style="color:#3399ff">&bull;</font>&#160;Total categories:&#160;<span class="red">' . $total_cat . '</span><br/>' .
'<font  style="color:#3399ff">&bull;</font>&#160;Total sections:&#160;<span class="red">' . $total_sub . '</span><br/>' .
'<font  style="color:#3399ff">&bull;</font>&#160;Total threads:&#160;<span class="red">' . $total_thm . '</span><br/>' .
'<font  style="color:#3399ff">&bull;</font>&#160;Total post:&#160;<span class="red">' . $total_msg . '</span><br/>' .
'<font  style="color:#3399ff">&bull;</font>&#160;Total files:&#160;<span class="red">' . $total_files . '</span></div>';
echo '</div>';
}

