<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

$realtime = ($config->timeshift + $systemUser->userConfig->timeshift) * 3600;
require '../downloads/classes/download.php';


$dir_clean = opendir('../files/temp/open_zip');
while ($file = readdir($dir_clean)) {
    if ($file != 'index.php' && $file != '.htaccess' && $file != '.' && $file != '..' && $file != '.svn') {
        $time_file = filemtime('../files/temp/open_zip/' . $file);
        if ($time_file < ($realtime - 300))
            @unlink('../files/temp/open_zip/' . $file);
    }
}
closedir($dir_clean);
$req_down = $db->query("SELECT * FROM `download__files` WHERE `id` = '$id' AND (`type` = 2 OR `type` = 3)  LIMIT 1");
$res_down = $req_down->fetch();
if (($req_down->rowCount() == 0) || !is_file($res_down['dir'] . '/' . $res_down['name']) || ($res_down['type'] == 3 && $systemUser->rights < 6 && $systemUser->rights != 4)) {
    require('../system/head.php');
    echo $tools->displayError('File not found<br /><a href="index.php">By category</a>');
    require('../system/end.php');
    exit;
}
if (isset($_GET['more'])) {
    $more = abs(intval($_GET['more']));
    $req_more = $db->query("SELECT * FROM `download__more` WHERE `id` = '$more' LIMIT 1");
    $res_more = $req_more->fetch();
    if (!$req_more->rowCount() || !is_file($res_down['dir'] . '/' . $res_more['name'])) {
        require('../system/head.php');
        echo $tools->displayError('File not found<br /><a href="index.php">By category</a>');
        require('../system/end.php');
        exit;
    }
    $file_open = $res_down['dir'] . '/' . $res_more['name'];
    $isset_more = '&amp;more=' . $more;
    $title_pages = $res_more['rus_name'];
} else {
    $file_open = $res_down['dir'] . '/' . $res_down['name'];
    $title_pages = $res_down['rus_name'];
    $isset_more = '';
}

$title_pages = $tools->checkout(mb_substr($title_pages, 0, 20));
$textl = 'View the archive - ' . (mb_strlen($res_down['rus_name']) > 20 ? $title_pages . '...' : $title_pages);
require('../system/head.php');
require('../downloads/classes/pclzip.lib.php');
$array = array (
    'cgi',
    'pl',
    'asp',
    'aspx',
    'shtml',
    'shtm',
    'fcgi',
    'fpl',
    'jsp',
    'py',
    'htaccess',
    'ini',
    'php',
    'php3',
    'php4',
    'php5',
    'php6',
    'phtml',
    'phps'
);
if (!isset($_GET['file'])) {
    $zip = new PclZip($file_open);
    if (($list = $zip->listContent()) == 0) {
        echo $tools->displayError('Failed to open archive or selected File is not a ZIP archive<br /><a href="index.php?act=view&amp;id=' . $id . '">Back</a>');
        require('../system/end.php');
        exit;
    }
    for ($i = 0; $i < sizeof($list); $i++) {
        for (reset($list[$i]); $key = key($list[$i]); next($list[$i])) {
            $file_size = str_replace("--size:", "", strstr($list_content, "--size"));
            $list_size .= str_replace($file_size, $file_size . '|', $file_size);
            $list_content = "[$i]--$key:" . $list[$i][$key];
            $zip_file = str_replace("--filename:", "", strstr($list_content, "--filename"));
            $save_list .= str_replace($zip_file, $zip_file . '|', $zip_file);
        }
    }
    $file_size_two = explode("|", $list_size);
    echo '<div class="mainblok"><div class="phdr"><b>View the archive:</b> ' . $res_down['name'] . '</div><div class="gmenu">You can download individual Files from the archive or view the code</div>';
    $preview = explode("|", $save_list);
    $total = count($preview) - 1;
    if ($total > 0) {
        $end = $start + $kmess;
        if ($end > $total)
            $end = $total;
        for ($i = $start; $i < $end; $i++) {
            echo ($i % 2) ? '<div class="list2">' : '<div class="list1">';
            $path = $preview[$i];
            $file_name = preg_replace("#.*[\\/]#si", '', $path);
            $dir = preg_replace("#[\\/]?[^\\/]*$#si", '', $path);
            $format = explode('.', $file_name);
            $format_file = strtolower($format[count($format) - 1]);
            echo '<b>' . ($i + 1) . ')</b> ' . $dir . '/' . mb_convert_encoding($file_name, "UTF-8", "Windows-1251");
            if ($file_size_two[$i] > 0)
						 echo '&nbsp;';
                echo Download::displayFileSize($file_size_two[$i]);
            if ($format_file)
                echo ' - <a href="index.php?act=open_zip&amp;id=' . $id . '&amp;file=' . rawurlencode($path) . '&amp;start=' . $start . $isset_more . '">' . (in_array($format_file, $array) ? 'code' : 'Download') . '</a>';
            echo '</div>';
        }
    } else
        echo '<div class="list2">Archive is empty</div>';
    echo '<div class="gmenu">Weight unpacked the archive: ' . Download::displayFileSize(array_sum($file_size_two)) . '</div>';
    echo '<div class="phdr">Total Files: ' . $total . '<br/>';
echo '<a href="index.php?act=view&amp;id=' . $id . '">To File</a></div>';
    if ($total > $kmess) {
        echo '<div class="gmenu">' . $tools->displayPagination('index.php?act=open_zip&amp;id=' . $id . '&amp;', $start, $total, $kmess) . '<br/>';
        echo '<form action="index.php" method="get"><input type="hidden" value="open_zip" name="act" />
            <input type="hidden" value="' . $id . '" name="id" /><input type="text" name="page" size="2"/><input type="submit" value="Go to page &gt;&gt;"/></form></div>';
    }

} else {

    $FileName = rawurldecode(trim($_GET['file']));
    $format = explode('.', $FileName);
    $format_file = strtolower($format[count($format) - 1]);
    if (strpos($FileName, '..') !== false or strpos($FileName, './') !== false) {
        echo $tools->displayError('<a href="index.php?act=view&amp;id=' . $id . '">To File</a>');
        require('../system/end.php');
        exit;
    }
    $FileName = htmlspecialchars(trim($FileName), ENT_QUOTES, 'UTF-8');
    $FileName = strtr($FileName, array (
        '&' => '',
        '$' => '',
        '>' => '',
        '<' => '',
        '~' => '',
        '`' => '',
        '#' => '',
        '*' => ''
    ));
    $zip = new PclZip($file_open);
    $content = $zip->extract(PCLZIP_OPT_BY_NAME, $FileName, PCLZIP_OPT_EXTRACT_AS_STRING);
    $content = $content[0]['content'];
    $FileName = preg_replace("#.*[\\/]#si", "", $FileName);
    if (in_array($format_file, $array)) {
        $content_two = explode("\r\n", $content);
        echo '<div class="mainblok"><div class="phdr"><b>' . mb_convert_encoding($FileName, "UTF-8", "Windows-1251") . '</b></div><div class="list1"><div class="phpcode">';
        $rus_simvol = array (
            'а',
            'б',
            'в',
            'г',
            'д',
            'е',
            'ё',
            'ж',
            'з',
            'и',
            ' ',
            ' ',
            ' ',
            ' ',
            ' ',
            ' ',
            ' ',
            'р',
            'с',
            'т',
            'у',
            'ф',
            'х',
            'ц',
            'ч',
            'ш',
            'щ',
            'ъ',
            'ы',
            'ь',
            'э',
            'ю',
            'я',
            'А',
            'Б',
            'В',
            'Г',
            'Д',
            'Е',
            'Ё',
            'Ж',
            'З',
            'И',
            'Й',
            'К',
            'Л',
            'М',
            'Н',
            'О',
            'П',
            'Р',
            'С',
            'Т',
            'У',
            'Ф',
            'Х',
            'Ц',
            'Ч',
            'Ш',
            'Щ',
            'Ъ',
            'Ы',
            'Ь',
            'Э',
            'Ю',
            'Я'
        );
        for ($i = 0; $i < 66; $i++) {
            if (strstr($content, $rus_simvol[$i]) !== false)
                $UTF = 1;
        }
        $php_code = trim($content);
        $php_code = substr($php_code, 0, 2) != "<?" ? "<?php\n" . $php_code . "\n?>" : $php_code;
        echo $UTF ? highlight_string($php_code, true) : highlight_string(iconv('windows-1251', 'utf-8', $php_code), true);
        echo '</div></div><div class="phdr">Total lines: ' . count($content_two) . '</div>';
    } else {
        $NewNameFile = strtr($tools->rusLat(mb_convert_encoding($FileName, "UTF-8", "Windows-1251")), array (
            ' ' => '_',
            '@' => '',
            '%' => ''
        ));
        if (file_exists('../files/temp/open_zip/' . $NewNameFile)) {
            header('Location: ../files/temp/open_zip/' . $NewNameFile);
            exit;
        }
        $NewFile = '../files/temp/open_zip/' . $NewNameFile;
        $dir = @fopen($NewFile, "wb");
        if ($dir) {
            if (flock($dir, LOCK_EX)) {
                fwrite($dir, $content);
                flock($dir, LOCK_UN);
            }
            fclose($dir);
            header('Location: ../files/temp/open_zip/' . $NewNameFile);
        } else
            echo $tools->displayError('Unable to Save File on the server');
    }
    echo '<div class="phdr"><a href="index.php?act=open_zip&amp;id=' . $id . '&amp;start=' . $start . '">Back</a></div>';
}
?>