<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';

require('../system/bootstrap.php');

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

$textl = _t('Downloads');
$headmod = 'downloads';
set_time_limit(99999);

require '../downloads/classes/download.php';
require '../system/head.php';

$req_down = $db->query("SELECT * FROM `down__files` WHERE `id` = '$id' AND (`type` = 2 OR `type` = 3)  LIMIT 1");
$res_down = $req_down->fetch();
if (($req_down->rowCount() == 0) || !is_file($res_down['dir'] . '/' . $res_down['name']) || $tools->format($res_down['name']) != 'mp3' || ($res_down['type'] == 3 && $systemUser->rights < 6 && $systemUser->rights != 4)) {
    echo $tools->displayError('File not found<br /><a href="index.php">By category</a>');
    require('../system/end.php');
    exit;
}
$bit = 64;
$input_file= $res_down['dir'] . '/' . $res_down['name'];
$output_file='../files/download/temp/mp3/' . $bit . '_' . $res_down['name'];
exec("lame '".escapeshellcmd($input_file)."' -b $bit --mp3input '".escapeshellcmd($output_file)."' ");
echo '<a href="' . $output_file . '">Download</a>';
require('../system/end.php');

?>