<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

namespace Johncms\Forum;

class Voter
{
    private $post;

    private $user;

    private $plus = 0;

    private $minus = 0;

    private $hide = false;

    private $hideLimit = 10;

    private $reset;

    private $exists = false;

    private $table = 'cms_forum_like';

    public function __construct($post, $reset = false)
    {
        $this->post = $post;
        $this->reset = $reset;
        $this->user = \App::getContainer()->get(\Johncms\Api\UserInterface::class)->id;
        $this->db = \App::getContainer()->get(\PDO::class);
        $this->select();
    }

    static function getUser()
    {
        return \App::getContainer()->get(\Johncms\Api\UserInterface::class)->id;
    }

    public function db()
    {
        return $this->db;
    }

    public function add($type, $value = 1)
    {
        if ($this->exists()) {
            $result = $this->db()
                ->exec("UPDATE `" . $this->table . "` SET `type` = '" . $type . "', `value` = " . $value . " WHERE `post_id` = " . $this->post . " AND `user_id` = " . $this->user . " LIMIT 1");
        } else {
            $result = $this->db()
                ->prepare("INSERT INTO `" . $this->table . "` (`post_id`, `user_id`, `value`, `type`) VALUES (?, ?, ?, ?)")
                ->execute([$this->post, $this->user, $value, $type]);
        }
        return $result;
    }

    public function delete()
    {
        $result = false;
        if ($this->exists()) {
            $result = $this->db()
                ->exec("DELETE FROM `" . $this->table . "` WHERE `post_id` = " . $this->post . " AND `user_id` = " . $this->user);
        }
        return $result;
    }

    private function select()
    {
        $exists = $this->db()
            ->query("SELECT COUNT(*) FROM `" . $this->table . "` WHERE `post_id` = " . $this->post)->fetchColumn();
        if ($exists) {
            $result = $this->db()
                ->query("SELECT * FROM `" . $this->table . "` WHERE `post_id` = " . $this->post)
                ->fetchAll();
            foreach ($result as $value) {
                if ($value['user_id'] == $this->user) {
                    $this->exists = true;
                }
                if ($value['type'] == 'plus') {
                    $this->plus++;
                } else {
                    $this->minus++;
                }
            }
            $this->hide = ($this->plus + $this->hideLimit - $this->minus > 0);
        }
    }

    private function exists()
    {
        return $this->exists;
    }

    public function view($id)
    {
        return '
            <div class="green">
            ' . $this->plus . ' <a href="" onclick="like(' . $id . ', \'plus\')" id="like">Like</a>
            ' . $this->minus . ' <a href="" onclick="like(' . $id . ', \'minus\')" id="like">Dislike</a>
            </div>
        ';
    }
}
