<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

class Subscribe
{


    private $picks;

    private $bans;

    private $sectionPicks;

    private $sectionBans;

    private $time;

    private $update = false;

    private $settings;

    public function __construct() {

        $sql = 'SELECT `set_forum` FROM `users` WHERE `id` = ' . core::$user_id;
        $ser = mysql_fetch_assoc(mysql_query($sql))['set_forum'];
        #var_dump($this->settings); die;
        $settings = (!empty($ser) ? unserialize($ser) : []);
        $this->settings = $settings;
        $this->picks = new Elements(!is_null($settings['pick']) ? $settings['pick'] : []);
        $this->bans = new Elements(!is_null($settings['ban']) ? $settings['ban'] : []);
        $this->sectionPicks = new Elements(!is_null($settings['spick']) ? $settings['spick'] : []);
        $this->sectionBans = new Elements(!is_null($settings['sban']) ? $settings['sban'] : []);
        $this->time = $settings['reset'];
    }

    private function save() {
        $settings['pick'] = $this->picks->get();
        $settings['ban'] = $this->bans->get();
        $settings['spick'] = $this->sectionPicks->get();
        $settings['sban'] = $this->sectionBans->get();
        $settings['reset'] = $this->time;
        #var_dump($this->settings); die;
        $array = array_merge($this->settings, $settings);
        mysql_query('UPDATE `users` SET `set_forum` = "' . mysql_real_escape_string((serialize($array))) . '" WHERE `id` = ' . core::$user_id);
    }

    public function __destruct() {
        if ($this->update) {
            $this->save();
        }
    }

    public function update() {
        $this->update = true;
    }

    public function reset() {
        $this->time = time();
        $this->update();
    }

    private function put(Elements $first, Elements $second, $value) {
        $update = false;
        if (!$first->exists($value)) {
            $first->add($value);
            $update = true;
        }
        if ($second->exists($value) & $update) {
            $second->remove($value);
        }
        !$update ?: $this->update();
    }

    public function subscribe($value, $type = 'pick', $section = true) {
        if (!in_array($type, ['pick', 'ban'])) {
            return false;
        }
        if (!$value) {
            return false;
        }
        if ($section) {
            $first = $this->sPicks();
            $second = $this->sBans();
        } else {
            $first = $this->picks();
            $second = $this->bans();
        }
        if ($type == 'ban') {
            list($first, $second) = [$second, $first];
        }
        $this->put($first, $second, $value);
    }

    private function getPicks() {
        $array = $this->diff($this->getInts(), $this->bans()->get());
        return count($array) > 0 ? ' AND `id` IN(' . implode(',', $array) . ')' : '';
    }

    private function getBans() {
        $array = $this->diff($this->getInts('ban'), $this->picks()->get());
        return count($array) > 0 ? ' AND `id` NOT IN(' . implode(',', $array) . ')' : '';
    }

    private function getTime() {
        return $this->time;
    }

    public function where() {
        return $this->getPicks() . (!$this->getPicks() ? $this->getBans() : '');
    }

    public function whereTime() {
        return $this->where() . ($this->getTime() ? ' AND `time` > ' . $this->getTime() : '');
    }

    public function picks() {
        return $this->picks;
    }

    public function bans() {
        return $this->bans;
    }

    public function sPicks() {
        return $this->sectionPicks;
    }

    public function sBans() {
        return $this->sectionBans;
    }

    public function sections() {
        $res = [];
        $uid = substr(md5(uniqid(time())), 0, 8);
        $result = mysql_fetch_assoc(mysql_query("SELECT GROUP_CONCAT(`id` SEPARATOR ',') as `ids`, GROUP_CONCAT(`text` SEPARATOR '" . $uid . "') as `names` FROM `forum` WHERE `type` = 'r'"));

        if ($result) {
            $keys = explode(',', $result['ids']);
            $names = explode($uid, $result['names']);
            $res = array_combine($keys, $names);
        }

        return $res;
    }

    private function getSectionTopics(Elements $array) {
        if ($array->count() > 0) {
            $result = mysql_fetch_row(mysql_query("SELECT GROUP_CONCAT(`id` SEPARATOR ',') FROM `forum` WHERE `type` = 't' AND `refid` IN(" . implode(',', $array->get()) . ")"))[0];


            return !is_int($result) && !empty($result) ? explode(',', $result) : [$result];
        } else {
            return [];
        }
    }

    private function diff(array $section, array $array) {
        $result = [];
        foreach ($section as $value) {
            if (!in_array($value, $array)) {
                $result[] = $value;
            }
        }
        return $result;
    }

    private function getInts($type = 'pick') {
        if (!in_array($type, ['pick', 'ban'])) {
            return false;
        }
        return $type == 'pick'
            ? array_unique($this->picks()->get() + $this->getSectionTopics($this->sPicks()))
            : array_unique($this->bans()->get() + $this->getSectionTopics($this->sBans()));
    }
}
