<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

require('../incfiles/core.php');
$lng_forum = core::load_lng('forum');
if (isset($_SESSION['ref']))
    unset($_SESSION['ref']);

/*
-----------------------------------------------------------------
Настройки форума
-----------------------------------------------------------------
*/
$set_forum = $user_id && !empty($datauser['set_forum']) ? unserialize($datauser['set_forum']) : array(
    'farea'    => 1,
    'upfp'     => 0,
    'preview'  => 1,
    'postclip' => 1,
    'postcut'  => 2
);

/*
-----------------------------------------------------------------
Список расширений файлов, разрешенных к выгрузке
-----------------------------------------------------------------
*/
// Файлы архивов
$ext_arch = array(
    'zip',
    'rar',
    '7z',
    'tar',
    'gz',
    'apk'
);
// Звуковые файлы
$ext_audio = array(
    'mp3',
    'amr'
);
// Файлы документов и тексты
$ext_doc = array(
    'txt',
    'pdf',
    'doc',
    'docx',
    'rtf',
    'djvu',
    'xls',
    'xlsx'
);
// Файлы Java
$ext_java = array(
    'sis',
    'sisx',
    'apk'
);
// Файлы картинок
$ext_pic = array(
    'jpg',
    'jpeg',
    'gif',
    'png',
    'bmp'
);
// Файлы SIS
$ext_sis = array(
    'sis',
    'sisx'
);
// Файлы видео
$ext_video = array(
    '3gp',
    'avi',
    'flv',
    'mpeg',
    'mp4'
);
// Файлы Windows
$ext_win = array(
    'exe',
    'msi'
);
// Другие типы файлов (что не перечислены выше)
$ext_other = array('wmf');

// Ограничиваем доступ к Форуму
$error = '';
if (!$set['mod_forum'] && $rights < 7)
    $error = $lng_forum['forum_closed'];
elseif ($set['mod_forum'] == 1 && !$user_id)
    $error = $lng['access_guest_forbidden'];
if ($error) {
    require('../incfiles/head.php');
    echo '<div class="rmenu"><p>' . $error . '</p></div>';
    require('../incfiles/end.php');
    exit;
}

$headmod = $id ? 'forum,' . $id : 'forum';

// Заголовки страниц форума
if (empty($id)) {
    $textl = '' . $lng['forum'] . '';
} else {
    $req = mysql_query("SELECT `text` FROM `forum` WHERE `id`= '" . $id . "'");
    $res = mysql_fetch_assoc($req);
    $hdr = strtr($res['text'], array(
        '&laquo;' => '',
        '&raquo;' => '',
        '&quot;'  => '',
        '&amp;'   => '',
        '&lt;'    => '',
        '&gt;'    => '',
        '&#039;'  => ''
    ));
    $hdr = mb_substr($hdr, 0, 30);
    $hdr = functions::checkout($hdr);
    $textl = mb_strlen($res['text']) > 30 ? $hdr . '...' : $hdr;
}

// Переключаем режимы работы
$mods = array(
    'addfile',
    'addvote',
    'close',
    'deltema',
    'delvote',
    'editpost',
    'editvote',
    'arz',
	'arz_del',
	'shikoyat',
    'fayl',
	'zaklad',
	'zaklad_del',
    'my_zaklad',
	'txt',
	'm1',
	'm2',
    'rahmat',
    'plyus',
	'minus',
	'file',
    'files',
    'filter',
    'loadtem',
    'massdel',
    'new',
    'nt',
    'per',
    'post',
    'ren',
    'restore',
    'say',
    'tema',
    'users',
    'vip',
    'vote',
    'who',
    'curators'
);
if ($act && ($key = array_search($act, $mods)) !== false && file_exists('includes/' . $mods[$key] . '.php')) {
    require('includes/' . $mods[$key] . '.php');
} else {
    require('../incfiles/head.php');

    // Если форум закрыт, то для Админов выводим напоминание
    if (!$set['mod_forum']) echo '<div class="alarm">' . $lng_forum['forum_closed'] . '</div>';
    elseif ($set['mod_forum'] == 3) echo '<div class="rmenu">' . $lng['read_only'] . '</div>';
    if (!$user_id) {
        if (isset($_GET['newup']))
            $_SESSION['uppost'] = 1;
        if (isset($_GET['newdown']))
            $_SESSION['uppost'] = 0;
    }
    if ($id) {
        // Определяем тип запроса (каталог, или тема)
        $type = mysql_query("SELECT * FROM `forum` WHERE `id`= '$id'");
        if (!mysql_num_rows($type)) {
            // Если темы не существует, показываем ошибку
            echo functions::display_error($lng_forum['error_topic_deleted'], '<a href="index.php">' . $lng['to_forum'] . '</a>');
            require('../incfiles/end.php');
            exit;
        }
        $type1 = mysql_fetch_assoc($type);

        // Фиксация факта прочтения Топика
        if ($user_id && $type1['type'] == 't') {
            $req_r = mysql_query("SELECT * FROM `cms_forum_rdm` WHERE `topic_id` = '$id' AND `user_id` = '$user_id' LIMIT 1");
            if (mysql_num_rows($req_r)) {
                $res_r = mysql_fetch_assoc($req_r);
                if ($type1['time'] > $res_r['time'])
                    mysql_query("UPDATE `cms_forum_rdm` SET `time` = '" . time() . "' WHERE `topic_id` = '$id' AND `user_id` = '$user_id' LIMIT 1");
            } else {
                mysql_query("INSERT INTO `cms_forum_rdm` SET `topic_id` = '$id', `user_id` = '$user_id', `time` = '" . time() . "'");
            }
        }

        // Получаем структуру форума
        $res = true;
        $allow = 0;
        $parent = $type1['refid'];
        while ($parent != '0' && $res != false) {
            $req = mysql_query("SELECT * FROM `forum` WHERE `id` = '$parent' LIMIT 1");
            $res = mysql_fetch_assoc($req);
            if ($res['type'] == 'f' || $res['type'] == 'r') {
                $tree[] = '<a href="index.php?id=' . $parent . '">' . $res['text'] . '</a>';
                if ($res['type'] == 'r' && !empty($res['edit'])) {
                    $allow = intval($res['edit']);
                }
            }
            $parent = $res['refid'];
        }
        $tree[] = '<a href="index.php">' . $lng['forum'] . '</a>';
        krsort($tree);
        if ($type1['type'] != 't' && $type1['type'] != 'm')
            $tree[] = '<b>' . $type1['text'] . '</b>';

        // Счетчик файлов и ссылка на них
        $sql = ($rights == 9) ? "" : " AND `del` != '1'";
        if ($type1['type'] == 'f') {
            $count = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `cat` = '$id'" . $sql), 0);
            if ($count > 0)
                $filelink = '<a href="index.php?act=files&amp;c=' . $id . '">' . $lng_forum['files_category'] . '</a>';
        } elseif ($type1['type'] == 'r') {
            $count = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `subcat` = '$id'" . $sql), 0);
            if ($count > 0)
                $filelink = '<a href="index.php?act=files&amp;s=' . $id . '">' . $lng_forum['files_section'] . '</a>';
        } elseif ($type1['type'] == 't') {
            $count = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `topic` = '$id'" . $sql), 0);
            if ($count > 0)
                $filelink = '<a href="index.php?act=files&amp;t=' . $id . '">' . $lng_forum['files_topic'] . '</a>';
        }
        $filelink = isset($filelink) ? $filelink . '&#160;<span class="red">(' . $count . ')</span>' : false;

        // Счетчик "Кто в теме?"
        $wholink = false;
        if ($user_id && $type1['type'] == 't') {
            $online_u = mysql_result(mysql_query("SELECT COUNT(*) FROM `users` WHERE `lastdate` > " . (time() - 300) . " AND `place` = 'forum,$id'"), 0);
            $online_g = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_sessions` WHERE `lastdate` > " . (time() - 300) . " AND `place` = 'forum,$id'"), 0);
            $wholink = '<a href="index.php?act=who&amp;id=' . $id . '">' . $lng_forum['who_here'] . '?</a>&#160;<span class="red">(' . $online_u . '&#160;/&#160;' . $online_g . ')</span><br/>';
        }

		
        switch ($type1['type']) {
            case 'r':
                ////////////////////////////////////////////////////////////
                // Список топиков                                         //
                ////////////////////////////////////////////////////////////
                $total = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type`='t' AND `refid`='$id'" . ($rights >= 7 ? '' : " AND `close`!='1'")), 0);
                if (($user_id && !isset($ban['1']) && !isset($ban['11']) && $set['mod_forum'] != 4) || core::$user_rights) {

$ps = mysql_fetch_assoc(mysql_query("SELECT `text` FROM `forum` WHERE `type` = 'r' AND `close` != '1' AND `id` = '" . $id . "' ORDER BY `time` DESC LIMIT 1"));
echo '<div class="phdr"><b>'.$ps['text'].'</b></div>';
				                    // Кнопка создания новой темы
	echo '<div class="menu"><img src="images/create.png"> <a href="index.php?act=nt&amp;id='.$id.'&yes">'.$lng_forum['new_topic'].'</a></div>';
                }
				echo '<div class="phdr"><b>'.$lng_forum['topic'].'</b></div>';
                if ($total) {
                    $req = mysql_query("SELECT * FROM `forum` WHERE `type`='t'" . ($rights >= 7 ? '' : " AND `close`!='1'") . " AND `refid`='$id' ORDER BY `vip` DESC, `time` DESC LIMIT $start, $kmess");
                    $i = 0;
                    while (($res = mysql_fetch_assoc($req)) !== false) {
                        if ($res['close'])
                            echo '<div class="rmenu">';
                        else
                            echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                        $nikuser = mysql_query("SELECT `user_id`,`from` FROM `forum` WHERE `type` = 'm' AND `close` != '1' AND `refid` = '" . $res['id'] . "' ORDER BY `time` DESC LIMIT 1");
                        $nam = mysql_fetch_assoc($nikuser);
                        $colmes = mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `refid`='" . $res['id'] . "'" . ($rights >= 7 ? '' : " AND `close` != '1'"));
                        $colmes1 = mysql_result($colmes, 0);
                        $cpg = ceil($colmes1 / $kmess);
                        $np = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_rdm` WHERE `time` >= '" . $res['time'] . "' AND `topic_id` = '" . $res['id'] . "' AND `user_id`='$user_id'"), 0);
                        
echo '<img src="images/forum.png"> <a href="index.php?id=' . $res['id'] . '"><b>' . $res['text'] . '</b></a> (' . $colmes1 . ')';
                        
						echo '</br>Muallif: <a href="/users/profile.php?user='.$res['user_id'].'"><b>'.$res['from'].'</b></a>';
                        if (!empty($nam['from'])) {
 echo '</br>Javob berdi: <a href="/users/profile.php?user='.$nam['user_id'].'"><b>'.$nam['from'].'</b></a>';
                        }
     echo ' <span class="gray">(' . functions::display_date($res['time']) . ')</span>
	 </br>Sahifa: <a href="index.php?id=' . $res['id'] . '&amp;page=' . $cpg . '">&#160;&gt;&gt;&gt;</a></div>';
                        ++$i;
                    }
                    unset($_SESSION['fsort_id']);
                    unset($_SESSION['fsort_users']);
                } else {
                    echo '<div class="menu"><p>' . $lng_forum['topic_list_empty'] . '</p></div>';
                }
                echo '<div class="phdr">' . $lng['total'] . ': ' . $total . '</div>';
                if ($total > $kmess) {
                    echo '<div class="topmenu">' . functions::display_pagination('index.php?id=' . $id . '&amp;', $start, $total, $kmess) . '</div>' .
                        '<p><form action="index.php?id=' . $id . '" method="post">' .
                        '<input type="text" name="page" size="2"/>' .
                        '<input type="submit" value="' . $lng['to_page'] . ' &gt;&gt;"/>' .
                        '</form></p>';
                }
                break;

            case 't':
                ////////////////////////////////////////////////////////////
                // Показываем тему с постами                              //
                ////////////////////////////////////////////////////////////
                $filter = isset($_SESSION['fsort_id']) && $_SESSION['fsort_id'] == $id ? 1 : 0;
                $sql = '';
                if ($filter && !empty($_SESSION['fsort_users'])) {
                    // Подготавливаем запрос на фильтрацию юзеров
                    $sw = 0;
                    $sql = ' AND (';
                    $fsort_users = unserialize($_SESSION['fsort_users']);
                    foreach ($fsort_users as $val) {
                        if ($sw)
                            $sql .= ' OR ';
                        $sortid = intval($val);
                        $sql .= "`forum`.`user_id` = '$sortid'";
                        $sw = 1;
                    }
                    $sql .= ')';
                }

                // Если тема помечена для удаления, разрешаем доступ только администрации
                if ($rights < 6 && $type1['close'] == 1) {
                    echo '<div class="rmenu"><p>' . $lng_forum['topic_deleted'] . '<br/><a href="?id=' . $type1['refid'] . '">' . $lng_forum['to_section'] . '</a></p></div>';
                    require('../incfiles/end.php');
                    exit;
                }

                // Счетчик постов темы
                $colmes = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type`='m'$sql AND `refid`='$id'" . ($rights >= 7 ? '' : " AND `close` != '1'")), 0);
                if ($start >= $colmes) {
                    // Исправляем запрос на несуществующую страницу
                    $start = max(0, $colmes - (($colmes % $kmess) == 0 ? $kmess : ($colmes % $kmess)));
                }
$tf = mysql_fetch_assoc(mysql_query("SELECT `id`,`refid`,`text`, `soft`, `edit` FROM `forum` WHERE `type`='f' AND `id`='".$res['id']."' ORDER BY `realid`"));
$tp = mysql_fetch_assoc(mysql_query("SELECT `id`,`refid`,`text`, `soft`, `edit` FROM `forum` WHERE `type`='r' AND `refid`='".$res['id']."' ORDER BY `realid`"));
/////////////////////
//mysql_query("UPDATE `forum_lenta` SET `status` = '0',`user`='".$user_id."' WHERE `mavzu`='".$id."'");

echo '<div class="menu"><a href="/"><b>'.$tf['text'].'</b></a> | <a href="?id='.$tp['id'].'"><b>'.$tp['text'].'</b></a></div>';
echo '<div class="menu"><b>Mavzu:</b> '.$type1['text'].'</div>';
$co = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `topic`='$id'"), 0);
if ($co > 0){
echo '<div class="menu"><img src="images/file.png"> <a href="?act=fayl&id='.$id.'">Mavzu fayllari</a> <b>('.$co.')</b></div>';
             }
			 // Выводим название топика
echo '<div class="phdr"><b>' . $lng_forum['post'].'</b></div>';

                // Метка удаления темы
                if ($type1['close']) {
                    echo '<div class="rmenu">' . $lng_forum['topic_delete_who'] . ': <b>' . $type1['close_who'] . '</b></div>';
                } elseif (!empty($type1['close_who']) && $rights >= 7) {
                    echo '<div class="gmenu"><small>' . $lng_forum['topic_delete_whocancel'] . ': <b>' . $type1['close_who'] . '</b></small></div>';
                }

                // Метка закрытия темы
                if ($type1['edit']) {
                    echo '<div class="rmenu">' . $lng_forum['topic_closed'] . '</div>';
                }

                // Блок голосований
                if ($type1['realid']) {
                    $clip_forum = isset($_GET['clip']) ? '&amp;clip' : '';
                    $vote_user = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_vote_users` WHERE `user`='$user_id' AND `topic`='$id'"), 0);
                    $topic_vote = mysql_fetch_assoc(mysql_query("SELECT `name`, `time`, `count` FROM `cms_forum_vote` WHERE `type`='1' AND `topic`='$id' LIMIT 1"));
                    echo '<div  class="gmenu"><b>' . functions::checkout($topic_vote['name']) . '</b><br />';
                    $vote_result = mysql_query("SELECT `id`, `name`, `count` FROM `cms_forum_vote` WHERE `type`='2' AND `topic`='" . $id . "' ORDER BY `id` ASC");
                    if (!$type1['edit'] && !isset($_GET['vote_result']) && $user_id && $vote_user == 0) {
                        // Выводим форму с опросами
                        echo '<form action="index.php?act=vote&amp;id=' . $id . '" method="post">';
                        while (($vote = mysql_fetch_assoc($vote_result)) !== false) {
                            echo '<input type="radio" value="' . $vote['id'] . '" name="vote"/> ' . functions::checkout($vote['name'], 0, 1) . '<br />';
                        }
                        echo '<p><input type="submit" name="submit" value="' . $lng['vote'] . '"/><br /><a href="index.php?id=' . $id . '&amp;start=' . $start . '&amp;vote_result' . $clip_forum .
                            '">' . $lng_forum['results'] . '</a></p></form></div>';
                    } else {
                        // Выводим результаты голосования
                        echo '<small>';
                        while (($vote = mysql_fetch_assoc($vote_result)) !== false) {
                            $count_vote = $topic_vote['count'] ? round(100 / $topic_vote['count'] * $vote['count']) : 0;
                            echo functions::checkout($vote['name'], 0, 1) . ' [' . $vote['count'] . ']<br />';
                            echo '<img src="vote_img.php?img=' . $count_vote . '" alt="' . $lng_forum['rating'] . ': ' . $count_vote . '%" /><br />';
                        }
                        echo '</small></div><div class="bmenu">' . $lng_forum['total_votes'] . ': ';
                        if (core::$user_rights > 6)
                            echo '<a href="index.php?act=users&amp;id=' . $id . '">' . $topic_vote['count'] . '</a>';
                        else
                            echo $topic_vote['count'];
                        echo '</div>';
                        if ($user_id && $vote_user == 0)
                            echo '<div class="bmenu"><a href="index.php?id=' . $id . '&amp;start=' . $start . $clip_forum . '">' . $lng['vote'] . '</a></div>';
                    }
                }

                // Получаем данные о кураторах темы
                $curators = !empty($type1['curators']) ? unserialize($type1['curators']) : array();
                $curator = false;
                if ($rights < 6 && $rights != 3 && $user_id) {
                    if (array_key_exists($user_id, $curators)) $curator = true;
                }

                // Фиксация первого поста в теме
                if (($set_forum['postclip'] == 2 && ($set_forum['upfp'] ? $start < (ceil($colmes - $kmess)) : $start > 0)) || isset($_GET['clip'])) {
                    $postreq = mysql_query("SELECT `forum`.*, `users`.`sex`, `users`.`rights`, `users`.`lastdate`, `users`.`status`, `users`.`datereg`
                    FROM `forum` LEFT JOIN `users` ON `forum`.`user_id` = `users`.`id`
                    WHERE `forum`.`type` = 'm' AND `forum`.`refid` = '$id'" . ($rights >= 7 ? "" : " AND `forum`.`close` != '1'") . "
                    ORDER BY `forum`.`id` LIMIT 1");
                    $postres = mysql_fetch_assoc($postreq);
                    if ($postres['sex'])
echo '';
                    else
echo '';
                    if ($user_id && $user_id != $postres['user_id']) {
                    } else {
                    }
                    echo @$user_rights[$postres['rights']];
                    if ($postres['close']) {
                    }
                    if (mb_strlen($postres['text']) > 500)
                    echo '</p></div>';
                }

                // Памятка, что включен фильтр
                if ($filter) {
                    echo '<div class="rmenu">' . $lng_forum['filter_on'] . '</div>';
                }

                // Задаем правила сортировки (новые внизу / вверху)
                if ($user_id) {
                    $order = $set_forum['upfp'] ? 'DESC' : 'ASC';
                } else {
                    $order = ((empty($_SESSION['uppost'])) || ($_SESSION['uppost'] == 0)) ? 'ASC' : 'DESC';
                }

                ////////////////////////////////////////////////////////////
                // Основной запрос в базу, получаем список постов темы    //
                ////////////////////////////////////////////////////////////
                $req = mysql_query("
                  SELECT `forum`.*, `users`.`sex`, `users`.`rights`, `users`.`lastdate`, `users`.`status`, `users`.`datereg`
                  FROM `forum` LEFT JOIN `users` ON `forum`.`user_id` = `users`.`id`
                  WHERE `forum`.`type` = 'm' AND `forum`.`refid` = '$id'"
                    . ($rights >= 7 ? "" : " AND `forum`.`close` != '1'") . "$sql
                  ORDER BY `forum`.`id` $order LIMIT $start, $kmess
                ");

				                // Верхнее поле "Написать"
                if (($user_id && !$type1['edit'] && $set_forum['upfp'] && $set['mod_forum'] != 3 && $allow != 4) || ($rights >= 7 && $set_forum['upfp'])) {
                    echo '<div class="gmenu"><form name="form1" action="index.php?act=say&amp;id=' . $id . '" method="post">';
                    if ($set_forum['farea']) {
                        $token = mt_rand(1000, 100000);
                        $_SESSION['token'] = $token;
                        echo '<p>' .
                            bbcode::auto_bb('form1', 'msg') .
                            '<textarea rows="' . $set_user['field_h'] . '" name="msg"></textarea></p>' .
                            '<p><input type="checkbox" name="addfiles" value="1" /> ' . $lng_forum['add_file'] .
                            ($set_user['translit'] ? '<br /><input type="checkbox" name="msgtrans" value="1" /> ' . $lng['translit'] : '') .
                            '</p><p><input type="submit" name="submit" value="' . $lng['write'] . '" style="width: 107px; cursor: pointer;"/> ' .
                            (isset($set_forum['preview']) && $set_forum['preview'] ? '<input type="submit" value="' . $lng['preview'] . '" style="width: 107px; cursor: pointer;"/>' : '') .
                            '<input type="hidden" name="token" value="' . $token . '"/>' .
                            '</p></form></div>';
                    } else {
                        echo '<p><input type="submit" name="submit" value="' . $lng['write'] . '"/></p></form></div>';
                    }
                }

                // Для администрации включаем форму массового удаления постов
                if ($rights == 3 || $rights >= 6)
                    echo '<form action="index.php?act=massdel" method="post">';
                $i = 1;

                ////////////////////////////////////////////////////////////
                // Основной список постов                                 //
                ////////////////////////////////////////////////////////////
                while (($res = mysql_fetch_assoc($req)) !== false) {
                    // Фон поста
                    if ($res['close']) {
                        echo '<div class="rmenu">';
                    } else {
                        echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                    }

echo '<b>'.++$st.'.</b> ';
	// Метка пола
                    if ($res['sex']) {
echo (time() > $res['lastdate'] + 300 ? '<img src="/images/' . ($res['sex'] == 'm' ? 'man' : 'woman') . ($res['rights'] > 7 && $res['rights'] < 10 ? '_sv' : '') . ($res['rights'] > 6 && $res['rights'] < 9 ? '_adm' : '') . ($res['rights'] > 5 && $res['rights'] < 7 ? '_smod' : '') . ($res['rights'] > 4 && $res['rights'] < 6 ? '_lmod' : '') . ($res['rights'] > 3 && $res['rights'] < 5 ? '_dmod' : '') . ($res['rights'] > 2 && $res['rights'] < 4 ? '_fmod' : '') . '_off.gif" width="14" height="14" align="middle" alt=""/>&#160;' : '<img src="/images/' . ($res['sex'] == 'm' ? 'man' : 'woman') . ($res['rights'] > 7 && $res['rights'] < 10 ? '_sv' : '') . ($res['rights'] > 6 && $res['rights'] < 9 ? '_adm' : '') . ($res['rights'] > 5 && $res['rights'] < 7 ? '_smod' : '') . ($res['rights'] > 4 && $res['rights'] < 6 ? '_lmod' : '') . ($res['rights'] > 3 && $res['rights'] < 5 ? '_dmod' : '') . ($res['rights'] > 2 && $res['rights'] < 4 ? '_fmod' : '') . '_on.gif" width="14" height="14" align="middle" alt=""/> ');
                    } else {
                        echo functions::image('del.png');
                    }
$z=mysql_query("SELECT * FROM `forum_group` WHERE `user_id`='".$res['user_id']."' LIMIT 1");
     while (($a = mysql_fetch_array($z)) !== false) {
echo '<img src="/images/group/'.$a['img'].'.png" width="13" height="13" style="margin-bottom: -2px;" alt="*"> ';
}										
					
 // Ник юзера и ссылка на его анкету
                    if ($user_id && $user_id != $res['user_id']) {
echo '<a href="../users/profile.php?user=' . $res['user_id'] . '"><b>' . $res['from'] . '</b></a> ';
$u_p = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `user_id`='".$res['user_id']."'" . ($rights >= 7 ? '' : " AND `close`!='1'")), 0);
echo '<span style="color: #525252; font-weight: bold;"> ['.$u_p.']</span>';
                    } else {
                        echo '<b>' . $res['from'] . '</b> ';
$u_p = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type`='m' AND `user_id`='".$res['user_id']."'" . ($rights >= 7 ? '' : " AND `close`!='1'")), 0);
echo '<span style="color: #525252; font-weight: bold;"> ['.$u_p.']</span>';
						}
echo (!empty($res['medal']) ? ' <img src="/images/huso/' . $res['medal'] . '.png" align="top"/ >' : '');
                    // Метка онлайн/офлайн
$sek= time()-$res['lastdate']; if($sek==0){$bbb='<span class="green"> [on]</span>  ';}elseif($sek<60){$bbb='<span class="green"> ['.$sek.'s]</span>  ';}elseif($sek>60&&$sek<120){$bbb='<span class="green"> [1m]</span>  ';}elseif($sek>120&&$sek<180){$bbb='<span class="green"> [2m]</span>  ';}elseif($sek>180&&$sek<240){$bbb='<span class="green"> [3m]</span>  ';}elseif($sek>240&&$sek<300){$bbb='<span class="green"> [4m]</span>  ';}elseif($sek>300&&$sek<360){$bbb='<span class="green"> [5m]</span>  ';}elseif($sek>360&&$sek<420){$bbb='<span class="green"> [6m]</span>  ';}elseif($sek>420&&$sek<480){$bbb='<span class="green"> [7m]</span>  ';}elseif($sek>480&&$sek<540){$bbb='<span class="green"> [8m]</span>  ';}elseif($sek>540&&$sek<600){$bbb='<span class="green"> [9m]</span>  '; }echo( time()>$res['lastdate']+300 ? '<span class="red"> [off]</span>':'<span class="black">'.$bbb.'</span></a>');
if ($user_id != $res['user_id']){
}else{
echo ' <a href="/forum/index.php?id='.$res['id'].'&act=addfile">Fayl biriktirish</a>';
}
		//////////////////////--------->>>>>>>>>>>>>>>>>>
                    // Ссылки на ответ и цитирование
                    if ($user_id && $user_id != $res['user_id']) {
$r1 = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_rahmat` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."'"));
if ($user_id && $user_id != $r1['user_id'])echo ' <a href="?act=rahmat&amp;id='.$res['id'].'">Rahmat</a> <span style="color: #BFC6CF;">|</span> ';
echo '<a href="index.php?act=say&amp;id=' . $res['id'] . '&amp;yes">Javob</a> <span style="color: #BFC6CF;">|</span> ' .
'<a href="index.php?act=say&amp;id=' . $res['id'] . '&amp;yes&cyt">Sit</a> <span style="color: #BFC6CF;">|</span> ';
echo '<a href="?act=arz&amp;id='.$res['id'].'">Arz</a><span style="color: #BFC6CF;"> |</span>
<a href="/mail/index.php?act=write&id=' . $res['user_id'] . '">Sh/x</a> <span style="color: #BFC6CF;">|</span> 

<a href="?act=txt&id='.$res['id'].'">TXT</a> '; 

$r2 = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."' and `votte` = '1'"));
if ($user_id && $user_id != $r2['user_id'])echo '<span style="color: #BFC6CF;">|</span> <a href="?act=plyus&id='.$res['id'].'">+</a> ';

$r3 = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."' and `votte` = '2'"));
if ($user_id && $user_id != $r3['user_id'])echo '<span style="color: #BFC6CF;">|</span> <a href="?act=minus&id='.$res['id'].'">-</a>';

                    }
////////////////--------------->>>>>>>>>>>>>>>>>
                    // Время поста
                    echo '<div class="br"></div><span class="gray">' . functions::display_date($res['time']) . '</span><br />';


                    // Закрываем таблицу с аватаром
                    if ($set_user['avatar']) {
                        echo '</td></tr></table>';
                    }

                    ////////////////////////////////////////////////////////////
                    // Вывод текста поста                                     //
                    ////////////////////////////////////////////////////////////
                    $text = $res['text'];
                    $text = functions::checkout($text, 1, 1);
                    if ($set_user['smileys']) {
                        $text = functions::smileys($text, $res['rights'] ? 1 : 0);
                    }
echo '<div style="padding-top: 4px;"></div>
<div style="border-bottom: 1px dashed #D7EBB9; border-top: 1px dashed #D7EBB9;">
<div style="padding: 10px 0px;">'.$text.'</div></div><div style="font-size: inherit;"><small></small></div>';
/////////////////////+++++//////////////////////////////
$s1 = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."' and `votte` = '1'"));
$hisob = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$s1['post_id']."' and `votte` = '1'"),0);
  if($hisob > 0){
echo '<div style="border-bottom: 1px dashed #D7EBB9; padding: 4px 0px;"><i>
<b style="color: #525252;">+ ('.$hisob.'): </b>'; 
}

$ss1 = mysql_query("SELECT * FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."' and `votte` = '1'");
  while($s1 = mysql_fetch_assoc($ss1)){
  $us = mysql_fetch_assoc(mysql_query("SELECT * FROM `users` WHERE `id` = '".$s1['user_id']."'"));
echo '<a href="../users/profile.php?user='.$us['id'].'"><b>'.$us['name'].'</b></a>, '; 
}
  if($hisob > 0){echo '</i></div>';}
/////////////////////----////////////////////////////////
$s2 = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."' and `votte` = '2'"));
$hisob = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$s2['post_id']."' and `votte` = '2'"),0);
  if($hisob > 0){
echo '<div style="border-bottom: 1px dashed #D7EBB9; padding: 4px 0px;"><i>
<b style="color: #525252;">- ('.$hisob.'): </b>'; 
}

$ss2 = mysql_query("SELECT * FROM `forum_votte` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."' and `votte` = '2'");
  while($s2 = mysql_fetch_assoc($ss2)){
  $us = mysql_fetch_assoc(mysql_query("SELECT * FROM `users` WHERE `id` = '".$s2['user_id']."'"));
echo '<a href="../users/profile.php?user='.$us['id'].'"><b>'.$us['name'].'</b></a>, '; 
}
  if($hisob > 0){echo '</i></div>';}
/////////////////Rahmat aytdi///////////////////////////
$s = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_rahmat` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."'"));
$hisob = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum_rahmat` WHERE `tema_id` = '".$id."' and `post_id` = '".$s['post_id']."'"),0);
  if($hisob > 0){
echo '<div style="border-bottom: 1px dashed #D7EBB9; padding: 4px 0px;"><i>
<b style="color: #525252;">Rahmat aytdi ('.$hisob.'): </b>'; 
}

$ss = mysql_query("SELECT * FROM `forum_rahmat` WHERE `tema_id` = '".$id."' and `post_id` = '".$res['id']."'");
  while($s = mysql_fetch_assoc($ss)){
  $us = mysql_fetch_assoc(mysql_query("SELECT * FROM `users` WHERE `id` = '".$s['user_id']."'"));
echo '<a href="../users/profile.php?user='.$us['id'].'"><b>'.$us['name'].'</b></a>, '; 
}
  if($hisob > 0){echo '</i></div>';}
///////////////////////////////////
					// Если пост редактировался, показываем кем и когда
                    if ($res['kedit']) {
                        echo '<br /><span class="gray"><small>' . $lng_forum['edited'] . ' <b>' . $res['edit'] . '</b> (' . functions::display_date($res['tedit']) . ') <b>[' . $res['kedit'] . ']</b></small></span>';
                    }

                    // Если есть прикрепленный файл, выводим его описание
$freq = mysql_query("SELECT * FROM `cms_forum_files` WHERE `post` = '" . $res['id'] . "'");
                    if (mysql_num_rows($freq) > 0) {
$file_count = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_files` WHERE `post` = '" . $res['id'] . "'"), 0);

						echo '<div style="border-bottom: 1px dashed #D7EBB9; border-top: 1px dashed #D7EBB9;">
<div style="padding: 4px 0px;"><b>' . $lng_forum['attached_file'] . ' ['.$file_count.']:</b>';
                        
while (($fres = mysql_fetch_assoc($freq)) !== FALSE) {
                        $fls = round(@filesize('../files/forum/attach/' . $fres['filename']) / 1024, 2);
                        // Предпросмотр изображений
                        $att_ext = strtolower(functions::format('./files/forum/attach/' . $fres['filename']));
                        $pic_ext = array(
                            'gif',
                            'jpg',
                            'jpeg',
                            'png'
                        );
                        if (in_array($att_ext, $pic_ext)) {
echo '<br />— <a href="index.php?act=file&amp;id=' . $fres['id'] . '">' . $fres['filename'] . '</a>';
                        } else {
echo '<br />— <a href="index.php?act=file&amp;id=' . $fres['id'] . '">' . $fres['filename'] . '</a>';
                        }
						}
						echo '</div></div>';

						}

                    // Ссылки на редактирование / удаление постов
                    if (
                        (($rights == 3 || $rights >= 6 || $curator) && $rights >= $res['rights'])
                        || ($res['user_id'] == $user_id && !$set_forum['upfp'] && ($start + $i) == $colmes && $res['time'] > time() - 300)
                        || ($res['user_id'] == $user_id && $set_forum['upfp'] && $start == 0 && $i == 1 && $res['time'] > time() - 300)
                        || ($i == 1 && $allow == 2 && $res['user_id'] == $user_id)
                    ) {
echo '<div style="font-size: inherit;">';

                        // Чекбокс массового удаления постов
                        if ($rights == 3 || $rights >= 6) {
                            echo '<input type="checkbox" name="delch[]" value="' . $res['id'] . '"/>&#160;';
                        }

                        // Служебное меню поста
                        $menu = array(
                            '<a href="index.php?act=editpost&amp;id=' . $res['id'] . '">' . $lng['edit'] . '</a>',
                            ($rights >= 7 && $res['close'] == 1 ? '<a href="index.php?act=editpost&amp;do=restore&amp;id=' . $res['id'] . '">' . $lng_forum['restore'] . '</a>' : ''),
                            ($res['close'] == 1 ? '' : '<a href="index.php?act=editpost&amp;do=del&amp;id=' . $res['id'] . '">' . $lng['delete'] . '</a>')
                        );
                        echo functions::display_menu($menu);

                        // Показываем, кто удалил пост
                        if ($res['close']) {
                            echo '<div class="red">' . $lng_forum['who_delete_post'] . ': <b>' . $res['close_who'] . '</b></div>';
                        } elseif (!empty($res['close_who'])) {
                            echo '<div class="green">' . $lng_forum['who_restore_post'] . ': <b>' . $res['close_who'] . '</b></div>';
                        }

                        // Показываем IP и Useragent
                        if ($rights == 3 || $rights >= 6) {
                            if ($res['ip_via_proxy']) {
                                echo '<div class="gray"><b class="red"><a href="' . $set['homeurl'] . '/' . $set['admp'] . '/index.php?act=search_ip&amp;ip=' . long2ip($res['ip']) . '">' . long2ip($res['ip']) . '</a></b> - ' .
                                    '<a href="' . $set['homeurl'] . '/' . $set['admp'] . '/index.php?act=search_ip&amp;ip=' . long2ip($res['ip_via_proxy']) . '">' . long2ip($res['ip_via_proxy']) . '</a>' .
                                    ' - ' . $res['soft'] . '</div>';
                            } else {
                                echo '<div class="gray"><a href="' . $set['homeurl'] . '/' . $set['admp'] . '/index.php?act=search_ip&amp;ip=' . long2ip($res['ip']) . '">' . long2ip($res['ip']) . '</a> - ' . $res['soft'] . '</div>';
                            }
                        }
                        echo '</div>';
                    }
                    echo '</div>';
                    ++$i;
                }

				
                // Постраничная навигация
                if ($colmes > $kmess) {
                    echo '<div class="menu" style="padding-top: 12px; padding-bottom: 12px;">' . functions::display_pagination('index.php?id=' . $id . '&amp;', $start, $colmes, $kmess) . '</div>' .
                        '<p><form action="index.php?id=' . $id . '" method="post">' .
                        '</form></p>';
                } else {
                }

				
				
                // Кнопка массового удаления постов
                if ($rights == 3 || $rights >= 6) {
                    echo '<div class="rmenu"><input type="submit" value=" ' . $lng['delete'] . ' "/></div>';
                    echo '</form>';
                }

                // Нижнее поле "Написать"
                if (($user_id && !$type1['edit'] && !$set_forum['upfp'] && $set['mod_forum'] != 3 && $allow != 4) || ($rights >= 7 && !$set_forum['upfp'])) {
				echo '<div class="phdr"><b>Mavzuga javob yozish</b></div>';
				echo '<div class="menu"><form name="form2" action="index.php?act=say&amp;id=' . $id . '" method="post">';
                    if ($set_forum['farea']) {
                        $token = mt_rand(1000, 100000);
                        $_SESSION['token'] = $token;
                        echo '<p>';
                        echo bbcode::auto_bb('form2', 'msg');
                        echo '<textarea rows="' . $set_user['field_h'] . '" name="msg"></textarea><br/></p>';
                        if ($set_user['translit'])
                            echo '<br /><input type="checkbox" name="msgtrans" value="1" /> ' . $lng['translit'];
echo '</p><p><input type="submit" name="submit" value="' . $lng['write'] . '" style="cursor: pointer;"/>
<input type="hidden" name="token" value="' . $token . '"/>' .
                            '</p></form></div>';
                    } else {
                        echo '<p><input type="submit" name="submit" value="' . $lng['write'] . '"/></p></form></div>';
                    }
                }

				if ($user_id && $user_id != $res['user_id']) {
echo '<div class="phdr"><b>Ma\'lumotlar</b></div>';
$r3 = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_mavzu` WHERE `tema` = '".$id."'"));
if ($user_id && $user_id != $r3['us']){
echo '<div class="menu"><img src="images/3.png" alt="-" style="width: 14px; margin-bottom: -3px;"> 
<a href="?act=m1&amp;id='.$id.'">Kerakli mavzu <font color="green"><b>+1</b></font></a>
<div class="br"></div><img src="images/3.png" alt="-" style="width: 14px; margin-bottom: -3px;"> 
<a href="?act=m2&amp;id='.$id.'">Keraksiz mavzu <font color="red"><b>-1</b></font></a><div class="br"></div></div>';
}
///////////////
if ($rights == 3 || $rights >= 6) {
$k = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum_mavzu` WHERE `tema` = '".$id."' AND `javob` = '1'"),0);
$k1 = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum_mavzu` WHERE `tema` = '".$id."' AND `javob` = '2'"),0);
echo '<div class="menu"><b>Berilgan ovozlar:</b><div class="br"></div>
Kerakli mavzu <font color="green"><b>+</b></font> <b>'.$k.' ta</b><div class="br"></div>
Keraksiz mavzu <font color="red"><b>-</b></font> <b>'.$k1.' ta</b></div>';
}
$forum_zaklad = mysql_fetch_assoc(mysql_query("SELECT * FROM `forum_zaklad` WHERE `tema` = '".$id."' and `us` = '".$user_id."' "));
if($forum_zaklad == 0) {
echo '<div class="menu"><img src="images/3.png" alt="-" style="width: 14px; margin-bottom: -3px;"> 
<a href="?act=zaklad&amp;id='.$id.'">Zakladkaga qo\'shish</a></div>';
} else {
echo '<div class="menu"><img src="images/3.png" alt="-" style="width: 14px; margin-bottom: -3px;"> 
<a href="?act=zaklad_del&amp;id='.$id.'">Zakladkadan o\'chirish</a></div>';

}
}
$m = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `refid` = '".$id."'"),0);
echo '<div class="menu">Mavzuga oid xabarlar soni: <b>'.$m.' ta</b>';
$v = mysql_query("SELECT * FROM `forum` WHERE `type`='m'" . ($rights >= 7 ? '' : " AND `close`!='1'") . " AND `refid`='$id' ORDER BY `vip` DESC, `time` DESC LIMIT 1");
while (($r = mysql_fetch_assoc($v)) !== FALSE) {
echo '<div class="br"></div>So\'ngi faollik vaqti: <b>' . functions::display_date($r['time']) . '</b></div>';
}

                // Список кураторов
                if ($curators) {
                    $array = array();
                    foreach ($curators as $key => $value) {
                        $array[] = '<a href="../users/profile.php?user=' . $key . '">' . $value . '</a>';
                    }
echo '<p><div class="menu">' . $lng_forum['curators'] . ': ' . implode(', ', $array) . '</div></p>';
                }

                // Ссылки на модерские функции управления темой
                if ($rights == 3 || $rights >= 6) {
echo '<p><div class="menu">';
                    if ($rights >= 7)
                        echo '<a href="index.php?act=curators&amp;id=' . $id . '&amp;start=' . $start . '">' . $lng_forum['curators_of_the_topic'] . '</a><br />';
                    echo isset($topic_vote) && $topic_vote > 0
                        ? '<a href="index.php?act=editvote&amp;id=' . $id . '">' . $lng_forum['edit_vote'] . '</a><br/><a href="index.php?act=delvote&amp;id=' . $id . '">' . $lng_forum['delete_vote'] . '</a><br/>'
                        : '<a href="index.php?act=addvote&amp;id=' . $id . '">' . $lng_forum['add_vote'] . '</a><br/>';
                    echo '<a href="index.php?act=ren&amp;id=' . $id . '">' . $lng_forum['topic_rename'] . '</a><br/>';
                    // Закрыть - открыть тему
                    if ($type1['edit'] == 1)
                        echo '<a href="index.php?act=close&amp;id=' . $id . '">' . $lng_forum['topic_open'] . '</a><br/>';
                    else
                        echo '<a href="index.php?act=close&amp;id=' . $id . '&amp;closed">' . $lng_forum['topic_close'] . '</a><br/>';
                    // Удалить - восстановить тему
                    if ($type1['close'] == 1)
                        echo '<a href="index.php?act=restore&amp;id=' . $id . '">' . $lng_forum['topic_restore'] . '</a><br/>';
                    echo '<a href="index.php?act=deltema&amp;id=' . $id . '">' . $lng_forum['topic_delete'] . '</a><br/>';
                    if ($type1['vip'] == 1)
                        echo '<a href="index.php?act=vip&amp;id=' . $id . '">' . $lng_forum['topic_unfix'] . '</a>';
                    else
                        echo '<a href="index.php?act=vip&amp;id=' . $id . '&amp;vip">' . $lng_forum['topic_fix'] . '</a>';
                    echo '<br/><a href="index.php?act=per&amp;id=' . $id . '">' . $lng_forum['topic_move'] . '</a></div></p>';
                }

                break;
								
				
            default:
                // Если неверные данные, показываем ошибку
                echo functions::display_error($lng['error_wrong_data']);
                break;
        }
    } else {
        ////////////////////////////////////////////////////////////
        // Список Категорий форума                                //
        ////////////////////////////////////////////////////////////
        $count = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_forum_files`" . ($rights >= 7 ? '' : " WHERE `del` != '1'")), 0);
     echo '<div class="phdr"><a href="?act=my_zaklad"><b>Zakladka</b></a> | <a href="search.php">' . $lng['search'] . '</a> | <a href="index.php?act=files">' . $lng_forum['files_forum'] . '</a> <span class="red">(' . $count . ')</span></div>';
if ($rights == 3 || $rights >= 6) {
$sh = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum_arz` ORDER by id"), 0);
echo '<div class="menu"><a href="index.php?act=shikoyat">Shikoyatlar ('.$sh.')</a></div>';
 } 
 
 $req = mysql_query("SELECT `id`,`user_id`, `text`, `soft` FROM `forum` WHERE `type`='f' ORDER BY `realid`");
        $i = 0;
        while (($res = mysql_fetch_array($req)) !== false) {
            echo '<div class="phdr">';
            echo '<b>'.$res['text'].'</b>';
            echo '</div>';
            ++$i;
        
$r = mysql_query("SELECT `id`,`refid`,`text`, `soft`, `edit` FROM `forum` WHERE `type`='r' AND `refid`='".$res['id']."' ORDER BY `realid`");
                $total = mysql_num_rows($r);
                if ($total) {
                    $i = 0;
                    while (($re = mysql_fetch_assoc($r)) !== false) {
                        echo $i % 2 ? '<div class="menu">' : '<div class="menu">';
$coltem = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type` = 't' AND `refid` = '" . $res['id'] . "'"), 0);
echo '<img src="images/3.png"> <a href="?id=' . $re['id'] . '">' . $re['text'] . '</a>';
$t = mysql_result(mysql_query("SELECT COUNT(*) FROM `forum` WHERE `type`='t' AND `refid`='".$re['id']."'" . ($rights >= 7 ? '' : " AND `close`!='1'")), 0);

echo ' ['.$t.']';
                        if ($coltem)
                            echo " ($coltem)";
							
                        echo '</div>';
                        ++$i;
                    }
                    unset($_SESSION['fsort_id']);
                    unset($_SESSION['fsort_users']);
                } else {
                    echo '<div class="menu"><p>' . $lng_forum['section_list_empty'] . '</p></div>';
                }
		
		
		}
        $online_u = mysql_result(mysql_query("SELECT COUNT(*) FROM `users` WHERE `lastdate` > " . (time() - 300) . " AND `place` LIKE 'forum%'"), 0);
        $online_g = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_sessions` WHERE `lastdate` > " . (time() - 300) . " AND `place` LIKE 'forum%'"), 0);
        echo '<div class="phdr">' . ($user_id ? '<a href="index.php?act=who">' . $lng_forum['who_in_forum'] . '</a>' : $lng_forum['who_in_forum']) . '&#160;(' . $online_u . '&#160;/&#160;' . $online_g . ')</div>';
        unset($_SESSION['fsort_id']);
        unset($_SESSION['fsort_users']);
    }

    // Навигация внизу страницы
    if (!$id) {
        echo '<a href="../pages/faq.php?act=forum">' . $lng_forum['forum_rules'] . '</a>';
    }
    echo '</p>';

}

require_once('../incfiles/end.php');