<?php
/*
 * Socialbux 5.0 (http://socialbux.net)
 * JohnCMS v7.1 Edition
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Dev Project
 * @email       Tunzxywalexdevmaster@gmail.com
 * @email       Tunzxy007@yahoo.com
 * @Whatsapp    +2349076642400 
 * @copyright   Copyright (C) Naijadev Community Wapego 2011-2019
 * @license     Premium Version Licence
 */

defined('_IN_JOHNADM') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

// Проверяем права доступа
if ($systemUser->rights < 7) {
    header('Location: ../?err');
    exit;
}

$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';

echo '<div id="page-wrapper">

            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="row">
                    <div class="col-lg-12">
                        <h1 class="page-header">
                            Dashboard <small>Restart Database</small>
                        </h1>
                        <ol class="breadcrumb">
                            <li class="active">
                                <i class="fa fa-dashboard"></i> Clear Cache
                            </li>
                        </ol>
                    </div>
                </div>
                <!-- /.row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="alert alert-info alert-dismissable">';

switch ($mod) {
    case 1:
        // Получаем список ID "мертвых" профилей
        $req = $db->query("SELECT `id`
            FROM `users`
            WHERE `datereg` < '" . (time() - 2592000 * 6) . "'
            AND `lastdate` < '" . (time() - 2592000 * 5) . "'
            AND `postforum` = '0'
            AND `postguest` < '10'
            AND `komm` < '10'
        ");

        if ($req->rowCount()) {
            $del = new Johncms\CleanUser;

            // Удаляем всю информацию
            while ($res = $req->fetch()) {
                $del->removeAlbum($res['id']);      // Удаляем личные Фотоальбомы
                $del->removeGuestbook($res['id']);  // Удаляем личную Гостевую
                $del->removeMail($res['id']);       // Удаляем почту
                $del->removeKarma($res['id']);      // Удаляем карму
                $del->cleanComments($res['id']);    // Удаляем комментарии
                $del->removeUser($res['id']);       // Удаляем пользователя
                $db->exec("DELETE FROM `cms_forum_rdm` WHERE `user_id` = " . $res['id']);
            }

            $db->query("
                OPTIMIZE TABLE
                `users`,
                `cms_album_cat`,
                `cms_album_files`,
                `cms_album_comments`,
                `cms_album_downloads`,
                `cms_album_views`,
                `cms_album_votes`,
                `cms_mail`,
                `cms_contact`,
                `cms_forum_rdm`
            ");
        }

        echo '<div class="rmenu"><p>' . _t('Inactive profiles deleted') . '</p><p><a href="index.php">' . _t('Continue') . '</a></p></div>';
        break;

    default:
        $total = $db->query("SELECT COUNT(*) FROM `users`
            WHERE `datereg` < '" . (time() - 2592000 * 6) . "'
            AND `lastdate` < '" . (time() - 2592000 * 5) . "'
            AND `postforum` = '0'
            AND `postguest` < '10'
            AND `komm` < '10'")->fetchColumn();
        echo '<div class="menu">' .
            '<form action="index.php?act=usr_clean&amp;mod=1" method="post">' .
            '<p><h3>' . _t('Inactive profiles') . '</h3>'
            . _t('This category includes profiles, recorded more than 6 months ago, with the date of last visit for more than 5 months ago and with zero activity.<br>Can safely remove them.') . '</p>' .
            '<p>' . _t('Total') . ': <b>' . $total . '</b></p>' .
            '<p><input type="submit" class="btn btn-default"  name="submit" value="' . _t('Delete') . '"/></p></form></div>' .
            '<div class="phdr"><a href="index.php">' . _t('Back') . '</a></div>';
}
