<?php

declare(strict_types=1);

use Documentation\DocArticles;
use Documentation\DocSections;

$view->addData(
    [
        'title'      => __('Добавить статью'),
        'page_title' => __('Добавить статью'),
    ],
    ['system::layout/default']
);

$data = [
    'page_title'  => __('Добавить статью'),
    'errors'      => [],
    'messages'    => [],
    'form_action' => '/documentation/add_article/',
    'back_url'    => '/documentation/',
];

$data['sections'] = DocSections::all();

$data['fields'] = [
    'name'       => $request->getPost('name', '', FILTER_SANITIZE_STRING),
    'code'       => $request->getPost('code', '', FILTER_SANITIZE_STRING),
    'page_title' => $request->getPost('page_title', '', FILTER_SANITIZE_STRING),
    'version'    => $request->getPost('version', '', FILTER_SANITIZE_STRING),
    'section_id' => $request->getPost('section_id', '', FILTER_VALIDATE_INT),
    'text'       => $request->getPost('text', ''),
    'created_by' => $user->id,
];

if ($request->getMethod() === 'POST') {
    $check = DocArticles::where('code', '=', $data['fields']['code'])->first();

    if (! $check) {
        DocArticles::create($data['fields']);
        $data['messages'][] = 'Статья успешно добавлена';
        $data['fields'] = [
            'name'       => '',
            'code'       => '',
            'page_title' => '',
            'version'    => '',
            'section_id' => '',
            'text'       => '',
        ];
    } else {
        $data['errors'][] = 'Такая запись уже есть';
    }
}


echo $view->render('documentation::add_article', ['data' => $data]);
