<?php

namespace Documentation;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @mixin Builder
 * @property integer id
 * @property integer section_id
 * @property string name
 * @property string page_title
 * @property string code
 * @property string version
 * @property string text
 * @property integer view_count
 * @property integer created_by
 * @property integer updated_by
 *
 * @property string detail_page_url
 */
class DocArticles extends Model
{

    use SoftDeletes;

    protected $fillable = [
        'section_id',
        'name',
        'page_title',
        'version',
        'code',
        'text',
        'created_by',
        'updated_by',
    ];

    /**
     * Связь с моделью разделов
     *
     * @return HasOne
     */
    public function section(): HasOne
    {
        return $this->hasOne(DocSections::class, 'id', 'section_id');
    }

    public function getDetailPageUrlAttribute(): string
    {
        return '/documentation/' . $this->code . '/';
    }

    /**
     * @return DocArticles|Model|object|null
     */
    public function getPreviousArticleAttribute()
    {
        return (new DocArticles())->where('id', '<', $this->id)->orderBy('id', 'desc')->first();
    }

    /**
     * @return DocArticles|Model|object|null
     */
    public function getNextArticleAttribute()
    {
        return (new DocArticles())->where('id', '>', $this->id)->orderBy('id')->first();
    }
}
