<?php

namespace Documentation;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @mixin Builder
 */
class DocSections extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'code',
    ];

    /**
     * Связь с моделью статей
     *
     * @return HasMany
     */
    public function articles(): HasMany
    {
        return $this->hasMany(DocArticles::class, 'section_id', 'id')->orderBy('id');
    }

    /**
     * @param $value
     * @return string
     */
    public function getNameAttribute($value): string
    {
        return htmlspecialchars($value);
    }

}
