<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

Capsule::Schema()->create(
    'doc_sections',
    static function (Blueprint $table) {
        $table->increments('id');
        $table->string('name');
        $table->string('code')->nullable();
        $table->string('version')->nullable();
        $table->timestamps();
        $table->softDeletes();
    }
);

Capsule::Schema()->create(
    'doc_articles',
    static function (Blueprint $table) {
        $table->increments('id');
        $table->integer('section_id')->unsigned()->index();
        $table->string('name');
        $table->string('page_title');
        $table->string('code')->index();
        $table->string('version')->nullable();
        $table->longText('text');
        $table->integer('view_count')->nullable();
        $table->integer('created_by')->nullable();
        $table->integer('updated_by')->nullable();
        $table->timestamps();
        $table->softDeletes();

        $table->unique(['section_id', 'code'], 'section_code');

        $table->foreign('section_id')
            ->references('id')
            ->on('doc_sections')
            ->onUpdate('cascade')
            ->onDelete('cascade');
    }
);

echo 'Установка выполнена!';
