<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Vote extends AbstractAction
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Изменение рейтинга';
    }

    public function invoke() : void
    {
        $type = $this->context->routeAction() == 'votequestion' ? 'q' : 'a';
        if (!preg_match('/(\d+)(m?)/', $this->context->routeParam(), $m)) {
            $this->resultNotFound();
        }
        $id = intval($m[1]);
        $value = ($m[2] == 'm') ? -1 : 1;

        /** @var \Qa\Dao\VoteableEntity $voteableEntity */
        if ($type == 'q') {
            $voteableEntity = $this->context->questionsEntity();
        } else {
            $voteableEntity = $this->context->answersEntity();
        }

        $data = $voteableEntity->getById($id);
        if (empty($data['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = '/qa/show/' . ($type == 'q' ? $id : $data['question_id']);

        if (!$voteableEntity->canVote($data)) {
            $this->resultForbidden();
        }

        if ($voteableEntity->hasVote($id)) {
            $_SESSION['alert'] = [
                'type' => 'alert-danger',
                'content' => 'Вы уже голосовали'
            ];
            header('Location: ' . $this->backUrl);
            exit;
        }

        $voteableEntity->vote($id, $value);


        if ($type == 'q') {
            $_SESSION['alert'] = [
                'type' => 'alert-success',
                'content' => 'Рейтинг вопроса изменён'
            ];
        } else {
            $_SESSION['alert'] = [
                'type' => 'alert-success',
                'content' => 'Рейтинг ответа изменён. <a class="alert-link" href="#a' . $id . '">Перейти</a>'
            ];
        }
        header('Location: ' . $this->backUrl);
    }
}
