<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Search extends Index
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
    }

    public function invoke() : void
    {
        $query = $_GET['q'] ?? '';
        $this->listQuestions('search', $query);
    }

    protected function getQuestions($mode, $param, $start, $limit): array
    {
        $query = trim(preg_replace('/[^\w\x7F-\xFF\s]/', ' ', rawurldecode($param)));
        $searchError = $this->validateSearch($query);
        $paramUrl = rawurlencode($query);
        $this->context->add('pagenavUrl', "$mode/?q=$paramUrl&amp;");
        $this->context->add('searchQuery', $query);
        $this->context->add('searchError', $searchError);
        if ($searchError) {
            return [0, []];
        } else {
            $questionsEntity = $this->context->questionsEntity();
            return $questionsEntity->getBySearch($query, $start, $limit);
        }
    }

    private function validateSearch(string $query) : string
    {
        if (mb_strlen($query) < 4)
            return 'Общая длина поискового запроса не должна быть менее 4 символов.';
        if (mb_strlen($query) > 64)
            return 'Общая длина поискового запроса не должна превышать 64 символа.';
        return '';
    }
}
