<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Comments extends AbstractAction
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Комментарии';
    }

    public function invoke() : void
    {
        global $start;
        $user = $this->context->user();
        $limit = $user->config->kmess;
        [$commentsCount, $count] = $this->context->commentsEntity()->getAll($start, $limit);
        $this->render('qa::comments', [
            'start' => $start,
            'limit' => $limit,
            'comments' => $count,
            'commentsCount' => $commentsCount,
        ]);
    }
}
