<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class DeleteQuestion extends AbstractAction
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Удаление вопроса';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $questionsEntity = $this->context->questionsEntity();
        $question = $questionsEntity->getById($id);
        if (empty($question['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = "/qa/show/$id";

        if (!$questionsEntity->canDelete($question)) {
            $this->resultForbidden();
        }

        $qtitle = htmlspecialchars('"' . $question['title'] . '"');

        if (isset($_GET['confirm'])) {
            // Удаляем файлы
            if (!empty($question['attachment']) && file_exists($question['attachment']['path'])) {
                unlink($question['attachment']['path']);
            }
            $questionsEntity->delete($question);
            $_SESSION['alert'] = [
                'type' => 'alert-warning',
                'content' => "Вопрос $qtitle удалён"
            ];
            header('Location: /qa/');
            return;
        }

        $this->render('qa::delete', [
            'page_title' => $this->title,
            'caption_html' => "вопрос $qtitle",
            'data' => [
                'delete_url' => "/qa/delete/$id?confirm",
                'back_url' => $this->backUrl,
            ],
        ]);
    }
}
