<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Tag extends Index
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Фильтр по тегу';
    }

    public function invoke() : void
    {
        $tag = $this->context->routeParam();
        if (empty($tag)) {
            $this->resultNotFound();
        } else {
            parent::listQuestions('tag', urldecode($tag));
        }
    }

    protected function getQuestions($mode, $param, $start, $limit): array
    {
        $questionsEntity = $this->context->questionsEntity();
        $this->context->add('pagenavUrl', "$mode/$param?");
        $this->context->add('tag', $param);
        $this->context->add('popularTags', $questionsEntity->getTags(10));
        return $questionsEntity->getByTag($param, $start, $limit);
    }
}
