<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Answers extends AbstractAction
{
    private const ITEMS_PER_PAGE = 10;

    public function __construct(Context $context)
    {
        parent::__construct($context);
    }

    public function invoke() : void
    {
        global $page;
        $limit = self::ITEMS_PER_PAGE;
        $start = ($page - 1) * $limit;

        $user = $this->context->user();
        $unreadMode = $user->isValid() && ($this->context->routeParam() == 'unread');
        [$answersCount, $answers] = $this->context->answersEntity()
                ->getAnswers($unreadMode, $start, $limit);

        $template = 'answers' . ($unreadMode ? '_unread' : '');
        $this->render("qa::$template", [
            'start' => $start,
            'limit' => $limit,
            'answers' => $answers,
            'answersCount' => $answersCount,
        ]);
    }
}
