<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class EditAnswer extends Answer
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Редактирование ответа';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $answersEntity = $this->context->answersEntity();
        $answer = $answersEntity->getById($id);
        if (empty($answer['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = '/qa/show/' . $answer['question_id'];

        if (!$answersEntity->canEdit($answer)) {
            $this->resultForbidden();
        }

        $questionsEntity = $this->context->questionsEntity();
        $question = $questionsEntity->getById($answer['question_id']);
        $this->context->navChain()->add(
                htmlspecialchars($question['title']),
                $this->backUrl);

        $errors = [];
        if (isset($_GET['delete_file']) && !empty($answer['attachment'])) {
            if (file_exists($answer['attachment']['path'])) {
                unlink($answer['attachment']['path']);
            }
            $answer['attachment'] = false;
            $answer['attachment_name'] = '';
            $answersEntity->update($answer);
        }
        if (isset($_POST['submit'])) {
            $this->processPostData($answer);
            $errors = $this->validateAnswer($answer);
            if (empty($errors)) {
                $answersEntity->update($answer);
                if ($answer['attachment_name'] && $this->hasFile()) {
                    $this->finishUploadFile($answer['id']);
                }
                $_SESSION['alert'] = [
                    'type' => 'alert-success',
                    'content' => 'Ответ изменён'
                ];
                header('Location: ' . $this->backUrl);
                return;
            }
        }

        $this->render('qa::edit_answer', [
            'answer' => $answer,
            'errors' => $errors
        ]);
    }
}
