<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class EditComment extends Comment
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Редактирование комментария';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $commentsEntity = $this->context->commentsEntity();
        $comment = $commentsEntity->getById($id);
        if (empty($comment['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = $this->getBacklink(
                $comment['parent_id'], $comment['parent_type']);
        $comment['backlink'] = $this->backUrl;

        if (!$commentsEntity->canEdit($comment)) {
            $this->resultForbidden();
        }

        $errors = [];
        if (isset($_POST['submit'])) {
            $this->processPostData($comment);
            $errors = $this->validateComment($comment);
            if (empty($errors)) {
                $commentsEntity->update($comment);
                $_SESSION['alert'] = [
                    'type' => 'alert-success',
                    'content' => 'Комментарий изменён'
                ];
                header('Location: ' . $comment['backlink']);
                return;
            }
        }

        $this->render('qa::edit_comment', [
            'comment' => $comment,
            'errors' => $errors
        ]);
    }
}
