<?php

/**
 * This file is part of JohnCMS Content Management System.
 *
 * @copyright JohnCMS Community
 * @license   https://opensource.org/licenses/GPL-3.0 GPL-3.0
 * @link      https://johncms.com JohnCMS Project
 */

declare(strict_types=1);

defined('_IN_JOHNADM') || die('Error: restricted access');

// $config = di('config')['johncms'];
$config = di('config')['indexpage'];

$data = [];

$title = 'Настройки главной страницы';
$nav_chain->add($title);

// Получаем сохраненные настройки
$settings = $config;

// Настройки главной
if (isset($_POST['submit'])) {
    // Принимаем настройки из формы
    $settings['posts'] = isset($_POST['posts']) && $_POST['posts'] > -1 && $_POST['posts'] < 20 ? (int) ($_POST['posts']) : 5;
    $settings['files'] = isset($_POST['files']) && $_POST['files'] > -1 && $_POST['files'] < 20 ? (int) ($_POST['files']) : 5;
    $settings['articles'] = isset($_POST['articles']) && $_POST['articles'] > -1 && $_POST['articles'] < 20 ? (int) ($_POST['articles']) : 5;
    $settings['box'] = isset($_POST['box']);

    $config = $settings;
    // $configFile = "<?php\n\n" . 'return ' . var_export(['johncms' => $config], true) . ";\n";
    $configFile = "<?php\n\n" . 'return ' . var_export(['indexpage' => $config], true) . ";\n";

    if (! file_put_contents(CONFIG_PATH . 'autoload/indexpage.local.php', $configFile)) {
        echo $view->render(
            'system::pages/result',
            [
                'title'         => $title,
                'type'          => 'alert-danger',
                'message'       => __('ERROR: Can not write indexpage.local.php'),
                'admin'         => true,
                'menu_item'     => 'indexpage',
                'parent_menu'   => 'module_menu',
                'back_url'      => '/admin/indexpage/',
                'back_url_name' => __('Back'),
            ]
        );
        exit;
    }

    $data['success_message'] = __('Settings are saved successfully');

    if (function_exists('opcache_reset')) {
        opcache_reset();
    }
}

$data['form_action'] = '/admin/indexpage/';
$data['settings'] = $settings;

echo $view->render(
    'admin::indexpage',
    [
        'title'      => $title,
        'page_title' => $title,
        'data'       => $data,
    ]
);
