<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email		Tunzxywalex@gmail.com
 * @Whatsapp	+2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */

namespace Johncms;

use Psr\Container\ContainerInterface;

class Environment implements Api\EnvironmentInterface
{
    private $ip;
    private $ipViaProxy;
    private $userAgent;
    private $ipCount = [];

    /**
     * @var ContainerInterface
     */
    private $container;

    public function __invoke(ContainerInterface $container)
    {
        $this->container = $container;
        $this->ipLog($this->getIp());
        $this->UrlRoute();
        $this->AgentWeb();
        return $this;
    }

    /*
     * Url Route
     * Example index.php/act/read/do/like Like index.php/act/read&do=like
     */
    public function UrlRoute()
    {
        if(!empty($_SERVER['PATH_INFO']))
        {
            $r = explode('/', $_SERVER['PATH_INFO']);
            for($i=0;$i<count($r);$i++)
            {
                if($i % 2)
                    $_REQUEST[$r[$i]] = $_GET[$r[$i]] = isset($r[$i+1]) ? $r[$i+1] : '';
            }
        }
    }

    public function getIp()
    {
        if (null === $this->ip) {
            $ip = filter_var($_SERVER['REMOTE_ADDR'], FILTER_VALIDATE_IP);
            $ip = ip2long($ip);
            $this->ip = sprintf("%u", $ip);
        }

        return $this->ip;
    }

    public function getIpViaProxy()
    {
        if ($this->ipViaProxy !== null) {
            return $this->ipViaProxy;
        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])
            && preg_match_all(
                '#\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}#s',
                filter_var($_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_SANITIZE_STRING),
                $vars
            )
        ) {
            foreach ($vars[0] AS $var) {
                $ipViaProxy = ip2long($var);

                if ($ipViaProxy && $ipViaProxy != $this->getIp() && !preg_match('#^(10|172\.16|192\.168)\.#', $var)) {
                    return $this->ipViaProxy = sprintf("%u", $ipViaProxy);
                }
            }
        }

        return $this->ipViaProxy = 0;
    }

    public function getUserAgent()
    {
        if ($this->userAgent !== null) {
            return $this->userAgent;
        } elseif (isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA']) && strlen(trim($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])) > 5) {
            return $this->userAgent = 'Opera Mini: ' . mb_substr(filter_var($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'], FILTER_SANITIZE_SPECIAL_CHARS), 0, 150);
        } elseif (isset($_SERVER['HTTP_USER_AGENT'])) {
            return $this->userAgent = mb_substr(filter_var($_SERVER['HTTP_USER_AGENT'], FILTER_SANITIZE_SPECIAL_CHARS), 0, 150);
        } else {
            return $this->userAgent = 'Not Recognised';
        }
    }


    public function AgentWeb()
	{
       if (isset($_GET['w']))
			$_SESSION['agent_web'] = 'web';
		if (isset($_GET['m']))
			$_SESSION['agent_web'] = 'wap';
		if (isset($_POST['web']))
			$_SESSION['agent_web'] = 'web';
		if (isset($_POST['wap']))
			$_SESSION['agent_web'] = 'wap';
		if ($_SESSION['agent_web'] == 'web')
			$agent_web = 'web';
		elseif ($_SESSION['agent_web'] == 'wap')
			$agent_web = 'wap';
		else
			$agent_web = 'wap';
		return $agent_web;
	}





    public function getIpLog()
    {
        return $this->ipCount;
    }

    private function ipLog($ip)
    {
        $file = ROOT_PATH . 'files/cache/ip_flood.dat';
        $tmp = [];
        $requests = 1;

        if (!file_exists($file)) {
            $in = fopen($file, "w+");
        } else {
            $in = fopen($file, "r+");
        }

        flock($in, LOCK_EX) or die("Cannot flock ANTIFLOOD file.");
        $now = time();

        while ($block = fread($in, 8)) {
            $arr = unpack("Lip/Ltime", $block);

            if (($now - $arr['time']) > 60) {
                continue;
            }

            if ($arr['ip'] == $ip) {
                $requests++;
            }

            $tmp[] = $arr;
            $this->ipCount[] = $arr['ip'];
        }

        fseek($in, 0);
        ftruncate($in, 0);

        for ($i = 0; $i < count($tmp); $i++) {
            fwrite($in, pack('LL', $tmp[$i]['ip'], $tmp[$i]['time']));
        }

        fwrite($in, pack('LL', $ip, $now));
        fclose($in);
    }
}
