<?php
##### Немного информации
##### Модуль Кинотеатр для JohnCMS
##### Автор Гальцев Тимофей
##### VK: https://vk.com/galtsev_t
##### TG: https://t.me/galtsev_t

namespace Films\Controllers;

use Johncms\Controller\BaseController;
use Films\Models\Films;
use Films\Models\Category;
use Johncms\Exceptions\PageNotFoundException;
use Johncms\System\Http\Request;
use Films\Services\Plus;

class FilmsController extends BaseController
{
    protected $module_name = 'films';
    public $settings;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->settings = Films::getSettings('base');
        if($this->settings->apiKinopoisk == 'null' or $this->settings->apiVideoCDN == 'null') {
            throw new PageNotFoundException('Не заполнены важные данные в настройках');
            exit;
        }
    }

    public function index()
    {
        define('_IS_HOMEPAGE', 1);
        $config = di('config')['johncms'];
        $this->nav_chain->showHomePage(false);
        $films = new Films();
        $all = $films->orderByDesc('id')->limit(16)->get();
        $cartoons = $films->where('type', 'CARTOON')->inRandomOrder()->limit(8)->get();
        $topFilms = $films->where([
            ['ratingKinopoisk', '>', '6'],
            ['year', '>=', '2021'],
            ])->inRandomOrder()->limit(8)->get();
        $serials = $films->where('type', 'SERIAL')->inRandomOrder()->limit(8)->get();
        $this->render->addData(
            [
                'title'             => $config['meta_title'] ?? '',
                'keywords'          => $config['meta_key'],
                'description'       => $config['meta_desc'],
                'all'               => $all,
                'cartoons'          => $cartoons,
                'serials'           => $serials,
                'topFilms'          => $topFilms,
                'allCount'          => $all->count(),
                'cartoonsCount'     => $cartoons->count(),
                'serialsCount'      => $serials->count(),
                'topFilmsCount'     => $topFilms->count(),
            ]
        );
        return $this->render->render('films::index');
    }

    public function findFilm(int $film_id) {
        $this->nav_chain->add('Кинотеатр', '/films/');
        if(is_int($film_id)) {
            $data = (new Films())
            ->where('kinopoiskId', $film_id)
            ->first();
            if ($data === null) {
                $data = Plus::getApi('https://kinopoiskapiunofficial.tech/api/v2.2/films/'. $film_id, $this->settings);
            } else {
                $data['posterUrl'] = '/upload/films/'.$data['kinopoiskId'].'.jpg';
            }
            if(isset($data['ratingAgeLimits'])) {
                $data['ratingAgeLimits'] = str_replace("age", "", $data['ratingAgeLimits']);
            }
            if(isset($data['nameRu'])) {
                $this->render->addData(
                    [
                        'title'         => $data['nameRu'],
                        'page_title'    => $data['nameRu'],
                        'description'   => $data['shortDescription'],
                        'videoApiCDN'   => Plus::getApiVideoCdn($data['kinopoiskId'], $this->settings),
                    ]
                );
                $this->nav_chain->add($data['nameRu'], '/films/'.$film_id.'/');
                return $this->render->render('films::film', ['data' => $data]);
            } else {
                throw new PageNotFoundException('Фильм не найден');
            }
        }

    }

    public function category(string $category_name, string $category_type) {
        $category = (new Category())
        ->where('nameEn', $category_name)
        ->first();
        if ($category === null) {
            throw new PageNotFoundException('Категория не найдена');
        } else {
            if(strtoupper($category_type) == 'FILM' or strtoupper($category_type) == 'SERIAL' or strtoupper($category_type) == 'CARTOON') {
                $films = (new Films())
                ->where([
                    ['genres', 'like', '%'.strtolower($category->nameRu).'%'],
                    ['type', $category_type],
                    ])
                ->paginate(10);
            } else {
                $films = (new Films())
                ->where('genres', 'like', '%'.strtolower($category->nameRu).'%')
                ->paginate(10);
            }
            $this->render->addData(
                [
                    'title'       => $category->nameRu,
                    'page_title'  => $category->nameRu,
                    'pagination'  => $films->render(),
                    'count'       => $films->count(),
                ]
            );
            $this->nav_chain->add('Категории', '/films/category/');
            $this->nav_chain->add($category->nameRu, '/films/category/'. $category->nameEn .'/');
            return $this->render->render('films::category', ['data' => $films]);
    }
    }

    public function showCategories() {
        $category = new Category();
        $data = $category->all();
        $this->render->addData(
            [
                'title'      => 'Категории',
                'page_title' => 'Категории',
                'count'      => $data->count(),
            ]
        );
        $this->nav_chain->add('Категории', '/films/category/');
        return $this->render->render('films::categories', ['data' => $data]);
    }

    public function searchFilm(Request $request) {
        if ($request->getMethod() === 'POST') {
            $search = $request->getPost('search');
            $films = Plus::getApi('https://kinopoiskapiunofficial.tech/api/v2.1/films/search-by-keyword?keyword='.urlencode($search).'&page=1', $this->settings);
                    
            $this->render->addData(
                [
                    'data'  => $films,
                    'count' => count($films),
                ]
            );

        }
        $this->render->addData(
            [
                'title'       => 'Поиск',
                'page_title'  => 'Поиск',
            ]
        );
        $this->nav_chain->add('Кинотеатр', '/films/');
        $this->nav_chain->add('Поиск', '/films/search/');
        return $this->render->render('films::search');
    }

}