<?php

declare(strict_types=1);

namespace App\Rezka;

use DiDom\Document;
use DiDom\Element;
use Illuminate\Support\Facades\Http;

class ListParser
{
    private string $protocol = 'https://';
    private string $baseUrl;
    private string $userAgent;

    public function __construct()
    {
        $this->baseUrl = 'rezkify.com';
        $this->userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36';
    }

    /**
     * Получаем фильмы с определенной страницы
     */
    public function getFilms(string $url = '/'): array
    {
        $film = Http::withHeaders(
            [
                'Referer' => $this->protocol . $this->baseUrl,
                'Cookie'  => 'rzk_theme=day' // Кука для поиска.
            ]
        )
            ->withUserAgent($this->userAgent)
            ->get($this->protocol . $this->baseUrl . $url);

        $pageHtml = $film->body();
        $document = new Document($pageHtml);

        $items = $document->find('.b-content__inline_items .b-content__inline_item');
        $films = [];
        foreach ($items as $item) {
            $films[] = $this->parseListItem($item);
        }

        return [
            'items' => $films,
            'meta'  => $this->parsePages($document),
        ];
    }

    public function parseListItem(Element $document): array
    {
        $type = 'film';
        if ($document->has('.b-content__inline_item-cover>a>.series')) {
            $type = 'series';
        }

        $url = $document->getAttribute('data-url');
        if ($url) {
            $url = parse_url($url, PHP_URL_PATH);
        }

        return [
            'cover' => $document->first('.b-content__inline_item-cover img')?->getAttribute('src'),
            'name'  => $document->first('.b-content__inline_item-link a')?->text(),
            'meta'  => $document->first('.b-content__inline_item-link div')?->text(),
            'type'  => $type,
            'url'   => $url,
        ];
    }

    public function parsePages(Document $document): array
    {
        $pagination = $document->first('.b-navigation');
        $next = $pagination?->first('.b-navigation__next')?->parent()?->getAttribute('href');
        if ($next) {
            $nextPageUrl = parse_url($next, PHP_URL_PATH);
            $nextPageUrlQuery = parse_url($next, PHP_URL_QUERY);
            if (!empty($nextPageUrlQuery)) {
                $nextPageUrl .= '?' . $nextPageUrlQuery;
            }
        }

        return [
            'nextPageUrl' => $nextPageUrl ?? null,
            'nextPage'    => 0,
        ];
    }
}
