<?php

namespace App\Rezka;

use Illuminate\Support\Arr;

class FilmParser
{
    private function decodeStreams(string $string): ?string
    {
        // Вырезаем всякое лишнее
        $str = str_replace(['#h', '//_//'], [''], $string);
        $trashCombo = $this->getTrash();
        $str = str_replace($trashCombo, [''], $str);

        // Декодируем в нормальную строку
        $decodedStr = base64_decode($str . '==');
        if ($str != false) {
            return $decodedStr;
        }
        return null;
    }

    /**
     * Собираем массив символов для замены
     * @return array
     */
    private function getTrash(): array
    {
        $trashList = ["@", "#", "!", "^", "$"];
        $trashCombo = [];
        for ($i = 2; $i < 4; $i++) {
            $testArr = [];
            for ($ii = 1; $ii <= $i; $ii++) {
                $testArr[] = $trashList;
            }
            $cartesian = Arr::crossJoin(...$testArr);
            foreach ($cartesian as $item) {
                $data_bytes = implode('', $item);
                $trashCombo[] = base64_encode($data_bytes);
            }
        }

        return $trashCombo;
    }

    public function getStreams(string $string): ?array
    {
        $streamsString = $this->decodeStreams($string);
        if (!$streamsString) {
            return null;
        }

        $streams = [];
        $exp = explode(',', $streamsString);
        foreach ($exp as $item) {
            if (preg_match('/\[(.*)](.*) or (.*)/i', $item, $matches)) {
                $streams[] = [
                    'name' => $matches[1],
                    'm3u8' => $matches[2],
                    'mp4'  => $matches[3],
                ];
            }
        }

        return !empty($streams) ? $streams : null;
    }
}
