<?php

/**
 * This file is part of JohnCMS Content Management System.
 *
 * @copyright JohnCMS Community
 * @license   https://opensource.org/licenses/GPL-3.0 GPL-3.0
 * @link      https://johncms.com JohnCMS Project
 */

namespace Indexpage\Controllers;

use Johncms\Controller\BaseController;
use Johncms\Counters;
use News\Models\NewsArticle;

$config = di('config')['indexpage'];


class IndexpageController extends BaseController
{
    protected $module_name = 'indexpage';

    public function index(): string
    {
        $connection = \Illuminate\Database\Capsule\Manager::connection();

        define('_IS_HOMEPAGE', 1);
        $this->nav_chain->showHomePage(false);

        $config = di('config')['johncms'];
		$iconfig = di('config')['indexpage'];
        $news_config = di('config')['news'];
        $this->render->addData(
            [
                'title'       => $config['meta_title'] ?? '',
                'keywords'    => $config['meta_key'],
                'description' => $config['meta_desc'],
            ]
        );
        if($iconfig['last_themes'] > 0){
        	$themes = $connection->table('forum_topic')
	            // ->select('name', 'id', 'last_post_date')
	            ->orderByDesc('last_post_date')
	            ->paginate($iconfig['last_themes']);
        }
        if($iconfig['last_files'] > 0){
	        $files = $connection->table('download__files')
	            // ->select('name', 'id', 'last_post_date')
	            ->orderByDesc('time')
	            ->paginate($iconfig['last_files']);
        }
        if($iconfig['last_lib'] > 0){
	        $articles = $connection->table('library_texts')
	            // ->select('name', 'id', 'last_post_date')
	            ->orderByDesc('time')
	            ->paginate($iconfig['last_lib']);
        }

        $data = [];
        if ($news_config['homepage_show']) {
            $news = (new NewsArticle())->withCount('comments')->withSum('votes', 'vote')->active();
            if ($news_config['homepage_days'] > 0) {
                $news->lastDays($news_config['homepage_days']);
                $news_new_count = $news->count();
            }
            $news = $news->limit($news_config['homepage_quantity'])->orderByDesc('active_from')->orderByDesc('id')->get();
        }

        $data['news'] = $news ?? [];
        if(isset($themes)) $data['themes'] = $themes ?? [];
        if(isset($files)) $data['files'] = $files ?? [];
        if(isset($articles)) $data['articles'] = $articles ?? [];
        // TODO: Если приживется, объединить со счетчиками в меню для избежания лишних запросов
        /** @var Counters $counters */
        $counters = di('counters');
        $count['forum'] = $counters->forumCounters();
        $count['guestbook'] = $counters->guestbookCounters();
        $count['downloads'] = $counters->downloadsCounters();
        $count['library'] = $counters->libraryCounters();
        $count['users'] = $counters->usersCounters();
        $count['news'] = [
            'new' => $news_new_count ?? 0,
        ];
        $data['counters'] = $count;

        return $this->render->render('indexpage::index', ['data' => $data]);
        if(isset($themes)) { return $this->render->render('indexpage::index', ['themes' => $themes]); }
        if(isset($files)) { return $this->render->render('indexpage::index', ['files' => $files]); }
        if(isset($articles)) { return $this->render->render('indexpage::index', ['articles' => $articles]); }
    }
}
