<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

// Каталог пользовательских Аватаров
if ($id && is_dir(ROOT_PATH . 'images/covers/' . $id)) {
    $photo = isset($_GET['covers']) ? intval($_GET['covers']) : false;

    if ($systemUser->isValid() && $photo && is_file('../images/covers/' . $id . '/' . $photo . '.png')) {
        if (isset($_POST['submit'])) {
            // Устанавливаем пользовательский Аватар
            if (@copy('../images/covers/' . $id . '/' . $photo . '.png', '../files/users/photo/' . $systemUser->id . '.png')) {
                echo '<div class="gmenu"><p>' . _t('Profile Photo has been successfully applied') . '<br />' .
                    '<a href="../profile/?act=edit">' . _t('Continue') . '</a></p></div>';
            } else {
                echo $tools->displayError(_t('An error occurred'), '<a href="' . $_SESSION['ref'] . '">' . _t('Back') . '</a>');
            }
        } else {
            echo '<div class="phdr"><a href="?act=covers"><b>' . _t('Photo') . '</b></a> | ' . _t('Set to Profile') . '</div>' .
                '<div class="rmenu"><p>' . _t('Are you sure you want to set yourself this photo?') . '</p>' .
                '<p><img src="../images/covers/' . $id . '/' . $photo . '.png" alt="" /></p>' .
                '<p><form action="?act=covers&amp;id=' . $id . '&amp;covers=' . $photo . '" method="post"><input type="submit" name="submit" value="' . _t('Yes Save') . '"/></form></p>' .
                '</div>' .
                '<div class="phdr"><a href="?act=covers&amp;id=' . $id . '">' . _t('Cancel') . '</a></div>';
        }
    } else {
        // Показываем список Аватаров
        echo '<div class="phdr"><a href="?act=covers"><b>' . _t('Profile Photo') . '</b></a> | ' . htmlentities(file_get_contents(ROOT_PATH . 'images/covers/' . $id . '/name.dat'), ENT_QUOTES, 'utf-8') . '</div>';
        $array = glob(ROOT_PATH . 'images/covers/' . $id . '/*.png');
        $total = count($array);
        $end = $start + $kmess;

        if ($end > $total) {
            $end = $total;
        }

        if ($total > 0) {
            for ($i = $start; $i < $end; $i++) {
                echo $i % 2 ? '<article class="_55wo _56bf _5rgl"><div class="story_body_container">' : '<article class="_55wo _56bf _5rgl"><div class="story_body_container">';
                echo '<img src="../images/covers/' . $id . '/' . basename($array[$i]) . '" alt="" />';

                if ($systemUser->isValid()) {
                    echo ' - <a href="?act=covers&amp;id=' . $id . '&amp;covers=' . basename($array[$i]) . '">' . _t('Select') . '</a>';
                }

                echo '</div></article>';
            }
        } else {
            echo '<div class="menu">' . _t('The list is empty') . '</div>';
        }

        echo '<div class="phdr">' . _t('Total') . ': ' . $total . '</div>';

        if ($total > $kmess) {
            echo '<p>' . $tools->displayPagination('?act=covers&amp;id=' . $id . '&amp;', $start, $total, $kmess) . '</p>' .
                '<p><form action="?act=covers&amp;id=' . $id . '" method="post">' .
                '<input type="text" name="page" size="2"/>' .
                '<input type="submit" value="' . _t('To Page') . ' &gt;&gt;"/>' .
                '</form></p>';
        }

        echo '<p><a href="?act=covers">' . _t('Back') . '</a><br />';
    }
} else {
    // Показываем каталоги с Аватарами
    echo '<div class="phdr"><a href="?"><b>' . _t('Information, FAQ') . '</b></a> | ' . _t('Cover') . '</div>';
    $dir = glob(ROOT_PATH . 'images/covers/*', GLOB_ONLYDIR);
    $total = 0;
    $total_dir = count($dir);

    for ($i = 0; $i < $total_dir; $i++) {
        $count = (int)count(glob($dir[$i] . '/*.png'));
        $total = $total + $count;
        echo $i % 2 ? '<article class="_55wo _56bf _5rgl"><div class="story_body_container">' : '<article class="_55wo _56bf _5rgl"><div class="story_body_container">';
        echo '<a href="?act=covers&amp;id=' . basename($dir[$i]) . '">' . htmlentities(file_get_contents($dir[$i] . '/name.dat'), ENT_QUOTES, 'utf-8') .
            '</a> (' . $count . ')</div></article>';
    }

    echo '<div class="phdr">' . _t('Total') . ': ' . $total . '</div>' .
        '<p><a href="' . $_SESSION['ref'] . '">' . _t('Back') . '</a></p>';
}
