<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email		Tunzxywalex@gmail.com
 * @Whatsapp	+2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */

define('_IN_JOHNCMS', 1);

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

// Закрываем от неавторизованных юзеров
if (!$systemUser->isValid()) {
    require('../system/head.php');
    echo $tools->displayError(_t('For registered users only'));
    require('../system/end.php');
    exit;
}



// Получаем данные пользователя
$user = $tools->getUser(isset($_REQUEST['user']) ? abs(intval($_REQUEST['user'])) : 0);

if (!$user) {
    require('../system/head.php');
    echo $tools->displayError(_t('This User does not exists'));
    require('../system/end.php');
    exit;
}

/**
 * Находится ли выбранный пользователь в контактах и игноре?
 *
 * @param int $id Идентификатор пользователя, которого проверяем
 * @return int Результат запроса:
 *                0 - не в контактах
 *                1 - в контактах
 *                2 - в игноре у меня
 */
function is_contact($id = 0)
{
    global $db, $systemUser;

    static $user_id = null;
    static $return = 0;

    if (!$systemUser->isValid() && !$id) {
        return 0;
    }

    if (is_null($user_id) || $id != $user_id) {
        $user_id = $id;
        $req = $db->query("SELECT * FROM `cms_contact` WHERE `user_id` = '" . $systemUser->id . "' AND `from_id` = '$id'");

        if ($req->rowCount()) {
            $res = $req->fetch();
            if ($res['ban'] == 1) {
                $return = 2;
            } else {
                $return = 1;
            }
        } else {
            $return = 0;
        }
    }

    return $return;
}

// Переключаем режимы работы
$array = [
    'activity'  => 'includes',
    'ban'       => 'includes',
    'edit'      => 'includes',
    'images'    => 'includes',
    'info'      => 'includes',
    'ip'        => 'includes',
    'guestbook' => 'includes',
    'karma'     => 'includes',
    'office'    => 'includes',
    'password'  => 'includes',
    'reset'     => 'includes',
    'settings'  => 'includes',
    'stat'      => 'includes',
    'premium'   => 'includes',
];
$path = !empty($array[$act]) ? $array[$act] . '/' : '';

if (isset($array[$act]) && file_exists($path . $act . '.php')) {
    require_once($path . $act . '.php');
} else {
    // Анкета пользователя
    $headmod = 'profile,' . $user['id'];
    $textl = _t('Profile') . ': ' . htmlspecialchars($user['name']);
       if ($agent_web == 'wap') {
    require('../system/head.php');
            }
   if ($agent_web == 'web') {
   require('../themes/default/headprofile.php');
   }
   echo '<br><div class="col-md-6">';


    //Уведомление о дне рожденья
    if ($user['dayb'] == date('j', time()) && $user['monthb'] == date('n', time())) {
        echo '<div class="gmenu">' . _t('We Greet you a Happy Birthday') . ' ' . $user['name'] . '!!!</div>';
    }

    // Информация о юзере
    $arg = [
        'lastvisit' => 1,
        'iphist'    => 1,
        'header'    => '<b>ID:' . $user['id'] . '</b>',
    ];

    if ($user['id'] != $systemUser->id) {
        $arg['footer'] = '<span class="gray">' . _t('Where?') . ':</span> ' . $tools->displayPlace($user['id'],
                $user['place']);
    }
        if ($systemUser->rights >= 7 && !$user['preg'] && empty($user['regadm'])) {
        echo '<div class="rmenu">' . _t('Pending confirmation') . '</div>';
    }
if (!$tools->isIgnor($user['id'])
            && is_contact($user['id']) != 2
            && !isset($systemUser->ban['1'])
            && !isset($systemUser->ban['3'])
        ) {
             '<a href="../mail/index.php?act=write&amp;id=' . $user['id'] . '">Send Mail</a> ';

echo '  <div class="ossn-profile container">
	<div class="row">
    	<div class="col-md-11">
			<div class="ossn-profile">
				<div class="top-container">
					<div id="container" class="profile-cover" ><img src="../images/man.jpg" height="170" width="170">
					</div>
					<div class="profile-photo"><img src="../files/users/photo/' . $user['id'] . '.jpg" height="170" width="170">
					</div>
					<div class="user-fullname data-username-verified-' . $user['name'] . '" data-verified="0"><font color="black">' . $user['name'] . '</font></div>
                    <div class="user-fullname ossn-profile-role"><i class="fa fa-star"></i>' . $systemUser->rights.'</div>

                    <div id="profile-hr-menu" class="profile-hr-menu">
						<ul><li><a class="menu-user-timeline-timeline" href="?act=info&amp;user=' . $user['id'] . '">Timeline</a></li><li><a class="menu-user-timeline-friends" href="?act=activity&amp;user=' . $user['id'] . '">Activities</a></li><li><a class="menu-user-timeline-photos" href="../album/index.php?act=list&amp;user=' . $user['id'] . '">Photos</a></li><li><a class="menu-user-timeline-videos" href="?act=stat&amp;user=' . $user['id'] . '">Statistics</a></li></ul>	</div>';
}
					echo'<div id="profile-menu" class="profile-menu">';
					if ($user['id'] != $systemUser->id) {
        
        // Контакты
        if (is_contact($user['id']) != 2) {
            if (!is_contact($user['id'])) {
                echo '<a class="btn-action" href="../mail/index.php?id=' . $user['id'] . '">' . _t('Add as Friend') . '</a>';
            } else {
                echo '<a class="btn-action" href="../mail/index.php?act=deluser&amp;id=' . $user['id'] . '">' . _t('UnFriend') . '</a>';
            }
        }
 }                   echo'<a href="../mail/index.php?act=write&amp;id=' . $user['id'] . '" id="profile-message" data-guid="3" class="btn-action">
                        Message</a>';

echo'<div class="ossn-profile-extra-menu dropdown"><div class=""><a role="button" data-toggle="dropdown" class="btn-action" data-target="#" aria-expanded="false"><i class="fa fa-sort-desc"></i></a><ul class="dropdown-menu multi-level" role="menu" aria-labelledby="dropdownMenu">';

    // Меню анкеты
    $menu = [];

    if ($user['id'] == $systemUser->id || $systemUser->rights == 9 || ($systemUser->rights == 7 && $systemUser->rights > $user['rights'])) {
        $menu[] = '<li><a class="profile-menu-extra-block" href="?act=edit&amp;user=' . $user['id'] . '">' . _t('Edit') . '</a></li>';
    }

   if ($user['id'] != $systemUser->id && $systemUser->rights > $user['rights']) {
        $menu[] = '<li><a class="profile-menu-extra-block" href="?act=ban&amp;mod=do&amp;user=' . $user['id'] . '">' . _t('Ban') . '</a></li>';
    }
 
 if ($user['id'] != $systemUser->id && $systemUser->rights >= 9 && $systemUser->rights > $user['rights']) {
        $menu[] = '<li><a class="profile-menu-extra-block" href="' . $config['homeurl'] . '/admin/index.php?act=usr_del&amp;id=' . $user['id'] . '">' . _t('Delete') . '</a></li>';
    }

    if (!empty($menu)) {
        echo '' . implode('', $menu) . '</ul></div></div></div></div></div></div></div></div></div></div>';
    }


//    echo '<img src="../files/users/photo/' . $user['id'] . '.jpg" width="60" height="180" align="center" alt="" /></div>';
//    echo '<img src="' . $config['homeurl'] . '/files/users/avatar/' .$systemUser->id . '.png" width="60" height="200" align="center" alt="" /></div>';
	//echo '<div class="user"><p>' . $tools->displayUser($user, $arg) . '</p></div></div></div>';

    // Если юзер ожидает подтверждения регистрации, выводим напоминание
## New Karma
    // Карма

    if ($set_karma['on']) {
        $karma = $user['karma_plus'] - $user['karma_minus'];
        if ($karma > 0) {
            $images = ($user['karma_minus'] ? ceil($user['karma_plus'] / $user['karma_minus']) : $user['karma_plus']) > 10 ? '2' : '1';
            //echo '<div class="gmenu">';
        } else {
            if ($karma < 0) {
            $images = ($user['karma_plus'] ? ceil($user['karma_minus'] / $user['karma_plus']) : $user['karma_minus']) > 10 ? '-2' : '-1';
            //echo '<div class="rmenu">';
        } else {
            $images = 0;
            //echo '<div class="menu">';
        }
      }


		$plus = ($user['karma_minus']+ $user['karma_plus']) ? round(100 / ($user['karma_minus'] + $user['karma_plus']) * $user['karma_plus']) : 50;
		$minus = ($user['karma_minus']+ $user['karma_plus']) ? round(100 / ($user['karma_minus'] + $user['karma_plus']) * $user['karma_minus']) : 50;
        echo '<table  width="100%"><tr><td width="22" valign="top"><img src="' . $config['homeurl'] . '/images/k_' . $images . '.gif"/></td><td>';
		if ($plus > 0)
			echo '<img src="' . $config['homeurl'] . '/profile/plus.php?img=' . $plus . '" alt="' . _t('Like') . ': +' . $plus  . '%" /><br />';
		if ($minus > 0)
			echo '<img src="' . $config['homeurl'] . '/profile/minus.php?img=' . $minus . '" alt="' . _t('Dislike') . ': -' . $minus  . '%" /><br />';	
		echo 
            '<div class="sub">' .
            '<span class="green"><a href="?act=karma&amp;user=' . $user['id'] . '&amp;type=1">' . _t('Like') . ' (' . $user['karma_plus'] . ')</a></span> | ' .
            '<span class="red"><a href="?act=karma&amp;user=' . $user['id'] . '">' . _t('Dislike') . ' (' . $user['karma_minus'] . ')</a></span>';

        if ($user['id'] != $systemUser->id) {
            if (!$systemUser->karma_off && (!$user['rights'] || ($user['rights'] && !$set_karma['adm'])) && $user['ip'] != $systemUser->ip) {
                $sum = $db->query("SELECT SUM(`points`) FROM `karma_users` WHERE `user_id` = '" . $systemUser->id . "' AND `time` >= '" . $systemUser->karma_time . "'")->fetchColumn();
                $count = $db->query("SELECT COUNT(*) FROM `karma_users` WHERE `user_id` = '" . $systemUser->id . "' AND `karma_user` = '" . $user['id'] . "' AND `time` > '" . (time() - 86400) . "'")->fetchColumn();



                if (empty($systemUser->ban) && $systemUser->postforum >= $set_karma['forum'] && $systemUser->total_on_site >= $set_karma['karma_time'] && ($set_karma['karma_points'] - $sum) > 0 && !$count) {
                    echo '<br /><a href="?act=karma&amp;mod=vote&amp;user=' . $user['id'] . '">' . _t('Vote') . '</a>';
                }
            }
        } else {



            $total_karma = $db->query("SELECT COUNT(*) FROM `karma_users` WHERE `karma_user` = '" . $systemUser->id . "' AND `time` > " . (time() - 86400))->fetchColumn();

            if ($total_karma > 0) {
                echo '<br /><a href="?act=karma&amp;mod=new">' . _t('New reviews') . '</a> (' . $total_karma . ')';
            }
        }
        echo '</div></td></tr></table>';
    }

echo'';
if ($systemUser->isValid() && $user['id'] == $systemUser->id) {
    $datauser['comm_old'] = $datauser['comm_count'];
}


$context_top = '    <div class="row ossn-profile-bottom">
    
    <div class="col-md-7">
    <div class="ossn-profile-wall">
    <div class="ossn-wall-container">';
    //'<div class="user"><p>' . $tools->displayUser($user, ['iphide' => 1,]) . '</p></div>';

// Параметры Гостевой
$arg = [
    'comments_table' => 'cms_users_guestbook', // Таблица Гостевой
    'object_table'   => 'users',               // Таблица комментируемых объектов
    'script'         => '?user=' . $user['id'] . '',      // Имя скрипта (с параметрами вызова)
    'sub_id_name'    => 'user',                // Имя идентификатора комментируемого объекта
    'sub_id'         => $user['id'],           // Идентификатор комментируемого объекта
    'owner'          => $user['id'],           // Владелец объекта
    'owner_delete'   => true,                  // Возможность владельцу удалять комментарий
    'owner_reply'    => true,                  // Возможность владельцу отвечать на комментарий
    'title'          => _t('Comments'),        // Название раздела
    'context_top'    => $context_top           // Выводится вверху списка
];

// Показываем комментарии
$comm = new Johncms\Comments($arg);

// Обновляем счетчик непрочитанного
if (!$mod && $user['id'] == $systemUser->id && $user['comm_count'] != $user['comm_old']) {
    /** @var PDO $db */
    $db = $container->get(PDO::class);
    $db->query("UPDATE `users` SET `comm_old` = '" . $user['comm_count'] . "' WHERE `id` = " . $systemUser->id);
}

echo'<div>More Options</div>';
    // Меню выбора
    $total_photo = $db->query("SELECT COUNT(*) FROM `cms_album_files` WHERE `user_id` = '" . $user['id'] . "'")->fetchColumn();
    echo '<div class="list2">';
        
    $bancount = $db->query("SELECT COUNT(*) FROM `cms_ban_users` WHERE `user_id` = '" . $user['id'] . "'")->fetchColumn();

    if ($bancount) {
        echo '<div><img src="../images/block.gif" width="16" height="16"/>&#160;<a href="?act=ban&amp;user=' . $user['id'] . '">' . _t('Violations') . '</a> (' . $bancount . ')</div>';
    }
//echo '</div></div></div>';
    echo     
        '</div>';
		
    if ($user['id'] != $systemUser->id) {
        echo '<p>';
        // Контакты
        if (is_contact($user['id']) != 2) {
            if (!is_contact($user['id'])) {
                echo '<div><img src="../images/users.png" width="16" height="16"/>&#160;<a class="btn btn-success" href="../mail/index.php?id=' . $user['id'] . '">' . _t('Add as Friend') . '</a></div>';
            } else {
                echo '<div><img src="../images/users.png" width="16" height="16"/>&#160;<a class="btn btn-danger" href="../mail/index.php?act=deluser&amp;id=' . $user['id'] . '">' . _t('UnFriend') . '</a></div>';
            }
        }

        if (is_contact($user['id']) != 2) {
            echo '<div><img src="../images/del.png" width="16" height="16"/>&#160;<a class="btn btn-danger" href="../mail/index.php?act=ignor&amp;id=' . $user['id'] . '&amp;add">' . _t('Block User') . '</a></div>';
        } else {
            echo '<div><img src="../images/del.png" width="16" height="16"/>&#160;<a class="btn btn-warning" href="../mail/index.php?act=ignor&amp;id=' . $user['id'] . '&amp;del">' . _t('Unlock User') . '</a></div>';
        }

        echo '</p>';

        

    }

if ($user['premium'] ==1) {
    $account = 'Premium Member';
    $Link = '<a class="btn btn-warning" href="index.php?act=premium&amp;mod=remove&amp;user=' . $user['id'] . '">Remove Now</a>';
} else {
    $account = 'Free Member';
    $Link = '<a class="btn btn-success" href="index.php?act=premium&amp;mod=apply&amp;user=' . $user['id'] . '">Upgrade Now</a>';
}

echo '<table width="100%" cellpadding="0" cellspacing="0"><tr>';
echo '<td width="auto">';
echo 'Account Type: <font color="red">'.$account.'</font><br>';
echo ' <style>
   #card{
	   float:left;
	   width:460px;
	   height:270px;
	   margin:5px;
	   border:1px solid black;
	   background-image: url("../images/id.jpg");
	   background-repeat: no-repeat;
	   background-size: 460px 270px;
	   -webkit-print-color-adjust: exact;
   }
   #c_left{
	   margin-top:65px;
	   margin-left:10px;
	   float:left;
	   width:100px;
	   height:120px;

	   
   }
   #c_box{
	  width:10px; 
	  height:5px;
	  padding:2px;

   }
  #c_right{
	   
	   margin-left:190px;
	   width:220px;
	   height:400px;

   }
   td{
	   font-size:14px;
   }

   </style>';

echo ' <div id="card">
	  <div id="c_left">
	  <img src="../files/users/photo/' . $user['id'] . '.jpg"   width="80px"height="100px"style="border:1px solid black;">
	  <div id="c_box"><br>Email: ' . $user['mail'] . '</div>
	  </div>
	  <div id="c_right">
	  <div style="margin-top:4px;margin-left:90px;color:#fff;">Member Id: ' . $user['id'] . ' <br></div>
	  <table style="margin-top:23px;">
	  <br><br>
	  <tr>
	  <td><b>Username</b></td><td><b>: ' . $user['name'] . '</b></td>
	  </tr>
	  <tr>
	  <td><b>City, Country</b></td><td>: ' . $user['live'] . '</td>
	  </tr>
	   <tr>
	  <td><b>Contact No.</b></td><td>: ' . $user['mibile'] . '</td>
	  </tr>
	  <tr>
	  <td><b>Date Of Birth</b></td><td>: ' . $user['dayb'] . '/' . $user['monthb'] . '/' . $user['yearofbirth'] . '</td>
	  </tr>
	 	 
	  <tr>
	  <td><br><b><i>Emmanuel Oyewale</i></b></td><td><i>C.E.O:-</i></td>
	  </tr>
	   <tr>
	  <td></td><td><img src="../images/sign.jpg" width="80px"height="20px" style="border:1px solid black;"></td>
	  </tr>
	  </table>
	   </div>';

echo '</td>';
if ($systemUser->rights ==9) {
    echo '<td width="auto" align="right">';
    echo $Link;
    echo '</td>';
}
echo '</tr></table>';
echo '</div></div></div>';
}

if ($agent_web == 'web') {
   require('../themes/default/sidebarweb.php');
   }
        if ($agent_web == 'wap') {
        require('../system/end.php');
        }
