<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

// Закрываем от неавторизованных юзеров
if (!$systemUser->isValid()) {
    require('../system/head.php');
    echo $tools->displayError(_t('For registered users only'));
    require('../system/end.php');
    exit;
}

// Получаем данные пользователя
$user = $tools->getUser(isset($_REQUEST['user']) ? abs(intval($_REQUEST['user'])) : 0);

if (!$user) {
    require('../system/head.php');
    echo $tools->displayError(_t('This User does not exists'));
    require('../system/end.php');
    exit;
}

/**
 * Находится ли выбранный пользователь в контактах и игноре?
 *
 * @param int $id Идентификатор пользователя, которого проверяем
 * @return int Результат запроса:
 *                0 - не в контактах
 *                1 - в контактах
 *                2 - в игноре у меня
 */
function is_contact($id = 0)
{
    global $db, $systemUser;

    static $user_id = null;
    static $return = 0;

    if (!$systemUser->isValid() && !$id) {
        return 0;
    }

    if (is_null($user_id) || $id != $user_id) {
        $user_id = $id;
        $req = $db->query("SELECT * FROM `cms_contact` WHERE `user_id` = '" . $systemUser->id . "' AND `from_id` = '$id'");

        if ($req->rowCount()) {
            $res = $req->fetch();
            if ($res['ban'] == 1) {
                $return = 2;
            } else {
                $return = 1;
            }
        } else {
            $return = 0;
        }
    }

    return $return;
}

// Переключаем режимы работы
$array = [
    'activity'  => 'includes',
    'ban'       => 'includes',
    'edit'      => 'includes',
    'images'    => 'includes',
    'info'      => 'includes',
    'ip'        => 'includes',
    'guestbook' => 'includes',
    'karma'     => 'includes',
    'office'    => 'includes',
    'password'  => 'includes',
    'reset'     => 'includes',
    'settings'  => 'includes',
    'stat'      => 'includes',
    'premium'   => 'includes',
];
$path = !empty($array[$act]) ? $array[$act] . '/' : '';

if (isset($array[$act]) && file_exists($path . $act . '.php')) {
    require_once($path . $act . '.php');
} else {
    // Анкета пользователя
    $headmod = 'profile,' . $user['id'];
    $textl = _t('Profile') . ': ' . htmlspecialchars($user['name']);
    require('../system/head.php');
    
    echo'<div><div><div class="timeline nontouch"><div class="cover"><div><div class="_67g9 coverPhotoSection"><div class="notTransparent">';
    
    //Cover Photo plugins fixed
if (file_exists('../files/users/photo/' . $user['id'] . '.png')) {
    echo'<img src="../files/users/photo/' . $user['id'] . '.png" width="578px" height="200px" class="_1c3k _67it _403j img">';}else{echo'<img src="../images/man.jpg" width="530px" height="200px" class="_1c3k _67it _403j img">';}

    echo'</div></div></div>';

//Profile Pictures plugins fixed
if (file_exists('../files/users/avatar/' . $user['id'] . '.png')) {
    echo '<div class="_1bn2 acw apl"><div><div><div class="_67hb"><div class="_5dne _1jlw"><img class="profpic img" style="border: 7px white solid; font-size: 40.5px; width: 85px; height: 85px;" src="../files/users/avatar/' . $user['id'] . '.png" alt="' . $user['name'] . '" border="0" /></div></div><span><div class="_45w7"><span><strong class="profileName">' . $user['name'] . '</strong></a>';}else{
    echo '<div class="_1bn2 acw apl"><div><div><div class="_67hb"><div class="_5dne _1jlw"><img class="profpic img" style="border: 7px white solid; font-size: 40.5px; width: 85px; height: 85px;" src="../images/empty.jpg" alt="' . $user['name'] . '" border="0" /></div></div><span><div class="_45w7"><span><strong class="profileName">' . $user['name'] . '</strong>';}

echo'<img src="" width="7" height="14" class="presence_icon presenceIcon img">';
echo'</span><div><a href="">' . $user['status'] . '</a></div></div><span class="mfss fcg"><span><div class="ib bylineItem" role="heading"><img src="../images/kkE5oR4elmj.png" width="12" height="14" class="l img" role="presentation" aria-level="4"><span class="c mfss">City/Country: ' . $user['live'] . '</span><div class="clear"></div></div></span></span></span></div><div class="_2pic"><div class="_2pic"><a href="../profile/index.php?act=images&mod=up_photo&user=' . $user['id'] . '">Edit cover photo</a></div></div></div>
<div class="_52jj _3-8w"><div class="_52ja _52jj _ck_ _2pia">' . $user['about'] . '</div>';


    // Меню анкеты
    $menu = [];

    if ($user['id'] == $systemUser->id || $systemUser->rights == 9 || ($systemUser->rights == 7 && $systemUser->rights > $user['rights'])) {
        $menu[] = '<a class="_58-p" href="?act=edit&amp;user=' . $user['id'] . '"><span class="_52jd">' . _t('Edit Bio') . '</span></a>';
    }

    if ($user['id'] != $systemUser->id && $systemUser->rights >= 7 && $systemUser->rights > $user['rights']) {
        $menu[] = '<a class="_58-p" href="' . $config['homeurl'] . '/admin/index.php?act=usr_del&amp;id=' . $user['id'] . '"><span class="_52jd">' . _t('Delete This Account') . '</span></a>';
    }

    if ($user['id'] != $systemUser->id && $systemUser->rights > $user['rights']) {
        $menu[] = '<a class="_58-p" href="?act=ban&amp;mod=do&amp;user=' . $user['id'] . '"><span class="_52jd">' . _t('Ban This Account') . '</span></a>';
    }

    if (!empty($menu)) {
        echo '' . implode(' | ', $menu) . '</div>';
    }

echo'<div class="basicNavItems mfsm fcg"><a href="?act=info&amp;user=' . $user['id'] . '" class="sec">About</a> · <a href="../mail/friends.php" class="sec">Friends</a> · <a href="../album/index.php?act=list&amp;user=' . $user['id'] . '" class="sec">Photos</a> · <a href="?act=stat&amp;user=' . $user['id'] . '" class="sec">Statistics</a> · <a href="?act=activity&amp;user=' . $user['id'] . '" class="sec">Activity log</a></div></div>';

    //Уведомление о дне рожденья
    if ($user['dayb'] == date('j', time()) && $user['monthb'] == date('n', time())) {
        echo '<div class="gmenu">' . _t('Birthday') . '!!!</div>';
    }

    // Информация о юзере
    $arg = [
        'lastvisit' => 1,
        'iphist'    => 1,
        'header'    => '<b>ID:' . $user['id'] . '</b>',
    ];

    if ($user['id'] != $systemUser->id) {
        $arg['footer'] = '<span class="gray">' . _t('Where?') . ':</span> ' . $tools->displayPlace($user['id'],
                $user['place']);
    }

//    echo '<div class="user"><p>' . $tools->displayUser($user, $arg) . '</p></div>';

    // Если юзер ожидает подтверждения регистрации, выводим напоминание
    if ($systemUser->rights >= 7 && !$user['preg'] && empty($user['regadm'])) {
        echo '<div class="rmenu">' . _t('Pending confirmation') . '</div>';
    }

    // Карма
    if ($set_karma['on']) {
        $karma = $user['karma_plus'] - $user['karma_minus'];

        if ($karma > 0) {
            $images = ($user['karma_minus'] ? ceil($user['karma_plus'] / $user['karma_minus']) : $user['karma_plus']) > 10 ? '2' : '1';
            echo '<div class="gmenu">';
        } else {
            if ($karma < 0) {
                $images = ($user['karma_plus'] ? ceil($user['karma_minus'] / $user['karma_plus']) : $user['karma_minus']) > 10 ? '-2' : '-1';
                echo '<div class="rmenu">';
            } else {
                $images = 0;
                echo '<div class="menu">';
            }
        }

        echo '<table  width="100%"><tr><td width="22" valign="top"><img src="' . $config['homeurl'] . '/images/k_' . $images . '.gif"/></td><td>' .
            '<b>' . _t('Karma') . ' (' . $karma . ')</b>' .
            '<div class="sub">' .
            '<span class="green"><a href="?act=karma&amp;user=' . $user['id'] . '&amp;type=1">' . _t('For') . ' (' . $user['karma_plus'] . ')</a></span> | ' .
            '<span class="red"><a href="?act=karma&amp;user=' . $user['id'] . '">' . _t('Against') . ' (' . $user['karma_minus'] . ')</a></span>';

        if ($user['id'] != $systemUser->id) {
            if (!$systemUser->karma_off && (!$user['rights'] || ($user['rights'] && !$set_karma['adm'])) && $user['ip'] != $systemUser->ip) {
                $sum = $db->query("SELECT SUM(`points`) FROM `karma_users` WHERE `user_id` = '" . $systemUser->id . "' AND `time` >= '" . $systemUser->karma_time . "'")->fetchColumn();
                $count = $db->query("SELECT COUNT(*) FROM `karma_users` WHERE `user_id` = '" . $systemUser->id . "' AND `karma_user` = '" . $user['id'] . "' AND `time` > '" . (time() - 86400) . "'")->fetchColumn();

                if (empty($systemUser->ban) && $systemUser->postforum >= $set_karma['forum'] && $systemUser->total_on_site >= $set_karma['karma_time'] && ($set_karma['karma_points'] - $sum) > 0 && !$count) {
                    echo '<br /><a href="?act=karma&amp;mod=vote&amp;user=' . $user['id'] . '">' . _t('Vote') . '</a>';
                }
            }
        } else {
            $total_karma = $db->query("SELECT COUNT(*) FROM `karma_users` WHERE `karma_user` = '" . $systemUser->id . "' AND `time` > " . (time() - 86400))->fetchColumn();

            if ($total_karma > 0) {
                echo '<br /><a href="?act=karma&amp;mod=new">' . _t('New reviews') . '</a> (' . $total_karma . ')';
            }
        }
      //  echo '</div></td></tr></table></div>';
    }

  echo'';
if ($systemUser->isValid() && $user['id'] == $systemUser->id) {
    $datauser['comm_old'] = $datauser['comm_count'];
}


$context_top = '';
    //'<div class="user"><p>' . $tools->displayUser($user, ['iphide' => 1,]) . '</p></div>';

// Параметры Гостевой
$arg = [
    'comments_table' => 'cms_users_guestbook', // Таблица Гостевой
    'object_table'   => 'users',               // Таблица комментируемых объектов
    'script'         => '?user=' . $user['id'] . '',      // Имя скрипта (с параметрами вызова)
    'sub_id_name'    => 'user',                // Имя идентификатора комментируемого объекта
    'sub_id'         => $user['id'],           // Идентификатор комментируемого объекта
    'owner'          => $user['id'],           // Владелец объекта
    'owner_delete'   => true,                  // Возможность владельцу удалять комментарий
    'owner_reply'    => true,                  // Возможность владельцу отвечать на комментарий
    'title'          => _t('Profile Feed'),        // Название раздела
    'context_top'    => $context_top           // Выводится вверху списка
];

// Показываем комментарии
$comm = new Johncms\Comments($arg);

// Обновляем счетчик непрочитанного
if (!$mod && $user['id'] == $systemUser->id && $user['comm_count'] != $user['comm_old']) {
    /** @var PDO $db */
    $db = $container->get(PDO::class);
    $db->query("UPDATE `users` SET `comm_old` = '" . $user['comm_count'] . "' WHERE `id` = " . $systemUser->id);
}

    }


require_once('../system/end.php');
