<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://socialbux.epizy.com  -  Nairaland Project
 * @copyright   Copyright (C) Socialbux Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

$headmod = 'login to ' . $config->copyright . '';
require('system/bootstrap.php');
require('system/head.php');

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

if ($systemUser->isValid()) {
    echo '<div class="menu"><h2><a href="' . $config->homeurl . '">' . _t('Home', 'system') . '</a></h2></div>';
} else {
    echo '<h2>Login To ' . $config->copyright . '</h2><p>';
   // echo '<div class="phdr"><b>' . _t('Login', 'system') . '</b></div>';
    $error = [];
    $captcha = false;
    $display_form = 1;
    $user_login = isset($_POST['n']) ? $_POST['n'] : null;
    $user_pass = isset($_POST['p']) ? $_POST['p'] : null;
    $user_mem = isset($_POST['mem']) ? 1 : 0;
    $user_code = isset($_POST['code']) ? trim($_POST['code']) : null;

    if ($user_pass && !$user_login) {
        $error[] = _t('You have not entered login', 'system');
    }

    if ($user_login && !$user_pass) {
        $error[] = _t('You have not entered password', 'system');
    }

    if ($user_login && (mb_strlen($user_login) < 2 || mb_strlen($user_login) > 20)) {
        $error[] = _t('Nickname', 'system') . ': ' . _t('Invalid length', 'system');
    }

    if ($user_pass && (mb_strlen($user_pass) < 1)) {
        $error[] = _t('Password', 'system') . ': ' . _t('Invalid length', 'system');
    }

    if (!$error && $user_pass && $user_login) {
        // Запрос в базу на юзера
        $stmt = $db->prepare('SELECT * FROM `users` WHERE `name_lat` = ? LIMIT 1');
        $stmt->execute([$tools->rusLat($user_login)]);

        if ($stmt->rowCount()) {
            $systemUser = $stmt->fetch();

            if ($systemUser['failed_login'] > 2) {
                if ($user_code) {
                    if (mb_strlen($user_code) > 3 && $user_code == $_SESSION['code']) {
                        // Если введен правильный проверочный код
                        unset($_SESSION['code']);
                        $captcha = true;
                    } else {
                        // Если проверочный код указан неверно
                        unset($_SESSION['code']);
                        $error[] = _t('The security code is not correct', 'system');
                    }
                } else {
                    // Показываем CAPTCHA
                    $display_form = 0;
                    echo '<form action="login.php' . ($id ? '?id=' . $id : '') . '" method="post">' .
                        '<div class="menu"><p><img src="captcha.php?r=' . rand(1000, 9999) . '" alt="' . _t('Verification code', 'system') . '"/><br />' .
                        _t('Enter verification code', 'system') . ':<br><input type="text" size="5" maxlength="5"  name="code"/>' .
                        '<input type="hidden" name="n" value="' . htmlspecialchars($user_login) . '"/>' .
                        '<input type="hidden" name="p" value="' . $user_pass . '"/>' .
                        '<input type="hidden" name="mem" value="' . $user_mem . '"/>' .
                        '<input type="submit" name="submit" value="' . _t('Continue', 'system') . '"/></p></div></form>';
                }
            }

            if ($systemUser['failed_login'] < 3 || $captcha) {
                if (md5(md5($user_pass)) == $systemUser['password']) {
                    // Если логин удачный
                    $display_form = 0;
                    $db->exec("UPDATE `users` SET `failed_login` = '0' WHERE `id` = " . $systemUser['id']);

                    if (!$systemUser['preg']) {
                        // Если регистрация не подтверждена
                        echo '<div class="rmenu"><p>' . _t('Sorry, but your request for registration is not considered yet. Please, be patient.', 'system') . '</p></div>';
                    } else {
                        // Если все проверки прошли удачно, подготавливаем вход на сайт
                        if (isset($_POST['mem'])) {
                            // Установка данных COOKIE
                            $cuid = base64_encode($systemUser['id']);
                            $cups = md5($user_pass);
                            setcookie("cuid", $cuid, time() + 3600 * 24 * 365);
                            setcookie("cups", $cups, time() + 3600 * 24 * 365);
                        }

                        // Установка данных сессии
                        $_SESSION['uid'] = $systemUser['id'];
                        $_SESSION['ups'] = md5(md5($user_pass));

                        $db->exec("UPDATE `users` SET `sestime` = '" . time() . "' WHERE `id` = " . $systemUser['id']);
                        $set_user = unserialize($systemUser['set_user']);

                        if ($systemUser['lastdate'] < (time() - 3600) && $set_user['digest']) {
                            header('Location: ' . $config->homeurl . '/index.php?act=digest&last=' . $systemUser['lastdate']);
                        } else {
                            header('Location: ' . $config->homeurl . '/index.php');
                        }

                        echo '<div class="gmenu"><p><b><a href="index.php?act=digest">' . _t('Enter site', 'system') . '</a></b></p></div>';
                    }
                } else {
                    // Если логин неудачный
                    if ($systemUser['failed_login'] < 3) {
                        // Прибавляем к счетчику неудачных логинов
                        $db->exec("UPDATE `users` SET `failed_login` = '" . ($systemUser['failed_login'] + 1) . "' WHERE `id` = " . $systemUser['id']);
                    }

                    $error[] = _t('Authorization failed', 'system');
                }
            }
        } else {
            $error[] = _t('Authorization failed', 'system');
        }
    }

    if ($display_form) {
        if ($error) {
            echo $tools->displayError($error);
        }

        $info = '';

        echo $info;
         echo '<table><tr><th>Login With Password:';
        echo '<form action="login.php" method="post">' . _t('Username', 'system') . ':' .
            '<input type="text" name="n" value="' . htmlentities($user_login, ENT_QUOTES, 'UTF-8') . '"/>' .
            '&nbsp;<br>' . _t('Password', 'system') . ':' .
            '<input type="password" name="p"/><br>' .
            '<input type="checkbox" name="mem" value="1" checked="checked"/>' . _t('Remember', 'system') . '' .
            '<br><input type="submit" value="' . _t('Login', 'system') . '"/>' .
            '</form></table>';
    }
}
echo"<style>html { -webkit-text-size-adjust: 100%; line-height:1.5}

h1, h2, h3, h4, form, div, p, img { padding: 0; margin: 0; }

h1, h2, h3, h4, h5 { color:#200;
                     font-family: Open Sans, Tahoma, 'Segoe UI', Roboto, Ubuntu, 'Helvetica Neue', Arial, sans-serif;}

p { margin: 4px 0 0 0}

table { border-spacing: 0; border: 0; margin:0px; width:100%; padding:5px;}

div.body {max-width:1024px; margin: 0px auto; width:100%;}

th, td { padding: 6px 8px;
         background: #e8ece0;
         text-align: center;
         border: 1px solid #c8ccc0;
         border-bottom-width: 0px;
         overflow: hidden;
}

tr:first-child td, tr:first-child th {
    border-top-left-radius: 12px; border-top-right-radius: 12px;
}
tr:last-child td {
    border-bottom: 1px solid #c8ccc0;
    border-bottom-left-radius: 12px; border-bottom-right-radius: 12px;
}
td.w, tr.w { background: #f6f6ec;}
td.pd {border-bottom-left-radius: 12px; border-bottom-right-radius: 12px;}
td.pu {border-top-left-radius: 12px; border-top-right-radius: 12px;}

tr:first-child td, tr:first-child th, tr:last-child td, th:last-child td, td:first-child, td:last-child, div.vertipics img {
    box-shadow: 1px 1px 7px #c8c8c8;
} 

@media screen and (max-width: 320px) and (orientation: portrait) {
    table { padding: 4px 0px;}
    th, td { border: 0px; border-top: 1px solid #c8ccc0; padding: 6px 0px;}
    tr:first-child td, tr:first-child th { border-top-left-radius: 0px; border-top-right-radius: 0px; }
    tr:last-child td { border-bottom: 1px solid #c8ccc0; border-bottom-left-radius: 0px; border-bottom-right-radius: 0px;}
    td.pd {border-bottom-left-radius: 0px; border-bottom-right-radius: 0px;}
    td.pu {border-top-left-radius: 0px; border-top-right-radius: 0px;}
}

form.inline { display: inline }
img.img { padding:0; margin:0;}

@media screen and (min-width:  240px){ img.img, div.narrow { max-width:  208px }}
@media screen and (min-width:  320px){ img.img, div.narrow { max-width:  320px }}
@media screen and (min-width:  340px){ img.img, div.narrow { max-width:  320px }}
@media screen and (min-width:  360px){ img.img, div.narrow { max-width:  328px }}
@media screen and (min-width:  375px){ img.img, div.narrow { max-width:  342px }}
@media screen and (min-width:  411px){ img.img, div.narrow { max-width:  379px }}
@media screen and (min-width:  414px){ img.img, div.narrow { max-width:  382px }}
@media screen and (min-width:  480px){ img.img, div.narrow { max-width:  448px }}
@media screen and (min-width:  512px){ img.img, div.narrow { max-width:  480px }}
@media screen and (min-width:  640px){ img.img, div.narrow { max-width:  608px }}
@media screen and (min-width:  768px){ img.img, div.narrow { max-width:  736px }}
@media screen and (min-width: 1024px){ img.img, div.narrow { max-width:  976px }}
@media screen and (min-width: 9999px){ img.img, div.narrow { max-width:  976px }}

#postform input[type=text], #postform textarea {
    min-width: 80px; margin: 0px auto; width: 100%;
    -webkit-box-sizing: border-box; /* safari/chrome, other webkit */
    -moz-box-sizing: border-box;    /* firefox, other gecko */
     box-sizing: border-box;
    border: 1px solid #c8ccc0;
    border-radius: 12px;
}

input[type=text], input[type=submit], textarea {
    border: 1px solid #c8ccc0; border-radius: 12px; background:#fff; padding: 2px 7px;}
input[type=submit]:hover {background:#e8ece0;}
select {border: 1px solid #c8ccc0; background:#fff;}
select, input[type=file], input[type=submit], input[type=checkbox] {cursor: pointer}
textarea {padding: 5px;}
td.grad, .grad { background-color: #f6f6ec; margin: 6px;}

.grad input[type=text], input[type=text].central {  margin: 0px auto; min-width: 90px; width: 50%;}

.grad img {margin: 6px 0 3px 0; padding-bottom: 3px;}

.grad img:hover {margin: 6px 0 3px 0; padding-bottom: 1px; border-bottom: 2px solid #185518;}

body, td, th, div, button.button-link, input, textarea {
    font-family: Open Sans, system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Ubuntu, 'Helvetica Neue', sans-serif;
    font-size: 11pt; margin: 0px;
}
button, input, textarea {color: #000;}
body { text-align: center; background: #fff;}

@media (prefers-color-scheme:dark) {
    body {background: #e6e6e6; filter: brightness(0.9) saturate(1.2)}
}

div.container {
    max-width: 1024px; margin-left: auto; margin-right: auto; padding: 6px; background-color: #fff;
    border-left: 1px solid gray; border-right: 1px solid gray;
}

a{color:#181870; text-decoration: none; word-break: break-word;}
a:visited {color:#401848;}
a:hover { text-decoration:underline}
a.m, .m { color: #44b; }
a.f, .f { color: #b4b; }
a.user, .user a, .featured td { color:#551818; }
td.homeuser, td.homeuser a, td.homeuser span, div.sig{font-size: 9.5pt;}
td.homeuser h3 { font-size: 13.5pt; color:#000}
td.homeuser a {color:#551818}
td.featured { color:#551818}
a:visited img.nnn {display: none}
hr {border: none; margin: 3px; height: 1px;
    background: #d9d9d9; background: linear-gradient(90deg,#f6f6ec,#d9d9d9,#d9d9d9,#f6f6ec)}

.s { font-size: 9.5pt; color:#555518 }
.s a {font-size: 9.5pt; color:#551818 }
.b { font-size: 12.5pt; }
.g { color:#185518; }

.u { font-weight: normal }
.bl{ background-color: #6b8eae}
.button-link { border: none; background-color: transparent; text-decoration: underline; cursor: pointer; padding: 0; }
td.l, .l {text-align: left}
td.friends { padding-top: 0px; padding-bottom: 0px; }
td.messages { padding-left: 20px; }
td.gr, td.gr span, td.gr a { color: grey }
.friend {border:1px solid #999100; padding:4px; white-space: nowrap; background-color: white}
.friend a {text-decoration: none}

.highlight {font-weight: bold; font-size:13.5pt; background-color: yellow}

span.bold a, p.bold a, a.bold, td.bold a {font-weight: bold}

span.eb img {background-image:url('/icons/bg.gif');
  background-repeat: no-repeat; width:23px; height:22px;}
span.eb:hover img {background-image:url('/icons/hoverbg.gif');}

img.faces {width:15px; height:15px;}

blockquote{margin: 1px; background-color: #d7e0c9; border: 1px #c6ccbe solid; padding: 4px 6px; border-radius: 10px;}

.small, td.small{font-size:9.5pt}
td.sig{padding:3px 6px 5px 6px; font-size:9.5pt; color:grey}
.upd {background: #993; padding:1px;}
.frupd {background: #399; padding:1px;}

div.narrow {margin: 0px auto 0px 0px;}

iframe.youtube { width: 420px; height: 280px; max-width: 92%}

.noisy { color: #b00; font-weight: bold}

.pushleft{margin: 0px 0px 0px -8px;}
.pushleft2{margin: 0px 0px 0px -2px;}

.manual{margin: 0 -8px;}
.manual span {padding-left: 6px; padding-right: 6px;}

p.nocopy, div.nocopy, td.nocopy {
    -webkit-user-select: none;
    -khtml-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    -o-user-select: none;
    /* user-select: none;*/
}


div.webdesigners {margin: 0px auto; padding: 0px; max-width: 850px;}
div.webdesigners img { margin: 6px; padding: 0px; width: 154px; height:95px; background: url('/static/white.png') no-repeat;}
@media screen and (max-width: 320px) { 
    div.webdesigners {margin: 0px 0px;} 
    div.webdesigners img {margin: 2px 2px;}
}

div.vertipics img { margin: 6px; padding: 0px; width: 318px; height:106px; background: url('/static/white.png') no-repeat;
                    border: 1px solid #c6ccbe; border-radius: 10px;}

@media screen and (max-width: 1024px) {
    div.vertipics img {margin: 8px 3px;}
}

@media screen and (max-width: 360px) { 
    div.vertipics img {margin: 8px -8px;}
}
.campaign_stats span, .ad_details span{
    margin-right: .5%;
}
.green{
    color: green;
}
.orange{
    color: orange;
}
.red{
    color: red;
}
.vertiborder{ border: 1px solid #c6ccbe; border-radius: 10px; padding: 0;}

td.grad h1 {
    margin-top: -4px;
}
table th h3 {
    margin: -4px 0px;
}
</style>";

require('system/end.php');
