<?php
/*
 * Naijadev Clone 3.1.0 (http://naijadev.ml or http://naijadev.in)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://facebook.com/tunzxywalex Tunz Project
 * @email		Tunzxywalex@gmail.com
 * @Whatsapp	+2349076642400
 * @copyright   Copyright (C) Naijadev Community 2018
 * @license     Premium Version Licence
 */

namespace Johncms;

use Psr\Container\ContainerInterface;

class Tools implements Api\ToolsInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \PDO
     */
    private $db;

    /**
     * @var Api\UserInterface::class
     */
    private $user;

    /**
     * @var UserConfig
     */
    private $userConfig;

    /**
     * @var Api\ConfigInterface
     */
    private $config;

    public function __invoke(ContainerInterface $container)
    {
        $this->container = $container;
        $this->config = $container->get(Api\ConfigInterface::class);
        $this->db = $container->get(\PDO::class);
        $this->user = $container->get(Api\UserInterface::class);
        $this->userConfig = $this->user->getConfig();

        return $this;
    }

    public function antiflood()
    {
        $config = $this->config['antiflood'];

        switch ($config['mode']) {
            // Адаптивный режим
            case 1:
                $adm = $this->db->query('SELECT COUNT(*) FROM `users` WHERE `rights` > 0 AND `lastdate` > ' . (time() - 300))->fetchColumn();
                $limit = $adm > 0 ? $config['day'] : $config['night'];
                break;
            // День
            case 3:
                $limit = $config['day'];
                break;
            // Ночь
            case 4:
                $limit = $config['night'];
                break;
            // По умолчанию день / ночь
            default:
                $c_time = date('G', time());
                $limit = $c_time > $config['day'] && $c_time < $config['night'] ? $config['day'] : $config['night'];
        }

        // Для Администрации задаем лимит в 4 секунды
        if ($this->user->rights > 0) {
            $limit = 4;
        }

        $flood = $this->user->lastpost + $limit - time();

        return $flood > 0 ? $flood : false;
    }

    /**
     * Обработка текстов перед выводом на экран
     *
     * @param string $str
     * @param int    $br   Параметр обработки переносов строк
     *                     0 - не обрабатывать (по умолчанию)
     *                     1 - обрабатывать
     *                     2 - вместо переносов строки вставляются пробелы
     * @param int    $tags Параметр обработки тэгов
     *                     0 - не обрабатывать (по умолчанию)
     *                     1 - обрабатывать
     *                     2 - вырезать тэги
     *
     * @return string
     */
    public function checkout($str, $br = 0, $tags = 0)
    {
        $str = htmlentities(trim($str), ENT_QUOTES, 'UTF-8');

        if ($br == 1) {
            $str = nl2br($str);
        } elseif ($br == 2) {
            $str = str_replace("\r\n", ' ', $str);
        }

        if ($tags == 1) {
            $str = $this->container->get(Api\BbcodeInterface::class)->tags($str);
        } elseif ($tags == 2) {
            $str = $this->container->get(Api\BbcodeInterface::class)->notags($str);
        }

        return trim($str);
    }

    /**
     * Показываем дату с учетом сдвига времени
     *
     * @param int $var Время в Unix формате
     * @return string Отформатированное время
     */
    public function displayDate($var)
    {
        $shift = ($this->config->timeshift + $this->userConfig->timeshift) * 3600;

        if (date('Y', $var) == date('Y', time())) {
            if (date('z', $var + $shift) == date('z', time() + $shift)) {
                return _t('Today', 'system') . ', ' . date("H:i", $var + $shift);
            }
            if (date('z', $var + $shift) == date('z', time() + $shift) - 1) {
                return _t('Yesterday', 'system') . ', ' . date("H:i", $var + $shift);
            }
        }

        return date("d.m.Y / H:i", $var + $shift);
    }

    /**
     * Сообщения об ошибках
     *
     * @param string|array $error Сообщение об ошибке (или массив с сообщениями)
     * @param string       $link  Необязательная ссылка перехода
     * @return string
     */
    public function displayError($error = '', $link = '')
    {
        return '<div class="rmenu"><p><b>' . _t('ERROR', 'system') . '!</b><br>'
            . (is_array($error) ? implode('<br>', $error) : $error) . '</p>'
            . (!empty($link) ? '<p>' . $link . '</p>' : '') . '</div>';
    }

    /**
     * Постраничная навигация
     * За основу взята доработанная функция от форума SMF 2.x.x
     *
     * @param string $url
     * @param int    $start
     * @param int    $total
     * @param int    $kmess
     * @return string
     */
    public function displayPagination($url, $start, $total, $kmess)
    {
        $neighbors = 2;
        if ($start >= $total) {
            $start = max(0, $total - (($total % $kmess) == 0 ? $kmess : ($total % $kmess)));
        } else {
            $start = max(0, (int)$start - ((int)$start % (int)$kmess));
        }

        $base_link = '<a class="btn-page-o" href="' . strtr($url, ['%' => '%%']) . 'page=%d' . '">%s</a>';
        $out[] = $start == 0 ? '' : sprintf($base_link, $start / $kmess, 'First');

        if ($start > $kmess * $neighbors) {
            $out[] = sprintf($base_link, 1, '1');
        }

        if ($start > $kmess * ($neighbors + 1)) {
            $out[] = '<span class="btn-page">...</span>';
        }

        for ($nCont = $neighbors; $nCont >= 1; $nCont--) {
            if ($start >= $kmess * $nCont) {
                $tmpStart = $start - $kmess * $nCont;
                $out[] = sprintf($base_link, $tmpStart / $kmess + 1, $tmpStart / $kmess + 1);
            }
        }

        $out[] = '<span class="btn-page"><b>' . ($start / $kmess + 1) . '</b></span>';
        $tmpMaxPages = (int)(($total - 1) / $kmess) * $kmess;

        for ($nCont = 1; $nCont <= $neighbors; $nCont++) {
            if ($start + $kmess * $nCont <= $tmpMaxPages) {
                $tmpStart = $start + $kmess * $nCont;
                $out[] = sprintf($base_link, $tmpStart / $kmess + 1, $tmpStart / $kmess + 1);
            }
        }

        if ($start + $kmess * ($neighbors + 1) < $tmpMaxPages) {
           // $out[] = '<span class="btn-page-o">...</span>';
        }

        if ($start + $kmess * $neighbors < $tmpMaxPages) {
            $out[] = sprintf($base_link, $tmpMaxPages / $kmess + 1, $tmpMaxPages / $kmess + 1);
        }

        if ($start + $kmess < $total) {
            $display_page = ($start + $kmess) > $total ? $total : ($start / $kmess + 2);
            $out[] = sprintf($base_link, $display_page, 'Last');
        }

        return implode(' ', $out);
    }

    /**
     * Показываем местоположение пользователя
     *
     * @param int    $user_id
     * @param string $place
     * @return mixed|string
     */
    public function displayPlace($user_id = 0, $place = '', $headmod = '')
    {
        $place = explode(",", $place);

        $placelist = [
            'admlist'          => '<a href="#home#/users/index.php?act=admlist">' . _t('List of Admins', 'system') . '</a>',
            'album'            => '<a href="#home#/album/index.php">' . _t('Watching the photo album', 'system') . '</a>',
            'birth'            => '<a href="#home#/users/index.php?act=birth">' . _t('List of birthdays', 'system') . '</a>',
            'downloads'        => '<a href="#home#/downloads/index.php">' . _t('Downloads', 'system') . '</a>',
            'faq'              => '<a href="#home#/help/">' . _t('Reading the FAQ', 'system') . '</a>',
            'forum'            => '<a href="#home#/forum/index.php">' . _t('Forum', 'system') . '</a>&#160;/&#160;<a href="#home#/forum/index.php?act=who">&gt;&gt;</a>',
            'forumfiles'       => '<a href="#home#/forum/index.php?act=files">' . _t('Forum Files', 'system') . '</a>',
            'forumwho'         => '<a href="#home#/forum/index.php?act=who">' . _t('Looking, who in Forum?', 'system') . '</a>',
            'guestbook'        => '<a href="#home#/guestbook/index.php">' . _t('Guestbook', 'system') . '</a>',
            'here'             => _t('Here, in the list', 'system'),
            'homepage'         => _t('On the Homepage', 'system'),
            'library'          => '<a href="#home#/library/index.php">' . _t('Library', 'system') . '</a>',
            'mail'             => _t('Personal correspondence', 'system'),
            'news'             => '<a href="#home#/news/index.php">' . _t('Reading the news', 'system') . '</a>',
            'online'           => '<a href="#home#/users/index.php?act=online">' . _t('Who is online?', 'system') . '</a>',
            'profile'          => _t('Profile', 'system'),
            'profile_personal' => _t('Personal Profile', 'system'),
            'registration'     => _t('Registered on the site', 'system'),
            'userlist'         => '<a href="#home#/users/index.php?act=userlist">' . _t('List of users', 'system') . '</a>',
            'userstop'         => '<a href="#home#/users/index.php?act=top">' . _t('Watching Top 10 Users', 'system') . '</a>',
        ];

        if (array_key_exists($place[0], $placelist)) {
            if ($place[0] == 'profile') {
                if ($place[1] == $user_id) {
                    return '<a href="' . $this->config['homeurl'] . '/profile/?user=' . $place[1] . '">' . $placelist['profile_personal'] . '</a>';
                } else {
                    $user = $this->getUser($place[1]);

                    return $placelist['profile'] . ': <a href="' . $this->config['homeurl'] . '/profile/?user=' . $user['id'] . '">' . $this->nick($user['id']) . '</a>';
                }
            } elseif ($place[0] == 'online' && !empty($headmod) && $headmod == 'online') {
                return $placelist['here'];
            } else {
                return str_replace('#home#', $this->config['homeurl'], $placelist[$place[0]]);
            }
        }

        return '<a href="' . $this->config['homeurl'] . '/index.php">' . $placelist['homepage'] . '</a>';
    }

    /**
     *
     * @return string
     */
    public function displayUser($user = 0, array $arg = [])
    {
        global $mod;
        $out = false;
        $homeurl = $this->config['homeurl'];

        if (!$user['id']) {
            $out = '<b>' . _t('Guest', 'system') . '</b>';

            if (!empty($user['name'])) {
                $out .= ': ' . $this->nick($user['id']);
            }

            if (!empty($arg['header'])) {
                $out .= ' ' . $arg['header'];
            }
        } else {
            $out .= '<!-- wall item -->
<div class="ossn-wall-item" id="activity-item-27">
	<div class="row">
		<div class="meta">';

            if (file_exists((ROOT_PATH . 'files/users/avatar/' . $user['id'] . '.png'))) {
                $out .= '<img class="user-img"  src="' . $homeurl . '/files/users/photo/' . $user['id'] . '.jpg" width="50" height="50" alt="' . $user['name'] . '" />';
            } else {
                $out .= '<img class="user-img" src="' . $homeurl . '/images/empty.png" width="50" height="50" alt="" class="user-img"  />';
            }

            $out .= '</td><td>';

  //          if ($user['sex']) {
//                $out .= $this->image(($user['sex'] == 'm' ? 'm' : 'w') . ($user['datereg'] > time() - 86400 ? '_new' : '') . '.png', ['class' => 'icon-inline']);
    //        } else {
      //          $out .= $this->image('del.png');
        //    }

            $out .= !$this->user->isValid() || $this->user->id == $user['id'] ? '<a href="' . $homeurl . '/profile/?user=' . $user['id'] . '"><b>' . $this->nick($user['id']) . '</b></a>' : '<a href="' . $homeurl . '/profile/?user=' . $user['id'] . '"><b>' . $this->nick($user['id']) . '</b></a>';
            $rank = [
                        0 => '(Novice)',
                        1 => '(<font color="purple">Novice</font>)',
                         2 => '(<font color="gold">Super Mod</font>)',
                        3 => '(<font color="yellow">VIP</font>)',
                        4 => '(<font color="pink">Vip Pro</font>)',
                        5 => '(<font color="blue">Junior Admin</font>)',
                        6 => '(<font color="gold">Senior Admin</font>)',
                        7 => '(<font color="orange">Admin</font>)',
                        9 => '(<font color="red">Owner/Founder</font>)',
            ];
            $rights = isset($user['rights']) ? $user['rights'] : 0;
            if ($user['id'] == '1') {
               $out .= ' (Author)';
            } else {
               $out .= ' ' . $rank[$rights];
            }
            $out .= (time() > $user['lastdate'] + 300 ? '<font color="red"><b>Offline</b></font>' :'<font color="green"><b>Online</b></font>');
            if (!empty($arg['header'])) {
                $out .= ' ' . $arg['header'];
            }
            if (!isset($arg['stshide']) && !empty($user['status'])) {
                $out .= '<div class="status">' . $this->image('label.png', ['class' => 'icon-inline']) . $user['status'] . '</div>';
            } 
            $out .= '</td></tr></table>';
        }

        if (isset($arg['body'])) {
            $out .= '<div>' . $arg['body'] . '</div>';
        }

        $ipinf = isset($arg['iphide']) ? !$arg['iphide'] : ($this->user->rights ? 1 : 0);
        $lastvisit = time() > $user['lastdate'] + 300 && isset($arg['lastvisit']) ? $this->displayDate($user['lastdate']) : false;

        if ($ipinf || $lastvisit || isset($arg['sub']) && !empty($arg['sub']) || isset($arg['footer'])) {
            $out .= '';

            if (isset($arg['sub'])) {
                $out .= '<div>' . $arg['sub'] . '</div>';
            }

            if ($lastvisit) {
                $out .= '<div>' . _t('Last Visit', 'system') . ': ' . $lastvisit . '</div>';
            }

            $iphist = '';

            if ($ipinf) {
                $out .= '<div>' . _t('Via', 'system') . ': ' . htmlspecialchars($user['browser']) . '</div>' .
                                    
                $hist = $mod == 'history' ? '&amp;mod=history' : '';
                $ip = long2ip($user['ip']);

                
                $out .= '';
            }

            if (isset($arg['footer'])) {
                $out .= $arg['footer'];
            }
            $out .= '</div></div>';
        }

        return $out;
    }


    /**
     * Получение флага для выбранной локали
     *
     * @param string $locale
     * @return string
     */
    public function getFlag($locale)
    {
        $file = ROOT_PATH . 'system' . DIRECTORY_SEPARATOR . 'locale' . DIRECTORY_SEPARATOR . $locale . DIRECTORY_SEPARATOR . 'lng.png';
        $flag = is_file($file) ? 'data:image/png;base64,' . base64_encode(file_get_contents($file)) : false;

        return $flag !== false ? '<img src="' . $flag . '" style="margin-right: 8px; vertical-align: middle">' : '';
    }

    /**
     * @return string
     */
    public function getSkin()
    {
        return $this->user->isValid() && !empty($this->userConfig->skin)
            ? $this->userConfig->skin
            : $this->config->skindef;
    }
    public function getSkins()
    {
        return $this->user->isValid() && !empty($this->userConfig->skins)
            ? $this->userConfig->skins
            : $this->config->skinweb;
    }

    /**
     * Получаем данные пользователя
     *
     * @param int $id Идентификатор пользователя
     * @return array|bool
     */
    public function getUser($id = 0)
    {
        if ($id && $id != $this->user->id) {
            $req = $this->db->query("SELECT * FROM `users` WHERE `id` = '$id'");

            if ($req->rowCount()) {
                return $req->fetch();
            } else {
                return false;
            }
        } else {
            return $this->user;
        }
    }

    /**
     * @param string $name
     * @param array  $args
     * @return bool|string
     */
    public function image($name, array $args = [])
    {
        $homeurl = $this->config['homeurl'];

        if (is_file(ROOT_PATH . 'theme/' . $this->getSkin() . '/images/' . $name)) {
            $src = $homeurl . '/theme/' . $this->getSkin() . '/images/' . $name;
        } elseif (is_file(ROOT_PATH . 'images/' . $name)) {
            $src = $homeurl . '/images/' . $name;
        } else {
            return false;
        }

        return '<img src="' . $src . '" alt="' . (isset($args['alt']) ? $args['alt'] : '') . '"' .
            (isset($args['width']) ? ' width="' . $args['width'] . '"' : '') .
            (isset($args['height']) ? ' height="' . $args['height'] . '"' : '') .
            ' class="' . (isset($args['class']) ? $args['class'] : 'icon') . '"/>';
    }




    /**
     * Mod Logo Changer v 0.2
     * Mod By Aan Gabreil Elfha Gymkhana
     * CopyRight CyberGhostNet
     * aan.mukaror@gmail.com
     */
      public function LogoUrl() {
         $homeurl = $this->config['homeurl'];
         $varLogo = $this->config['logourl'];
         if (file_exists(ROOT_PATH . 'images/logo/' . $this->config['logourl'])) {
            $var = $homeurl . '/images/logo/' . $varLogo;
             return $var;
          } else {
        $var = $homeurl . '/images/logo.gif';
         return $var;
         }
       }



    /**
     * Mod Auto Avatar v 0.2
     * Mod By Aan Gabreil Elfha Gymkhana
     * CopyRight CyberGhostNet
     * aan.mukaror@gmail.com
     */
     public function createTags($name, $type = 0){
        $homeurl = $this->config['homeurl'];
        //global $homeurl;
        if(stristr($name, ' ')){
            $explode = explode(' ', $name);
            unset($name);
            $count = count($explode);
            for($i = 0; $i < $count; $i++){
                $getEx = str_replace(',', '', trim($explode[$i]));

                $name .= ($type == 1 ? "<span class=\"button-tag\"><a href=\"$homeurl/forum/search.php?search=$getEx\" class=\"post-tag\" rel=\"nofollow\">$getEx</a></span>" : $getEx.',');
            }
         }elseif($type == 1) $name = "<span class=\"button-tag\"><a href=\"$homeurl/forum/search.php?search=$name\" class=\"post-tag\" rel=\"nofollow\">$name</a></span>";
         return $name;
    }



    /**
     * Mod Auto Avatar v 0.2
     * Mod By Aan Gabreil Elfha Gymkhana
     * CopyRight CyberGhostNet
     * aan.mukaror@gmail.com
     */
      public function Avatar($var, $var1) {
         $imV = imagecreatetruecolor(65, 65);
         $color1V = rand(0,900);
         $color2V = rand(0,900);
         $color3V = rand(0,900);
         $backgroundV = @imagecolorallocate($imV, $color1V,$color2V,$color3V);
         $whiteV = @imagecolorallocate($imV, 255, 255, 255);
         @imagefilledrectangle($imV, 0, 0, 65, 65, $backgroundV);
         $textsV = substr($var,0,1);
//reg_nic
         $textsV = ucfirst($textsV);
         $fontV = ROOT_PATH . 'system/plugin/src/Fonts/Avatar.ttf';
         $save_nameV = ROOT_PATH . 'files/users/photo/'.$var1.'.png';
//usid
         @imagettftext($imV, 45, 0, 16, 56, $whiteV, $fontV, $textsV);
         @imagepng($imV, $save_nameV);
         return imagedestroy($imV);
      }


    /**
     * Mod Anti Injection v 0.2
     * Mod By Aan Gabreil Elfha Gymkhana
     * CopyRight CyberGhostNet
     * aan.mukaror@gmail.com
     */
      public function Anti($jcuser, $jcpass) {
           $homeurl = $this->config['homeurl'];
           $banlist = array(
                    "insert", "select", "update", "delete", "distinct", "having", "truncate", "replace",
"handler", "users", "user_id", "id", "login", "db", "download", "forum", "guestbook", "home", "stats", "theme", "modules", "js", "javascript", "hacked", "like", " as ", "or ", "procedure", "files", "incfiles", "root", "rootpath", "server", "https", "limit", "order by", "group by", "asc", "union", "http", "chmod", "hack", "hacker", "crack", "cmd", "exec", "eval", "decode", "encode", "session", "desc", "ftp", "pages", "panel", "news", "@", "+", "*"
             );
            if (preg_match('/[a-zA-Z0-9]+/', $jcuser)) {
               $jcuser = trim(str_replace($banlist, '', strtolower($jcuser)));
            } else {
               $jcuser = NULL;
            }
            if (preg_match('/[a-zA-Z0-9]+/', $jcpass)) {
               $jcpass = trim(str_replace($banlist, '',strtolower($jcpass)));
            } else {
               $jcpass = NULL;
            }
           $array = array('user' => $jcuser, 'pass' => $jcpass);
           if (in_array(NULL, $array)) {
                    return '1';
            } else {
                    return $array;
            }
        }


    /**
     * rewrite url
     * by Aan Gabriel
     *
     * @param string $url
     * @param int    $start
     * @param int    $total
     * @param int    $kmess
     * @return string
     */
     public function Rewrite($text)
{
       $text = html_entity_decode(trim($text), ENT_QUOTES, 'UTF-8');
       $text=str_replace(" ","-", $text);
       $text=str_replace("--","-", $text);
       $text=str_replace("@","-",$text);
       $text=str_replace("/","-",$text);
       $text=str_replace("\\","-",$text);
       $text=str_replace(":","",$text);
       $text=str_replace("\"","",$text);
       $text=str_replace("'","",$text);
       $text=str_replace("<","",$text);
       $text=str_replace(">","",$text);
       $text=str_replace(",","",$text);
       $text=str_replace("?","",$text);
       $text=str_replace(";","",$text);
       $text=str_replace(".","",$text);
       $text=str_replace("[","",$text);
       $text=str_replace("]","",$text);
       $text=str_replace("(","",$text);
       $text=str_replace(")","",$text);
       $text=str_replace("*","",$text);
       $text=str_replace("!","",$text);
       $text=str_replace("$","-",$text);
       $text=str_replace("&","-and-",$text);
       $text=str_replace("%","",$text);
       $text=str_replace("#","",$text);
       $text=str_replace("^","",$text);
       $text=str_replace("=","",$text);
       $text=str_replace("+","",$text);
       $text=str_replace("~","",$text);
       $text=str_replace("`","",$text);
       $text=str_replace("--","-",$text);
       $text = preg_replace("/(Р“ |Р“Ў|Р±єЎ|Р±єЈ|Р“Ј|Р“ў|Р±є§|Р±єҐ|Р±є­|Р±є©|Р±є«|Р”ѓ|Р±є±|Р±єЇ|Р±є·|Р±єі|Р±єµ)/", 'a', $text);
       $text = preg_replace("/(aРњЂ|aРњЃ|aРњЈ|aРњ‰|aРњѓ|Р“ў|Р“ўРњЂ|Р“ўРњЃ|Р“ўРњЈ|Р“ўРњ‰|Р“ўРњѓ|Р”ѓ|Р”ѓРњЂ|Р”ѓРњЃ|Р”ѓРњЈ|Р”ѓРњ‰|Р”ѓРњѓ)/", 'a', $text);
       $text = preg_replace("/(Р“РЃ|Р“©|Р±є№|Р±є»|Р±єЅ|Р“Є|Р±»Ѓ|Р±єї|Р±»‡|Р±»ѓ|Р±»…)/", 'e', $text);
       $text = preg_replace("/(eРњЂ|eРњЃ|eРњЈ|eРњ‰|eРњѓ|Р“Є|Р“ЄРњЂ|Р“ЄРњЃ|Р“ЄРњЈ|Р“ЄРњ‰|Р“ЄРњѓ)/", 'e', $text);
       $text = preg_replace("/(Р“¬|Р“­|Р±»‹|Р±»‰|Р”©)/", 'i', $text);
      $text = preg_replace("/(iРњЂ|iРњЃ|iРњЈ|iРњ‰|iРњѓ)/", 'i', $text);
       $text = preg_replace("/(Р“І|Р“і|Р±»Ќ|Р±»Џ|Р“µ|Р“ґ|Р±»“|Р±»‘|Р±»™|Р±»•|Р±»—|Р–Ў|Р±»ќ|Р±»›|Р±»Ј|Р±»џ|Р±»Ў)/", 'o', $text);
       $text = preg_replace("/(oРњЂ|oРњЃ|oРњЈ|oРњ‰|oРњѓ|Р“ґ|Р“ґРњЂ|Р“ґРњЃ|Р“ґРњЈ|Р“ґРњ‰|Р“ґРњѓ|Р–Ў|Р–ЎРњЂ|Р–ЎРњЃ|Р–ЎРњЈ|Р–ЎРњ‰|Р–ЎРњѓ)/", 'o', $text);
       $text = preg_replace("/(Р“№|Р“є|Р±»Ґ|Р±»§|Р•©|Р–°|Р±»«|Р±»©|Р±»±|Р±»­|Р±»Ї)/", 'u', $text);
       $text = preg_replace("/(uРњЂ|uРњЃ|uРњЈ|uРњ‰|uРњѓ|Р–°|Р–°РњЂ|Р–°РњЃ|Р–°РњЈ|Р–°Рњ‰|Р–°Рњѓ)/", 'u', $text);
       $text = preg_replace("/(Р±»і|Р“Ѕ|Р±»µ|Р±»·|Р±»№)/", 'y', $text);
       $text = preg_replace("/(Р”‘)/", 'd', $text);
       $text = preg_replace("/(yРњЂ|yРњЃ|yРњЈ|yРњ‰|yРњѓ)/", 'y', $text);
       $text = preg_replace("/(Р”‘)/", 'd', $text);
       $text = preg_replace("/(Р“Ђ|Р“Ѓ|Р±є |Р±єў|Р“ѓ|Р“‚|Р±є¦|Р±є¤|Р±є¬|Р±єРЃ|Р±єЄ|Р”‚|Р±є°|Р±є®|Р±є¶|Р±єІ|Р±єґ)/", 'A', $text);
       $text = preg_replace("/(AРњЂ|AРњЃ|AРњЈ|AРњ‰|AРњѓ|Р“‚|Р“‚РњЂ|Р“‚РњЃ|Р“‚РњЈ|Р“‚Рњ‰|Р“‚Рњѓ|Р”‚|Р”‚РњЂ|Р”‚РњЃ|Р”‚РњЈ|Р”‚Рњ‰|Р”‚Рњѓ)/", 'A', $text);
       $text = preg_replace("/(Р“€|Р“‰|Р±єС‘|Р±єє|Р±єј|Р“Љ|Р±»Ђ|Р±єѕ|Р±»†|Р±»‚|Р±»„)/", 'E', $text);
       $text = preg_replace("/(EРњЂ|EРњЃ|EРњЈ|EРњ‰|EРњѓ|Р“Љ|Р“ЉРњЂ|Р“ЉРњЃ|Р“ЉРњЈ|Р“ЉРњ‰|Р“ЉРњѓ)/", 'E', $text);
       $text = preg_replace("/(Р“Њ|Р“Ќ|Р±»Љ|Р±»€|Р”РЃ)/", 'I', $text);
       $text = preg_replace("/(IРњЂ|IРњЃ|IРњЈ|IРњ‰|IРњѓ)/", 'I', $text);
       $text = preg_replace("/(Р“’|Р““|Р±»Њ|Р±»Ћ|Р“•|Р“”|Р±»’|Р±»ђ|Р±»�|Р±»”|Р±»–|Р– |Р±»њ|Р±»љ|Р±»ў|Р±»ћ|Р±» )/", 'O', $text);
       $text = preg_replace("/(OРњЂ|OРњЃ|OРњЈ|OРњ‰|OРњѓ|Р“”|Р“”РњЂ|Р“”РњЃ|Р“”РњЈ|Р“”Рњ‰|Р“”Рњѓ|Р– |Р– РњЂ|Р– РњЃ|Р– РњЈ|Р– Рњ‰|Р– Рњѓ)/", 'O', $text);
       $text = preg_replace("/(Р“™|Р“љ|Р±»¤|Р±»¦|Р•РЃ|Р–Ї|Р±»Є|Р±»РЃ|Р±»°|Р±»¬|Р±»®)/", 'U', $text);$text = preg_replace("/(UРњЂ|UРњЃ|UРњЈ|UРњ‰|UРњѓ|Р–Ї|Р–ЇРњЂ|Р–ЇРњЃ|Р–ЇРњЈ|Р–ЇРњ‰|Р–ЇРњѓ)/", 'U', $text);
      $text = preg_replace("/(Р±»І|Р“ќ|Р±»ґ|Р±»¶|Р±»С‘)/", 'Y', $text);
      $text = preg_replace("/(Р”ђ)/", 'D', $text);
      $text = preg_replace("/(YРњЂ|YРњЃ|YРњЈ|YРњ‰|YРњѓ)/", 'Y', $text);
      $text = preg_replace("/(Р”ђ)/", 'D', $text);
      $text=strtolower($text);
      return $text;
    }


    /**
     * Постраничная навигация
     * За основу взята доработанная функция от форума SMF 2.x.x
     *
     * @param string $url
     * @param int    $start
     * @param int    $total
     * @param int    $kmess
     * @return string
     */
     public function displayPagination2($url, $start, $total, $kmess)
{
        $neighbors = 2;
        if ($start >= $total) {
            $start = max(0, $total - (($total % $kmess) == 0 ? $kmess : ($total % $kmess)));
        } else {
            $start = max(0, (int)$start - ((int)$start % (int)$kmess));
        }

        $base_link = '(<a class="pagenav" href="' . strtr($url, ['%' => '%%']) . '_p=%d.html' . '">%s</a>)';
        $out[] = $start == 0 ? '' : sprintf($base_link, $start / $kmess, '&lt;&lt;');
 
        if ($start > $kmess * $neighbors) {
            $out[] = sprintf($base_link, 1, '1');
        }

        if ($start > $kmess * ($neighbors + 1)) {
            $out[] = '<span style="font-weight: bold;">...</span>';
        } 

        for ($nCont = $neighbors; $nCont >= 1; $nCont--) {
            if ($start >= $kmess * $nCont) {
                $tmpStart = $start - $kmess * $nCont;
                $out[] = sprintf($base_link, $tmpStart / $kmess + 1, $tmpStart / $kmess + 1);
            }
        }

        $out[] = '<span class="currentpage"><b>(' . ($start / $kmess + 1) . ')</b></span>';
        $tmpMaxPages = (int)(($total - 1) / $kmess) * $kmess;

        for ($nCont = 1; $nCont <= $neighbors; $nCont++) {
            if ($start + $kmess * $nCont <= $tmpMaxPages) {
                $tmpStart = $start + $kmess * $nCont;
                $out[] = sprintf($base_link, $tmpStart / $kmess + 1, $tmpStart / $kmess + 1);
            }
        }
 
        if ($start + $kmess * ($neighbors + 1) < $tmpMaxPages) {
            $out[] = '<span style="font-weight: bold;">...</span>';
        }

        if ($start + $kmess * $neighbors < $tmpMaxPages) {
            $out[] = sprintf($base_link, $tmpMaxPages / $kmess + 1, $tmpMaxPages / $kmess + 1);
        } 

        if ($start + $kmess < $total) {
            $display_page = ($start + $kmess) > $total ? $total : ($start / $kmess + 2);
            $out[] = sprintf($base_link, $display_page, '&gt;&gt;');
        }

        return implode(' ', $out);
    }
 


    /**
     * Mod Nick Color v 7.0.0
     * Mod By Aan Gabreil Elfha Gymkhana
     * CopyRight CyberGhostNet
     * aan.mukaror@gmail.com
     */
     public function nick($id, $mod = false){
       $ban = $this->db->query("SELECT COUNT(*) FROM `cms_ban_users` WHERE `user_id` = '" . $id . "' AND `ban_time` > '" . time() . "'")->fetchColumn();
       $user = $this->db->query("SELECT * FROM `users` WHERE `id` = '" . $id . "'")->fetch();
       if($ban > 0) {
         $out .= '<font color="black">'.($mod == 1 ? '<small>' : '<b>').'<s>' . $user['name'] . '</s>'.($mod == 1 ? '</small>' : '</b>').'</font>';
       } else {
         if($user['rights'] > 1) {
             if($user['rights'] == 3) {
               $font = '<font color="green">';
             }
             if($user['rights'] > 3) {
               $font = '<font color="red">';
             }
             if($user['rights'] == 6) {
               $font = '<font color="#993399">';
             }
             if($user['rights'] == 7) {
               $font = '<font color="gold">';
             }
            if($user['rights'] == 9) {
               $font = '<font color="red">';
            }
            if($user['rights'] == 10) {
               $font = '<font color="#7192a8">';
            }
           $out .= ''.$font.'' . $user['name']. '</font>';
        } else {
           $out .= '<font color="blue">' . $user['name'] . '</font>';
        }
       }
      return $out;
      }



/*
   public function restart($time, $user_id) {
        $sql = "UPDATE users SET balans_time = $time, balans_day = 0 WHERE id = $user_id";
        $return = $this->db->exec($sql);
        //header('Location:'. $_SERVER['PHP_SELF']);
        //exit;
        return $return;
    }
 
*/

    /**
     * Mod Nick Color v 7.0.0
     * Mod By Aan Gabreil Elfha Gymkhana
     * CopyRight CyberGhostNet
     * aan.mukaror@gmail.com
     */
     public function Limited($var, $id, $limit){
        $_a = '<div id="'.$var.'" class="limitinput"></div><script>textCounter(document.getElementById("'.json_encode($id) . '"),"' . $var . '", '.json_encode($limit).')</script>';
         return $_a;
     }

    /**
     * Проверка на игнор у получателя
     *
     * @param $id
     * @return bool
     */
    public function isIgnor($id)
    {
        static $user_id = null;
        static $return = false;

        if (!$this->user->isValid() && !$id) {
            return false;
        }

        if (is_null($user_id) || $id != $user_id) {
            $user_id = $id;
            $req = $this->db->query("SELECT * FROM `cms_contact` WHERE `user_id` = '$id' AND `from_id` = " . $this->user->id);

            if ($req->rowCount()) {
                $res = $req->fetch();
                if ($res['ban'] == 1) {
                    $return = true;
                }
            }
        }

        return $return;
    }

    /**
     * Транслитерация с Русского в латиницу
     *
     * @param string $str
     * @return string
     */
    public function rusLat($str)
    {
        $replace = [
            'а' => 'a',
            'б' => 'b',
            'в' => 'v',
            'г' => 'g',
            'д' => 'd',
            'е' => 'e',
            'ё' => 'e',
            'ж' => 'j',
            'з' => 'z',
            'и' => 'i',
            'й' => 'i',
            'к' => 'k',
            'л' => 'l',
            'м' => 'm',
            'н' => 'n',
            'о' => 'o',
            'п' => 'p',
            'р' => 'r',
            'с' => 's',
            'т' => 't',
            'у' => 'u',
            'ф' => 'f',
            'х' => 'h',
            'ц' => 'c',
            'ч' => 'ch',
            'ш' => 'sh',
            'щ' => 'sch',
            'ъ' => "",
            'ы' => 'y',
            'ь' => "",
            'э' => 'ye',
            'ю' => 'yu',
            'я' => 'ya',
        ];

        return strtr(mb_strtolower($str), $replace);
    }

    /**
     * Обработка смайлов
     *
     * @param string $str
     * @param bool   $adm
     * @return string
     */
    public function smilies($str, $adm = false)
    {
        static $smiliesCache = [];

        if (empty($smiliesCache)) {
            $file = ROOT_PATH . 'files/cache/smileys.dat';

            if (file_exists($file) && ($smileys = file_get_contents($file)) !== false) {
                $smiliesCache = unserialize($smileys);

                return strtr($str, ($adm ? array_merge($smiliesCache['usr'], $smiliesCache['adm']) : $smiliesCache['usr']));
            } else {
                return $str;
            }
        } else {
            return strtr($str, ($adm ? array_merge($smiliesCache['usr'], $smiliesCache['adm']) : $smiliesCache['usr']));
        }
    }

    /**
     * Функция пересчета на дни, или часы
     *
     * @param int $var
     * @return bool|string
     */
    public function timecount($var)
    {
        if ($var < 0) {
            $var = 0;
        }

        $day = ceil($var / 86400);

        return $var >= 86400
            ? $day . ' ' . _p('Day', 'Days', $day, 'system')
            : date("G:i:s", mktime(0, 0, $var));
    }

    // Транслитерация текста
    public function trans($str)
    {
        $replace = [
            'a'  => 'а',
            'b'  => 'б',
            'v'  => 'в',
            'g'  => 'г',
            'd'  => 'д',
            'e'  => 'е',
            'yo' => 'ё',
            'zh' => 'ж',
            'z'  => 'з',
            'i'  => 'и',
            'j'  => 'й',
            'k'  => 'к',
            'l'  => 'л',
            'm'  => 'м',
            'n'  => 'н',
            'o'  => 'о',
            'p'  => 'п',
            'r'  => 'р',
            's'  => 'с',
            't'  => 'т',
            'u'  => 'у',
            'f'  => 'ф',
            'h'  => 'х',
            'c'  => 'ц',
            'ch' => 'ч',
            'w'  => 'ш',
            'sh' => 'щ',
            'q'  => 'ъ',
            'y'  => 'ы',
            'x'  => 'э',
            'yu' => 'ю',
            'ya' => 'я',
            'A'  => 'А',
            'B'  => 'Б',
            'V'  => 'В',
            'G'  => 'Г',
            'D'  => 'Д',
            'E'  => 'Е',
            'YO' => 'Ё',
            'ZH' => 'Ж',
            'Z'  => 'З',
            'I'  => 'И',
            'J'  => 'Й',
            'K'  => 'К',
            'L'  => 'Л',
            'M'  => 'М',
            'N'  => 'Н',
            'O'  => 'О',
            'P'  => 'П',
            'R'  => 'Р',
            'S'  => 'С',
            'T'  => 'Т',
            'U'  => 'У',
            'F'  => 'Ф',
            'H'  => 'Х',
            'C'  => 'Ц',
            'CH' => 'Ч',
            'W'  => 'Ш',
            'SH' => 'Щ',
            'Q'  => 'Ъ',
            'Y'  => 'Ы',
            'X'  => 'Э',
            'YU' => 'Ю',
            'YA' => 'Я',
        ];

        return strtr($str, $replace);
    }
 public function displayExpIco($var) {
        if ($var < 20)
            return $this->image('level/1-gacon.gif');
        if ($var >= 20 && $var < 40)
            return $this->image('level/2-buago.gif');
        if ($var >= 40 && $var < 80)
            return $this->image('level/3-buagodoi.gif');
        if ($var >= 80 && $var < 200)
            return $this->image('level/4-buada.gif');
        if ($var >= 200 && $var < 350)
            return $this->image('level/5-buadadoi.gif');
        if ($var >= 350 && $var < 500)
            return $this->image('level/6-riusat.gif');
        if ($var >= 500 && $var < 700)
            return $this->image('level/7-riusatdoi.gif');
        if ($var >= 700 && $var < 1000)
            return $this->image('level/8-riuchiensat.gif');
        if ($var >= 1000 && $var < 1500)
            return $this->image('level/9-riuchiensatcham.gif');
        if ($var >= 1500 && $var < 2000)
            return $this->image('level/10-riubac.gif');
        if ($var >= 2000 && $var < 3000)
            return $this->image('level/11-riubacdoi.gif');
        if ($var >= 3000 && $var < 5000)
            return $this->image('level/12-riuchienbac.gif');
        if ($var >= 5000 && $var < 7000)
            return $this->image('level/13-riuchienbaccham.gif');
        if ($var >= 7000 && $var < 10000)
            return $this->image('level/14-riuvang.gif');
        if ($var >= 10000 && $var < 15000)
            return $this->image('level/15-riuvangdoi.gif');
        if ($var >= 15000 && $var < 20000)
            return $this->image('level/16-riuchienvang.gif');
        if ($var >= 20000)
            return $this->image('level/2-riuchienvangcham.gif');
    }
    public function displayUsername($username, $rights = 1, $isBbcode = false)
    {
        switch ($rights) {
            case 2:
            case 3: //Fmod (Forum moder)
                return (!$isBbcode ? '<span style="color: #34ff5d;">' . $username . '</span>' : '[color=#34ff5d]' . $username . '[/color]');
                break;
            case 4:
            case 5:
            case 6: //Smod (Super moder)
                return (!$isBbcode ? '<span style="color: #b53dd2;">' . $username . '</span>' : '[color=#b53dd2]' . $username . '[/color]');
                break;
            case 7: //Adm (Administrator)
            case 8:
                return (!$isBbcode ? '<span style="color: #ffff00;">' . $username . '</span>' : '[color=#ffff00]' . $username . '[/color]');
                break;
            case 9: //Supervisor
                return (!$isBbcode ? '<span style="color: #ff0000;">' . $username . '</span>'  : '[color=#ff0000]' . $username . '[/color]');
                break;
            default:
                return $username;
                break;
        }
    }
    public function rewriteUrl($str, $topicId, $page = 0, $displayPagination = false) {
        if ($this->config->rewriteurl) {
            $str = $this->rusLat($str); //convert strings Russian character into latin character
            $str = $this->container->get('bbcode')->notags($str);
            $str = strtolower($str);
            $str = str_replace(['â', 'ầ', 'ầ', 'ấ', 'ấ', 'ậ', 'ậ', 'ẩ', 'ẩ', 'ẫ', 'ẫ', 'ă', 'ằ', 'ằ', 'ắ', 'ắ', 'ặ', 'ặ', 'ẳ', 'ẳ', 'ẵ', 'ẵ', 'à', 'à', 'á', 'á', 'ạ', 'ạ', 'ả', 'ả', 'ã', 'ã', 'Â', 'Ầ', 'Ầ', 'Ấ', 'Ấ', 'Ậ', 'Ậ', 'Ẩ', 'Ẩ', 'Ẫ', 'Ẫ', 'Ă', 'Ắ', 'Ằ', 'Ằ', 'Ắ', 'Ặ', 'Ặ', 'Ẳ', 'Ẳ', 'Ẵ', 'Ẵ', 'À', 'À', 'Á', 'Á', 'Ạ', 'Ạ', 'Ả', 'Ả', 'Ã', 'Ã'], 'a', $str);
            $str = str_replace(['ê', 'ề', 'ề', 'ế', 'ế', 'ệ', 'ệ', 'ể', 'ể', 'ễ', 'ễ', 'è', 'è', 'é', 'é', 'ẹ', 'ẹ', 'ẻ', 'ẻ', 'ẽ', 'ẽ', 'Ẽ', 'Ẽ', 'Ê', 'Ề', 'Ề', 'Ế', 'Ế', 'Ệ', 'Ệ', 'Ể', 'Ể', 'Ễ', 'Ễ', 'È', 'È', 'É', 'É', 'Ẹ', 'Ẹ', 'Ẻ', 'Ẻ'], 'e', $str);
            $str = str_replace(['ì', 'ì', 'í', 'í', 'ị', 'ị', 'ỉ', 'ỉ', 'ĩ', 'ĩ', 'Ì', 'Ì', 'Í', 'Í', 'Ị', 'Ị', 'Ỉ', 'Ỉ', 'Ĩ', 'Ĩ'], 'i', $str);
            $str = str_replace(['ô', 'ồ', 'ồ', 'ố', 'ố', 'ộ', 'ộ', 'ổ', 'ổ', 'ỗ', 'ỗ', 'ơ', 'ờ', 'ờ', 'ớ', 'ớ', 'ợ', 'ợ', 'ở', 'ở', 'ỡ', 'ỡ', 'ò', 'ò', 'ó', 'ó', 'ọ', 'ọ', 'ỏ', 'ỏ', 'õ', 'õ', 'Ô', 'Ồ', 'Ồ', 'Ố', 'Ố', 'Ộ', 'Ộ', 'Ổ', 'Ổ', 'Ỗ', 'Ỗ', 'Ờ', 'Ơ', 'Ờ', 'Ớ', 'Ớ', 'Ợ', 'Ợ', 'Ở', 'Ở', 'Ỡ', 'Ỡ', 'Ò', 'Ò', 'Ó', 'Ó', 'Ọ', 'Ọ', 'Ỏ', 'Ỏ', 'Õ', 'Õ'], 'o', $str);
            $str = str_replace(['ư', 'ừ', 'ừ', 'ứ', 'ứ', 'ự', 'ự', 'ử', 'ử', 'ữ', 'ữ', 'ù', 'ù', 'ú', 'ú', 'ụ', 'ụ', 'ủ', 'ủ', 'ũ', 'ũ', 'Ư', 'Ừ', 'Ừ', 'Ứ', 'Ứ', 'Ự', 'Ự', 'Ử', 'Ử', 'Ữ', 'Ữ', 'Ù', 'Ù', 'Ú', 'Ú', 'Ụ', 'Ụ', 'Ủ', 'Ủ', 'Ũ', 'Ũ'], 'u', $str);
            $str = str_replace(['ỳ', 'ỳ', 'ý', 'ý', 'ỵ', 'ỵ', 'ỷ', 'ỷ', 'ỹ', 'ỹ', 'Ỳ', 'Ỳ', 'Ý', 'Ý', 'Ỵ', 'Ỵ', 'Ỷ', 'Ỷ', 'Ỹ', 'Ỹ'], 'y', $str);
            $str = str_replace(['Đ', 'đ'], 'd', $str);
            $str = str_replace(' ', '-', $str); // Replaces all spaces with hyphens.
            $str = preg_replace('/[^A-Za-z0-9\-]/', '', $str); // Removes special chars.
            $str = preg_replace('/-+/', '-', $str);
            $str = substr($str, 0, 100);
            if ($page > 1)
                 $str = $this->config->homeurl . '/forum/' . $str . '-t' . $topicId . '-p' . $page . '.html'; 
            else {
                if ($displayPagination)
                    $str = $this->config->homeurl . '/forum/' . $str . '-t' . $topicId . '-p{PAGE}.html';
                else
                    $str = $this->config->homeurl . '/forum/' . $str . '-t' . $topicId . '.html';
            }
        } else {
            if ($page > 1) {
                    $str = $this->config->homeurl . '/forum/index.php?id=' . $topicId . '&amp;page=' . $page;
            } else {
                if ($displayPagination)
                    $str = $this->config->homeurl . '/forum/index.php?id=' . $topicId . '&amp;';
                else
                    $str = $this->config->homeurl . '/forum/index.php?id=' . $topicId;
            }
        }
        return $str;
    }
    public function substring($str, $length = 100, $sub_character = ' ') {
        $result = $str;
        if (mb_strlen($str) > $length) {
            $result = mb_substr($str, 0, $length);
            while (($tmp = mb_substr($str, $length, 1)) && $tmp != $sub_character) {
                $result .= $tmp;
                $length++;
            }
        }
        return trim($result);
    }
    public function generateString($length = 0) {
        $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*()+[]';
        if ($length == 0)
        $length = mt_rand(25, 32);
        $result = '';
        for ($i = 0; $i < $length; $i++)
            $result .= $alphabet[mt_rand(0, 75)];
        return $result;
    }
    public function passwordHash($string) {
        $options = [
                'cost' => 11,
                'salt' => mcrypt_create_iv(22, MCRYPT_DEV_URANDOM),
                ];
        return password_hash(trim($string), PASSWORD_BCRYPT, $options);
    }
    public function passwordVerify($password, $hash) {
        return password_verify($password, $hash);
    }
}


