<?php
/*
#
# +------------------------------------------------------------------------------+
# | Sitemap Creator 0.2 beta  build 20080514                                     |
# +------------------------------------------------------------------------------+
# | Sitemap Creator crawls/spiders your website, creates XML sitemaps , pings    |
# | Search Engine bots to crawl them, tracks bots and send it by mail.           |
# +------------------------------------------------------------------------------+
# | Email         gadelkareem@gmail.com                                          |
# | Web           www.gadelkareem.com                                            |
# |                                                                              |
# | Before using, modifying or publishing this class, you should refer to the    |
# | GNU GENERAL PUBLIC LICENSE. This is available at:                            |
# | http://www.gnu.org/licenses/gpl.txt                                          | 
# +------------------------------------------------------------------------------+
# | .config.inc.php : configuration file , edit with your information as adviced |
# +------------------------------------------------------------------------------+
#
*/

#website domain, do not add 'http://'
#ex : 'gadelkareem.com' or just leave it as server's host
#the script allows creating sitemaps for more than one host,
#however you still need to change it here first
#recommended : $_SERVER['HTTP_HOST']
define('SMC_SITE', $_SERVER['HTTP_HOST'] );
#change to https if required
#recommended : 'http://'
define('SMC_SCHEME', 'http://' );
#your email address
#set to false to disable mail
define('SMC_EMAIL', 'admin@'.SMC_SITE );
#disable crawling specific directories or links
#use @-@ to split between different URLs
#you can use regular expressions
#ex: 'photos/?@-@contact/?' - should disable all links to /photos/ and /contact/
#ex: 'wp-login.php' - disable links to wp-login.php
#recommended : false
define('SMC_DISABLED_DIRS', false );
#Login Password
#this is used internally by the script to secure the script
#set to false to disable login form
define('SMC_PASS',  'demopass');
#location of your google sitemap stylesheet
#gss.xsl file included with the script 
#based on : http://sourceforge.net/projects/gstoolbox
#set to false to disable
#recommended : 1
define('SMC_GSS',  1);
#weather to show internal Notices and Warning, this is totally different from PHP error handling
#recommended : true
define('SMC_SHOW_ERROR', true); 
#weather to show internal debug messages, 
#enable if you can not run the script and no errors show
#recommended : false
define('SMC_SHOW_DEBUG', false); 
#weather to check last modified from file headers or set as current time
#ref : http://www.sitemaps.org/protocol.php#lastmoddef
#recommended : true
define('SMC_CALC_LAST_MODIFIED', true); 
#Decide how you want to count periority of pages
#ref : http://www.sitemaps.org/protocol.php#prioritydef
#This could be one of the following :
# false : Disabled
# 1     : depending on number and placement of linkbacks
# 2     : depending on crawled first links
# 3     : depending on URL structure ( path depth )
#recommended : 1
define('SMC_CALC_PERIORITY', 1); 
#Set the minimum priority should be given to URL
#ref : http://www.sitemaps.org/protocol.php#prioritydef
#recommended : 0.1
define('SMC_MIN_PERIORITY', 0.1); 
#weather or not to count page frequency
#ref : http://www.sitemaps.org/protocol.php#changefreqdef
#frequency is counted per periority
#recommended : true
define('SMC_CALC_FREQUENCY', true); 
#weather or not to ping search engines
#ref : http://www.sitemaps.org/protocol.php#submit_ping
#recommended : true
define('SMC_PING', true); 
#enable crawl before creating sitemap when calling from crontab
#recommended : true
define('SMC_CRAWL_FIRST', true); 
#Number of URLs to display on the sitemap page per page
#recommended : 200
define('SMC_PER_PAGE', 200); 


#set memory limit in MB for the script to run
#recommended : 200 +
define('SMC_MEMORY_LIMIT',  250);
#set URLs limit to stop after crawling that number of URLs
#recommended : false
define('SMC_URLS_LIMIT',  false);
#weather to use Cache, try to use cache to avoid duplicating url requests
#recommended : true
define('SMC_USE_CACHE', true);
#weather to blacklist error pages, or non text types that looks otherwise
#recommended : true
define('SMC_USE_BLACKLIST', true);
#Number of seconds to keep the cache, set to 1 hour
#recommended : 60*60*1
define('SMC_CACHE_TTL', 60*60*1 ); 
#set time out for crawler to run, increase this value if you didn't find all your URLs
#recommended : 200
define('SMC_CRAWL_TIME_OUT', 200); 
#set max time the crawler to connect or retrieve a page, do not set that too high 
#recommended : 15
define('SMC_CONNECT_TIME_OUT', 15); 
#set number or redirects the crawler should follow
#recommended : 1
define('SMS_MAX_REDIRECT', 1); 


/* Do not change unless adviced */
#data directory, please remember to (chmod 777)
#recommended : dirname(__FILE__).'/data/'
define('SMC_DATA', dirname(__FILE__).'/data/');
#script url path
#recommended : $_SERVER['PHP_SELF']
define('SMC_SELF', $_SERVER['PHP_SELF']); 

/*internal settings*/
define('SMC_VERSION', '0.2b');
define('SMC_DATA_CACHE', SMC_DATA.'cache/');
define('SMC_DATA_SITES', SMC_DATA.'sites/');
define('SMC_DATA_ERRORS', SMC_DATA.'errors/');
define('SMC_DATA_SITEMAPS', SMC_DATA_SITES.SMC_SITE.'_sitemaps/'); 
$pings = array (
	'Google' => 'http://www.google.com/webmasters/sitemaps/ping?sitemap=',
	'Yahoo' => 'http://search.yahooapis.com/SiteExplorerService/V1/updateNotification?appid=SitemapWriter&url=',
	'Live Search' => 'http://webmaster.live.com/ping.aspx?siteMap=',
	'Ask.com' => 'http://submissions.ask.com/ping?sitemap=',
	'MoreOver' => 'http://api.moreover.com/ping?u=',
);


?>