<?php
function utf_strlen($str)  /* Проверка длинны контента в utf8 */
{
 if(function_exists('mb_strlen')) return mb_strlen($str, 'utf-8');
 if(function_exists('iconv_strlen')) return iconv_strlen($str, 'utf-8');
 return strlen(utf8_decode($str));
}
function AutoContent($get_url) /* Функция выдерает ключевые слова со станицы */
{

 # НАСТРОЙКИ СКРИПТА

 $Occurence_min = 1; // минимальное кол-во повторов слов в ключевом списке
 $Wordlength_min = 4; // минимальное кол-во символов в ключевом слове
 $Wordlength_max = 15; // максимальное кол-во символов в ключевом слове
 $Keywordlength_max  =100; // максимальная длинна сгенерированного списка
 $default_text = 'default'; // текст по умолчанию, если контента нет
 $blacklist_path = 'stopwords.txt'; // черный список
 $seperator = " "; // разделитель между словами (лучше не ставить, т.к некоторые поисковики игнорируют такой текст)

 # НЕ ТРОГАТЬ (РАБОТЕТ ПАРСЕР)

 $buffer = strip_tags(join('',file("$get_url"))); // берем содержимое
 if(trim($buffer)=="") $output = $default_text; // если нет контента, то задаем по умолчанию
 else
  {
   $buffer = preg_replace("/(\[|\])/", "", $buffer); // удаляем скобки
   $buffer = eregi_replace("[\n\r\t]+", " ", $buffer); // удаляем пробелы и табуляцию
   $buffer = eregi_replace("(/\*.*\*/|\<\?php[^<]*\?\>)", " ", $buffer); // удаляем рнр теги и комментарии, если такие имеются в тексте
   $buffer = strip_htmlentities($buffer); // конвертируем html эквиваленты в их значения...
   $buffer = eregi_replace("(".CHR(31)."|&quot;|&amp;|&lt;|&gt;|&nbsp;|&sect;|&copy;|[_=\?\*\'\"\+!@()#{}:;\./, -]|[0-9])+", " ", $buffer); // ... затем уничтожаем их
   $blacklist = array_unique(explode("\r\n",(file("$blacklist_path")))); // открываем Черный список слов
   $words = array_unique(explode(" ",$buffer));
   unset($words[0]); // удаляем слова из keywords, которые содержаться в stopwords.txt

   /* Парсим и раскладываем оставшиеся слова */

   $relevant = array();
   foreach($words as $k=>$v): if(utf_strlen($v)<$Wordlength_min || utf_strlen($v)>$Wordlength_max) continue;
   $v = trim(strtolower($v));
   if(in_array($v, $blacklist)) continue;
   if(substr($v,-2)=='ый' || substr($v,-2)=='ых' || substr($v,-2)=='го' || substr($v,-2)=='ми' || substr($v,-2)=='ом' || substr($v,-2)=='ся' || substr($v,-2)=='ее' || substr($v,-2)=='ое') continue;

   /* Расчитываем релевантность */

   if(!isset($relevant[$v])) $relevant[$v] = 1;
   else $relevant[$v]++;
   endforeach;
   arsort($relevant);
   $output = '';
   foreach($relevant as $k=>$v)
    {
     if($v<$Occurence_min) continue;
     if(utf_strlen($output)>$Keywordlength_max) break;
     $output.=$seperator.$k;
    }
   return $output = substr($output,1);
  }
}
function strip_htmlentities($text) /* Функция удаляющая HTML эквиваленты и опасные символы */
{
 $html2iso = array('&ndash;'=>'-','&quot;'=>CHR(34),'&ndash;'=>'-','&nbsp;'=>CHR(32),'&iexcl;'=>CHR(161),'&cent;'=>CHR(162),'&pound;'=>CHR(163),'&curren;'=>CHR(164),'&yen;'=>CHR(165),'&brvbar;'=>CHR(166),'&sect;'=>CHR(167),'&uml;'=>CHR(168),'&copy;'=>CHR(169),'&ordf;'=>CHR(170),'&laquo;'=>CHR(171),'&not;'=>CHR(172),'&shy;'=>CHR(173),'&reg;'=>CHR(174),'&macr;'=>CHR(175),'&deg;'=>CHR(176),'&plusmn;'=>CHR(177),'&sup2;'=>CHR(178),'&sup3;'=>CHR(179),'&acute;'=>CHR(180),'&micro;'=>CHR(181),'&para;'=>CHR(182),'&middot;'=>CHR(183),'&cedil;'=>CHR(184),'&sup1;'=>CHR(185),'&ordm;'=>CHR(186),'&raquo;'=>CHR(187),'&frac14;'=>CHR(188),'&frac12;'=>CHR(189),'&frac34;'=>CHR(190),'&iquest;'=>CHR(191),'&Agrave;'=>CHR(192),'&Aacute;'=>CHR(193),'&Acirc;'=>CHR(194),'&Atilde;'=>CHR(195),'&Auml;'=>CHR(196),'&Aring;'=>CHR(197),'&AElig;'=>CHR(198),'&Ccedil;'=>CHR(199),'&Egrave;'=>CHR(200),'&Eacute;'=>CHR(201),'&Ecirc;'=>CHR(202),'&Euml;'=>CHR(203),'&Igrave;'=>CHR(204),'&Iacute;'=>CHR(205),'&Icirc;'=>CHR(206),'&Iuml;'=>CHR(207),'&ETH;'=>CHR(208),'&Ntilde;'=>CHR(209),'&Ograve;'=>CHR(210),'&Oacute;'=>CHR(211),'&Ocirc;'=>CHR(212),'&Otilde;'=>CHR(213),'&Ouml;'=>CHR(214),'&times;'=>CHR(215),'&Oslash;'=>CHR(216),'&Ugrave;'=>CHR(217),'&Uacute;'=>CHR(218),'&Ucirc;'=>CHR(219),'&Uuml;'=>CHR(220),'&Yacute;'=>CHR(221),'&THORN;'=>CHR(222),'&szlig;'=>CHR(223),'&agrave;'=>CHR(224),'&aacute;'=>CHR(225),'&acirc;'=>CHR(226),'&atilde;'=>CHR(227),'&auml;'=>CHR(228),'&aring;'=>CHR(229),'&aelig;'=>CHR(230),'&ccedil;'=>CHR(231),'&egrave;'=>CHR(232),'&eacute;'=>CHR(233),'&ecirc;'=>CHR(234),'&euml;'=>CHR(235),'&igrave;'=>CHR(236),'&iacute;'=>CHR(237),'&icirc;'=>CHR(238),'&iuml;'=>CHR(239),'&eth;'=>CHR(240),'&ntilde;'=>CHR(241),'&ograve;'=>CHR(242),'&oacute;'=>CHR(243),'&ocirc;'=>CHR(244),'&otilde;'=>CHR(245),'&ouml;'=>CHR(246),'&divide;'=>CHR(247),'&oslash;'=>CHR(248),'&ugrave;'=>CHR(249),'&uacute;'=>CHR(250),'&ucirc;'=>CHR(251),'&uuml;'=>CHR(252),'&yacute;'=>CHR(253),'&thorn;'=>CHR(254),'&yuml;'=>CHR(255));
 reset($html2iso);
 unset($entities);
 unset($isochars);
 while(list($key, $value) = each($html2iso))
  {
   // Perl pattern
   //$entities[] = "/$key/g";
   $entities[] = "/$key/";
   $isochars[] = $value;
   $text = str_replace($key, $value, $text);
  }
 return $text;
}
?>