<?php

require_once 'func.php';
	require_once 'config.php';							# Инклюдим настройки

	// Прием данных, переданных через POST с формы
	
	$text = $_POST['text'];								# текст надписи
	$v_size_canvas = $_POST['v_size_canvas'];			# тип размера холста
	
	// если выбран ручной тип размера холста , то получить только переменные $size_canvas_w и $size_canvas_h
	if ($v_size_canvas == 'man') {
		$size_canvas_w = $_POST['size_canvas_w'];		# ширина холста
		$size_canvas_h	= $_POST['size_canvas_h'];		# высота холста
		$coord_x = $_POST['coord_x'];					# координата x верхнего левого угла надписи
		$coord_y = $_POST['coord_y'];					# координата y верхнего левого угла надписи
	}
	
	$size = $_POST['size'];								# размер шрифта
	$angle = $_POST['angle'];							# угол поворота
	$v_bgcolor = $_POST['v_bgcolor'];					# формат цвета фона
	
	// если выбран формат цвета фона #rrggbb, то получить только переменную $bgcolor_rrggbb ($bgcolor_r, $bgcolor_g, $bgcolor_b - не получать)
	if ($v_bgcolor == 'rrggbb') {
		$bgcolor_rrggbb = $_POST['bgcolor_rrggbb'];		# цвет фона в формате #rrggbb
	}
	
	// если выбран формат цвета фона r,g,b, то получить только переменные $bgcolor_r, $bgcolor_g, $bgcolor_b ($bgcolor_rrggbb - не получать)
	if ($v_bgcolor == 'rgb') {
		$bgcolor_r = $_POST['bgcolor_r'];				# уровень красного цвета фона в формате r,g,b
		$bgcolor_g = $_POST['bgcolor_g'];				# уровень зеленого цвета фона в формате r,g,b 
		$bgcolor_b = $_POST['bgcolor_b'];				# уровень синего цвета фона в формате r,g,b
	}
	
	$v_txtcolor = $_POST['v_txtcolor'];					# формат цвета текста
	
	// если выбран формат цвета текста #rrggbb, то получить только переменную $txtcolor_rrggbb ($txtcolor_r, $txtcolor_g, $txtcolor_b - не получать)
	if ($v_txtcolor == 'rrggbb') {
		$txtcolor_rrggbb = $_POST['txtcolor_rrggbb'];	# цвет текста в формате #rrggbb
	}
	
	// если выбран формат цвета текста r,g,b, то получить только переменные $txtcolor_r, $txtcolor_g, $txtcolor_b ($txtcolor_rrggbb - не получать)
	if ($v_txtcolor == 'rgb') {
		$txtcolor_r = $_POST['txtcolor_r'];				# уровень красного цвета текста в формате r,g,b
		$txtcolor_g = $_POST['txtcolor_g'];				# уровень зеленого цвета текста в формате r,g,b 
		$txtcolor_b = $_POST['txtcolor_b'];				# уровень синего цвета текста в формате r,g,b
	}
	
	$font = $_POST['font'];								# шрифт
	$format = $_POST['format'];							# формат изображения
	
	// если формат изображения PNG, то получить только переменную $transparency ($quality и $threshold - не получать)
	if ($format == 'png') {
		$transparency = $_POST['transparency'];			# уровень прозрачности для PNG
	}
	
	// если формат изображения JPG, то получить только переменную $quality ($transparency и $threshold - не получать)
	if ($format == 'jpg') {
		$quality = $_POST['quality'];					# уровень качества для JPG
	}
	
	// если формат изображения WBMP, то получить только переменную $threshold ($transparency и  $quality - не получать)
	if ($format == 'wbmp') {
		$threshold = $_POST['threshold'];				# уровень порогового значения для WBMP
	}

	// Производим преобразование спецсимволов в их HTML эквиваленты и удаление обратных слэшей

	$text = stripslashes(htmlspecialchars ($text));
	$v_size_canvas = stripslashes(htmlspecialchars ($v_size_canvas));
	if ($v_size_canvas == 'man') {
		$size_canvas_w = stripslashes(htmlspecialchars ($size_canvas_w));
		$size_canvas_h	= stripslashes(htmlspecialchars ($size_canvas_h));
		$coord_x = stripslashes(htmlspecialchars ($coord_x));
		$coord_y = stripslashes(htmlspecialchars ($coord_y));
	}	
	$size = stripslashes (htmlspecialchars ($size));
	$angle = stripslashes (htmlspecialchars ($angle));
	$v_bgcolor = stripslashes (htmlspecialchars ($v_bgcolor));
	if ($v_bgcolor == 'rrggbb') {
		$bgcolor_rrggbb = stripslashes (htmlspecialchars ($bgcolor_rrggbb));
	}
	if ($v_bgcolor == 'rgb') {
		$bgcolor_r = stripslashes (htmlspecialchars ($bgcolor_r));
		$bgcolor_g = stripslashes (htmlspecialchars ($bgcolor_g));
		$bgcolor_b = stripslashes (htmlspecialchars ($bgcolor_b));
	}
	$v_txtcolor = stripslashes (htmlspecialchars ($v_txtcolor));
	if ($v_txtcolor == 'rrggbb') {
		$txtcolor_rrggbb = stripslashes (htmlspecialchars ($txtcolor_rrggbb));
	}
	if ($v_txtcolor == 'rgb') {
		$txtcolor_r = stripslashes (htmlspecialchars ($txtcolor_r));
		$txtcolor_g = stripslashes (htmlspecialchars ($txtcolor_g));
		$txtcolor_b = stripslashes (htmlspecialchars ($txtcolor_b));
	}
	$font = stripslashes (htmlspecialchars ($font));
	$format = stripslashes (htmlspecialchars ($format));
	if ($format == 'png') {
		$transparency = stripslashes (htmlspecialchars ($transparency));
	}
	if ($format == 'jpg') {
		$quality = stripslashes (htmlspecialchars ($quality));
	}
	if ($format == 'wbmp') {
		$threshold = stripslashes (htmlspecialchars ($threshold));
	}

	// Проверяем, все ли поля заполнены, всё ли выбрано
	
	if ($text == '') {$error[1] = 'Не введен текст надписи!';}
	if ($v_size_canvas == '') {$error[2] = 'Не выбран тип размера холста!';}
	if ($v_size_canvas == 'man') {
		if ($size_canvas_w == '') {$error[3] = 'Не выбрана ширина холста!';}
		if ($size_canvas_h == '') {$error[4] = 'Не выбрана высота холста!';}
		if ($coord_x == '') {$error[5] = 'Не выбрана координата x верхнего левого угла надписи!';}
		if ($coord_y == '') {$error[6] = 'Не выбрана координата y верхнего левого угла надписи!';}
	}
	if ($size == '') {$error[7] = 'Не выбран размер шрифта!';}
	if ($angle == '') {$error[8] = 'Не выбран угол поворота!';}
	if ($v_bgcolor == '') {$error[9] = 'Не выбран формат цвета фона!';}
	if ($v_bgcolor == 'rrggbb') {
		if ($bgcolor_rrggbb == '') {$error[10] = 'Не выбран цвет фона в формате #rrggbb!';}
	}
	if ($v_bgcolor == 'rgb') {
		if ($bgcolor_r == '') {$error[11] = 'Не выбран уровень красного цвета фона в формате r,g,b!';}
		if ($bgcolor_g == '') {$error[12] = 'Не выбран уровень зеленого цвета фона в формате r,g,b!';}
		if ($bgcolor_b == '') {$error[13] = 'Не выбран уровень синего цвета фона в формате r,g,b!';}
	}
	if ($v_txtcolor == '') {$error[14] = 'Не выбран формат цвета текста!';}
	if ($v_txtcolor == 'rrggbb') {
		if ($txtcolor_rrggbb == '') {$error[15] = 'Не выбран цвет текста в формате #rrggbb!';}
	}
	if ($v_txtcolor == 'rgb') {
		if ($txtcolor_r == '') {$error[16] = 'Не выбран уровень красного цвета текста в формате r,g,b!';}
		if ($txtcolor_g == '') {$error[17] = 'Не выбран уровень зеленого цвета текста в формате r,g,b!';}
		if ($txtcolor_b == '') {$error[18] = 'Не выбран уровень синего цвета текста в формате r,g,b!';}
	}
	if ($font == '') {$error[19] = 'Не выбран шрифт!';}
	if ($format == '') {$error[20] = 'Не выбран формат изображения!';}
	if ($format == 'png') {
		if ($transparency == '') {$error[21] = 'Не выбран уровень прозрачности для PNG!';}
	}
	if ($format == 'jpg') {
		if ($quality == '') {$error[22] = 'Не выбран уровень качества для JPG!';}
	}
	if ($format == 'wbmp') {
		if ($threshold == '') {$error[23] = 'Не выбран уровень уровень порогового значения для WBMP!';}
	}
	
	// Если есть ошибки, то выводим их на экран и прекращаем дальнейшие действия
	if ($error) {
		$title = 'Лого-генератор: Ошибка';
		$keywords = 'Лого-генератор: Ошибка';
		$description = 'Лого-генератор: Ошибка';
		include_once 'head.php';
		echo '<div align="center" class="head">ЛОГО-ГЕНЕРАТОР: ОШИБКА</div>'."\n";
		echo '<p>'."\n";
		for ($n = 1; $n < 24; $n++) {
			if ($error[$n]) {
				echo $error[$n];
				echo '<br />'."\n";
			}
		}
		echo '<br />'."\n";
		echo '<a href="index.php';
		if ($url) {echo "?url=".$url;}
		echo '">Назад</a><br />'."\n";
		echo '</p>'."\n";
		include_once 'footer.php';
		exit;
	}

	// Проверка данных с помощью регулярных выражений 
	// (в полях ввода проверяем допустимые символы, при выборе строгое соответствие возможным вариантам);
	//проверка максимальной и минимальной длины;
	// проверка действительности существования выбранного шрифта
		
	if (preg_match ('/[^0-9a-zA-Zа-яА-Я.]/', $text)) {$error[1] = 'Вы ввели запрещенные символы в поле текста надписи!';}
	if (!preg_match ('/^din$|^man$/', $v_size_canvas)) {$error[2] = 'Неправильный тип размера холста!';}
	if ($v_size_canvas == 'man') {
		if (preg_match ('/[^0-9]/', $size_canvas_w)) {$error[3] = 'Неправильная ширина холста!';}
		if (preg_match ('/[^0-9]/', $size_canvas_h)) {$error[4] = 'Неправильная высота холста!';}
		if (preg_match ('/[^0-9]/', $coord_x)) {$error[5] = 'Неправильная координата x верхнего левого угла надписи!';}
		if (preg_match ('/[^0-9]/', $coord_y)) {$error[6] = 'Неправильная координата y верхнего левого угла надписи!';}
	}
	if (preg_match ('/[^0-9]/', $size)) {$error[7] = 'Неправильный размер шрифта!';}
	if (preg_match ('/[^0-9]/', $angle)) {$error[8] = 'Непраильный угол поворота!';}
	if (!preg_match ('/^rgb$|^rrggbb$/', $v_bgcolor)) {$error[9] = 'Неправильный формат цвета фона!';}
	if ($v_bgcolor == 'rrggbb') {
		if (strlen($bgcolor_rrggbb) != 6) {$error[10] = 'Неправильный  цвет фона в формате #rrggbb!';}
		if (preg_match ('/[^0-9a-fA-F]/', $bgcolor_rrggbb)) {$error[10] = 'Неправильный цвет фона в формате #rrggbb!';}
	}
	if ($v_bgcolor == 'rgb') {
		if (strlen ($bgcolor_r) > 3) {$error[11] = 'Неправильный уровень красного цвета фона в формате r,g,b!';}
		if (preg_match ('/[^0-9]/', $bgcolor_r)) {$error[11] = 'Неправильный уровень красного цвета фона в формате r,g,b!';}
		
		if (strlen ($bgcolor_g) > 3) {$error[12] = 'Неправильный уровень зеленого цвета фона в формате r,g,b!';}
		if (preg_match ('/[^0-9]/', $bgcolor_g)) {$error[12] = 'Неправильный уровень зеленого цвета фона в формате r,g,b!';}
		
		if (strlen ($bgcolor_b) > 3) {$error[13] = 'Неправильный уровень синего цвета фона в формате r,g,b!';}
		if (preg_match ('/[^0-9]/', $bgcolor_b)) {$error[13] = 'Неправильный уровень синего цвета фона в формате r,g,b!';}
	}
	if (!preg_match ('/^rgb$|^rrggbb$/', $v_txtcolor)) {$error[14] = 'Неправильный формат цвета текста!';}
	if ($v_txtcolor == 'rrggbb') {
		if (strlen($txtcolor_rrggbb) != 6) {$error[15] = 'Неправильный  цвет текста в формате #rrggbb!';}
		if (preg_match ('/[^0-9a-fA-F]/', $txtcolor_rrggbb)) {$error[15] = 'Неправильный  цвет текста в формате #rrggbb!';}
	}
	if ($v_txtcolor == 'rgb') {
		if (strlen ($txtcolor_r) > 3) {$error[16] = 'Неправильный уровень красного цвета текста в формате r,g,b!';}
		if (preg_match ('/[^0-9]/', $txtcolor_r)) {$error[16] = 'Неправильный уровень красного цвета текста в формате r,g,b!';}
		
		if (strlen ($txtcolor_g) > 3) {$error[17] = 'Неправильный уровень зеленого цвета текста в формате r,g,b!';}
		if (preg_match ('/[^0-9]/', $txtcolor_g)) {$error[17] = 'Неправильный уровень зеленого цвета текста в формате r,g,b!';}
		
		if (strlen ($txtcolor_b) > 3) {$error[18] = 'Неправильный уровень синего цвета текста в формате r,g,b!';}
		if (preg_match ('/[^0-9]/', $txtcolor_b)) {$error[18] = 'Неправильный уровень синего цвета текста в формате r,g,b!';}
	}
	if (strlen ($font) > 60) {$error[19] = 'Неправильный выбор шрифта!';}
	if (!preg_match ('/^gif$|^jpg$|^png$|^wbmp$/', $format)) {$error[20] = 'Неправильный выбор формата изображения!';}
	if ($format == 'png') {
		if (preg_match ('/[^0-9]/', $transparency)) {$error[21] = 'Неправильный уровень прозрачности для PNG!';}
	}
	if ($format == 'jpg') {
		if (preg_match ('/[^0-9]/', $quality)) {$error[22] = 'Неправильный уровень качества для JPG!';}
	}
	if ($format == 'wbmp') {
		if (preg_match ('/[^0-9]/', $threshold)) {$error[23] = 'Неправильный уровень порогового значения для WBMP!';}
	}
	if (!is_file("fonts/$font.ttf")) {$error[19] = 'Такого шрифта не существует!';}
	
	// Если есть ошибки, то выводим их на экран и прекращаем дальнейшие действия
	if ($error) {
		$title = 'Лого-генератор: Ошибка';
		$keywords = 'Лого-генератор: Ошибка';
		$description = 'Лого-генератор: Ошибка';
		include_once 'head.php';
		echo '<div align="center" class="head">ЛОГО-ГЕНЕРАТОР: ОШИБКА</div>'."\n";
		echo '<p>'."\n";
		for ($n = 1; $n < 24; $n++) {
			if ($error[$n]) {
				echo $error[$n];
				echo '<br />'."\n";
			}
		}
		echo '<br />'."\n";
		echo '<a href="index.php';
		if ($url) {echo "?url=".$url;}
		echo '">Назад</a><br />'."\n";
		echo '</p>'."\n";
		include_once 'footer.php';
		exit;
	}

	// Автоудаление старых логотипов и защита от нехватки файловой квоты
	
	$dir = opendir ('img');
	while ($file = readdir ($dir)) {
		if (($file != '.') && ($file != '..') && ($file != 'index.php')) {
			$time_of_file_del = filemtime ('img/'.$file) + $timedel;	# вычисляем абсолютное врем я удаления изображений
			if (time() >= $time_of_file_del)
{
unlink ('img/'.$file);
 }
}
			else {$quantity_files = $quantity_files + 1;}				# подсчитываем количество неудаленных логотипов в данный момент
		}
	// если количество неудаленных логотипов в данный момент больше максимально разрешенного
	if ($quantity_files > $quantity_files_max) {
		$title = 'Лого-генератор: Ошибка';
		$keywords = 'Лого-генератор: Ошибка';
		$description = 'Лого-генератор: Ошибка';
		include_once 'head.php';
		echo '<div align="center" class="head">ЛОГО-ГЕНЕРАТОР: ОШИБКА</div>'."\n";
		echo '<p>'."\n";
		echo 'Извините, превышен лимит создаваемых логотипов. Попробуйте через некоторое время.<br />'."\n";
		echo '<br />'."\n";
		echo '<a href="index.php';
		if ($url) {echo "?url=".$url;}
		echo '">Назад</a><br />'."\n";
		echo '</p>'."\n";
		include_once 'footer.php';
		clearstatcache();
		closedir ($dir);
		exit;
	}
	
	$dir = opendir ('img');
	while ($file = readdir ($dir)) {
		if (($file != '.') && ($file != '..') && ($file != 'index.php')) {
			$total_space = $total_space + filesize('img/'.$file);	# подсчитываем размер всех логотипов в данный момент
		}
	}
	
	$total_space = $total_space / 1024;

	// если размер всех логотипов в данный момент больше максимально разрешенного
	if ($total_space > $total_space_max) {
		$title = 'Лого-генератор: Ошибка';
		$keywords = 'Лого-генератор: Ошибка';
		$description = 'Лого-генератор: Ошибка';
		include_once 'head.php';
		echo '<div align="center" class="head">ЛОГО-ГЕНЕРАТОР: ОШИБКА</div>'."\n";
		echo '<p>'."\n";
		echo 'Извините, превышен лимит создаваемых логотипов. Попробуйте через некоторое время.<br />'."\n";
		echo '<br />'."\n";
		echo '<a href="index.php';
		if ($url) {echo "?url=".$url;}
		echo '">Назад</a><br />'."\n";
		echo '</p>'."\n";
		include_once 'footer.php';
		clearstatcache();
		closedir ($dir);
		exit;
	}
	
	clearstatcache();
	closedir ($dir);

	// Обрезаем длинные строки и регулирум минимальные  максимальные значения
	
	$text = substr($text, 0, $text_symbols_max);
	if ($size_canvas_w < 1) {$size_canvas_w = 1;}
	if ($size_canvas_w > $size_canvas_w_max) {$size_canvas_w = $size_canvas_w_max;}
	if ($size_canvas_h < 1) {$size_canvas_h = 1;}
	if ($size_canvas_h > $size_canvas_h_max) {$size_canvas_h = $size_canvas_h_max;}
	if ($coord_x > $size_canvas_w_max) {$coord_x = $size_canvas_w_max;}
	if ($coord_y > $size_canvas_h_max) {$coord_y = $size_canvas_h_max;}
	if ($size < 1) {$size = 1;}
	if ($size > $size_max) {$size = $size_max;}
	if ($angle >= 360) {$angle = $angle - (360 * floor($angle/360));}
	if ($transparency > 127) {$transparency = 127;}
	if ($quality > 100) {$quality = 100;}
	if ($threshold > 9) {$threshold = 9;}
	if ($bgcolor_r > 255) {$bgcolor_r = 255;}
	if ($bgcolor_g > 255) {$bgcolor_g = 255;}
	if ($bgcolor_b > 255) {$bgcolor_b = 255;}
	if ($txtcolor_r > 255) {$txtcolor_r = 255;}
	if ($txtcolor_g > 255) {$txtcolor_g = 255;}
	if ($txtcolor_b > 255) {$txtcolor_b = 255;}

	// Преобразуем цвета фона и текста из формата #rrggbb в формат r,g,b
	
	// Преобразуем символы цвета фона и текста в формате #rrggbb с прописных в строчные
	if ($v_bgcolor == 'rrggbb') {$bgcolor_rrggbb = strtolower ($bgcolor_rrggbb);}
	if ($v_txtcolor == 'rrggbb') {$txtcolor_rrggbb = strtolower ($txtcolor_rrggbb);}
	
	// Разделяем строки по два символа
	if ($v_bgcolor == 'rrggbb') {
		$bgcolor_r = substr ($bgcolor_rrggbb, 0, 2);
		$bgcolor_g = substr ($bgcolor_rrggbb, 2, 2);
		$bgcolor_b = substr ($bgcolor_rrggbb, 4, 2);
	}
	if ($v_txtcolor == 'rrggbb') {
		$txtcolor_r = substr ($txtcolor_rrggbb, 0, 2);
		$txtcolor_g = substr ($txtcolor_rrggbb, 2, 2);
		$txtcolor_b = substr ($txtcolor_rrggbb, 4, 2);
	}

	// Заменяем символы на цифры
	if ($v_bgcolor == 'rrggbb') {
		$bgcolor_r = hex2rgb ($bgcolor_r);
		$bgcolor_g = hex2rgb ($bgcolor_g);
		$bgcolor_b = hex2rgb ($bgcolor_b);
	}
	if ($v_txtcolor == 'rrggbb') {
		$txtcolor_r = hex2rgb ($txtcolor_r);
		$txtcolor_g = hex2rgb ($txtcolor_g);
		$txtcolor_b = hex2rgb ($txtcolor_b);
	}

	$fontfile = "fonts/".$font.".ttf";							# Путь к выбранному шрифту
	
	// Расчет ширины, высоты и координат надриси
	
	$pos = ImageTTFBbox ($size, $angle, $fontfile, $text);
	
	if ($v_size_canvas == 'din') {
		$min_x = min ($pos[0], $pos[2], $pos[4], $pos[6]);
		$max_x = max ($pos[0], $pos[2], $pos[4], $pos[6]);
		$width = $max_x - $min_x + 1;
		$min_y = min($pos[1], $pos[3], $pos[5], $pos[7]);
		$max_y = max($pos[1], $pos[3], $pos[5], $pos[7]);
		$height = $max_y - $min_y + 1;
		$x = $pos[0] - $min_x;
		$y = $pos[1] - $min_y;
	}
	
	if ($v_size_canvas == 'man') {
		$width = $size_canvas_w;
		$height = $size_canvas_h;
		$x = $coord_x + $pos[0];
		$y = $coord_y - $pos[5];
	}

	// Приступаем к созданию изображения
	
	$im = ImageCreate ($width, $height);															# Создание пустого холста
	$bgcolor = ImageColorAllocateAlpha ($im, $bgcolor_r, $bgcolor_g, $bgcolor_b, $transparency);	# Определение цветов фона
	$textcolor = ImageColorAllocate ($im, $txtcolor_r, $txtcolor_g, $txtcolor_b);					# Определение цветов текста
	ImageTTFtext ($im, $size, $angle, $x, $y, $textcolor, $fontfile, $text);						# Вывод текста на изображение

	// Записываем статистику
	
	// За день
	$file_of_count_day = fopen ('count_day.dat', 'r+');
	flock ($file_of_count_day, LOCK_EX);											# блокируем файл от других
	if (date ('Ymd') > date ('Ymd', filemtime('count_day.dat'))) {					# если сегодня другой день нежели день последней модификации файла
		$gif_day = '0';
		$jpg_day = '0';
		$png_day = '0';
		$wbmp_day = '0';
		if ($format  == 'gif') {$gif_day++;}
		if ($format  == 'jpg') {$jpg_day++;}
		if ($format  == 'png') {$png_day++;}
		if ($format  == 'wbmp') {$wbmp_day++;}
		clearstatcache();
	} else {
		$count = fread ($file_of_count_day, 50);									# считываем 50 первых символов
		list ($gif_day, $jpg_day, $png_day, $wbmp_day) = split ('#', $count);		# разделяем данные
		if ($format  == 'gif') {$gif_day++;}
		if ($format  == 'jpg') {$jpg_day++;}
		if ($format  == 'png') {$png_day++;}
		if ($format  == 'wbmp') {$wbmp_day++;}
	}
	ftruncate ($file_of_count_day, 0);												# очищаем файл
	rewind ($file_of_count_day);													# устанавливаем маркер в начало
	fwrite ($file_of_count_day, $gif_day.'#'.$jpg_day.'#'.$png_day.'#'.$wbmp_day);	# записываем значения
	fclose ($file_of_count_day);
	
	
	//Всего
	$file_of_count_all = fopen ('count_all.dat', 'r+');
	flock ($file_of_count_all, LOCK_EX);											# блокируем файл от других
	$count = fread ($file_of_count_all, 50);										# считываем 50 первых символов
	list ($gif_all, $jpg_all, $png_all, $wbmp_all) = split ('#', $count);			# разделяем данные
	if ($format  == 'gif') {$gif_all++; $name = $gif_all;}
	if ($format  == 'jpg') {$jpg_all++; $name = $jpg_all;}
	if ($format  == 'png') {$png_all++; $name = $png_all;}
	if ($format  == 'wbmp') {$wbmp_all++; $name = $wbmp_all;}
	ftruncate ($file_of_count_all, 0);												# очищаем файл
	rewind ($file_of_count_all);													# устанавливаем маркер в начало
	fwrite ($file_of_count_all, $gif_all.'#'.$jpg_all.'#'.$png_all.'#'.$wbmp_all);	# записываем значения
	fclose ($file_of_count_all);

	// Сохраняем полученное изображение
	
	$file = 'img/'.$name.'.'.$format;								# формируем полный путь к сохраненному файлу
	
	if ($format == "gif") {ImageGIF ($im, $file);}
	if ($format == 'jpg') {ImageJPEG ($im, $file, $quality);}
	if ($format == 'png') {ImagePNG ($im, $file);}
	if ($format == 'wbmp') {Image2WBMP ($im, $file, $threshold);}

	// Удаляем идентификатор
	ImageDestroy($im);

	$title = 'Лого-генератор: Результат';
	$keywords = 'Лого-генератор: Результат';
	$description = 'Лого-генератор: Результат';
	include_once 'head.php';
echo '<div align="center" class="head">ЛОГО-ГЕНЕРАТОР: РЕЗУЛЬТАТ</div>
<p align="center">
<img src="'.$file.'" width="'.$width.'" height="'.$height.'" alt="logo">
</p>
';
echo '<p>Информация:<br />';
	echo 'Текст надписи: '.$text.'<br />'."\n";
	echo 'Разрешение: '.$width.'x'.$height.'<br />'."\n";
	echo 'Шрифт: '.$font.'<br />'."\n";
	echo 'Размер шрифта: '.$size.'<br />'."\n";
	if ($format == 'gif' || $format == 'jpg' || $format == 'png') {
		if ($v_txtcolor == 'rrggbb') {echo 'Цвет текста: #'.$txtcolor_rrggbb.'<br />'."\n";}
		if ($v_txtcolor == 'rgb') {echo 'Цвет текста: rgb('.$txtcolor_r.','.$txtcolor_g.','.$txtcolor_b.')<br />'."\n";}
		if ($v_bgcolor == 'rrggbb') {echo 'Цвет фона: #'.$bgcolor_rrggbb.'<br />'."\n";}
		if ($v_bgcolor == 'rgb') {echo 'Цвет фона: rgb('.$bgcolor_r.','.$bgcolor_g.','.$bgcolor_b.')<br />'."\n";}
	}
	echo 'Угол поворота: '.$angle.'<br />'."\n";
	echo 'Формат: '.strtoupper($format).'<br />'."\n";
	if ($format == 'png') {echo 'Прозрачность фона: '.$transparency.'<br />'."\n";}
	if ($format == 'jpg') {echo 'Качество: '.$quality.'<br />'."\n";}
	if ($format == 'wbmp') {echo 'Пороговое значение: '.$threshold.'<br />'."\n";}
	echo 'Размер: '.formatsize($file).'<br />'."\n";
	echo 'URL: '.$location.$file.'<br />'."\n";
	echo 'Создан в: '.date('H:i:s d.m.Y').'<br />'."\n";
	echo 'Сохранен до: '.date('H:i:s d.m.Y', time() + $timedel).'<br />'."\n";
echo '<br />
<a href="'.$file.'">Скачать лого</a><br />
<a href="font/'.$font.'.ttf.mid">Скачать шрифт</a><br />
<a href="index.php'.(isset($url) ? '?url='.$url : '').'">Назад</a><br />
</p>';
	require_once 'footer.php';
?>