Zapatec.MenuTree = function(el, config, noInit) {
	if (typeof config == "undefined")
		config = {};
	this._el = el;
	this._config = config;
	if (!noInit) this.initTree();
}

Zapatec.MenuTree.windowLoaded = false;
Zapatec.Utils.addEvent(window, 'load', function(){Zapatec.MenuTree.windowLoaded = true});

Zapatec.MenuTree.prototype.initTree = function() {
    var el = this._el;
    var config = this._config;
    function param_default(name, value) {
    	if (typeof config[name] == "undefined") config[name] = value;
	};
	param_default('d_profile', false);
	param_default('hiliteSelectedNode', true);
	param_default('compact', false);
	param_default('dynamic', false);
	param_default('initLevel', false);
	if (config.dynamic)
		config.initLevel = 0;
	this.config = config;
	if (this.config.d_profile) {
		var T1 = new Date().getTime();
		profile = {
			items : 0,
			trees : 0,
			icons : 0
		};
	}
	if (typeof el == "string")
		el = document.getElementById(el);
	this.list = el;
	this.items = {};
	this.trees = {};
	this.selectedItem = null;

	this.id=null;
	if (el)
		this.id = el.id || Zapatec.Utils.generateID("tree");
	else
		alert("Can not find Menu id=\"" + this._el + "\"")
	var top = this.top_parent = Zapatec.Utils.createElement("div");
	top.style.display = 'none'; // Initially menu is hidden and will be shown on triggerEvent
	top.__zp_menu = Zapatec.Utils.createElement("div", top);
	top.__zp_menu.className = 'zpMenu';
	top.className = "zpMenuContainer zpMenu-top";
	if (this.config.vertical)
		Zapatec.Utils.addClass(top, "zpMenu-vertical-mode");
	else
		Zapatec.Utils.addClass(top, "zpMenu-horizontal-mode");
	this.createTree(el, top, 0);
	if (el) {
		if (this.config.theme != '') {
			var theme = Zapatec.Utils.createElement("div");
			theme.className = 'zpMenu-' + this.config.theme;
			theme.appendChild(top);
			el.parentNode.insertBefore(theme, el);
		} else {
			el.parentNode.insertBefore(top, el);
		}
		el.parentNode.removeChild(el);
	}
	Zapatec.MenuTree.all[this.id] = this;
	if (this.selectedItem)
		this.sync(this.selectedItem.__zp_item);
	if (this.config.d_profile) {
		alert("Generated in " + (new Date().getTime() - T1) + " milliseconds\n" +
		      profile.items + " total tree items\n" +
		      profile.trees + " total (sub)trees\n" +
		      profile.icons + " total icons");
	}

	this.path = Zapatec.Utils.getCookie(this.config.pathCookie);
	if (this.path) {
		Zapatec.Utils.writeCookie(this.config.pathCookie, '');
	}

	if (!this.config.triggerEvent) {
		if (Zapatec.MenuTree.windowLoaded) {
			this.showMenu();
		} else {
			var self = this;
			Zapatec.Utils.addEvent(window, 'load', function(){self.showMenu()});
		}
	}
};

Zapatec.MenuTree.all = {};

Zapatec.MenuTree.prototype.is_hr_tag= function(item) {
	return (item.tagName.toLowerCase() == 'hr');
};

Zapatec.MenuTree.prototype.is_hr_class= function(item) {
	return (/zpMenu-item-hr/i.test(item.className));
};

Zapatec.MenuTree.prototype.createTree = function(list, parent, level) {
	if (this.config.d_profile)
		++profile.trees;
	var id;
	var intItem=1, bFirst=true;

	if (list) id=list.id;
	if (!id)  id=Zapatec.Utils.generateID("tree.sub");
	var
		self = this;
	function _makeIt() {
		self.creating_now = true;
		var
			last_li = null,
			next_li, 
			i = (list ? list.firstChild : null),
			items = parent.__zp_items = [];
		self.trees[id] = parent;
		parent.__zp_level = level;
		parent.__zp_treeid = id;
		parent.__zp_keymap = {};
		var strOddEven;
		while (i) {
			if (last_li)
				last_li.className += " zpMenu-lines-c";
			if (i.nodeType != 1)
				i = i.nextSibling;
			else {
				next_li = Zapatec.Utils.getNextSibling(i, 'li');
				if (i.tagName.toLowerCase() == 'li') {
					last_li = self.createItem(i, parent, next_li, level, intItem);
					if (last_li) {
						if (!self.is_hr_class(last_li)) 
						{
							strOddEven="zpMenu-item-" + (intItem % 2==1 ? "odd" : "even");
							Zapatec.Utils.addClass(last_li, strOddEven)
							intItem++
						}

						if (bFirst)
						{
							bFirst=false;
							Zapatec.Utils.addClass(last_li, "zpMenu-item-first");
						}
						items[items.length] = last_li.__zp_item;
					}
				}
				i = next_li;
			}
		}

		if (last_li) Zapatec.Utils.addClass(last_li, "zpMenu-item-last");

		i = parent.firstChild;
		if (i && !level) {
			i.className = i.className.replace(/ zpMenu-lines-./g, "");
			i.className += (i === last_li) ? " zpMenu-lines-s" : " zpMenu-lines-t";
		}
		if (last_li && (level || last_li !=  i)) {
			last_li.className = last_li.className.replace(/ zpMenu-lines-./g, "");
			last_li.className += " zpMenu-lines-b";
		}
		self.creating_now = false;
	};
	if (this.config.dynamic && level > 0)
		this.trees[id] = _makeIt;
	else
		_makeIt();
	return id;
};

Zapatec.MenuTree.tabIndex = 1000;

Zapatec.MenuTree.prototype.createItem = function(li, parent, next_li, level, intItem) {
	if (this.config.d_profile)
		++profile.items;
	if (!li.firstChild)
		return;
	var
		id = li.id || Zapatec.Utils.generateID("tree.item"),
		item = this.items[id] = Zapatec.Utils.createElement("div", parent.__zp_menu),
		t = Zapatec.Utils.createElement("table", item),
		tb = Zapatec.Utils.createElement("tbody", t),
		tr = Zapatec.Utils.createElement("tr", tb),
		td = Zapatec.Utils.createElement("td", tr),
		has_icon = false;

	if (!level) {
		td.style.whiteSpace = 'nowrap';
	}

	t.className = "zpMenu-table";
	t.cellSpacing = 0;
	t.cellPadding = 0;
	td.className = "zpMenu-label"

	var title = li.getAttribute('title');
	if (title) {
		td.setAttribute('title', title);
	}

	item.className = "zpMenu-item" + (li.className ? ' ' + li.className : '');
	Zapatec.Utils.addClass(item, "zpMenu-level-" + (level+1));
	item.__zp_item = id;
	item.__zp_tree = this.id;
	item.__zp_parent = parent.__zp_treeid;
	item.onmouseover = Zapatec.Menu.onItemMouseOver;
	item.onmouseout = Zapatec.Menu.onItemMouseOut;
	item.onclick = Zapatec.Menu.onItemClick;
	Zapatec.Utils.addClass(item, "zpMenu-item-" + (intItem % 2==1 ? "odd" : "even"));

	var fc, subtree = false, accessKey = null;

	var getAccessKey = function(node) {
		var key = null;
		if (node.nodeType == 1) {
			if (key = node.getAttribute('accesskey')) {
				node.removeAttribute('accesskey', false);
				if (/^[a-z0-9]$/i.test(key)) {
					return key;
				} else {
					key = null;
				}
			}
			var childNodes = node.childNodes;
			for (var i = 0; i < childNodes.length; i++) {
				if (key = getAccessKey(childNodes[i])) {
					break;
				}
			}
		} else if (node.nodeType == 3) {
			var label = node.data.replace(/(^\s+|\s+$)/g, '');
			if (/_([a-z0-9])/i.test(label)) {
				label = label.replace(/_([a-z0-9])/i, '<span style="text-decoration:underline">$1</span>');
				key = RegExp.$1;
				var span = Zapatec.Utils.createElement("span");
				span.innerHTML = label;
				var parent = node.parentNode;
				parent.insertBefore(span, node);
				parent.removeChild(node);
			}
		}
		return key;
	};

	while (fc = li.firstChild) {
		if (fc.nodeType == 1 && /^[ou]l$/i.test(fc.tagName)) {
			// Subtree
			if (!subtree) {
				this.item_addIcon(item, null);
				var np = Zapatec.Utils.createElement("div", parent);
				np.style.position = 'absolute';
				if (!this.config.triggerEvent) {
					np.style.left = '-9999px';
					np.style.top = '-9999px';
				}
				if (this.config.dropShadow) {
					var ds = np.__zp_dropshadow = Zapatec.Utils.createElement('div');
					parent.insertBefore(ds, np);
					ds.style.position = 'absolute';
					if (!this.config.triggerEvent) {
						ds.style.left = '-9999px';
						ds.style.top = '-9999px';
					}
					ds.style.backgroundColor = '#000';
					if (window.opera) {
						ds.style.backgroundColor = '#666';
					} else {
						ds.style.filter = 'alpha(opacity=' + this._config.dropShadow + ')';
					}
					ds.style.opacity = this.config.dropShadow / 100;
				}
				np.__zp_item = id;
				np.__zp_menu = Zapatec.Utils.createElement("div", np);
				np.__zp_menu.className = 'zpMenu' + (fc.className ? ' ' + fc.className : '');
				np.className = 'zpMenuContainer';
				np.__zp_menu.onmouseover = Zapatec.Menu.onItemMouseOver;
				np.__zp_menu.onmouseout = Zapatec.Menu.onItemMouseOut;
				if (next_li) {
					np.__zp_menu.className += " zpMenu-lined";
				}
				item.__zp_subtree = this.createTree(fc, np, level+1);
				if ((this.config.initLevel !=  false && this.config.initLevel <= level) ||
				    (this.config.compact && !/(^|\s)expanded(\s|$)/i.test(li.className))
				    || /(^|\s)collapsed(\s|$)/i.test(li.className)) {
					item.className += " zpMenu-item-collapsed";
					this.toggleItem(id);
				} else {
					item.className += " zpMenu-item-expanded";
				}
				if (/(^|\s)selected(\s|$)/i.test(li.className)) {
					this.selectedItem = item;
				}
				subtree = true;
			}
			li.removeChild(fc);
		} else {
			li.removeChild(fc);
			if (fc.nodeType == 3) {
				var label = fc.data.replace(/(^\s+|\s+$)/g, '');
				if (label) {
					if (!accessKey) {
						label = label.replace(/_([a-z0-9])/i, '<span style="text-decoration:underline">$1</span>');
						accessKey = RegExp.$1;
					}
					var span = Zapatec.Utils.createElement("span", td);
					span.innerHTML = label;
					if (title) span.setAttribute('title', title);
				}
			} else if (fc.tagName) {
				if (fc.tagName.toLowerCase() == 'img') {
					this.item_addIcon(item, fc);
					has_icon = true;
				} else {
					if (this._menuMode && (fc.tagName.toLowerCase() == 'hr')) {
						Zapatec.Utils.addClass(item, "zpMenu-item-hr");
					} else if (fc.tagName.toLowerCase() == 'input' && fc.getAttribute('type') == 'checkbox') {
						fc.onmousedown = function(ev){
							if (this.checked) {
								this.checked = false;
							} else {
								this.checked = true;
							}
							return Zapatec.Utils.stopEvent(ev);
						};
					} else if (fc.tagName.toLowerCase() == 'input' && fc.getAttribute('type') == 'radio') {
						fc.onmousedown = function(ev){
							this.checked = true;
							return Zapatec.Utils.stopEvent(ev);
						};
					} else if (fc.tagName.toLowerCase() == 'a') {
						if (!accessKey) {
							accessKey = getAccessKey(fc);
						}
						fc.tabIndex = ++Zapatec.MenuTree.tabIndex;
						fc.onfocus = Zapatec.Menu.onItemMouseOver;
						fc.onblur = Zapatec.Menu.onItemMouseOut;
					}
					td.appendChild(fc);
					if (title && !fc.getAttribute('title')) fc.setAttribute('title', title);
				}
			}
		}
	}

	if (accessKey) {
		accessKey = accessKey.toUpperCase().charCodeAt(0);
		parent.__zp_keymap[accessKey] = item;
	}

	if (!has_icon && !/zpMenu-item-hr/i.test(item.className))
		if (this.config.defaultIcons)
			this.item_addDefaultIcon(item, this.config.defaultIcons);
		else
			this.item_addDefaultIcon(item, "zpMenu-noicon");

	return item;
};

Zapatec.MenuTree.prototype.item_addDefaultIcon = function(item, className) {
	if (!className)
		return;
	var last_td = item.firstChild.firstChild.firstChild.lastChild, td;
	var td = Zapatec.Utils.createElement("td");
	td.className = "tgb icon " + className;

	last_td.parentNode.insertBefore(td, last_td);
};

Zapatec.MenuTree.prototype.item_addIcon = function(item, img) {
	if (this.config.d_profile)
		++profile.icons;
	var last_td = item.firstChild.firstChild.firstChild, td;
	last_td = img ? last_td.lastChild : last_td.firstChild;
	if (!img || !item.__zp_icon) {
		td = Zapatec.Utils.createElement("td");
		td.className = "tgb " + (img ? "icon" : "minus");
		last_td.parentNode.insertBefore(td, last_td);
	} else {
		td = item.__zp_icon;
		img.style.display = "none";
	}
	if (!img) {
		td.innerHTML = "&nbsp;";
		item.className += " zpMenu-item-more";
		item.__zp_state = true;
		item.__zp_expand = td;
	} else {
		td.appendChild(img);
		item.__zp_icon = td;
	}
};

Zapatec.MenuTree.prototype.itemClicked = function(item_id) {
	this.selectedItem = this.toggleItem(item_id);
	if (this.config.hiliteSelectedNode && this.selectedItem) {
		Zapatec.Menu.selectItem(this.selectedItem);
	}
	this.onItemSelect(item_id);
};

Zapatec.MenuTree.prototype.toggleItem = function(item_id, state) {
	if (item_id) {
		if (this.config.hiliteSelectedNode && this.selectedItem) {
			Zapatec.Menu.unselectItem(this.selectedItem);
		}
		var item = this.items[item_id];
		if (typeof state == "undefined")
			state = !item.__zp_state;
		if (state != item.__zp_state) {
			var subtree = this._getTree(item.__zp_subtree, this.creating_now);
			if (subtree) {
				if (state) {
					for (var i = 0; i < subtree.__zp_items.length; i++) {
						var subItemID = subtree.__zp_items[i];
						Zapatec.Menu.unselectItem(this.items[subItemID]);
						if (subtree.__zp_activeitem == subItemID) subtree.__zp_activeitem = '';
					}
				} else {
					for (var i = 0; i < subtree.__zp_items.length; i++) {
						var subItemID = subtree.__zp_items[i];
						this.toggleItem(subItemID, state);
						Zapatec.Menu.unselectItem(this.items[subItemID]);
						if (subtree.__zp_activeitem == subItemID) subtree.__zp_activeitem = '';
					}
				}
				this.treeSetDisplay(subtree, state);
				Zapatec.Utils.removeClass(item, "zpMenu-item-expanded");
				Zapatec.Utils.removeClass(item, "zpMenu-item-collapsed");
				Zapatec.Utils.addClass(item, state ? "zpMenu-item-expanded" : "zpMenu-item-collapsed");
			}
			var img = item.__zp_expand;
			if (img)
				img.className = "tgb " + (state ? "minus" : "plus");
			item.__zp_state = state;
			img = item.__zp_icon;
			if (img) {
				img.firstChild.style.display = "none";
				img.appendChild(img.firstChild);
				img.firstChild.style.display = "block";
			}
			if (this.config.compact && state) {
				var hideItems = this._getTree(item.__zp_parent).__zp_items;
				for (var i = hideItems.length; --i >= 0;) {
					if (hideItems[i] != item_id && hideItems[i].__zp_state) {
						this.toggleItem(hideItems[i], false);
					}
				}
			}
		}
		return item;
	}
	return null;
};

Zapatec.MenuTree.prototype.collapseAll = function() {
	for (var i in this.trees)
		this.toggleItem(this._getTree(i).__zp_item, false);
};

Zapatec.MenuTree.prototype.expandAll = function() {
	for (var i in this.trees)
		this.toggleItem(this._getTree(i).__zp_item, true);
};

Zapatec.MenuTree.prototype.toggleAll = function() {
	for (var i in this.trees)
		this.toggleItem(this._getTree(i).__zp_item);
};

Zapatec.MenuTree.prototype.sync = function(item_id) {
	var item = this.items[item_id];
	if (item) {
		this.collapseAll();
		this.selectedItem = item;
		var path = [];
		while (item.__zp_parent) {
			path[path.length] = item;
			var parentItem = this._getTree(item.__zp_parent);
			if (parentItem.__zp_item) {
				item = this.items[parentItem.__zp_item];
			} else {
				break;
			}
		}
		for (var ii = path.length; --ii >= 0;) {
			var item = path[ii];
			var item_id = item.__zp_item;
			this.itemShow(item_id);
			var menu = this._getTree(item.__zp_parent);
			menu.__zp_activeitem = item_id;
			Zapatec.Menu.selectItem(item);
		}
	}
};

Zapatec.MenuTree.prototype.highlightPath = function(item_id) {
	var item = this.items[item_id];
	if (item) {
		var a = [];
		while (item.__zp_parent) {
			a[a.length] = item;
			var pt = this._getTree(item.__zp_parent);
			if (pt.__zp_item)
				item = this.items[pt.__zp_item];
			else
				break;
		}
		for (var i = a.length; --i >= 0;) {
			Zapatec.Utils.addClass(a[i], 'zpMenuPath');
		}
	}
};

Zapatec.MenuTree.prototype.destroy = function() {
	var p = this.top_parent;
	p.parentNode.removeChild(p);
};

Zapatec.MenuTree.prototype._getTree = function(tree_id, dont_call) {
	var tree = this.trees[tree_id];
	if (typeof tree == "function") {
		if (dont_call)
			tree = null;
		else {
			tree();
			tree = this.trees[tree_id];
		}
	}
	return tree;
};

Zapatec.MenuTree.prototype.onItemSelect = function() {};

Zapatec.MenuTree.onItemToggle = function() {
	var item = this;
	var body = document.body;
	while (item && item !=  body && !/zpMenu-item/.test(item.className))
		item = item.parentNode;
	Zapatec.MenuTree.all[item.__zp_tree].itemClicked(item.__zp_item);
};

Zapatec.Menu = function(el, config_user) {
	if (arguments.length > 0) {
		this.init(el, config_user);
	}
};

Zapatec.Menu.prototype = new Zapatec.MenuTree('', null, true);

Zapatec.Menu.prototype.init = function(el, config_user) {
	this._el = el;
	this._config={};
	this.setOption(this._config, 'showDelay', 0);
	this.setOption(this._config, 'hideDelay', 500);
	this.setOption(this._config, 'onClick', false);
	this.setOption(this._config, 'vertical', false);
	this.setOption(this._config, 'scrollWithWindow', false);
	this.setOption(this._config, 'dropShadow', 0);
	this.setOption(this._config, 'drag', false);
	this.setOption(this._config, 'slide', false);
	this.setOption(this._config, 'glide', false);
	this.setOption(this._config, 'fade', false);
	this.setOption(this._config, 'wipe', false);
	this.setOption(this._config, 'unfurl', false);
	this.setOption(this._config, 'animSpeed', 10);
	this.setOption(this._config, 'compact', true);
	this.setOption(this._config, 'initLevel', 0);
	this.setOption(this._config, 'defaultIcons', null);
	this.setOption(this._config, 'zIndex', 0);
	this.setOption(this._config, 'theme', '');
	this.setOption(this._config, 'rememberPath', false);
	this.setOption(this._config, 'pathCookie', '__zp_item');
	this.setOption(this._config, 'triggerEvent', null);
	this.setOption(this._config, 'triggerKey', null);
	this.setOption(this._config, 'triggerObject', null);
	this.setOption(this._config, 'top', null);
	this.setOption(this._config, 'right', null);
	this.setOption(this._config, 'bottom', null);
	this.setOption(this._config, 'left', null);

	if (typeof config_user != "undefined") {
		for (var i in config_user) {
			if (typeof this._config[i] == "undefined") {
				alert("Error:Menu " + this._el + " has invalid parameter --" + i + ":" + config_user[i]);
			} else {
			this.setOption(this._config, i, config_user[i]);
			}
		}
	}
	if (this._config.theme != '') {
		var link = document.createElement('link');
		link.setAttribute('rel', 'stylesheet');
		link.setAttribute('type', 'text/css');
		link.setAttribute('href', '../themes/' + this._config.theme + '_2menus.css');
		document.getElementsByTagName('head')[0].appendChild(link);
	}

	this.animations = [];
	this._menuMode = true;
	this.initTree();
	this.openMenus = [];
	this.clickDone = false;

	if (this.config.triggerEvent) {
		var triggerEvent = this.config.triggerEvent;
		var triggerKey = this.config.triggerKey;
		var triggerObject = window.document;
		if (this.config.triggerObject) {
			if (typeof this.config.triggerObject == 'string') {
				var triggerObjectElement = window.document.getElementById(this.config.triggerObject);
				if (triggerObjectElement) {
					triggerObject = triggerObjectElement;
				}
			} else {
				triggerObject = this.config.triggerObject;
			}
		}
		var self = this;
		if (triggerEvent == 'mousedown' || triggerEvent == 'mouseup' || triggerEvent == 'click') {
			Zapatec.Utils.addEvent(triggerObject, 'mouseup',
				function(ev) {
					ev || (ev = window.event);
					var posX = ev.pageX || ev.clientX + window.document.body.scrollLeft || 0;
					var posY = ev.pageY || ev.clientY + window.document.body.scrollTop || 0;
					var button;
					if (ev.button) {
						button = ev.button;
					}	else {
						button = ev.which;
					}
					if (window.opera) {
						if (button == 1 && self.top_parent.style.display == 'none') {
							setTimeout(function() {self.popupMenu(posX, posY)}, 100);
							return Zapatec.Utils.stopEvent(ev);
						}
					} else {
						if (triggerKey == 'both' || (triggerKey == 'left' && button == 1)
						 || ((!triggerKey || triggerKey == 'right') && button > 1)) {
							setTimeout(function() {self.popupMenu(posX, posY)}, 100);
							return Zapatec.Utils.stopEvent(ev);
						}
					}
				}
			);
			window.document.oncontextmenu = new Function("return false");
		} else if (triggerEvent == 'keydown' || triggerEvent == 'keyup' || triggerEvent == 'keypress') {
			Zapatec.Utils.addEvent(triggerObject, 'keydown',
				function(ev) {
					ev || (ev = window.event);
					if (ev.keyCode == triggerKey) {
						self.popupMenu();
						return Zapatec.Utils.stopEvent(ev);
					}
				}
			);
		}
		Zapatec.Utils.addEvent(window.document, 'mouseup',
			function(ev) {
				setTimeout(function() {self.hideMenu()}, 50);
				return Zapatec.Utils.stopEvent(ev);
			}
		);
		Zapatec.Utils.addEvent(this.top_parent, 'mouseup',
			function(ev) {
				return Zapatec.Utils.stopEvent(ev);
			}
		);
		Zapatec.Utils.addEvent(window.document, 'keypress',
			function(ev) {
				ev || (ev = window.event);
				if (ev.keyCode == 27) {
					for (var i = 0; i < Zapatec.Menu.selectedItemsStack.length; i++) {
						if (Zapatec.MenuTree.all[Zapatec.Menu.selectedItemsStack[i].__zp_tree] == self) {
							return;
						}
					}
					self.hideMenu();
				}
			}
		);
	}	else {
		if (this.config.scrollWithWindow) {
			Zapatec.ScrollWithWindow.register(this.trees[this._el]);
		}
		if (this.config.drag) {
			var self = this;
			self.dragging = false;
			Zapatec.Utils.addEvent(window.document, "mousedown",
				function(ev) { return Zapatec.Menu.dragStart(ev, self) });
			Zapatec.Utils.addEvent(window.document, "mousemove",
				function(ev) { return Zapatec.Menu.dragMove(ev, self) });
			Zapatec.Utils.addEvent(window.document, "mouseup",
				function(ev) { return Zapatec.Menu.dragEnd(ev, self) });
		}
	}

	if (this._config.fade)
		this.addAnimation('fade');

	if (this._config.slide)
		this.addAnimation('slide');
	else if (this._config.glide)
		this.addAnimation('glide');
	else if (this._config.wipe)
		this.addAnimation('wipe');
	else if (this._config.unfurl)
		this.addAnimation('unfurl');
};

Zapatec.Menu.MOUSEOUT = 0;
Zapatec.Menu.MOUSEOVER = 1;
Zapatec.Menu.CLICK = 2;

Zapatec.Menu.prototype.setOption = function(config, name, val) {
   config[name] = val;
};

Zapatec.Menu.animations = {};

Zapatec.Menu.animations.fade = function(ref, counter) {
	var f = ref.filters, done = (counter==100);
	if (f) {
		if (!done && ref.style.filter.indexOf("alpha") == -1) {
			ref.style.filter += ' alpha(opacity=' + counter + ')';
		}
		else if (f.length && f.alpha) with (f.alpha) {
			if (done) enabled = false;
			else { opacity = counter; enabled=true }
		}
	}
	else {
		ref.style.opacity = ref.style.MozOpacity = counter/100.1;
	}
};

Zapatec.Menu.animations.slide = function(ref, counter) {
	var cP = Math.pow(Math.sin(Math.PI*counter/200),0.75);
	var noClip = ((window.opera || navigator.userAgent.indexOf('KHTML') > -1) ?
		'' : 'rect(auto, auto, auto, auto)');
	if (typeof ref.__zp_origmargintop == 'undefined') {
		ref.__zp_origmargintop = ref.style.marginTop;
	}
	ref.style.marginTop = (counter==100) ?
		ref.__zp_origmargintop : '-' + (ref.offsetHeight*(1-cP)) + 'px';
	ref.style.clip = (counter==100) ? noClip :
		'rect(' + (ref.offsetHeight*(1-cP)) + ', ' + ref.offsetWidth +
		'px, ' + ref.offsetHeight + 'px, 0)';
};

Zapatec.Menu.animations.glide = function(ref, counter) {
	var cP = Math.pow(Math.sin(Math.PI*counter/200),0.75);
	var noClip = ((window.opera || navigator.userAgent.indexOf('KHTML') > -1) ?
		'' : 'rect(auto, auto, auto, auto)');
	ref.style.clip = (counter==100) ? noClip :
		'rect(0, ' + ref.offsetWidth + 'px, ' + (ref.offsetHeight*cP) + 'px, 0)';
};

Zapatec.Menu.animations.wipe = function(ref, counter) {
	var noClip = ((window.opera || navigator.userAgent.indexOf('KHTML') > -1) ?
		'' : 'rect(auto, auto, auto, auto)');
	ref.style.clip = (counter==100) ? noClip :
		'rect(0, ' + (ref.offsetWidth*(counter/100)) + 'px, ' +
		(ref.offsetHeight*(counter/100)) + 'px, 0)';
};

Zapatec.Menu.animations.unfurl = function(ref, counter) {
	var noClip = ((window.opera || navigator.userAgent.indexOf('KHTML') > -1) ?
		'' : 'rect(auto, auto, auto, auto)');
	if (counter <= 50) {
		ref.style.clip = 'rect(0, ' + (ref.offsetWidth*(counter/50)) +
			'px, 10px, 0)';
	}
	else if (counter < 100) {
		ref.style.clip =  'rect(0, ' + ref.offsetWidth + 'px, ' +
			(ref.offsetHeight*((counter-50)/50)) + 'px, 0)';

	}
	else {
		ref.style.clip = noClip;
	}
};

Zapatec.Menu.prototype.addAnimation = function(animation) {
 this.animations[this.animations.length] = Zapatec.Menu.animations[animation];
};

Zapatec.Menu.prototype.treeSetDisplay = function(menu, show) {
	if (!menu.__zp_initialised) {
		menu.style.visibility = 'hidden';
		if (menu.__zp_dropshadow) {
			menu.__zp_dropshadow.style.visibility = 'hidden';
		}
		menu.__zp_initialised = true;
		return;
	}

	var treeId = menu.__zp_tree || menu.__zp_menu.firstChild.__zp_tree;
	var tree;
	if (treeId) {
		tree = Zapatec.MenuTree.all[treeId];
	}
	if (!tree) {
		return;
	}
	if (tree.animations.length == 0) {
		if (show) {
			menu.style.visibility = 'inherit';
			if (menu.__zp_dropshadow) {
				menu.__zp_dropshadow.style.visibility = 'inherit';
			}
		} else {
			menu.style.visibility = 'hidden';
			if (menu.__zp_dropshadow) {
				menu.__zp_dropshadow.style.visibility = 'hidden';
			}
		}
		return;
	}

	menu.__zp_anim_timer |= 0;
	clearTimeout(menu.__zp_anim_timer);
	menu.__zp_anim_counter |= 0;

	if (show && !menu.__zp_anim_counter) {
		menu.style.visibility = 'inherit';
		if (menu.__zp_dropshadow) {
			menu.__zp_dropshadow.style.visibility = 'inherit';
		}
	}

	for (var ii = 0; ii < tree.animations.length; ii++) {
		tree.animations[ii](menu, menu.__zp_anim_counter);
		if (menu.__zp_dropshadow
		 && tree.animations[ii] != Zapatec.Menu.animations.fade) {
			tree.animations[ii](menu.__zp_dropshadow, menu.__zp_anim_counter);
		}
	}

	if (!(show && menu.__zp_anim_counter == 100)) {
		menu.__zp_anim_counter += tree.config.animSpeed * (show ? 1 : -1);
		if (menu.__zp_anim_counter > 100) {
			menu.__zp_anim_counter = 100;
			menu.__zp_anim_timer = setTimeout(function() {
				tree.treeSetDisplay(menu, show);
			}, 50);
		}	else if (menu.__zp_anim_counter <= 0) {
			menu.__zp_anim_counter = 0;
			menu.style.visibility = 'hidden';
			if (menu.__zp_dropshadow) {
				menu.__zp_dropshadow.style.visibility = 'hidden';
			}
		}	else {
			menu.__zp_anim_timer = setTimeout(function() {
				tree.treeSetDisplay(menu, show);
			}, 50);
		}
	}
};

Zapatec.Menu.onItemMouseOver = function() {
	var item = this, tree = null;
	while (item && item != document.body) {
		var t_id = item.__zp_tree || item.firstChild.__zp_tree;
		if (t_id) tree = Zapatec.MenuTree.all[t_id];
		var itemClassName = item.className;
		if (/zpMenu-item/.test(itemClassName) && !/zpMenu-item-hr/.test(itemClassName)) {
			tree.itemMouseHandler(item.__zp_item, Zapatec.Menu.MOUSEOVER);
		}
		item = tree && item.__zp_treeid ?
			tree.items[item.__zp_item] : item.parentNode;
	}
	return true;
};

Zapatec.Menu.onItemMouseOut = function() {
	var item = this, tree = null;
	while (item && item != document.body) {
		var t_id = item.__zp_tree || item.firstChild.__zp_tree;
		if (t_id) tree = Zapatec.MenuTree.all[t_id];
		var itemClassName = item.className;
		if (
		 /zpMenu-item/.test(itemClassName) && !/zpMenu-item-hr/.test(itemClassName) &&
		 !(/zpMenu-level-1/.test(itemClassName) && !/zpMenu-item-selected/.test(itemClassName))
		) {
			tree.itemMouseHandler(item.__zp_item, Zapatec.Menu.MOUSEOUT);
		}
		item = tree && item.__zp_treeid ?
			tree.items[item.__zp_item] : item.parentNode;
	}
	return false;
};

Zapatec.Menu.onItemClick = function(ev) {
	var item = this;
	if (!/zpMenuDisabled/.test(item.className)) {
		while (item && item != document.body) {
			if (item.nodeName && item.nodeName.toLowerCase() == 'a') {
				return true;
			}
			if (/zpMenu-item/.test(item.className)) {
				var self = Zapatec.MenuTree.all[item.__zp_tree];
				if (self.config.onClick && item.__zp_subtree &&
					(/zpMenu-top/.test(self.trees[item.__zp_parent].className))) {
						self.itemMouseHandler(item.__zp_item, Zapatec.Menu.CLICK);
						return Zapatec.Utils.stopEvent(ev);
				}
				var itemLink = item.getElementsByTagName('a');
				var itemInput = item.getElementsByTagName('input');
				var itemSelect = item.getElementsByTagName('select');
				if (itemLink && itemLink.item(0)
				 && itemLink.item(0).getAttribute('href')
				 && itemLink.item(0).getAttribute('href') != '#'
				 && itemLink.item(0).getAttribute('href') != window.document.location.href + '#'
				 && itemLink.item(0).getAttribute('href') != 'javascript:void(0)') {
					var href = itemLink.item(0).getAttribute('href');
					var target = itemLink.item(0).getAttribute('target');
					if (self.config.rememberPath || self.config.pathCookie != '__zp_item') {
						Zapatec.Utils.writeCookie(self.config.pathCookie, item.__zp_item);
					}
				  try {
				  	if (target) {
							window.open(href, target);
						} else {
							window.location.href = href;
						}
				  } catch(e) {};
					if (self.config.triggerEvent) {
						self.hideMenu();
					}
				} else if (itemInput && itemInput.item(0)) {
					var inp = itemInput.item(0);
					var type = inp.getAttribute('type');
					if (type == 'checkbox') {
						if (inp.checked) {
							inp.checked = false;
						} else {
							inp.checked = true;
						}
					} else if (type == 'radio') {
						inp.checked = true;
					}
				} else if (itemSelect && itemSelect.item(0)) {
					return true;
				} else if (item.__zp_subtree) {
					self.itemMouseHandler(item.__zp_item, Zapatec.Menu.CLICK);
				} else if (self.config.triggerEvent) {
					self.hideMenu();
				}
				return Zapatec.Utils.stopEvent(ev);
			}
			item = item.parentNode;
		}
	}
	return false;
};

Zapatec.Menu.prototype.itemMouseHandler = function(item_id, type) {
	var item = this.items[item_id];
	if (!item) return;
	var menu = this._getTree(item.__zp_parent);

	if (menu && menu.__zp_activeitem != item_id) {
		if (menu.__zp_activeitem) {
			var lastItem = this.items[menu.__zp_activeitem];
			clearTimeout(lastItem.__zp_dimtimer);
			clearTimeout(lastItem.__zp_mousetimer);
			Zapatec.Menu.unselectItem(lastItem);
			if (lastItem.__zp_state) this.toggleItem(lastItem.__zp_item, false);
		}
		menu.__zp_activeitem = item_id;
		Zapatec.Menu.selectItem(item);
	}

	clearTimeout(item.__zp_dimtimer);
	if (type == Zapatec.Menu.MOUSEOUT) {
		item.__zp_dimtimer = setTimeout(function() {
			Zapatec.Menu.unselectItem(item);
			if (menu.__zp_activeitem == item_id) menu.__zp_activeitem = '';
		}, this.config.hideDelay);
	}

	clearTimeout(item.__zp_mousetimer);
	if (this.config.onClick && !this.clickDone) {
		if (/zpMenu-top/.test(this.trees[item.__zp_parent].className) &&
			(type == Zapatec.Menu.MOUSEOVER)) return;
		if (type == Zapatec.Menu.CLICK) this.clickDone = true;
	}

	if (!item.__zp_state && type)
	{
		item.__zp_mousetimer = setTimeout('Zapatec.MenuTree.all["' +
			item.__zp_tree + '"].itemShow("' + item.__zp_item + '")',
			(this.config.showDelay || 1));
	}
	else if (item.__zp_state && !type)
	{
		item.__zp_mousetimer = setTimeout('Zapatec.MenuTree.all["' +
			item.__zp_tree + '"].itemHide("' + item.__zp_item + '")',
			(this.config.hideDelay || 1));
	}
};

Zapatec.Menu.prototype.itemShow = function(item_id) {
	var item = this.items[item_id];
	var subMenu = this._getTree(item.__zp_subtree);
	var parMenu = this._getTree(item.__zp_parent);
	if (subMenu && !/zpMenuDisabled/.test(item.className)) {
		if (!subMenu.offsetHeight) {
			subMenu.style.visibility = 'visible';
		}

		var subMenuBorderLeft, subMenuBorderTop;
		if (typeof subMenu.clientLeft != 'undefined') {
			subMenuBorderLeft = subMenu.clientLeft;
			subMenuBorderTop = subMenu.clientTop;
		} else {
			subMenuBorderLeft = (subMenu.offsetWidth - subMenu.clientWidth) / 2;
			subMenuBorderTop = (subMenu.offsetHeight - subMenu.clientHeight) / 2;
		}

		var fc = subMenu.firstChild;
		var subMenuMarginLeft = fc.offsetLeft;
		var subMenuMarginTop = fc.offsetTop;

		var scrollX = window.pageXOffset || document.body.scrollLeft ||
			document.documentElement.scrollLeft || 0;
		var scrollY = window.pageYOffset || document.body.scrollTop ||
			document.documentElement.scrollTop || 0;
		var winW = document.body.clientWidth ||
			document.documentElement.clientWidth || window.innerWidth || 0;
		var winH = document.body.clientHeight ||
			document.documentElement.clientHeight || window.innerHeight || 0;

		if (!subMenu.style.width || !subMenu.style.height) {
			var maxHeight = winH - 7;
			if (subMenu.offsetHeight > maxHeight) {
				fc.__zp_first = fc.firstChild;
				fc.__zp_last = fc.lastChild;
				var up = Zapatec.Utils.createElement("div");
				up.__zp_tree = fc.firstChild.__zp_tree;
				up.className = 'zpMenuScrollUpInactive';
				up.__zp_mouseover = false;
				up.__zp_timer = null;
				var moveUp = function() {
					var container = up.parentNode;
					var containerHeight = container.offsetHeight;
					var containerMarginTop = container.offsetTop;
					var subMenu = container.parentNode;
					var subMenuHeight = subMenu.clientHeight;
					var upArrow = container.firstChild;
					var downArrow = container.lastChild;
					var downArrowHeight = downArrow.offsetHeight;
					if (container.__zp_first.previousSibling != upArrow) {
						while (containerHeight - downArrowHeight + 10
						 <= subMenuHeight - containerMarginTop * 2
						 && container.__zp_first.previousSibling != upArrow) {
							container.__zp_first = container.__zp_first.previousSibling;
						 	container.__zp_first.style.display = 'block';
							containerHeight = container.offsetHeight;
						}
						while (containerHeight - downArrowHeight + 10
						 > subMenuHeight - containerMarginTop * 2) {
							container.__zp_last.style.display = 'none';
							containerHeight = container.offsetHeight;
							container.__zp_last = container.__zp_last.previousSibling;
						}
						downArrow.style.height =
						 (subMenuHeight - (containerHeight - downArrowHeight)
						 - containerMarginTop * 2) + 'px';
						downArrow.className = 'zpMenuScrollDownActive';
						if (container.__zp_first.previousSibling == upArrow) {
							upArrow.className = 'zpMenuScrollUpInactive';
						}
						if (up.__zp_timer) clearTimeout(up.__zp_timer);
						if (up.__zp_mouseover) {
							up.__zp_timer = setTimeout(moveUp, 50);
						}
					}
					return true;
				};
				up.onmouseover = function() {
					up.__zp_mouseover = true;
					return moveUp();
				}
				up.onmouseout = function() {
					up.__zp_mouseover = false;
					if (up.__zp_timer) {
						clearTimeout(up.__zp_timer);
						up.__zp_timer = null;
					}
				};
				fc.insertBefore(up, fc.firstChild);
				var down = Zapatec.Utils.createElement("div");
				down.__zp_tree = fc.firstChild.__zp_tree;
				down.className = 'zpMenuScrollDownActive';
				down.__zp_mouseover = false;
				down.__zp_timer = null;
				var moveDown = function() {
					var container = down.parentNode;
					var containerHeight = container.offsetHeight;
					var containerMarginTop = container.offsetTop;
					var subMenu = container.parentNode;
					var subMenuHeight = subMenu.clientHeight;
					var upArrow = container.firstChild;
					var downArrow = container.lastChild;
					var downArrowHeight = downArrow.offsetHeight;
					if (container.__zp_last.nextSibling != downArrow) {
						while (containerHeight - downArrowHeight + 10
						 <= subMenuHeight - containerMarginTop * 2
						 && container.__zp_last.nextSibling != downArrow) {
							container.__zp_last = container.__zp_last.nextSibling;
						 	container.__zp_last.style.display = 'block';
							containerHeight = container.offsetHeight;
						}
						while (containerHeight - downArrowHeight + 10
						 > subMenuHeight - containerMarginTop * 2) {
							container.__zp_first.style.display = 'none';
							containerHeight = container.offsetHeight;
							container.__zp_first = container.__zp_first.nextSibling;
						}
						downArrow.style.height =
						 (subMenuHeight - (containerHeight - downArrowHeight)
						 - containerMarginTop * 2) + 'px';
						upArrow.className = 'zpMenuScrollUpActive';
						if (container.__zp_last.nextSibling == downArrow) {
							downArrow.className = 'zpMenuScrollDownInactive';
						}
						if (down.__zp_timer) clearTimeout(down.__zp_timer);
						if (down.__zp_mouseover) {
							down.__zp_timer = setTimeout(moveDown, 50);
						}
					}
					return true;
				};
				down.onmouseover = function() {
					down.__zp_mouseover = true;
					return moveDown();
				}
				down.onmouseout = function() {
					down.__zp_mouseover = false;
					if (down.__zp_timer) {
						clearTimeout(down.__zp_timer);
						down.__zp_timer = null;
					}
				};
				fc.appendChild(down);
				var lc = fc.__zp_last;
				while (subMenu.offsetHeight > maxHeight) {
					lc.style.display = 'none';
					lc = lc.previousSibling;
					fc.__zp_last = lc;
				}
			}
			var width = shadowWidth = fc.offsetWidth;
			if (typeof subMenu.clientLeft != 'undefined') {
				width += subMenuBorderLeft * 2 + subMenuMarginLeft * 2;
				shadowWidth = width;
			} else if (subMenu.__zp_dropshadow) {
				shadowWidth += subMenuBorderLeft * 2 + subMenuMarginLeft * 2;
			}
			var height = shadowHeight = fc.offsetHeight;
			if (typeof subMenu.clientTop != 'undefined') {
				height += subMenuBorderTop * 2 + subMenuMarginTop * 2;
				shadowHeight = height;
			} else if (subMenu.__zp_dropshadow) {
				shadowHeight += subMenuBorderTop * 2 + subMenuMarginTop * 2;
			}
			subMenu.style.width = width + 'px';
			subMenu.style.height = height + 'px';
			if (subMenu.__zp_dropshadow) {
				subMenu.__zp_dropshadow.style.width = shadowWidth + 'px';
				subMenu.__zp_dropshadow.style.height = shadowHeight + 'px';
			}
			fc.style.position = 'absolute';
			fc.style.left = fc.offsetLeft + 'px';
			fc.style.top = fc.offsetTop + 'px';
			fc.style.visibility = 'inherit';
		}

		var newLeft = 0, newTop = 0;
		var menuPos = Zapatec.Utils.getAbsolutePos(parMenu);
		if ((/zpMenu-top/.test(this.trees[item.__zp_parent].className))	&& (!(this.config.vertical))) {
			newLeft = item.offsetLeft;
			newTop = item.offsetHeight;
			if (menuPos.x + newLeft + subMenu.offsetWidth + subMenuMarginLeft + 7 > scrollX + winW) {
				newLeft += item.offsetWidth - subMenu.offsetWidth - subMenuMarginLeft;
				if (subMenu.__zp_dropshadow) newLeft -= 6;
			} else {
				newLeft -= subMenuBorderLeft;
			}
			if (menuPos.y + newTop + subMenu.offsetHeight + subMenuMarginTop + 7 > scrollY + winH) {
				newTop = -subMenu.offsetHeight;
				if (subMenu.__zp_dropshadow) newTop -= 5;
			}
		} else {
			newLeft = item.offsetWidth;
			newTop = item.offsetTop;
			if (menuPos.x + newLeft + subMenu.offsetWidth + subMenuMarginLeft + 7 > scrollX + winW) {
				newLeft = -subMenu.offsetWidth;
				if (subMenu.__zp_dropshadow) newLeft -= 5;
			}
			if (menuPos.y + newTop + subMenu.offsetHeight + subMenuMarginTop + 7 > scrollY + winH) {
				newTop -= subMenu.offsetHeight - item.offsetHeight;
				if (subMenu.__zp_dropshadow) newTop -= 5;
			} else {
				newTop -= subMenuBorderTop;
			}
		}
		if (menuPos.x + newLeft < 0) {
			newLeft = 0 - menuPos.x;
		}
		if (menuPos.y + newTop < 0) {
			newTop = 0 - menuPos.y;
		}
		subMenu.style.left = newLeft + 'px';
		subMenu.style.top = newTop + 'px';
		if (subMenu.__zp_dropshadow) {
			subMenu.__zp_dropshadow.style.left = (newLeft + 5) + 'px';
			subMenu.__zp_dropshadow.style.top = (newTop + 5) + 'px';
		}

		if (Zapatec.is_ie && !Zapatec.is_ie5) {
			if (!subMenu.__zp_wch) {
				subMenu.__zp_wch = Zapatec.Utils.createWCH(subMenu);
			}
			subMenu.__zp_wch.style.zIndex = -1;
			if (this._config.dropShadow) {
				Zapatec.Utils.setupWCH(subMenu.__zp_wch, -subMenuBorderLeft, -subMenuBorderTop,	subMenu.offsetWidth + 6, subMenu.offsetHeight + 5);
			} else {
				Zapatec.Utils.setupWCH(subMenu.__zp_wch, -subMenuBorderLeft, -subMenuBorderTop,	subMenu.offsetWidth, subMenu.offsetHeight);
			}
		}

		this.toggleItem(item_id, true);
	}
};

Zapatec.Menu.prototype.itemHide = function(item_id) {
	var item = this.items[item_id];
	var subMenu = this._getTree(item.__zp_subtree);
	var parMenu = this._getTree(item.__zp_parent);
	if (subMenu) {
		this.toggleItem(item_id, false);
		parMenu.__zp_activeitem = '';
		subMenu.__zp_activeitem = '';
		for (var i in this.items) {
			if (this.items[i].__zp_state) return;
		}
		this.clickDone = false;
	}
};

Zapatec.Menu.dragStart = function (ev, menu) {
	ev || (ev = window.event);
	if (menu.dragging) {
		return true;
	}
	var rootMenu = menu.trees[menu._el];
	if (!(/(absolute|fixed)/).test(rootMenu.style.position)) {
		rootMenu.style.position = 'absolute';
		var pos = Zapatec.Utils.getAbsolutePos(rootMenu);
		rootMenu.style.left = pos.x + 'px';
		rootMenu.style.top = pos.y + 'px';
	}
	var testElm = ev.srcElement || ev.target;
	while (1) {
		if (testElm == rootMenu) break;
		else testElm = testElm.parentNode;
		if (!testElm) return true;
	}
	menu.dragging = true;
	var posX = ev.pageX || ev.clientX + window.document.body.scrollLeft || 0;
	var posY = ev.pageY || ev.clientY + window.document.body.scrollTop || 0;
	var L = parseInt(rootMenu.style.left) || 0;
	var T = parseInt(rootMenu.style.top) || 0;
	menu.xOffs = (posX - L);
	menu.yOffs = (posY - T);
	if (menu.config.scrollWithWindow) {
		Zapatec.ScrollWithWindow.unregister(menu.trees[menu._el]);
	}
};

Zapatec.Menu.dragMove = function (ev, menu) {
	ev || (ev = window.event);
	var rootMenu = menu.trees[menu._el];
	if (!(menu && menu.dragging)) {
		return false;
	}
	var posX = ev.pageX || ev.clientX + window.document.body.scrollLeft || 0;
	var posY = ev.pageY || ev.clientY + window.document.body.scrollTop || 0;
	var st = rootMenu.style, L = posX - menu.xOffs, T = posY - menu.yOffs;
	st.left = L + "px";
	st.top = T + "px";
	return Zapatec.Utils.stopEvent(ev);
};

Zapatec.Menu.dragEnd = function (ev, menu) {
	if (!menu) {
		return false;
	}
	if (menu.dragging) {
		menu.dragging = false;
		var rootMenu = menu.trees[menu._el];
		var st = rootMenu.style, L = parseInt(st.left), T = parseInt(st.top);
		var scrollX = window.pageXOffset || document.body.scrollLeft ||
			document.documentElement.scrollLeft || 0;
		var scrollY = window.pageYOffset || document.body.scrollTop ||
			document.documentElement.scrollTop || 0;
		var winW = document.body.clientWidth ||
			document.documentElement.clientWidth || window.innerWidth || 0;
		var winH = document.body.clientHeight ||
			document.documentElement.clientHeight || window.innerHeight || 0;
		if (L < 0) {
			st.left = '0px';
		} else if (L + rootMenu.offsetWidth > scrollX + winW) {
			st.left = scrollX + winW - rootMenu.offsetWidth + 'px';
		}
		if (T < 0) {
			st.top = '0px';
		} else if (T + rootMenu.offsetHeight > scrollY + winH) {
			st.top = scrollY + winH - rootMenu.offsetHeight + 'px';
		}
		if (menu.config.scrollWithWindow) {
			Zapatec.ScrollWithWindow.register(rootMenu);
		}
	}
};

Zapatec.Menu.prototype.itemDisable = function(item_id) {
	var item = this.items[item_id];
	if (item) {
		Zapatec.Utils.addClass(item, "zpMenuDisabled");
	}
};

Zapatec.Menu.prototype.itemEnable = function(item_id) {
	var item = this.items[item_id];
	if (item) {
		Zapatec.Utils.removeClass(item, "zpMenuDisabled");
	}
};

Zapatec.Menu.prototype.popupMenu = function() {
	for (var menuId in Zapatec.MenuTree.all) {
		var menu = Zapatec.MenuTree.all[menuId];
		if (menu.config.triggerEvent) {
			menu.hideMenu();
		}
	}
	if (arguments.length > 1) {
		this.showMenu(arguments[0], arguments[1]);
	} else {
		this.showMenu();
	}
};

Zapatec.Menu.prototype.showMenu = function() {
	var top = this.top_parent;
	var menu = top.__zp_menu;

	if (arguments.length > 1) {
		top.style.position = 'absolute';
		top.style.left = arguments[0] + 'px';
		top.style.top = arguments[1] + 'px';
	}

	top.style.display = 'block';

	if (!menu.style.width) {
		if (menu.childNodes) {
			var menuWidth = 0;
			var itemMargin = 0;
			for (var i = 0; i < menu.childNodes.length; i++) {
				var item = menu.childNodes[i];
				if (i == 0) {
					itemMargin = item.offsetLeft;
				}
				if (this.config.vertical) {
					if (item.offsetWidth > menuWidth) {
						menuWidth = item.offsetWidth + itemMargin;
					}
				} else {
					menuWidth += item.offsetWidth + itemMargin;
				}
			}
			if (typeof menu.clientLeft != 'undefined') {
				menuWidth += menu.clientLeft * 2;
			} else {
				menuWidth += menu.offsetWidth - menu.clientWidth;
			}
			if (menu.clientWidth > menuWidth) {
				menu.style.width = menu.clientWidth + 'px';
			} else {
				menu.style.width = menuWidth + 'px';
			}
		}
	}

	if (arguments.length <= 1) {
		if (this.config.top || this.config.right || this.config.bottom || this.config.left) {
			top.style.position = 'absolute';
			if (this.config.top) {
				top.style.top = parseInt(this.config.top) + 'px';
			} else if (this.config.bottom) {
				var winH = document.body.clientHeight || document.documentElement.clientHeight || window.innerHeight || 0;
				top.style.top = (winH - parseInt(this.config.bottom) - menu.offsetHeight - (top.offsetHeight - top.clientHeight)) + 'px';
			}
			if (this.config.left) {
				top.style.left = parseInt(this.config.left) + 'px';
			} else if (this.config.right) {
				var winW = document.body.clientWidth ||	document.documentElement.clientWidth || window.innerWidth || 0;
				top.style.left = (winW - parseInt(this.config.right) - menu.offsetWidth - (top.offsetWidth - top.clientWidth)) + 'px';
			}
		} else if (window.opera && (this.config.drag || this.config.scrollWithWindow)) {
			top.style.position = 'absolute';
			var pos = Zapatec.Utils.getAbsolutePos(top);
			top.style.left = pos.x + 'px';
			top.style.top = pos.y + 'px';
		}
	}

	top.style.zIndex = this.config.zIndex;

	if ((this.config.rememberPath || this.config.pathCookie != '__zp_item') && this.path) {
		this.highlightPath(this.path);
		if (this.config.rememberPath == 'expand') {
			this.sync(this.path);
		}
	}
};

Zapatec.Menu.prototype.hideMenu = function() {
	if (this.top_parent.style.display != 'none') {
		this.collapseAll();
		this.top_parent.style.display = 'none';
	}
};

Zapatec.Menu.selectedItemsStack = new Array();

Zapatec.Menu.selectItem = function(item) {
	Zapatec.Utils.addClass(item, "zpMenu-item-selected");
	if (/zpMenu-item-collapsed/i.test(item.className)) {
		Zapatec.Utils.addClass(item, "zpMenu-item-selected-collapsed");
	}
	for (var i = Zapatec.Menu.selectedItemsStack.length - 1; i >= 0; i--) {
		if (Zapatec.Menu.selectedItemsStack[i] == item) {
			Zapatec.Menu.selectedItemsStack.splice(i, 1);
		}
	}
	Zapatec.Menu.selectedItemsStack.push(item);
};

Zapatec.Menu.unselectItem = function(item) {
	Zapatec.Utils.removeClass(item, "zpMenu-item-selected");
	Zapatec.Utils.removeClass(item, "zpMenu-item-selected-collapsed");
	for (var i = Zapatec.Menu.selectedItemsStack.length - 1; i >= 0; i--) {
		if (Zapatec.Menu.selectedItemsStack[i] == item) {
			Zapatec.Menu.selectedItemsStack.splice(i, 1);
		}
	}
};

Zapatec.Utils.addEvent(window, "load", Zapatec.Utils.checkActivation);
