<?php

/*
////////////////////////////////////////////////////////////////////////////////
// JohnCMS                Mobile Content Management System                    //
// Project site:          http://johncms.com                                  //
// Support site:          http://gazenwagen.com                               //
////////////////////////////////////////////////////////////////////////////////
// Lead Developer:        Oleg Kasyanov   (AlkatraZ)  alkatraz@gazenwagen.com //
// Development Team:      Eugene Ryabinin (john77)    john77@gazenwagen.com   //
//                        Dmitry Liseenko (FlySelf)   flyself@johncms.com     //
////////////////////////////////////////////////////////////////////////////////
// Search_ex: by Ares^ (ICQ# 462776)                                          //
////////////////////////////////////////////////////////////////////////////////
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');
$textl = 'Расширенный поиск пользователей';
$headmod = 'usersearch';
require('../incfiles/head.php');

echo '<div class="phdr"><a href="index.php"><b>Актив сайта</b></a> | Расширенный поиск пользователей</div>';

/*
-----------------------------------------------------------------
Принимаем данные
-----------------------------------------------------------------
*/
$sex = isset($_REQUEST['sex']) ? abs(intval($_REQUEST['sex'])) : 0;
$from_age = isset($_REQUEST['from']) ? abs(intval($_REQUEST['from'])) : 0;
$to_age = isset($_REQUEST['to']) ? abs(intval($_REQUEST['to'])) : 0;
$live = isset($_POST['live']) ? functions::check(mb_substr($_POST['live'], 0, 50)) : '';
$live = $live ? $live : functions::check(mb_substr(rawurldecode($_GET['live']), 0, 50));
$photo = intval($_REQUEST['photo']) ? 1 : 0;
$online = intval($_REQUEST['online']) ? 1 : 0;
$new = intval($_REQUEST['new']) ? 1 : 0;
/*
-----------------------------------------------------------------
Задаем запрос к БД
-----------------------------------------------------------------
*/
if ($sex) {
    $sql = '`sex` = \'' . ($sex == 1 ? 'm' : 'zh') . '\'';
    $md = date('m-d', $realtime);
    if ($from_age) {
        $year_from = date('Y', $realtime) - $from_age;
        $date = $year_from . '-' . $md;
        $sql .= ' AND UNIX_TIMESTAMP(CONCAT_WS("-",`yearofbirth`,`monthb`,`dayb`)) <= UNIX_TIMESTAMP(\'' . $date . '\') AND `yearofbirth` != \'0\'';
    }
    if ($to_age) {
        $year_to = date('Y', $realtime) - $to_age;
        $date = $year_to . '-' . $md;
        $sql .= ' AND UNIX_TIMESTAMP(CONCAT_WS("-",`yearofbirth`,`monthb`,`dayb`)) >= UNIX_TIMESTAMP(\'' . $date . '\')';
    }
    if ($live)
	    $sql .=	' AND `live` LIKE \'%' . $live . '%\'';
    if ($photo) {
        $sql .= ' AND `id` IN ( ';
        $dir = opendir('../files/users/photo');
        while ($file = readdir($dir)) {
            $name = explode(".", $file);
            $names = preg_replace('#^(.*?)_small.(gif|jpg|png)$#isU', '$1', $file);
            if ($name[1] == 'jpg' && $name[0] != $names.'_small' && $name[0] != $user_id) {
                $name[0] = $name[0].', ';
                $sql .= $name[0];
            }
        }
        closedir($dir);
        $sql .= '0 )';
    }
    if ($online)
	    $sql .= ' AND `lastdate` > \'' . ($realtime - 300) . '\'';
    if ($new)
	    $sql .= ' AND `datereg` > \'' . ($realtime - 86400) . '\'';
    /*
    -----------------------------------------------------------------
    Проверям на ошибки
    -----------------------------------------------------------------
    */
    $error = array();
    if ($from_age && $to_age && $from_age >= $to_age)
        $error[] = 'Не правильно указан диапазон возраста!';
    if ($from_age > 41 || $to_age > 41)
        $error[] = 'Максимально-допустимое значение возраста - 41.';
    if ($live && mb_strlen($live) < 2)
        $error[] = 'Минимальное значение города - 2 символа.';
    if (!$error) {
        /*
        -----------------------------------------------------------------
        Выводим результаты поиска
        -----------------------------------------------------------------
        */
        $req = mysql_query("SELECT COUNT(*) FROM `users` WHERE `id` != '$user_id' AND $sql");
        $total = mysql_result($req, 0);
        if ($total) {
            $req = mysql_query("SELECT * FROM `users` WHERE `id` != '$user_id' AND $sql ORDER BY `id` LIMIT $start, $kmess");
            while ($res = mysql_fetch_array($req)) {
                $ages = (int)((time() - mktime(0, 0, 0, $res['monthb'], $res['dayb'], $res['yearofbirth'])) / (60 * 60 * 24 * 365.25));
                if ($to_age || $from_age)
                    $age = '<li><span class="gray">Возраст:</span> ' . $ages . '</li>';
                if ($live)
                    $city = '<li><span class="gray">Город:</span> ' . $res['live'] . '</li>';
                echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
                $arg = array (
                    'iphide' => 1,
                    'body' => $age.$city
                );
                echo functions::display_user($res, $arg);
                echo '</div>';
                ++$i;
            }
            echo '<div class="phdr">Всего: ' . $total . '</div>';
            if ($total > $kmess) {
                echo '<div class="topmenu">' . functions::display_pagination('index.php?act=search_ex&amp;live=' . rawurlencode($live) . '&amp;sex=' .
                    $sex . '&amp;from=' . $from_age. '&amp;to=' . $to_age . '&amp;on=' . $online  . '&amp;new=' . $new . '&amp;photo=' . $photo .
                    '&amp;', $start, $total, $kmess) . '</div>' .
                    '<p><form action="index.php?act=search_ex" method="post">' .
                    '<input type="hidden" name="live" value="' . functions::checkout($live) . '" /><input type="hidden" name="sex" value="' . $sex . '" />' .
                    '<input type="hidden" name="from" value="' . $from_age . '" /><input type="hidden" name="to" value="' . $to_age . '" />' .
                    '<input type="hidden" name="on" value="' . $online . '" /><input type="hidden" name="new" value="' . $new . '" />' .
                    '<input type="hidden" name="photo" value="' . $photo . '" /><input type="text" name="page" size="2"/>' .
                    '<input type="submit" value="К странице &gt;&gt;"/>' .
                    '</form></p>';
            }
        } else {
            echo '<div class="rmenu">Поиск не дал результатов.</div>';
        }
    } else {
        /*
        -----------------------------------------------------------------
        Выводим сообщение об ошибке
        -----------------------------------------------------------------
        */
            echo functions::display_error($error);
    }
} else {
    /*
    -----------------------------------------------------------------
    Выводим форму поиска
    -----------------------------------------------------------------
    */
    echo '<form action="index.php?act=search_ex" method="post">' .
        '<div class="list1"><p>' .
        'Ищу</p><select name="sex">' . ($datauser['sex'] == 'm' ? '<option value="2" select="selected">Девушку</option><option value="1">Парня</option>' :
        '<option value="1" select="selected">Парня</option><option value="2">Девушку</option>') . '</select>' .
        '<p>В возрасте <small>(макс. 41)</small></p>от <input type="text" maxlength="2" size="2" name="from" value="0"/> ' .
        'до <input type="text" maxlength="2" size="2" name="to" value="0"/>' .
        '<p>Из города <small>(мин. 2, макс. 50)</small></p><input type="text" name="live"/></div>' .
        '<div class="list2"><p><input type="checkbox" name="photo" value="1" /> с фото</p>' .
        '<p><input type="checkbox" name="online" value="1" /> сейчас онлайн</p>' .
        '<p><input type="checkbox" name="new" value="1" /> только новые</p></div>' .
        '<div class="list1"><input type="submit" value="Поиск" name="submit" />' .
        '</div></form>';
}

echo '<div class="topmenu">' . ($sex ? '<a href="index.php?act=search_ex">Новый поиск</a>' : '<a href="index.php">Назад</a>') . '</div>';

?>