<?php
/*
############################################################################
# Translation and Fix by -=Freeon=- for overdoze.ru
############################################################################
*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");
require ("./includes/browser.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/utils.inc.php");

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SContacts']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);
$PageFolders = str_replace("[session]", $MainSettings->SessAppend_form($TransIDEnabled), $PageFolders);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);

$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

if ($_GET['mode']) {
	$mode = $_GET['mode'];
}
elseif ($_POST['mode']) {
	$mode = $_POST['mode'];
}
else {
	$mode = "view";
}

if ($UseDatabase == 1 && $EnableContacts) {
	function formatcsv($string) {
		$quote = 0;
		$returnstring = $string;
		if (strstr($string, ',')) {
			$quote = 1;
		}
		if (strstr($string, '"')) {
			$quote = 1;
			$returnstring = str_replace('"', '""', $returnstring);
		}
		if (strstr($string, "\r") || strstr($string, "\n")) {
			$quote = 1;
		}
		if ($quote == 1) {
			$returnstring = '"' . $returnstring . '"';
		}
		return $returnstring;
	}


	if ($MySQLMakeConnection) {
		$MySQLID = $MySQLConnection->DB_CheckUser($_SESSION['currentemailaddress'], $_SESSION['sess_p']);
	}

	if ($mode == "popup") {
		// Called via a pop up window
		// This is the selector for dynamically inserting an address into the compose form
		$LetterView = $_GET['view'];
		if (!isset($LetterView)) {
			$LetterView = 'all';
		}
		$PagePopUp = $getFile->fileRead('addressbook_popup');
		$PagePopUpList = $getFile->fileRead('addressbook_popuplist');

		$alphabet = array ("","","","","","","","","","","","","","","","","","","","","","","","","","","","");

		$AlphaBar = " ";
		for($i=0; $i<count($alphabet); $i++) {
			$AlphaBar .= "<a href=\"addressbook.php?mode=popup&amp;view=" . $alphabet[$i] . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $alphabet[$i] . "</a> | ";
		}
		$AlphaBar .= "<a href=\"addressbook.php?mode=popup&amp;view=num" . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">#</a> ";

		if ($LetterView == 'all') {
			$LetterCurrent = $lang['SContacts']['All'];
		}
		elseif ($LetterView == 'num') {
			$LetterCurrent = '0-9';
		}
		else {
			$LetterCurrent = strtoupper($LetterView);
		}

		if ($MySQLMakeConnection) {
			$ab_entry = $MySQLConnection->DB_GetEmailList($LetterView);
			if (is_array($ab_entry)) {
				while(list($key, $value) = each($ab_entry)) { 
					$fullname = $ab_entry[$key]['firstname'] . " " . $ab_entry[$key]['lastname'];
					$fullname = str_replace ('"', "'", $fullname);
					$fullname = trim(addslashes($fullname));
					$CurrentAddress = str_replace ("[addressbook_name]", $fullname, $PagePopUpList);
					$CurrentAddress = str_replace ("[addressbook_lastname]", $ab_entry[$key]['lastname'], $CurrentAddress);
					$CurrentAddress = str_replace ("[addressbook_firstname]", $ab_entry[$key]['firstname'], $CurrentAddress);
					$CurrentAddress = str_replace ("[addressbook_email]", $ab_entry[$key]['email'], $CurrentAddress);
					$FullList .= $CurrentAddress;
				}
			}
		}
		$PagePopUp = str_replace("[charset]", $DefaultCharSet, $PagePopUp);
		$PagePopUp = str_replace("[addressbook_alphabar]", $AlphaBar, $PagePopUp);
		$PagePopUp = str_replace("[addressbook_currentletter]", $LetterCurrent, $PagePopUp);
		$PagePopUp = str_replace("[addressbook_list]", $FullList, $PagePopUp);
		$PagePopUp = str_replace("[compose_field]", strip_tags($_GET['field']), $PagePopUp);
		$PagePopUp = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PagePopUp);
		$PagePopUp = str_replace("[session_force]", "&amp;" . strip_tags(SID), $PagePopUp);
		$PagePopUp = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PagePopUp);
		$PagePopUp = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PagePopUp);

		$PagePopUp = LangReplace('SContacts', $PagePopUp, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PagePopUp;
	}

	if ($mode == "selector") {
		// Called via a pop up window - selector for all to, cc and bcc fields at once
		// This is the selector for dynamically inserting an address into the compose form
		$PageSelector = $getFile->fileRead('addressbook_selector');
		if (isset($DisplayBcc) && ($DisplayBcc <> 1)) {
			$PageSelector = preg_replace("/(\[)(ifbcc)(])(\r\n)*(.*)(\[\/ifbcc\])/siU", "", $PageSelector);
		}
		else {
			$PageSelector = str_replace("[ifbcc]", "", $PageSelector);
			$PageSelector = str_replace("[/ifbcc]", "", $PageSelector);
		}

		if ($MySQLMakeConnection) {
			$ab_entry = $MySQLConnection->DB_GetEmailList();
			if (is_array($ab_entry)) {
				while(list($key, $value) = each($ab_entry)) {
					if ($ab_entry[$key]['firstname'] == "") {
						$DisplayName = $ab_entry[$key]['lastname'];
					}
					else {
						$DisplayName = $ab_entry[$key]['lastname'] . ", ". $ab_entry[$key]['firstname'];
					}
					$DisplayName = str_replace ('"', "'", $DisplayName);
					$DisplayName = trim(addslashes($DisplayName));

					$FullList .= "<option value=\"" . $ab_entry[$key]['email'] . "\">" . $DisplayName . "</option>";
				}
			}
		}
		$PageSelector = str_replace("[charset]", $DefaultCharSet, $PageSelector);
		$PageSelector = str_replace("[addressbook_list]", $FullList, $PageSelector);
		$PageSelector = LangReplace('SContacts', $PageSelector, $lang);
		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageSelector;
	}

	elseif ($mode == "view") {
		$LetterView = $_GET['view'];
		if (!isset($LetterView)) {
			$LetterView = 'all';
		}
		// Default view to view the addressbook
		$PageAB = $getFile->fileRead('addressbook_view');
		$PageABList = $getFile->fileRead('addressbook_viewlist');
		$PageABMenu = $getFile->fileRead('addressbook_menu');

		$alphabet = array ("","","","","","","","","","","","","","","","","","","","","","","","","","","","");
		$AlphaBar = " ";
		for($i=0; $i<count($alphabet); $i++) {
			$AlphaBar .= "<a href=\"addressbook.php?mode=view&amp;view=" . $alphabet[$i] . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $alphabet[$i] . "</a> | ";
		}
		$AlphaBar .= "<a href=\"addressbook.php?mode=view&amp;view=num" . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">#</a> ";

		if ($LetterView == 'all') {
			$LetterCurrent = $lang['SContacts']['All'];
		}
		elseif ($LetterView == 'num') {
			$LetterCurrent = '0-9';
		}
		else {
			$LetterCurrent = strtoupper($LetterView);
		}

		if ($MySQLMakeConnection) {
			$ab_entry = $MySQLConnection->DB_GetEmailList($LetterView);
			if (is_array($ab_entry)) {
				while(list($key, $value) = each($ab_entry)) { 
					$fullname = $ab_entry[$key]['firstname'] . " " . $ab_entry[$key]['lastname'];
					$fullname = str_replace ('"', "'", $fullname);
					$fullname = trim(addslashes($fullname));
					$CurrentAddress = str_replace ("[addressbook_name]", $fullname, $PageABList);
					$CurrentAddress = str_replace ("[addressbook_lastname]", $ab_entry[$key]['lastname'], $CurrentAddress);
					$CurrentAddress = str_replace ("[addressbook_firstname]", $ab_entry[$key]['firstname'], $CurrentAddress);
					$CurrentAddress = str_replace ("[addressbook_email]", $ab_entry[$key]['email'], $CurrentAddress);
					$CurrentAddress = str_replace ("[addressbook_id]", $ab_entry[$key]['id'], $CurrentAddress);
					$CurrentAddress = str_replace("[entry_number]", $ab_entry[$key]['id'], $CurrentAddress);
					if ($ab_entry[$key]['userid'] == 0) {
						$CurrentAddress = preg_replace("/(\[)(ifselectable)(])(\r\n)*(.*)(\[\/ifselectable\])/siU", "&nbsp;", $CurrentAddress);
					}
					else {
						$CurrentAddress = str_replace("[ifselectable]", "", $CurrentAddress);
						$CurrentAddress = str_replace("[/ifselectable]", "", $CurrentAddress);
					}

					$FullList .= $CurrentAddress;
				}
			}
		}
		$PageAB = str_replace("[addressbook_alphabar]", $AlphaBar, $PageAB);
		$PageAB = str_replace("[addressbook_currentletter]", $LetterCurrent, $PageAB);
		$PageAB = str_replace("[addressbook_list]", $FullList, $PageAB);
		$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

		$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
		$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
		$PageAB = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
		$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);
		$PageAB = LangReplace('SContacts', $PageAB, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageAB;
		echo $PageFooter;
	}

	elseif ($mode == "groups") {
		// Manage email groups.  Members of a group must be a member of the main addressbook first
		$PageAB = $getFile->fileRead('addressbook_groups');
		$PageABList = $getFile->fileRead('addressbook_grouplist');
		$PageABMenu = $getFile->fileRead('addressbook_menu');

		if ($MySQLMakeConnection) {
			$ab_entry = $MySQLConnection->DB_GetGroupList();
			if (is_array($ab_entry)) {
				while(list($key, $value) = each($ab_entry)) { 
					$ab_entry[$key]['groupname'] = str_replace ('"', "'", $ab_entry[$key]['groupname']);
					$ab_entry[$key]['groupname'] = trim(stripslashes($ab_entry[$key]['groupname']));
					$CurrentAddress = str_replace ("[group_name]", $ab_entry[$key]['groupname'], $PageABList);
					$CurrentAddress = str_replace ("[group_count]", $ab_entry[$key]['count'], $CurrentAddress);
					$CurrentAddress = str_replace ("[group_id]", $ab_entry[$key]['id'], $CurrentAddress);
					$CurrentAddress = str_replace ("[recipient_maximum]", $recipientmaximum, $CurrentAddress);
					$CurrentAddress = str_replace("[entry_number]", $ab_entry[$key]['id'], $CurrentAddress);
					if ($ab_entry[$key]['count'] > $recipientmaximum) {
						$CurrentAddress = str_replace("[ifexceedmax]", "", $CurrentAddress);
						$CurrentAddress = str_replace("[/ifexceedmax]", "", $CurrentAddress);
					}
					else {
						$CurrentAddress = preg_replace("/(\[)(ifexceedmax)(])(\r\n)*(.*)(\[\/ifexceedmax\])/siU", "", $CurrentAddress);
					}
					$FullList .= $CurrentAddress;
				}
			}
		}
		$PageAB = str_replace("[addressbook_list]", $FullList, $PageAB);
		$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

		$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
		$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
		$PageAB = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
		$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);

		if ($recipientmaximum > 0) {
			$PageAB = str_replace("[ifmaxrecipients]", "", $PageAB);
			$PageAB = str_replace("[/ifmaxrecipients]", "", $PageAB);
		}
		else {
			$PageAB = preg_replace("/(\[)(ifmaxrecipients)(])(\r\n)*(.*)(\[\/ifmaxrecipients\])/siU", "", $PageAB);
		}

		$PageAB = LangReplace('SContacts', $PageAB, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageAB;
		echo $PageFooter;
	}

	elseif ($mode == "groupdetails") {
		// Add, Edit or view a group from the database

		$PageAB = $getFile->fileRead('addressbook_groupdetails');
		$PageABMenu = $getFile->fileRead('addressbook_menu');
		$id = strip_tags($_REQUEST['id']);

		if ($id && $MySQLMakeConnection) {
			$ab_groupdetails = $MySQLConnection->DB_GetGroupDetails($id);
			$ab_groupmembers = $MySQLConnection->DB_GetGroupMembers($id);
		}
		else {
			$ab_groupmembers = $MySQLConnection->DB_GetGroupMembers();
		}

		$buildlist = "<select name=\"members[]\" multiple=\"multiple\" size=\"12\" width=\"400px\">";
		if (is_array($ab_groupmembers)) {
			while(list($key, $value) = each($ab_groupmembers)) {
				$fullname = $ab_groupmembers[$key]['firstname'] . " " . $ab_groupmembers[$key]['lastname'];
				$fullname = str_replace ('"', "'", $fullname);
				$fullname = trim(addslashes($fullname));
				$buildlist .= "<option value=\"$key\"";
				if ($ab_groupmembers[$key]['ismember'] == 1) {
					$buildlist .= " selected=\"selected\"";
				}
				$buildlist .= ">$fullname &lt;" . $ab_groupmembers[$key]['email'] . "&gt;</option>";
			}
		}
		$buildlist .= "</select>";

		$PageAB = str_replace ("[addressbook_groupname]", "<input type=\"text\" name=\"name\" value=\"" . $ab_groupdetails['name'] . "\" maxlength=\"150\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_groupnamevalue]", $ab_groupdetails['name'], $PageAB);
		$PageAB = str_replace ("[addressbook_groupmembers]", $buildlist, $PageAB);
		$PageAB = str_replace ("[addressbook_groupid]", $id, $PageAB);

		$PageAB = str_replace ("[addressbook_hiddenfields]", "<input type=\"hidden\" name=\"id\" value=\"$id\" /><input type=\"hidden\" name=\"mode\" value=\"savegroup\" />", $PageAB);

		$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

		$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
		$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
		$PageAB = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
		$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);
		$PageAB = LangReplace('SContacts', $PageAB, $lang);

		if (!empty($id)) {
			$PageAB = str_replace("[ifentry]", "", $PageAB);
			$PageAB = str_replace("[/ifentry]", "", $PageAB);
		}
		else {
			$PageAB = preg_replace("/(\[)(ifentry)(])(\r\n)*(.*)(\[\/ifentry\])/siU", "", $PageAB);
		}

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageAB;
		echo $PageFooter;
	}

	elseif ($mode == "edit") {
		// Add, Edit or view an entry from the database

		$PageAB = $getFile->fileRead('addressbook_entry');
		$PageABMenu = $getFile->fileRead('addressbook_menu');
		$id = strip_tags($_REQUEST['id']);

		if ($id && $MySQLMakeConnection) {
			$ab_entrydetails = $MySQLConnection->DB_GetEntryDetails($id);
		}

		if (!empty($ab_entrydetails['email'])) {
			$PageAB = str_replace("[ifemail]", "", $PageAB);
			$PageAB = str_replace("[/ifemail]", "", $PageAB);
		}
		else {
			$PageAB = preg_replace("/(\[)(ifemail)(])(\r\n)*(.*)(\[\/ifemail\])/siU", "", $PageAB);
		}

		if (!empty($id)) {
			$PageAB = str_replace("[ifentry]", "", $PageAB);
			$PageAB = str_replace("[/ifentry]", "", $PageAB);
		}
		else {
			$PageAB = preg_replace("/(\[)(ifentry)(])(\r\n)*(.*)(\[\/ifentry\])/siU", "", $PageAB);
		}

		if ($ab_entrydetails['userid'] == 0) {
			$PageAB = preg_replace("/(\[)(ifdeleteable)(])(\r\n)*(.*)(\[\/ifdeleteable\])/siU", "&nbsp;", $PageAB);
		}
		else {
			$PageAB = str_replace("[ifdeleteable]", "", $PageAB);
			$PageAB = str_replace("[/ifdeleteable]", "", $PageAB);
		}

		$PageAB = str_replace ("[addressbook_emailvalue]", $ab_entrydetails['email'], $PageAB);
		$PageAB = str_replace ("[addressbook_lastname]", "<input type=\"text\" name=\"lastname\" value=\"" . $ab_entrydetails['lastname'] . "\" maxlength=\"150\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_firstname]", "<input type=\"text\" name=\"firstname\" value=\"" . $ab_entrydetails['firstname'] . "\" maxlength=\"150\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_email]", "<input type=\"text\" name=\"email\" value=\"" . $ab_entrydetails['email'] . "\" maxlength=\"100\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_title]", "<input type=\"text\" name=\"title\" value=\"" . $ab_entrydetails['title'] . "\" maxlength=\"100\" size=\"20\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_homephone]", "<input type=\"text\" name=\"homephone\" value=\"" . $ab_entrydetails['homephone'] . "\" maxlength=\"50\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_workphone]", "<input type=\"text\" name=\"workphone\" value=\"" . $ab_entrydetails['workphone'] . "\" maxlength=\"50\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_cellphone]", "<input type=\"text\" name=\"cellphone\" value=\"" . $ab_entrydetails['cellphone'] . "\" maxlength=\"50\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_fax]", "<input type=\"text\" name=\"fax\" value=\"" . $ab_entrydetails['fax'] . "\" maxlength=\"50\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_url]", "<input type=\"text\" name=\"url\" value=\"" . $ab_entrydetails['url'] . "\" maxlength=\"50\" size=\"50\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_homeaddress]", "<textarea name=\"homeaddress\" cols=\"50\" rows=\"5\">" . $ab_entrydetails['homeaddress'] . "</textarea>", $PageAB);
		$PageAB = str_replace ("[addressbook_workaddress]", "<textarea name=\"workaddress\" cols=\"50\" rows=\"5\">" . $ab_entrydetails['workaddress'] . "</textarea>", $PageAB);
		$PageAB = str_replace ("[addressbook_notes]", "<textarea name=\"notes\" cols=\"50\" rows=\"5\">" . $ab_entrydetails['notes'] . "</textarea>", $PageAB);
		$PageAB = str_replace ("[addressbook_id]", $id, $PageAB);

		$PageAB = str_replace ("[addressbook_hiddenfields]", "<input type=\"hidden\" name=\"id\" value=\"$id\" /><input type=\"hidden\" name=\"mode\" value=\"save\" />", $PageAB);

		$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

		$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
		$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
		$PageAB = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
		$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);
		$PageAB = LangReplace('SContacts', $PageAB, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageAB;
		echo $PageFooter;
	}

	elseif ($mode == "vcard") {
		// Export as a vcard (RFC2426)
		$id = strip_tags($_REQUEST['id']);

		if ($id && $MySQLMakeConnection) {
			$ab_entrydetails = $MySQLConnection->DB_GetEntryDetails($id);
		}

		// This generates a vcard version 3.0 (\n as a line terminator where as vcard 2.1 uses \r\n)

		$BuildVCard = "BEGIN:VCARD\n";
		$BuildVCard .= "VERSION:3.0\n";
		$BuildVCard .= "N:" . $ab_entrydetails['lastname'] . ";" . $ab_entrydetails['firstname'] . "\n";
		$BuildVCard .= "FN:" . $ab_entrydetails['firstname'] . " " . $ab_entrydetails['lastname'] . "\n";
		$BuildVCard .= "TEL;WORK;VOICE:" . $ab_entrydetails['workphone'] . "\n";
		$BuildVCard .= "TEL;HOME;VOICE:" . $ab_entrydetails['homephone'] . "\n";
		$BuildVCard .= "TEL;CELL;VOICE:" . $ab_entrydetails['cellphone'] . "\n";
		$BuildVCard .= "TEL;WORK;FAX:" . $ab_entrydetails['fax'] . "\n";
		$BuildVCard .= "ADR;WORK:;;" . str_replace("\r", "", str_replace("\n" , ";", $ab_entrydetails['workaddress'])) . "\n";
		$BuildVCard .= "LABEL;WORK:" . $ab_entrydetails['workaddress'] . "\n";
		$BuildVCard .= "ADR;HOME:;;" . str_replace("\r", "", str_replace("\n" , ";", $ab_entrydetails['homeaddress'])) . "\n";
		$BuildVCard .= "LABEL;HOME:" . str_replace("\r", "", str_replace("\n" , ";", $ab_entrydetails['homeaddress'])) . "\n";
		$BuildVCard .= "EMAIL;PREF;INTERNET:" . $ab_entrydetails['email'] . "\n";
		$BuildVCard .= "URL;WORK:" . $ab_entrydetails['url'] . "\n";
		$BuildVCard .= "REV:" . date("Y-m-d") . "\n";
		$BuildVCard .= "PRODID:-//DWMAIL//NONSGML Version 3.6.2//EN\n";
		$BuildVCard .= "END:VCARD\n";

		$CardSize = strlen($BuildVCard);
		$FileName = $ab_entrydetails['firstname'] . "_" . $ab_entrydetails['lastname'] . ".vcf";

		ob_start();

		header ("Cache-Control: "); // leave blank to avoid IE errors
		header ("Pragma: "); // leave blank to avoid IE errors
		header ("Content-type: text/directory");

		header ("Content-Transfer-Encoding: text");
		header ("Content-Length: $CardSize");
		header ("Content-Disposition: attachment; filename=\"$FileName\"");

		header ("Content-Description: File Attachment"); 

		echo $BuildVCard;

		ob_end_flush();

	}

	elseif ($mode == "export") {
		// Export Contacts
		// Options page
		$PageAB = $getFile->fileRead('addressbook_export');
		$PageABMenu = $getFile->fileRead('addressbook_menu');

		$PageAB = str_replace ("[addressbook_hiddenfields]", "<input type=\"hidden\" name=\"mode\" value=\"exportfile\" />", $PageAB);

		$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

		$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
		$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
		$PageAB = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
		$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);
		$PageAB = LangReplace('SContacts', $PageAB, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageAB;
		echo $PageFooter;
	}

	elseif ($mode == "exportfile") {
		$exporttype = $_POST['exporttype'];
		if ($exporttype == "") {
			$exporttype = "CSV";
		}
		if ($exporttype == "CSV") {
			// Output CSV Header
			$OutputFile = '"Title","First Name","Last Name","E-mail Address","Business Address","Home Address","Home Phone","Work Phone","Cell Phone","Fax","Notes","Web page"' . "\r\n";
			if ($MySQLMakeConnection) {
				$ab_entry = $MySQLConnection->DB_GetEmailList();
				if (is_array($ab_entry)) {
					while(list($key, $value) = each($ab_entry)) { 
						$OutputFile .= formatcsv($ab_entry[$key]['title']) . ',' . 
								formatcsv($ab_entry[$key]['firstname']) . ',' . 
								formatcsv($ab_entry[$key]['lastname']) . ',' . 
								formatcsv($ab_entry[$key]['email']) . ',' . 
								formatcsv($ab_entry[$key]['workaddress']) . ',' . 
								formatcsv($ab_entry[$key]['homeaddress']) . ',' . 
								formatcsv($ab_entry[$key]['homephone']) . ',' . 
								formatcsv($ab_entry[$key]['workphone']) . ',' . 
								formatcsv($ab_entry[$key]['cellphone']) . ',' . 
								formatcsv($ab_entry[$key]['fax']) . ',' . 
								formatcsv($ab_entry[$key]['notes']) . ',' . 
								formatcsv($ab_entry[$key]['url']) . "\r\n";
					}
				}
			}
		}
		else {
			if ($MySQLMakeConnection) {
				$ab_entry = $MySQLConnection->DB_GetEmailList();
				if (is_array($ab_entry)) {
					while(list($key, $value) = each($ab_entry)) { 

						// This generates a vcard version 3.0 (\n as a line terminator where as vcard 2.1 uses \r\n)

						$OutputFile .= "BEGIN:VCARD\n";
						$OutputFile .= "VERSION:3.0\n";
						$OutputFile .= "N:" . $ab_entry[$key]['lastname'] . ";" . $ab_entry[$key]['firstname'] . "\n";
						$OutputFile .= "FN:" . $ab_entry[$key]['firstname'] . " " . $ab_entry[$key]['lastname'] . "\n";
						$OutputFile .= "TEL;WORK;VOICE:" . $ab_entry[$key]['workphone'] . "\n";
						$OutputFile .= "TEL;HOME;VOICE:" . $ab_entry[$key]['homephone'] . "\n";
						$OutputFile .= "TEL;CELL;VOICE:" . $ab_entry[$key]['cellphone'] . "\n";
						$OutputFile .= "TEL;WORK;FAX:" . $ab_entry[$key]['fax'] . "\n";
						$OutputFile .= "ADR;WORK:;;" . str_replace("\r", "", str_replace("\n" , ";", $ab_entry[$key]['workaddress'])) . "\n";
						$OutputFile .= "LABEL;WORK:" . $ab_entry[$key]['workaddress'] . "\n";
						$OutputFile .= "ADR;HOME:;;" . str_replace("\r", "", str_replace("\n" , ";", $ab_entry[$key]['homeaddress'])) . "\n";
						$OutputFile .= "LABEL;HOME:" . str_replace("\r", "", str_replace("\n" , ";", $ab_entry[$key]['homeaddress'])) . "\n";
						$OutputFile .= "URL;WORK:" . $ab_entry[$key]['url'] . "\n";
						$OutputFile .= "EMAIL;PREF;INTERNET:" . $ab_entry[$key]['email'] . "\n";
						$OutputFile .= "REV:" . date("Y-m-d") . "\n";
						$OutputFile .= "PRODID:-//DWMAIL//NONSGML Version 3.6.2//EN\n";
						$OutputFile .= "END:VCARD\n\n";

					}
				}
			}
		}

		$ExportSize = strlen($OutputFile);

		ob_start();

		header ("Cache-Control: "); // leave blank to avoid IE errors
		header ("Pragma: "); // leave blank to avoid IE errors
		if ($exporttype == "CSV") {
			$FileName = "contacts.csv";
			header ("Content-type: text/plain");
		}
		else {
			$FileName = "contacts.vcf";
			header ("Content-type: text/x-vcard");
		}

		header ("Content-Transfer-Encoding: text");
		header ("Content-Length: $ExportSize");
		header ("Content-Disposition: attachment; filename=\"$FileName\"");

		header ("Content-Description: File Attachment"); 

		echo $OutputFile;

		ob_end_flush();
	}

	elseif ($mode == "import") {
		// Import a vCard (RFC2426) or a CSV file
		// Stage 1 - File Upload Form
		$PageAB = $getFile->fileRead('addressbook_import');
		$PageABMenu = $getFile->fileRead('addressbook_menu');

		$PageAB = str_replace ("[addressbook_hiddenfields]", "<input type=\"hidden\" name=\"mode\" value=\"importfile\" />", $PageAB);
		$PageAB = str_replace ("[addressbook_importfile]", "<input type=\"file\" name=\"importupload\" size=\"40\" />", $PageAB);

		$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

		$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
		$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
		$PageAB = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
		$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);
		$PageAB = LangReplace('SContacts', $PageAB, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageAB;
		echo $PageFooter;

	}

	elseif ($mode == "importfile") {
		$importtype = $_POST['importtype'];
		if ($importtype == "") {
			$importtype = "vCard";
		}

		if ($_FILES) {
			if ($_FILES['importupload']['name'] <> "") {

				if ($importtype == "vCard") {
					// vCard import routine
					require_once "./includes/3rdparty/vCard/vCard.inc.php";
					$parse = new Contact_Vcard_Parse();
					$cardinfo = $parse->fromFile($_FILES['importupload']['tmp_name']);
					for ($i=0; $i<count($cardinfo); $i++) {
						$details['lastname'] = strip_tags(addslashes($cardinfo[$i]['N'][0]['value'][0][0]));
						$details['firstname'] = strip_tags(addslashes($cardinfo[$i]['N'][0]['value'][1][0]));
						$telarry = $cardinfo[$i]['TEL'];
						for ($j=0; $j<count($telarry); $j++) {
							if ($telarry[$j]['param']['TYPE'][0] == 'WORK' && $telarry[$j]['param']['TYPE'][1] == 'VOICE' && isset($telarry[$j]['value'][0][0])) {
								$details['workphone'] = strip_tags(addslashes($telarry[$j]['value'][0][0]));
							}
							elseif ($telarry[$j]['param']['TYPE'][0] == 'HOME' && $telarry[$j]['param']['TYPE'][1] == 'VOICE' && isset($telarry[$j]['value'][0][0])) {
								$details['homephone'] = strip_tags(addslashes($telarry[$j]['value'][0][0]));
							}
							elseif ($telarry[$j]['param']['TYPE'][0] == 'CELL' && $telarry[$j]['param']['TYPE'][1] == 'VOICE' && isset($telarry[$j]['value'][0][0])) {
								$details['cellphone'] = strip_tags(addslashes($telarry[$j]['value'][0][0]));
							}
							elseif ($telarry[$j]['param']['TYPE'][0] == 'WORK' && $telarry[$j]['param']['TYPE'][1] == 'FAX' && isset($telarry[$j]['value'][0][0])) {
								$details['fax'] = strip_tags(addslashes($telarry[$j]['value'][0][0]));
							}
						}
						$urlarry = $cardinfo[$i]['URL'];
						for ($j=0; $j<count($urlarry); $j++) {
							if ($urlarry[$j]['param']['TYPE'][0] == 'WORK' && isset($urlarry[$j]['value'][0][0])) {
								$details['url'] = strip_tags(addslashes($urlarry[$j]['value'][0][0]));
							}
						}
						$adrarry = $cardinfo[$i]['ADR'];
						for ($j=0; $j<count($adrarry); $j++) {
							if ($adrarry[$j]['param']['TYPE'][0] == 'WORK') {
								$adrworkarry = $adrarry[$j]['value'];
								$details['workadr'] = "";
								for ($k=0; $k<count($adrworkarry); $k++) {
									if ($adrworkarry[$k][0] <> "") {
										$details['workaddress'] .= strip_tags(addslashes($adrworkarry[$k][0])) . "\r\n";
									}
								}
							}
							elseif ($adrarry[$j]['param']['TYPE'][0] == 'HOME') {
								$adrhomearry = $adrarry[$j]['value'];
								$details['homeadr'] = "";
								for ($k=0; $k<count($adrhomearry); $k++) {
									if ($adrhomearry[$k][0] <> "") {
										$details['homeaddress'] .= strip_tags(addslashes($adrhomearry[$k][0])) . "\r\n";
									}
								}
							}
						}
						$emailarry = $cardinfo[$i]['EMAIL'];
						for ($j=0; $j<count($emailarry); $j++) {
							if ($emailarry[$j]['param']['TYPE'][0] == 'PREF' && $emailarry[$j]['param']['TYPE'][1] == 'INTERNET') {
								$details['email'] = strip_tags(addslashes($emailarry[$j]['value'][0][0]));
							}
						}

							$ab_addentry = $MySQLConnection->DB_NewEntry($details);

						$importstatus = 0;
						if ($ab_addentry == TRUE) {
							$importstatus = 1;
						}
						else {
							$importerror .= "<li>" . strip_tags($_FILES['importupload']['name']) . "</li>";
						}
						unset ($details);
					}
					if ($importstatus == 1) {
						header ("Location: addressbook.php?mode=view&" . strip_tags(SID));
						exit;
					}
					else {
						$PageGenericMessage = $getFile->fileRead('generic_message');
						$PageGenericMessage = str_replace("[pagetitle]", $lang['SContacts']['Title'], $PageGenericMessage);
						$returnmessage = $lang['SContacts']['ImportError'];
						$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

					header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
					echo $PageHeader;
					echo $PageGenericMessage;
					echo $PageFooter;

					}

				}
				else {

					function OutPutMapping($data, $selectname, $fieldname) {
						$rowcount = count($data);
						$return = "<select name=\"$selectname\">";
						$return .= "<option value=\"\"></option>";
						for ($c=0; $c<$rowcount; $c++) {
							$return .= "<option value=\"" . $c . "\"";
							if ($data[$c] == $fieldname) {
								$return .= " selected=\"selected\"";
							}
							$return .= ">" . $data[$c] . "</option>";
						}
						$return .= "</select>";
						return $return;

					}
					// CSV import routine goes here
					$PageAB = $getFile->fileRead('addressbook_importcsvmapping');
					$PageABMenu = $getFile->fileRead('addressbook_menu');

					$_SESSION['TMPImportFile'] = $data;
					$row = 1;
					$handle = fopen($_FILES['importupload']['tmp_name'], "r");
					$tmparry = array();
					while (($data = fgetcsv($handle, filesize($_FILES['importupload']['tmp_name']), ",")) !== FALSE) {
						$tmparry[] = $data;
						if ($row == 1) {
							$tmpmap .= "<table><tr><td><strong>" . $lang['SContacts']['Prefix'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'title', 'Title');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['FirstName'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'firstname', 'First Name');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['LastName'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'lastname', 'Last Name');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['Email'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'email', 'E-mail Address');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['WorkAddress'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'workaddress', 'Business Address');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['HomeAddress'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'homeaddress', 'Home Address');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['HomePhone'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'homephone', 'Home Phone');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['WorkPhone'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'workphone', 'Work Phone');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['CellPhone'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'cellphone', 'Cell Phone');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['Fax'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'fax', 'Fax');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['Notes'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'notes', 'Notes');
							$tmpmap .= "</td></tr><tr><td><strong>" . $lang['SContacts']['URL'] . "</strong></td><td>&raquo;</td><td>";
							$tmpmap .= OutPutMapping($data, 'url', 'Web page');
							$tmpmap .= "</td></tr></table>";

							$row++;

						}
					}
					fclose($handle);
					$_SESSION['TMPImportFile'] = $tmparry;

					$PageAB = str_replace ("[addressbook_csvfilename]", strip_tags($_FILES['importupload']['name']), $PageAB);
					$PageAB = str_replace ("[addressbook_csvmapping]", $tmpmap, $PageAB);
					$PageAB = str_replace ("[addressbook_hiddenfields]", "<input type=\"hidden\" name=\"mode\" value=\"importmapcsv\" />", $PageAB);
					$PageAB = str_replace("[addressbook_menu]", $PageABMenu, $PageAB);

					$PageAB = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageAB);
					$PageAB = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageAB);
					$PageAB = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageAB);
					$PageAB = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageAB);
					$PageAB = LangReplace('SContacts', $PageAB, $lang);

					header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
					echo $PageHeader;
					echo $PageAB;
					echo $PageFooter;

				}
			}
			else {
				// File doesn't have a name
				$PageGenericMessage = $getFile->fileRead('generic_message');
				$PageGenericMessage = str_replace("[pagetitle]", $lang['SContacts']['Title'], $PageGenericMessage);
				$returnmessage = $lang['SContacts']['ImportError'];
				$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

				header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
				echo $PageHeader;
				echo $PageGenericMessage;
				echo $PageFooter;
			}
		}
		else {
			// File not uploaded
			$PageGenericMessage = $getFile->fileRead('generic_message');
			$PageGenericMessage = str_replace("[pagetitle]", $lang['SContacts']['Title'], $PageGenericMessage);
			$returnmessage = $lang['SContacts']['ImportError'];
			$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;
			echo $PageGenericMessage;
			echo $PageFooter;
		}
	}

	elseif ($mode == "importmapcsv") {
		// Save a CSV mapping to the database

		for ($i=0; $i<sizeof($_SESSION['TMPImportFile']); $i++) {
			if ($i == 0 && $_POST['CSVHeaderLine'] == 1) {
				// Do nothing, header line
			}
			else {

				$rowcount = sizeof($_SESSION['TMPImportFile'][$i]);
				for ($c=0; $c<$rowcount; $c++) {
					if ($c == $_POST['email'] && $_POST['email'] <> '') {
						$checkemail = imap_rfc822_parse_adrlist(strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c])), $DefaultDomain);
						if (is_array($checkemail)) {
							$submitteddetails['email'] = $checkemail[0]->mailbox . "@" . $checkemail[0]->host;
						}
						else {
							$submitteddetails['email'] = '';
						}
					}
					elseif ($c == $_POST['title'] && $_POST['title'] <> '') {
						$submitteddetails['title'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['firstname'] && $_POST['firstname'] <> '') {
						$submitteddetails['firstname'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['lastname'] && $_POST['lastname'] <> '') {
						$submitteddetails['lastname'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['homephone'] && $_POST['homephone'] <> '') {
						$submitteddetails['homephone'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['workphone'] && $_POST['workphone'] <> '') {
						$submitteddetails['workphone'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['cellphone'] && $_POST['cellphone'] <> '') {
						$submitteddetails['cellphone'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['fax'] && $_POST['fax'] <> '') {
						$submitteddetails['fax'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['homeaddress'] && $_POST['homeaddress'] <> '') {
						$submitteddetails['homeaddress'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['workaddress'] && $_POST['workaddress'] <> '') {
						$submitteddetails['workaddress'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['notes'] && $_POST['notes'] <> '') {
						$submitteddetails['notes'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
					elseif ($c == $_POST['url'] && $_POST['url'] <> '') {
						$submitteddetails['url'] = strip_tags(addslashes($_SESSION['TMPImportFile'][$i][$c]));
					}
				}

				$ab_addentry = $MySQLConnection->DB_NewEntry($submitteddetails);
				unset ($submitteddetails);

			}
			$row++;

		}
		unset ($_SESSION['TMPImportFile']);

		header ("Location: addressbook.php?mode=view&" . strip_tags(SID));


	}

	elseif ($mode == "save") {
		// Save an entry to the database

		$id = strip_tags($_POST['id']);
		// Validate Email Address to RFC standards
		$checkemail = imap_rfc822_parse_adrlist(strip_tags(addslashes($_REQUEST['email'])), $DefaultDomain);
		if (is_array($checkemail)) {
			$submitteddetails['email'] = $checkemail[0]->mailbox . "@" . $checkemail[0]->host;
		}
		else {
			$submitteddetails['email'] = '';
		}
		$submitteddetails['lastname'] = strip_tags(addslashes($_REQUEST['lastname']));
		$submitteddetails['firstname'] = strip_tags(addslashes($_POST['firstname']));
		$submitteddetails['email'] = strip_tags(addslashes($_REQUEST['email']));
		$submitteddetails['title'] = strip_tags(addslashes($_POST['title']));
		$submitteddetails['homephone'] = strip_tags(addslashes($_POST['homephone']));
		$submitteddetails['workphone'] = strip_tags(addslashes($_POST['workphone']));
		$submitteddetails['cellphone'] = strip_tags(addslashes($_POST['cellphone']));
		$submitteddetails['fax'] = strip_tags(addslashes($_POST['fax']));
		$submitteddetails['homeaddress'] = strip_tags(addslashes($_POST['homeaddress']));
		$submitteddetails['workaddress'] = strip_tags(addslashes($_POST['workaddress']));
		$submitteddetails['url'] = strip_tags(addslashes($_POST['url']));
		$submitteddetails['notes'] = strip_tags(addslashes($_POST['notes']));

		if ($id <> "" && $MySQLMakeConnection) {
			$ab_addentry = $MySQLConnection->DB_UpdateEntry($id, $submitteddetails);
		}
		else {
			$ab_addentry = $MySQLConnection->DB_NewEntry($submitteddetails);
		}

		if ($ab_addentry == TRUE) {
			header ("Location: addressbook.php?mode=view&" . strip_tags(SID));
		}
	}

	elseif ($mode == "savegroup") {
		// Save a group to the database

		$id = strip_tags($_POST['id']);
		$submitteddetails['members'] = $_POST['members'];
		$submitteddetails['name'] = trim(strip_tags(addslashes($_POST['name'])));

		if (!is_array($_POST['members']) || empty($_POST['name'])) {
			$PageGenericMessage = $getFile->fileRead('generic_message');
			$PageGenericMessage = str_replace("[pagetitle]", $lang['SContacts']['Title'], $PageGenericMessage);
			$returnmessage = $lang['SContacts']['GroupError'];
			$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;
			echo $PageGenericMessage;
			echo $PageFooter;
		}
		else {

			if ($id <> "" && $MySQLMakeConnection) {
				$ab_addentry = $MySQLConnection->DB_UpdateGroup($id, $submitteddetails);
			}
			else {
				$ab_addentry = $MySQLConnection->DB_NewGroup($submitteddetails);
			}

			if ($ab_addentry == TRUE) {
				header ("Location: addressbook.php?mode=groups&" . strip_tags(SID));
			}
		}
	}

	elseif ($mode == "delete") {
		// Delete an entry from the database

		$id = strip_tags($_GET['id']);

		if ($id && $MySQLMakeConnection) {
			$ab_deleteentry = $MySQLConnection->DB_DeleteEntry($id);
		}

		if ($ab_deleteentry == TRUE) {
			header ("Location: addressbook.php?mode=view&" . strip_tags(SID));
		}
	}

	elseif ($mode == "deleteselection") {
		// Delete a selection of entries from the database

		$deleteerrors = 0;

		if ($_POST['selection'] <> "") {
			if (is_array($_POST['selection'])) {
				while(list($key, $value) = each($_POST['selection'])) { 
					$ab_deleteentry = $MySQLConnection->DB_DeleteEntry($key);
					if ($ab_deleteentry == FALSE) {
						$deleteerrors == 1;
					}
					unset ($ab_deleteentry);
				}
			}
		}

		if ($deleteerrors == 0) {
			if ($_POST['view'] == "All") {
				$_POST['view'] = 'all';
			}
			header ("Location: ./addressbook.php?mode=view&view=" . $_POST['view'] . "&" . strip_tags(SID));
		}
	}

	elseif ($mode == "deletegroupselection") {
		// Delete a selection of groups from the database

		$deleteerrors = 0;

		if ($_POST['selection'] <> "") {
			if (is_array($_POST['selection'])) {
				while(list($key, $value) = each($_POST['selection'])) { 
					$ab_deleteentry = $MySQLConnection->DB_DeleteGroup($key);
					if ($ab_deleteentry == FALSE) {
						$deleteerrors == 1;
					}
					unset ($ab_deleteentry);
				}
			}
		}

		if ($deleteerrors == 0) {
			header ("Location: ./addressbook.php?mode=groups&" . strip_tags(SID));
		}
	}


	$MySQLCloseConnection = $MySQLConnection->DB_CloseConnection();
}
else {
	$PageGenericMessage = $getFile->fileRead('generic_message');
	$PageGenericMessage = str_replace("[pagetitle]", $lang['SContacts']['Title'], $PageGenericMessage);
	$returnmessage = $lang['SContacts']['Disabled'];
	$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;
	echo $PageGenericMessage;
	echo $PageFooter;
}

$IMAPConnection->WM_IMAPClose();
?>