<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/utils.inc.php");

require ("./includes/options.inc.php");

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SCalendar']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);
$PageFolders = str_replace("[session]", $MainSettings->SessAppend_form($TransIDEnabled), $PageFolders);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

$crlf = $MainSettings->GetCRLF();
$IMAPConnection->_crlf = $crlf;
$IMAPConnection->_charset = $_SESSION['DefaultCharSet'];

if ($_GET['mode']) {
	$mode = $_GET['mode'];
}
elseif ($_POST['mode']) {
	$mode = $_POST['mode'];
}
else {
	$mode = "view";
}

function DrawMonth($day, $localmonth, $month, $year, $yearshort, $full, $celllg, $cellsm, $cellwk, $lang, $MySQLConnection, $MainSettings) {
		if ($full == 1) {
			$PageCalCell = $celllg;
		}
		else {
			$PageCalCell = $cellsm;
		}

		if (strlen($month) == 1) {
			$padmonth = "0" . $month;
		}
		else {
			$padmonth = $month;
		}

		if (strlen($day) == 1) {
			$padday = "0" . $day;
		}
		else {
			$padday = $day;
		}

		$daysmonth = date("t",strtotime("01 " . $lang['SCalendar']['MonthNames'][$padmonth] . " $year"));
		$firstday = date("w",strtotime("01 " . $lang['SCalendar']['MonthNames'][$padmonth] . " $year"));

		$dateset = $year . "-" . $month . "-" . $day;
		$datesplit = explode ("-", $dateset);
		$currentyear = $datesplit[0];
		$currentmonth = $datesplit[1];
		$currentday = $datesplit[2];

		$date = "$padmonth-$padday-$year";
		$daymod = 1;

		$currentdate = $lang['SCalendar']['MonthNames'][$month] . " " . $year;

		$Calendar_temp .= "<tr>";
		$weektemp = str_replace("[week_number]", date ("W", strtotime("01 " . $lang['SCalendar']['MonthNames'][$padmonth] . " $year")), $cellwk);
		$Calendar_temp .= $weektemp;
		unset ($weektemp);

		for ($i = 1; $i < $daysmonth + $firstday + $daymod; $i++) {

			$a = $i - $firstday + 1 - $daymod;
			$day = $i - $firstday + 1 - $daymod;
			if (strlen($a) == 1) {
				$a = "0$a";
			}
			if (($i < $firstday) || ($a == "00")) { 
				if ($full == 1) {
					$CellTemp = str_replace ("[calendar_cell]", "CalendarInActive", $PageCalCell);
				}
				else {
					$CellTemp = str_replace ("[calendar_cell]", '', $PageCalCell);
				}
				$CellTemp = str_replace ("[calendar_day]", "", $CellTemp);
				$CellTemp = str_replace ("[calendar_events]", "", $CellTemp);
				$Calendar_temp .= $CellTemp;
			}
			else {
				if (($padday == $a) && ($month == $localmonth) && ($full == 1)) {
					$CalClass = "CalendarActive";
				}
				elseif ($full == 1) {
					$CalClass = "CalendarInActive";
				}

				// We have to check both the upper end and the lower end of the day
				$DateToCheck = "$year-$padmonth-$a";
				$DateToCheck2 = "$year-$padmonth-$a 00:00:00";
				$CheckDay = $MySQLConnection->DB_CalDateCheck($DateToCheck);

				$CellTemp = str_replace ("[calendar_cell]", $CalClass, $PageCalCell);
				if (is_array($CheckDay) && $full <> 1) {
					$CellTemp = str_replace ("[calendar_day]", "<b>" . $a . "</b>", $CellTemp);
				}
				else {
					$CellTemp = str_replace ("[calendar_day]", $a, $CellTemp);
				}

				$BuildList = "";

				if (is_array($CheckDay) && $full == 1) {
					while(list($key, $value) = each($CheckDay)) {
						if (strlen($CheckDay[$key]['startminute']) == 1) {
							$CheckDay[$key]['startminute'] = "0" . $CheckDay[$key]['startminute'];
						}
						if (strlen($CheckDay[$key]['endminute']) == 1) {
							$CheckDay[$key]['endminute'] = "0" . $CheckDay[$key]['endminute'];
						}

						$BuildList .= "<a href=\"calendar.php?mode=edit&amp;id=" . $key . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\" class=\"CalendarEvent\">";
						if (($CheckDay[$key]['startdate'] <> "$a/$padmonth/$yearshort") && ($CheckDay[$key]['enddate'] <> "$a/$padmonth/$yearshort")) {
							$BuildList .=  $lang['SCalendar']['AllDayEvent'] . "<br />";
						}
						else {
							if ($CheckDay[$key]['startdate'] <> "$a/$padmonth/$yearshort") {
								$BuildList .= $CheckDay[$key]['startdate'] . " - ";
							}
							else {
								$BuildList .= $CheckDay[$key]['starthour'] . ":" . $CheckDay[$key]['startminute'] . " - ";
							}
							if ($CheckDay[$key]['enddate'] <> "$a/$padmonth/$yearshort") {
								$BuildList .= $CheckDay[$key]['enddate'] . "<br />";
							}
							else {
								$BuildList .= $CheckDay[$key]['endhour'] . ":" . $CheckDay[$key]['endminute'] . "<br />";
							}
						}
						$BuildList .= $CheckDay[$key]['subject'] . "</a><br />";
					}
				}

				$CellTemp = str_replace ("[calendar_events]", $BuildList, $CellTemp);
				$Calendar_temp .= $CellTemp;

				if (($i%7) == 0) {
					$Calendar_temp .= "</tr><tr>\n";
					if (($month == 1 || $month == 3 || $month == 5 || $month == 7 || $month == 8 || $month == 10 || $month == 12) && ($a+1 <= 31)) {
						$weektemp = str_replace("[week_number]", date ("W", strtotime($a + 2 . $lang['SCalendar']['MonthNames'][$padmonth] . " $year")), $cellwk);
						$Calendar_temp .= $weektemp;
						unset ($weektemp);
					}
					elseif (($month == 4 || $month == 6 || $month == 9 || $month == 11) && ($a+1 <= 30)) {
						$weektemp = str_replace("[week_number]", date ("W", strtotime($a + 2 . $lang['SCalendar']['MonthNames'][$padmonth] . " $year")), $cellwk);
						$Calendar_temp .= $weektemp;
						unset ($weektemp);
					}
					elseif (($month == 2) && ($a+1 <= $daysmonth)) {
						$weektemp = str_replace("[week_number]", date ("W", strtotime($a + 2 . $lang['SCalendar']['MonthNames'][$padmonth] . " $year")), $cellwk);
						$Calendar_temp .= $weektemp;
						unset ($weektemp);
					}
				}
			}
		}

		if (($i%7) != 1) {
			$Calendar_temp .= "</tr><tr>\n";
		}

		$Calendar_temp .= "</tr>";
		return $Calendar_temp;
}

if ($UseDatabase == 1 && $EnableCalendar == 1) {

	if ($MySQLMakeConnection) {
		$MySQLID = $MySQLConnection->DB_CheckUser($_SESSION['currentemailaddress'], $_SESSION['sess_p']);
	}

	if ($mode == "view") {
		// Default view to view calendar for this month
		$PageCal = $getFile->fileRead('calendar_month');
		$PageCalCell = $getFile->fileRead('calendar_cell');
		$PageCalCellSmall = $getFile->fileRead('calendar_smallcell');
		$PageCalWeek = $getFile->fileRead('calendar_weeknumber');
		$PageCalMenu = $getFile->fileRead('calendar_menu');

		// Make sure all dates are in GMT/UTC so we can apply a timezone to them later
		$gmtdate = gmdate("Y-m-d H:i:s");

		$datetimestamp = strtotime($gmtdate);

		// Now we apply a timezone shift to get the current day
		$localtimestamp = $datetimestamp + ($tz * 60);

		$year = strftime ("%Y", $localtimestamp);
		$currentyear = strftime ("%Y", $localtimestamp);
		$yearshort = strftime ("%y", $localtimestamp);
		$month = strftime ("%m", $localtimestamp);
		$localmonth = strftime ("%m", $localtimestamp);
		$day = strftime ("%d", $localtimestamp);

		if (($_GET['year']) || ($_GET['month'])) {
			$year = $_GET['year'];
			$month = $_GET['month'];
		}

		$currentdate = $lang['SCalendar']['MonthNames'][$month] . " " . $year;

		$Calendar_temp = DrawMonth($day, $localmonth, $month, $year, $yearshort, 1, $PageCalCell, $PageCalCellSmall, $PageCalWeek, $lang, $MySQLConnection, $MainSettings);


		if ($month == 12) {
			$pyear = $year + 1;
			$nextmonthlink = "<a href=\"calendar.php?year=" . $pyear . "&amp;month=01" . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SCalendar']['MonthNames'][1] . " " . $pyear . "</a>";
			$PageCal = str_replace("[calendar_nextyear]", $pyear, $PageCal);
			$PageCal = str_replace("[calendar_nextmonth]", '01', $PageCal);
			$NextMonth_temp = DrawMonth($day, $localmonth, '01', $pyear, $yearshort, 0, $PageCalCell, $PageCalCellSmall, $PageCalWeek, $lang, $MySQLConnection, $MainSettings);
		}
		else {
			$pmonth = $month + 1;
			if (strlen($pmonth) == 1) {
				$pmonth = "0$pmonth";
			}
			$nextmonthlink = "<a href=\"calendar.php?year=" . $year . "&amp;month=" . $pmonth . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SCalendar']['MonthNames'][$pmonth] . " " . $year . "</a>";
			$PageCal = str_replace("[calendar_nextyear]", $year, $PageCal);
			$PageCal = str_replace("[calendar_nextmonth]", $pmonth, $PageCal);
			$NextMonth_temp = DrawMonth($day, $localmonth, $pmonth, $year, $yearshort, 0, $PageCalCell, $PageCalCellSmall, $PageCalWeek, $lang, $MySQLConnection, $MainSettings);
		}

		if ($month == 1) {
			$pyear = $year - 1;
			$prevmonthlink = "<a href=\"calendar.php?year=" . $pyear . "&amp;month=12" . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SCalendar']['MonthNames'][12] . " " . $pyear . "</a>";
			$PageCal = str_replace("[calendar_previousyear]", $pyear, $PageCal);
			$PageCal = str_replace("[calendar_previousmonth]", '12', $PageCal);
			$PrevMonth_temp = DrawMonth($day, $localmonth, '12', $pyear, $yearshort, 0, $PageCalCell, $PageCalCellSmall, $PageCalWeek, $lang, $MySQLConnection, $MainSettings);
		}
		else {
			$pmonth = $month - 1;
			if (strlen($pmonth) == 1) {
				$pmonth = "0$pmonth";
			}
			$prevmonthlink = "<a href=\"calendar.php?year=" . $year . "&amp;month=" . $pmonth . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . "\">" . $lang['SCalendar']['MonthNames'][$pmonth] . " " . $year . "</a>";
			$PageCal = str_replace("[calendar_previousyear]", $year, $PageCal);
			$PageCal = str_replace("[calendar_previousmonth]", $pmonth, $PageCal);
			$PrevMonth_temp = DrawMonth($day, $localmonth, $pmonth, $year, $yearshort, 0, $PageCalCell, $PageCalCellSmall, $PageCalWeek, $lang, $MySQLConnection, $MainSettings);
		}


		$PageCal = str_replace("[lang=SunInitial]", $lang['SCalendar']['DayAbbrev'][1], $PageCal);
		$PageCal = str_replace("[lang=MonInitial]", $lang['SCalendar']['DayAbbrev'][2], $PageCal);
		$PageCal = str_replace("[lang=TueInitial]", $lang['SCalendar']['DayAbbrev'][3], $PageCal);
		$PageCal = str_replace("[lang=WedInitial]", $lang['SCalendar']['DayAbbrev'][4], $PageCal);
		$PageCal = str_replace("[lang=ThuInitial]", $lang['SCalendar']['DayAbbrev'][5], $PageCal);
		$PageCal = str_replace("[lang=FriInitial]", $lang['SCalendar']['DayAbbrev'][6], $PageCal);
		$PageCal = str_replace("[lang=SatInitial]", $lang['SCalendar']['DayAbbrev'][7], $PageCal);


		$PageCal = str_replace("[calendar_cells]", $Calendar_temp, $PageCal);
		$PageCal = str_replace("[calendar_menu]", $PageCalMenu, $PageCal);

		$PageCal = str_replace("[calendar_previous]", $prevmonthlink, $PageCal);
		$PageCal = str_replace("[calendar_next]", $nextmonthlink, $PageCal);

		$PageCal = str_replace("[calendarnext_cells]", $NextMonth_temp, $PageCal);
		$PageCal = str_replace("[calendarprevious_cells]", $PrevMonth_temp, $PageCal);

		$PageCal = str_replace("[calendar_date]", $currentdate, $PageCal);

		$BuildMonthList = "<select name=\"month\">\n";
		for ($i=1; $i<=12; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildMonthList .= "<option value=\"$ia\"";
			if ($ia == $localmonth) {
				$BuildMonthList .= " selected=\"selected\"";
			}
			$BuildMonthList .= ">" . $lang['SCalendar']['MonthNames'][$ia] . "</option>\n";
		}
		$BuildMonthList .= "</select> \n";

		$BuildYearList = "<select name=\"year\">\n";
		for ($i=2000; $i<=2020; $i++) {
			$BuildYearList .= "<option value=\"$i\"";
			if ($i == $currentyear) {
				$BuildYearList .= " selected=\"selected\"";
			}
			$BuildYearList .= ">$i</option>\n";
		}
		$BuildYearList .= "</select>\n";

		$PageCal = str_replace ("[month_list]", $BuildMonthList, $PageCal);
		$PageCal = str_replace ("[year_list]", $BuildYearList, $PageCal);

		$PageCal = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageCal);
		$PageCal = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageCal);
		$PageCal = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageCal);
		$PageCal = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageCal);
		$PageCal = LangReplace('SCalendar', $PageCal, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageCal;
		echo $PageFooter;
	}

	elseif ($mode == "edit") {
		// Add, Edit or view and entry from the database

		$PageCal = $getFile->fileRead('calendar_entry');
		$PageCalMenu = $getFile->fileRead('calendar_menu');
		$id = strip_tags($_GET['id']);

		if ($id && $MySQLMakeConnection) {
			$cal_entrydetails = $MySQLConnection->DB_GetCalDetails($id);
		}

		$PageCal = str_replace ("[calendar_subject]", "<input type=\"text\" name=\"subject\" value=\"" . $cal_entrydetails['subject'] . "\" maxlength=\"100\" size=\"50\" />", $PageCal);
		$PageCal = str_replace ("[calendar_location]", "<input type=\"text\" name=\"location\" value=\"" . $cal_entrydetails['location'] . "\" maxlength=\"100\" size=\"50\" />", $PageCal);
		$PageCal = str_replace ("[calendar_url]", "<input type=\"text\" name=\"url\" value=\"" . $cal_entrydetails['url'] . "\" maxlength=\"100\" size=\"50\" />", $PageCal);
		$PageCal = str_replace ("[calendar_invite]", "<input type=\"text\" name=\"invite\" value=\"" . $cal_entrydetails['attendees'] . "\" maxlength=\"100\" size=\"50\" />", $PageCal);

		if ($id) {
			if (empty($cal_entrydetails['uid'])) {
				$updateuid = $MySQLConnection->DB_AddUID("DWM" . str_replace(" ", "", str_replace(".", "", $version)) . time(), $id);
			}

			$startday = $cal_entrydetails['startday'];
			$startmonth = $cal_entrydetails['startmonth'];
			$startyear = $cal_entrydetails['startyear'];
			$starthour = $cal_entrydetails['starthour'];
			$startminute = $cal_entrydetails['startminute'];

			$endday = $cal_entrydetails['endday'];
			$endmonth = $cal_entrydetails['endmonth'];
			$endyear = $cal_entrydetails['endyear'];
			$endhour = $cal_entrydetails['endhour'];
			$endminute = $cal_entrydetails['endminute'];
		}
		else {
			// Make sure all dates are in GMT/UTC so we can apply a timezone to them later
			$gmtdate = gmdate("Y-m-d H:i:s");

			$datetimestamp = strtotime($gmtdate);

			// Now we apply a timezone shift to get the current day
			$localtimestamp = $datetimestamp + ($tz * 60);

			$startyear = strftime ("%Y", $localtimestamp);
			$startmonth = strftime ("%m", $localtimestamp);
			$startday = strftime ("%d", $localtimestamp);
			$starthour = strftime ("%H", $localtimestamp);
			$startminute = "00";

			$endyear = strftime ("%Y", $localtimestamp);
			$endmonth = strftime ("%m", $localtimestamp);
			$endday = strftime ("%d", $localtimestamp);
			$endhour = strftime ("%H", $localtimestamp);
			$endminute = "30";
		}

		// Build the start time fields

		$BuildStartDate = "<select name=\"starttime_day\">\n";
		for ($i=1; $i<=31; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildStartDate .= "<option value=\"$ia\"";
			if ($ia == $startday) {
				$BuildStartDate .= " selected=\"selected\"";
			}
			$BuildStartDate .= ">$ia</option>\n";
		}
		$BuildStartDate .= "</select>\n";

		$BuildStartDate .= "<select name=\"starttime_month\">\n";
		for ($i=1; $i<=12; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildStartDate .= "<option value=\"$ia\"";
			if ($ia == $startmonth) {
				$BuildStartDate .= " selected=\"selected\"";
			}
			$BuildStartDate .= ">" . $lang['SCalendar']['MonthNames'][$ia] . "</option>\n";
		}
		$BuildStartDate .= "</select>\n";

		$BuildStartDate .= "<select name=\"starttime_year\">\n";
		for ($i=2000; $i<=2020; $i++) {
			$BuildStartDate .= "<option value=\"$i\"";
			if ($i == $startyear) {
				$BuildStartDate .= " selected=\"selected\"";
			}
			$BuildStartDate .= ">$i</option>\n";
		}
		$BuildStartDate .= "</select>\n";

		$BuildStartTime = "<select name=\"starttime_time\">\n";
		for ($i=0; $i<24; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildStartTime .= "<option value=\"$ia:00\"";
			if ($ia == $starthour && $startminute == '00') {
				$BuildStartTime .= " selected=\"selected\"";
			}
			$BuildStartTime .= ">$ia:00</option>\n";

			$BuildStartTime .= "<option value=\"$ia:30\"";
			if ($ia == $starthour && $startminute == '30') {
				$BuildStartTime .= " selected=\"selected\"";
			}
			$BuildStartTime .= ">$ia:30</option>\n";
		}
		$BuildStartTime .= "</select>\n";

		// Build the end time fields

		$BuildEndDate = "<select name=\"endtime_day\">\n";
		for ($i=1; $i<=31; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildEndDate .= "<option value=\"$ia\"";
			if ($ia == $endday) {
				$BuildEndDate .= " selected=\"selected\"";
			}
			$BuildEndDate .= ">$ia</option>\n";
		}
		$BuildEndDate .= "</select>\n";

		$BuildEndDate .= "<select name=\"endtime_month\">\n";
		for ($i=1; $i<=12; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildEndDate .= "<option value=\"$ia\"";
			if ($ia == $endmonth) {
				$BuildEndDate .= " selected=\"selected\"";
			}
			$BuildEndDate .= ">" . $lang['SCalendar']['MonthNames'][$ia] . "</option>\n";
		}
		$BuildEndDate .= "</select>\n";

		$BuildEndDate .= "<select name=\"endtime_year\">\n";
		for ($i=2000; $i<=2020; $i++) {
			$BuildEndDate .= "<option value=\"$i\"";
			if ($i == $endyear) {
				$BuildEndDate .= " selected=\"selected\"";
			}
			$BuildEndDate .= ">$i</option>\n";
		}
		$BuildEndDate .= "</select>\n";

		$BuildEndTime = "<select name=\"endtime_time\">\n";
		for ($i=0; $i<24; $i++) {
			if (strlen($i) == 1) {
				$ia = "0$i";
			}
			else {
				$ia = $i;
			}
			$BuildEndTime .= "<option value=\"$ia:00\"";
			if ($ia == $endhour && $endminute == '00') {
				$BuildEndTime .= " selected=\"selected\"";
			}
			$BuildEndTime .= ">$ia:00</option>\n";

			$BuildEndTime .= "<option value=\"$ia:30\"";
			if ($ia == $endhour && $endminute == '30') {
				$BuildEndTime .= " selected=\"selected\"";
			}
			$BuildEndTime .= ">$ia:30</option>\n";
		}
		$BuildEndTime .= "</select>\n";	

		if (!empty($id)) {
			$PageCal = str_replace("[ifentry]", "", $PageCal);
			$PageCal = str_replace("[/ifentry]", "", $PageCal);
			$PageCal = preg_replace("/(\[)(ifnew)(])(\r\n)*(.*)(\[\/ifnew\])/siU", "", $PageCal);
		}
		else {
			$PageCal = preg_replace("/(\[)(ifentry)(])(\r\n)*(.*)(\[\/ifentry\])/siU", "", $PageCal);
			$PageCal = str_replace("[ifnew]", "", $PageCal);
			$PageCal = str_replace("[/ifnew]", "", $PageCal);
		}
		if ($EnableContacts == 1 && $UseDatabase == 1) {
			$PageCal = str_replace("[ifcontacts]", "", $PageCal);
			$PageCal = str_replace("[/ifcontacts]", "", $PageCal);
		}
		else {
			$PageCal = preg_replace("/(\[)(ifcontacts)(])(\r\n)*(.*)(\[\/ifcontacts\])/siU", "", $PageCal);
		}
		if (is_array($cal_entrydetails['attendees']) && sizeof($cal_entrydetails['attendees']) >= 1) {
			$PageCal = str_replace("[ifattendees]", "", $PageCal);
			$PageCal = str_replace("[/ifattendees]", "", $PageCal);
			for ($i=0;$i<sizeof($cal_entrydetails['attendees']);$i++) {
				$buildattendees .= "&quot;" . $cal_entrydetails['attendees'][$i]['name'] . "&quot; &lt;" . $cal_entrydetails['attendees'][$i]['email'] . "&gt; - " . $lang['SCalendar']['Status' . str_replace(" ", "+", $cal_entrydetails['attendees'][$i]['status'])] . "<br />";
			}
			$PageCal = str_replace("[calendar_attendees]", $buildattendees, $PageCal);
		}
		else {
			$PageCal = preg_replace("/(\[)(ifattendees)(])(\r\n)*(.*)(\[\/ifattendees\])/siU", "", $PageCal);
		}
		
		$PageCal = str_replace ("[calendar_starttime]", $BuildStartTime, $PageCal);
		$PageCal = str_replace ("[calendar_endtime]", $BuildEndTime, $PageCal);
		$PageCal = str_replace ("[calendar_startdate]", $BuildStartDate, $PageCal);
		$PageCal = str_replace ("[calendar_enddate]", $BuildEndDate, $PageCal);

		$PageCal = str_replace ("[calendar_id]", $id, $PageCal);

		$PageCal = str_replace ("[calendar_description]", "<textarea name=\"description\" style=\"width:500px; height:50px;\">" . $cal_entrydetails['description'] . "</textarea>", $PageCal);
		$PageCal = str_replace ("[calendar_hiddenfields]", "<input type=\"hidden\" name=\"id\" value=\"$id\" /><input type=\"hidden\" name=\"mode\" value=\"save\" />", $PageCal);

		$PageCal = str_replace("[calendar_menu]", $PageCalMenu, $PageCal);

		$PageCal = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageCal);
		$PageCal = str_replace ("[session_force]", "&amp;" . strip_tags(SID), $PageCal);
		$PageCal = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageCal);
		$PageCal = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageCal);
		$PageCal = LangReplace('SCalendar', $PageCal, $lang);

		header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
		echo $PageHeader;
		echo $PageCal;
		echo $PageFooter;
	}

	elseif ($mode == "icalendar") {
		// Export as an iCalendar file (RFC2445)
		$id = strip_tags($_REQUEST['id']);

		if ($id && $MySQLMakeConnection) {
			$cal_entrydetails = $MySQLConnection->DB_GetCalDetails($id);
		}

		// This generates an iCalendar version 2.0 (vCalendar version 1.0 not supported by DWmail)

		// Please note all dates and times are stored in the database in the user's current time zone.
		// i.e. if the user enters and appointment at 20:00 GMT and changes their timezone to GMT+1 then the appointment still remains 20:00

		$startday = $cal_entrydetails['startday'];
		$startmonth = $cal_entrydetails['startmonth'];
		$startyear = $cal_entrydetails['startyear'];
		$starthour = $cal_entrydetails['starthour'];
		$startminute = $cal_entrydetails['startminute'];

		$endday = $cal_entrydetails['endday'];
		$endmonth = $cal_entrydetails['endmonth'];
		$endyear = $cal_entrydetails['endyear'];
		$endhour = $cal_entrydetails['endhour'];
		$endminute = $cal_entrydetails['endminute'];

		// Convert to a UNIX timestamps
		$starttimestamp = strtotime ("$startyear$startmonth$startday $starthour$startminute00");
		$endtimestamp = strtotime ("$endyear$endmonth$endday $endhour$endminute00");

		// Force to GMT based on user's timezone entry
		$startGMTtimestamp = $starttimestamp + ($tz * 60);
		$endGMTtimestamp = $endtimestamp + ($tz * 60);

		require ('./includes/iCalendar.inc.php');
		$iCalendar = new iCal_Parse();
		$iCalendar->_dwmversion = $version;
		$BuildiCal = $iCalendar->BuildiCal($_SESSION, 'request', $startGMTtimestamp, $endGMTtimestamp, $cal_entrydetails['location'], $cal_entrydetails['subject'], $cal_entrydetails['description'], $cal_entrydetails['url'], '', '', $cal_entrydetails['uid']);
		$iCalendar->iCalDownload($cal_entrydetails['subject']);

	}

	elseif ($mode == "save") {
		// Save and entry to the database

		$id = strip_tags($_POST['id']);
		$submitteddetails['subject'] = strip_tags(addslashes($_POST['subject']));
		$submitteddetails['location'] = strip_tags(addslashes($_POST['location']));
		$submitteddetails['description'] = strip_tags(addslashes($_POST['description']));
		$submitteddetails['url'] = strip_tags(addslashes($_POST['url']));

		$submitteddetails['starttime'] = strip_tags($_POST['starttime_year']) . "-" . strip_tags($_POST['starttime_month']) . "-" . strip_tags($_POST['starttime_day']) . " " . strip_tags($_POST['starttime_time']) . ":00";
		$submitteddetails['endtime'] = strip_tags($_POST['endtime_year']) . "-" . strip_tags($_POST['endtime_month']) . "-" . strip_tags($_POST['endtime_day']) . " " . strip_tags($_POST['endtime_time']) . ":00";
		
		if ($id <> "" && $MySQLMakeConnection) {
			$cal_addentry = $MySQLConnection->DB_CalUpdateEntry($id, $submitteddetails);
		}
		else {
			$submitteddetails['uid'] = "DWM" . str_replace(" ", "", str_replace(".", "", $version)) . time();
			require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/compose.inc.php");

			$invite = $MainSettings->CheckSlashes(trim($_POST['invite']));
			$invite = str_replace("&quot;", '"', $invite);
			$invite = str_replace(";", ",", $invite);
			$invite_array  = imap_rfc822_parse_adrlist($invite, $DefaultDomain);
			$recipientcount = count ($invite_array);

			$allowemail = 0;

			if (!isset($_SESSION['lastemail'])) {
				$_SESSION['lastemail'] = time();
				$allowemail = 1;
			}
			else {
				if ((time() - $_SESSION['lastemail']) >= $floodfilter) {
					$_SESSION['lastemail'] = time();
					$allowemail = 1;
				}
			}

			// Flood check handler
			if ($allowemail == 0 && $recipientcount >= 1) {
				$error_floodfilter = $lang['SCompose']['FloodFilter'];
				$error_floodfilter = str_replace("[floodfilter]", $floodfilter, $error_floodfilter);
				$errormessage = $error_floodfilter;
			}

			// Maximum recipient handler
			elseif ($recipientcount > $recipientmaximum) {
				$errormessage = $lang['SCompose']['RecipientMaximum'];
				$errormessage = str_replace("[recipientmaximum]", $recipientmaximum, $errormessage);
			}
			// No recipients to email
			elseif ($recipientcount == 0) {
			}

			else {

			$users = array();

			unset ($invite);
			$i = 0;

			require_once("./includes/mime.inc.php");
			$MIMEChecker = new MIME();

			if (is_array($invite_array)) {
				for($key=0; $key<sizeof($invite_array); $key++) {
					if (($invite_array[$key]->mailbox <> "" && substr($invite_array[$key]->mailbox, 0, 6) <> "group:" && $invite_array[$key]->host <> "") && ($invite_array[$key]->mailbox <> "INVALID_ADDRESS" && $invite_array[$key]->host <> ".SYNTAX-ERROR")) {
						if ($key <> 0) {
							$invite .= ", ";
						}
						if ($invite_array[$key]->personal <> "") {
							$checkordname = $MIMEChecker->check8bit($invite_array[$key]->personal);
							if ($checkordname == TRUE) {
								$invite .= $MIMEChecker->RFCEncode($invite_array[$key]->personal, $_SESSION['DefaultCharSet']) . " ";
							}
							else {
								$invite .= "\"" . $invite_array[$key]->personal . "\" ";
							}
							unset ($checkordname);
						}
						$invite .= "<" . $invite_array[$key]->mailbox . "@" . $invite_array[$key]->host . ">";
						$attendees[$i] = $invite_array[$key]->mailbox . "@" . $invite_array[$key]->host;
						$users[$i]['email'] = $invite_array[$key]->mailbox . "@" . $invite_array[$key]->host;
						$users[$i]['name'] = $invite_array[$key]->personal;

					}
					elseif (substr($invite_array[$key]->mailbox, 0, 6) == "group:") {
						// We have found a group
						// At the moment, unfortunately we assume that details parsed from the database are in valid RFC format
						$groupname = substr($invite_array[$key]->mailbox, 6);
						$grouplisting = $MySQLConnection->DB_FindGroup($groupname);
						if ($grouplisting) {
							while(list($key, $value) = each($grouplisting)) {
								if (isset($invite) && $invite <> '') {
									$invite .= ", ";
								}
								$checkordname = $MIMEChecker->check8bit($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname']);
								if ($checkordname == TRUE) {
									$invite .= $MIMEChecker->RFCEncode($grouplisting[$key]['firstname'] . ' ' . $grouplisting[$key]['lastname'], $_SESSION['DefaultCharSet']) . " ";
								}
								else {
									$invite .= "\"" . $grouplisting[$key]['firstname'] . " " . $grouplisting[$key]['lastname'] . "\" ";
								}
								$invite .= "<" . $grouplisting[$key]['email'] . ">";
								$attendees[$i] = $grouplisting[$key]['email'];
								$users[$i]['email'] = $grouplisting[$key]['email'];
								$users[$i]['name'] = $grouplisting[$key]['firstname'] . " " . $grouplisting[$key]['lastname'];
							}
						}
						else {
							// Group does not exist
							$errormessage = str_replace("[groupname]", $groupname, $lang['SContacts']['GroupSendError']);
						}
					}
					$i++;
				}
			}
			// Reset to array for SMTP sending
			unset ($invite_array);
			$invite_array = imap_rfc822_parse_adrlist($invite, $DefaultDomain);

			// Convert to a UNIX timestamps
			$starttimestamp = strtotime (strip_tags($_POST['starttime_year']) . strip_tags($_POST['starttime_month']) . strip_tags($_POST['starttime_day']) . " " . strip_tags(str_replace(":", "", $_POST['starttime_time'])));
			$endtimestamp = strtotime (strip_tags($_POST['endtime_year']) . strip_tags($_POST['endtime_month']) . strip_tags($_POST['endtime_day']) . " " . strip_tags(str_replace(":", "", $_POST['endtime_time'])));

			// Force to GMT based on user's timezone entry
			$startGMTtimestamp = $starttimestamp + ($tz * 60);
			$endGMTtimestamp = $endtimestamp + ($tz * 60);

			require ('./includes/iCalendar.inc.php');
			$iCalendar = new iCal_Parse();
			$iCalendar->_dwmversion = $version;
			$iCalendar->_crlf = $crlf;
			$BuildiCal = $iCalendar->BuildiCal($_SESSION, 'request', $startGMTtimestamp, $endGMTtimestamp, $submitteddetails['location'], $submitteddetails['subject'], $submitteddetails['description'], $submitteddetails['url'], $attendees, '', $submitteddetails['uid']);

			if (($DWmailMode == 1) && ($UseSMTP == 1)) {
				require ("./includes/smtp.inc.php");
				$SMTPConnection = new WM_SMTPConnection($_SESSION);
				$SMTPConnection->_helodomain = $HELOServerName;
				$smtpconnect = $SMTPConnection->WM_SMTPConnect($DefaultSMTP);
				if (!$smtpconnect) {
					$smtperror[] = "Failed to connect to SMTP server: $DefaultSMTP";
				}
				$smtphelo = $SMTPConnection->WM_HELO();
				if (!$smtphelo) {
					$smtperror[] = "HELO to SMTP server failed";
				}
				if ($UseSMTPAuth == 1) {
					$smtpauth = $SMTPConnection->WM_SMTPAuth();
					if (!$smtpauth) {
						$smtperror[] = "Authentication to SMTP server failed";
					}
				}
				$smtpfrom = $SMTPConnection->WM_EnvelopeFROM($_SESSION['currentemailaddress']);
				if (!$smtpfrom) {
					$smtperror[] = "Could not set From address";
				}
				if (is_array($invite_array)) {
				for($key=0; $key<sizeof($invite_array); $key++) {
					if (($invite_array[$key]->mailbox <> "" && $invite_array[$key]->host <> "") && ($invite_array[$key]->mailbox <> "INVALID_ADDRESS" && $invite_array[$key]->host <> ".SYNTAX-ERROR")) {
						$smtpinvite = $SMTPConnection->WM_EnvelopeTO($invite_array[$key]->mailbox . "@" . $invite_array[$key]->host);
						if (!$smtpinvite) {
							$smtperror[] = "Could not set To address";
						}
					}
				}
				}

				$sendemail = $IMAPConnection->WM_IMAPBuildEmail($smtpinvite, '', '', '', $submitteddetails['subject'], $BuildiCal, '', '', 0, 'text', '', '', $_SESSION['currentemailaddress'], 1, $pname, '', 'text/calendar; method=REQUEST');

				// Make sure all new lines are \n and then force all \n to \r\n
				// to strip and bare line feeds (as SMTP will not allow this)
				$sendemail['header'] = str_replace ("\r\n", "\n", $sendemail['header']);
				$sendemail['header'] = str_replace ("\n", "\r\n", $sendemail['header']);

				$sendemail['message'] = str_replace ("\r\n", "\n", $sendemail['message']);
				$sendemail['message'] = str_replace ("\n", "\r\n", $sendemail['message']);

				$emailsent = $SMTPConnection->WM_Data($sendemail['header'] . "\r\n" . $sendemail['message']);
				if (!$emailsent) {
					$smtperror[] = "Could not send header and body of message";
					$emailsent = $smtperror;
				}

				$smtpclose = $SMTPConnection->WM_SMTPClose();

				// If you wish to see the SMTP communication logs then you can uncomment the next line (useful for debugging)
				// echo ($SMTPConnection->_smtplog);
			}
			else {
				// Build the email first
				$sendemail = $IMAPConnection->WM_IMAPBuildEmail($invite, '', '', '', $submitteddetails['subject'], $BuildiCal, '', '', 0, 'text', '', '', $_SESSION['currentemailaddress'], 0, $pname, '', 'text/calendar; method=REQUEST');

				// This bit actually calls the sendmail routine
				$emailsent = $IMAPConnection->WM_IMAPSendMail($sendemail);
			}

			}

			$cal_addentry = $MySQLConnection->DB_CalNewEntry($submitteddetails);
			$cal_addrecipients = $MySQLConnection->DB_CalNewRecipients($users, $cal_addentry);
		}

		if ($cal_addentry == TRUE) {
			header ("Location: calendar.php?month=" . strip_tags($_POST['starttime_month']) . "&year=" . strip_tags($_POST['starttime_year']) . "&mode=view&" . strip_tags(SID));
		}
	}

	elseif ($mode == "delete") {
		// Delete an entry from the database

		$id = strip_tags($_GET['id']);

		if ($id && $MySQLMakeConnection) {
			$cal_deleteentry = $MySQLConnection->DB_CalDeleteEntry($id);
		}

		if ($cal_deleteentry == TRUE) {
			header ("Location:calendar.php?mode=view&" . strip_tags(SID));
		}
	}
	$MySQLCloseConnection = $MySQLConnection->DB_CloseConnection();

}
else {
	$PageGenericMessage = $getFile->fileRead('generic_message');
	$PageGenericMessage = str_replace("[pagetitle]", "Calendar", $PageGenericMessage);
	$returnmessage = $lang['SCalendar']['Error'];
	$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;
	echo $PageGenericMessage;
	echo $PageFooter;
}

$IMAPConnection->WM_IMAPClose();
?>
