<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/mailbox.inc.php");

require ("./includes/options.inc.php");

$action = $_GET['action'];
if ($action == "purge") {
	$oldfolder2 = $_SESSION['folder'];
	$_SESSION['folder'] = $IMAPTrash;
}

$DefaultTemplate = strip_tags(trim($DefaultTemplate));

$getFile = new fileProperties($DefaultTemplate);
$PageHeader = $getFile->fileRead('header');
$PageFooter = $getFile->fileRead('footer');
$PageCopyright = $getFile->fileRead('copyright');
$PageDelete = $getFile->fileRead('delete');
$PageDeleteList = $getFile->fileRead('deletelist');
$PageMenu = $getFile->fileRead('menu');

$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

$PageDelete = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDelete);
$PageDelete = str_replace("[session_force]", "&amp;" . strip_tags(SID), $PageDelete);
$PageDelete = str_replace("[message_folder]", urlencode($_SESSION['folder']), $PageDelete);

$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
$PageHeader = str_replace("[pagetitle]", " - " . $lang['SDelete']['Title'], $PageHeader);
$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

if ($AllowExternal == 1 && $UseDatabase == 1) {
	$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
	$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
	$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
	$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
}
else {
	$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
	$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
}

$genericerror = $getFile->fileRead('generic_message');
$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

$IMAPConnection = new WM_IMAPConnection($_SESSION);
$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

$mailbox = $IMAPConnection->WM_IMAPConnect();

checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

include ("./includes/folderpane.inc.php");
$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
$PageHeader = LangReplace('Generic', $PageHeader, $lang);
$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
$PageFooter = LangReplace('Generic', $PageFooter, $lang);
$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
echo $PageHeader;

$numberofmessages = $IMAPConnection->WM_IMAPNumMessages();
$sortmessages = $IMAPConnection->WM_IMAPList(1, $numberofmessages);
$deletesummary = $lang['SDelete']['DeleteAll'];

$currrow = 1;

if ($_GET['f']) {
	$_SESSION['folder'] = strip_tags(trim($_GET['f']));
}

$bypassconfirm = 0;
if (($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") && ($UseTrash == 1) && ($_SESSION['folder'] <> $IMAPTrash)) {
	$bypassconfirm = 1;
}

if ($sortmessages <> "") {

	while(list($key, $value) = each($sortmessages)) { 

		if ($currrow == 1) {
			$classid = "col1";
			$currrow = 2;
		}
		else {
			$classid = "col2";
			$currrow = 1;
		}

		$IMAPConnection->WM_IMAPGetHeader($sortmessages[$key]['message_uid']);
		$headerdetails = $IMAPConnection->WM_IMAPFullHeaders();

		$subj = $IMAPConnection->WM_IMAPGetSubject();

		$CodeSearch = array (
			"[message_number]",
			"[message_from]",
			"[message_title]",
			"[message_date]",
			"[session]",
			"[rowcolour]"
		);

		$CodeReplace = array (
			$sortmessages[$key]['message_uid'],
			htmlentities(ereg_replace('<([^>]|\n)*>', '', $headerdetails['fromaddress']), ENT_QUOTES),
			$subj,
			$headerdetails['date'],
			$MainSettings->SessAppend_noecho($TransIDEnabled, 1),
			$classid
		);

		$CurrentMessage = str_replace ($CodeSearch, $CodeReplace, $PageDeleteList);
		$FullList .= $CurrentMessage;
		$HiddenFields .= "<input type=\"hidden\" name=\"selection[" . $sortmessages[$key]['message_uid'] . "]\" value=\"1\" />";
	}
	$CurrentDelete = str_replace ("[messagelist]", $FullList, $PageDelete);
	$CurrentDelete = str_replace("[deletesummary]", $deletesummary, $CurrentDelete);

	$CurrentDelete = str_replace("[hiddenfields]", $HiddenFields, $CurrentDelete);

	$CurrentDelete = LangReplace('SDelete', $CurrentDelete, $lang);
	$CurrentDelete = LangReplace('SMbox', $CurrentDelete, $lang);
	echo $CurrentDelete;
}

$IMAPConnection->WM_IMAPClose();

echo $PageFooter;
?>