<?php
/*
############################################################################

############################################################################
*/

// This include sets the contents of the folder pane to $PageFolderPane
// 
// This include must be called after an IMAP connection has been made
// and before $PageHeader is echoed

// If for some reason the folder tree is messing up and producing unexpected
// results, simply set this next variable to 0 to use a non-indented method
// of displaying folders
$fancyfolders = 1;

if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
	$IMAPConnection->_folderdelimiter = $DefaultDelimiter;
	$IMAPConnection->_IMAPSentMailFolder = $IMAPSentMail;
	$IMAPConnection->_IMAPTrashFolder = $IMAPTrash;
	$IMAPConnection->_IMAPDraftsFolder = $IMAPDrafts;
	$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
	$folders = $IMAPConnection->_folders;

	$refreshfolderlist = 0;

	if ($IMAPSubscriptions == 1 && $initiallogin == 1) {
		// Search to see if INBOX is subscribed to... if not, subscribe to it
		if ($IMAPConnection->_inboxfolderexist == 0) {
			$subscribeinbox = $IMAPConnection->WM_IMAPFolderSubscribe("INBOX", '');
			if ($subscribeinbox == TRUE) {
				$refreshfolderlist = 1;
			}
		}
		if ($IMAPConnection->_sentfolderexist == 0) {
			$createsent = $IMAPConnection->WM_IMAPFolderCreate($IMAPConnection->_IMAPSentMailFolder, '');
			$subscribesent = $IMAPConnection->WM_IMAPFolderSubscribe($IMAPConnection->_IMAPSentMailFolder, '');
			if ($subscribesent == TRUE) {
				$refreshfolderlist = 1;
			}
		}
		if ($IMAPConnection->_trashfolderexist == 0) {
			$createtrash = $IMAPConnection->WM_IMAPFolderCreate($IMAPConnection->_IMAPTrashFolder, '');
			$subscribetrash = $IMAPConnection->WM_IMAPFolderSubscribe($IMAPConnection->_IMAPTrashFolder, '');
			if ($subscribetrash == TRUE) {
				$refreshfolderlist = 1;
			}
		}
		if ($IMAPConnection->_draftsfolderexist == 0) {
			$createdrafts = $IMAPConnection->WM_IMAPFolderCreate($IMAPConnection->_IMAPDraftsFolder, '');
			$subscribedrafts = $IMAPConnection->WM_IMAPFolderSubscribe($IMAPConnection->_IMAPDraftsFolder, '');
			if ($subscribedrafts == TRUE) {
				$refreshfolderlist = 1;
			}
		}

	}
	elseif ($IMAPSubscriptions == 0 && $initiallogin == 1) {
		// Create special folders if they don't exist but don't subscribe
		if ($IMAPConnection->_sentfolderexist == 0) {
			$createsent = $IMAPConnection->WM_IMAPFolderCreate($IMAPConnection->_IMAPSentMailFolder, '');
			if ($createsent == TRUE) {
				$refreshfolderlist = 1;
			}
		}
		if ($IMAPConnection->_trashfolderexist == 0) {
			$createtrash = $IMAPConnection->WM_IMAPFolderCreate($IMAPConnection->_IMAPTrashFolder, '');
			if ($createtrash == TRUE) {
				$refreshfolderlist = 1;
			}
		}
		if ($IMAPConnection->_draftsfolderexist == 0) {
			$createdrafts = $IMAPConnection->WM_IMAPFolderCreate($IMAPConnection->_IMAPDraftsFolder, '');
			if ($createdrafts == TRUE) {
				$refreshfolderlist = 1;
			}
		}
	}

	if ($refreshfolderlist == 1) {
		// We have now updated this list so we need to update the folder list again
		$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
		$folders = $IMAPConnection->_folders;
	}

	sort($folders);
	$oldfolder = $_SESSION['folder'];
	$PageFolderPane = $getFile->fileRead('folderpane_imap');
	$PageFolderLinks = $getFile->fileRead('folderlinks');

	if ($fancyfolders == 1) {
		$PageFolderPane = str_replace ("[iffancyfolders]", '', $PageFolderPane);
		$PageFolderPane = str_replace ("[/iffancyfolders]", '', $PageFolderPane);
	}
	else {
		$PageFolderPane = preg_replace("/(\[)(iffancyfolders)(])(\r\n)*(.*)(\[\/iffancyfolders\])/siU", "", $PageFolderPane);
	}

	// Close current folder connection so we can halfopen to get all folder details at once
	$mailbox = $IMAPConnection->WM_IMAPClose();
	$mailbox = $IMAPConnection->WM_IMAPHalfConnect();

	$currentindent = 0;

	for($i=0; $i<count($folders); $i++) {
		$foldertemp = $PageFolderLinks;
		$imapstatus = $IMAPConnection->WM_IMAPStatus($folders[$i]['id']);
		$numberofmessages = $imapstatus->messages;
		$numberofnewmessages = $imapstatus->unseen;
		if ($numberofnewmessages > 0) {
			$numberofmessages .= " ($numberofnewmessages)";
		}

		$foldertemp = str_replace ("[folderid]", "?f=" . urlencode($folders[$i]['id']), $foldertemp);
		$foldertemp = str_replace ("[folderlocation]", "mailbox.php", $foldertemp);
		$foldertemp = str_replace ("[foldertotal]", $numberofmessages, $foldertemp);
		$folderid_arry[] = $folders[$i]['id'];

		$indentwidth = 17;
		$indentgraphics = '';

		if ($fancyfolders == 1) {
			$folderindent = substr_count($folders[$i]['id'], $IMAPConnection->_folderdelimiter);
			$isparent = is_array($IMAPConnection->_foldertree[$folders[$i]['id']]);

			if ($folderindent >= 1) {
				for ($j=1; $j<=$folderindent; $j++) {
					if ($j == $folderindent && $isparent == true) {
						if ($folderindent >= 2) {
							$indentgraphics .= "<a href=\"JavaScript:onclick=childDisplay('el" . $i . "', 'im" . $i . "');\"><img src=\"templates/$DefaultTemplate/images/folders/folder_collapsed.gif\" name=\"im" . $i . "\" border=\"0\" alt=\"\" /></a>";
						}
						else {
							$indentgraphics .= "<a href=\"JavaScript:onclick=childDisplay('el" . $i . "', 'im" . $i . "');\"><img src=\"templates/$DefaultTemplate/images/folders/folder_expanded.gif\" name=\"im" . $i . "\" border=\"0\" alt=\"\" /></a>";
						}
					}
					else {
						$indentgraphics .= "<img src=\"images/spacer.gif\" width=\"16\" border=\"0\" alt=\"\" />";
					}
					// $indentgraphics .= "<img src=\"images/spacer.gif\" width=\"16\" border=\"0\" alt=\"\" />";
				}
				$indentwidth = (17 * $folderindent) + 17;
			}

			if ($currentindent < $folderindent && $folderindent >= 1) {
				$currentindent = $folderindent;
				if ($folderindent >= 3) {
					$foldertemp = "<div id=\"el" . ($i-1) . "\" style=\"display:none;\">" . $foldertemp;
				}
				else {
					$foldertemp = "<div id=\"el" . ($i-1) . "\" style=\"display:block;\">" . $foldertemp;
				}
			}

			if ($folderindent == 0) {
				$condition = 0;
				$condition2 = 1;
			}
			else {
				$condition = 1;
				$condition2 = 1;
			}
			if ($currentindent > $folderindent && $folderindent >= $condition) {
				$indentdifference = $currentindent - $folderindent;
				$currentindent = $folderindent;
				for ($j=$indentdifference; $j>=$condition2; $j--) {
					$foldertemp = "</div>" . $foldertemp;
				}
			}
			if ($i == (count(folders) - 1) && $currentindent > 1) {
				for ($j=$currentindent; $j>=1; $j--) {
					$foldertemp = "</div>" . $foldertemp;
				}
			}
		}

		$currentnamearry = explode($IMAPConnection->_folderdelimiter, $folders[$i]['name']);
		$currentname = $currentnamearry[(sizeof($currentnamearry)-1)];

		$foldername_arry[] = str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $folders[$i]['name']);

		$foldertemp = str_replace ("[foldername]", str_replace("INBOX" . $IMAPConnection->_folderdelimiter, "", $currentname), $foldertemp);
		$foldertemp = str_replace ("[indentwidth]", $indentwidth, $foldertemp);

		if ($folders[$i]['name'] == $Trsh) {
			$foldertemp = str_replace ("[folderpurge]", ' <font size="1">[<a class="purge" href="deleteall.php?action=purge' . $MainSettings->SessAppend_noecho($TransIDEnabled, 0) . '">' . $lang['SFolderPane']['EmptyTrash'] . '</a>]</font>', $foldertemp);
			$foldertemp = str_replace ("[icon]", $indentgraphics . "<img src=\"templates/$DefaultTemplate/images/folders/folder_trash.gif\" border=\"0\" alt=\"" . $currentname . "\" />", $foldertemp);
		}
		elseif ($folders[$i]['name'] == $Inbx) {
			if (!isset($_SESSION['IT']) && $newmail > 0) {
				$_SESSION['IT'] = $numberofnewmessages;
			}
			$foldertemp = str_replace ("[folderpurge]", "", $foldertemp);
			$foldertemp = str_replace ("[icon]", $indentgraphics . "<img src=\"templates/$DefaultTemplate/images/folders/folder_inbox.gif\" border=\"0\" alt=\"Inbox\" />", $foldertemp);
		}
		elseif ($folders[$i]['name'] == $Outbx) {
			$foldertemp = str_replace ("[folderpurge]", "", $foldertemp);
			$foldertemp = str_replace ("[icon]", $indentgraphics . "<img src=\"templates/$DefaultTemplate/images/folders/folder_sent.gif\" border=\"0\" alt=\"" . $currentname . "\" />", $foldertemp);
		}
		elseif ($folders[$i]['name'] == $Drf) {
			$foldertemp = str_replace ("[folderpurge]", "", $foldertemp);
			$foldertemp = str_replace ("[icon]", $indentgraphics . "<img src=\"templates/$DefaultTemplate/images/folders/folder_drafts.gif\" border=\"0\" alt=\"" . $currentname . "\" />", $foldertemp);
		}
		else {
			$foldertemp = str_replace ("[folderpurge]", "", $foldertemp);
			$foldertemp = str_replace ("[icon]", $indentgraphics . "<img src=\"templates/$DefaultTemplate/images/folders/folder_blank.gif\" border=\"0\" alt=\"" . $currentname . "\" />", $foldertemp);
		}

		$folderlist .= $foldertemp;
		unset ($folderindent);
		unset ($isparent);
		unset ($indentgraphics);
		unset ($foldertemp);
	}

	// Close any remaining indent divs
	if ($currentindent > 1) {
		for ($j=$currentindent; $j>=1; $j--) {
			$folderlist .= "</div>";
		}
	}


	if ($UseDatabase == 1) {
		if ($EnableContacts == 1) {
			$folderaddressbook = $PageFolderLinks;
			$folderaddressbook = str_replace ("[folderlocation]", "addressbook.php?mode=view", $folderaddressbook);
			$folderaddressbook = str_replace ("[folderid]", "", $folderaddressbook);
			$folderaddressbook = str_replace ("[foldername]", $lang['Contacts'], $folderaddressbook);
			$folderaddressbook = str_replace ("[foldertotal]", "", $folderaddressbook);
			$folderaddressbook = str_replace ("[folderpurge]", "", $folderaddressbook);
			$folderaddressbook = str_replace ("[indentwidth]", "17", $folderaddressbook);
			$folderaddressbook = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_addressbook.gif\" border=\"0\" alt=\"" . $lang['Contacts'] . "\" />", $folderaddressbook);
			$folderlist .= $folderaddressbook;
		}

		if ($EnableCalendar == 1) {
			$foldercalendar = $PageFolderLinks;
			$foldercalendar = str_replace ("[folderlocation]", "calendar.php?mode=view", $foldercalendar);
			$foldercalendar = str_replace ("[folderid]", "", $foldercalendar);
			$foldercalendar = str_replace ("[foldername]", $lang['Calendar'], $foldercalendar);
			$foldercalendar = str_replace ("[foldertotal]", "", $foldercalendar);
			$foldercalendar = str_replace ("[folderpurge]", "", $foldercalendar);
			$foldercalendar = str_replace ("[indentwidth]", "17", $foldercalendar);
			$foldercalendar = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_calendar.gif\" border=\"0\" alt=\"" . $lang['Calendar'] . "\" />", $foldercalendar);
			$folderlist .= $foldercalendar;
		}
	}

	for($i=0; $i<count($folderid_arry); $i++) {
		$folderoptions .= "<option value=\"" . $folderid_arry[$i] . "\"";
		if ($folderid_arry[$i] == "INBOX") {
			$folderoptions .= " selected=\"selected\"";
		}
		$folderoptions .= ">" . $foldername_arry[$i] . "</option>\n";
	}
	$PageFolderPane = str_replace ("[folderlinks]", $folderlist, $PageFolderPane);
	$PageFolderPane = str_replace ("[folderoptions]", $folderoptions, $PageFolderPane);

	if ($AllowExternal == 1 && $UseDatabase == 1) {
		$PageFolderPane = str_replace("[ifexternal]", "", $PageFolderPane);
		$PageFolderPane = str_replace("[/ifexternal]", "", $PageFolderPane);
	}
	else {
		$PageFolderPane = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFolderPane);
	}
	// Reopen connection back to old folder
	$mailbox = $IMAPConnection->WM_IMAPClose();
	$mailbox = $IMAPConnection->WM_IMAPConnect();


}
else {
	$PageFolderPane = $getFile->fileRead('folderpane_pop3');
	$PageFolderLinks = $getFile->fileRead('folderlinks');
	$foldertemp_inbox = $PageFolderLinks;
	$foldertemp_inbox = str_replace ("[folderlocation]", "mailbox.php", $foldertemp_inbox);
	$foldertemp_inbox = str_replace ("[folderid]",  "?f=INBOX", $foldertemp_inbox);
	$foldertemp_inbox = str_replace ("[foldername]", "INBOX", $foldertemp_inbox);
	$foldertemp_inbox = str_replace ("[foldertotal]", "", $foldertemp_inbox);
	$foldertemp_inbox = str_replace ("[folderpurge]", "", $foldertemp_inbox);
	$foldertemp_inbox = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_inbox.gif\" border=\"0\" alt=\"Inbox\" />", $foldertemp_inbox);

	$imapstatus = $IMAPConnection->WM_IMAPStatus('INBOX');
	$numberofmessages = $imapstatus->messages;
	if (!isset($_SESSION['IT']) && $newmail > 0) {
		$_SESSION['IT'] = $numberofmessages;
	}

	$foldertemp_inbox = str_replace ("[indentwidth]", '17', $foldertemp_inbox);
	$folderlist = $foldertemp_inbox;

	if ($UseDatabase == 1) {
		if ($EnableContacts == 1) {
			$folderaddressbook = $PageFolderLinks;
			$folderaddressbook = str_replace ("[folderlocation]", "addressbook.php?mode=view", $folderaddressbook);
			$folderaddressbook = str_replace ("[folderid]", "", $folderaddressbook);
			$folderaddressbook = str_replace ("[foldername]", $lang['Contacts'], $folderaddressbook);
			$folderaddressbook = str_replace ("[foldertotal]", "", $folderaddressbook);
			$folderaddressbook = str_replace ("[folderpurge]", "", $folderaddressbook);
			$folderaddressbook = str_replace ("[indentwidth]", "17", $folderaddressbook);
			$folderaddressbook = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_addressbook.gif\" border=\"0\" alt=\"" . $lang['Contacts'] . "\" />", $folderaddressbook);
			$folderlist .= $folderaddressbook;
		}

		if ($EnableCalendar == 1) {
			$foldercalendar = $PageFolderLinks;
			$foldercalendar = str_replace ("[folderlocation]", "calendar.php?mode=view", $foldercalendar);
			$foldercalendar = str_replace ("[folderid]", "", $foldercalendar);
			$foldercalendar = str_replace ("[foldername]", $lang['Calendar'], $foldercalendar);
			$foldercalendar = str_replace ("[foldertotal]", "", $foldercalendar);
			$foldercalendar = str_replace ("[folderpurge]", "", $foldercalendar);
			$foldercalendar = str_replace ("[indentwidth]", "17", $foldercalendar);
			$foldercalendar = str_replace ("[icon]", "<img src=\"templates/$DefaultTemplate/images/folders/folder_calendar.gif\" border=\"0\" alt=\"" . $lang['Calendar'] . "\" />", $foldercalendar);
			$folderlist .= $foldercalendar;
		}
	}

	$PageFolderPane = str_replace ("[folderlinks]", $folderlist, $PageFolderPane);
	$PageFolderPane = str_replace ("[folderoptions]", "<option value=\"INBOX\" selected=\"selected\">INBOX</option>", $PageFolderPane);
}
$checknewmail = "";
if ($newmail > 0) {
	$checknewmail = "<iframe src=\"checknew.php?" . strip_tags(SID) . "\" allowtransparency=\"true\" scrolling=\"no\" width=\"1\" height=\"1\" frameborder=\"0\" border=\"0\"></iframe>";
}
$PageFolderPane = str_replace ("[checknewmail]", $checknewmail, $PageFolderPane);
$PageFolderPane = str_replace ("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageFolderPane);
$PageFolderPane = str_replace ("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageFolderPane);
$PageFolderPane = str_replace ("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageFolderPane);

?>
