<?php
/*
############################################################################

############################################################################
*/

$tzarry['Africa/Addis_Ababa'] = array('+0300', '+0300');
$tzarry['Africa/Algiers'] = array('+0100', '+0100');
$tzarry['Africa/Asmera'] = array('+0300', '+0300');
$tzarry['Africa/Bangui'] = array('+0100', '+0100');
$tzarry['Africa/Blantyre'] = array('+0200', '+0200');
$tzarry['Africa/Brazzaville'] = array('+0100', '+0100');
$tzarry['Africa/Bujumbura'] = array('+0200', '+0200');
$tzarry['Africa/Cairo'] = array('+0200', '+0300');
$tzarry['Africa/Ceuta'] = array('+0100', '+0200');
$tzarry['Africa/Dar_es_Salaam'] = array('+0300', '+0300');
$tzarry['Africa/Djibouti'] = array('+0300', '+0300');
$tzarry['Africa/Douala'] = array('+0100', '+0100');
$tzarry['Africa/Gaborone'] = array('+0200', '+0200');
$tzarry['Africa/Harare'] = array('+0200', '+0200');
$tzarry['Africa/Johannesburg'] = array('+0200', '+0200');
$tzarry['Africa/Kampala'] = array('+0300', '+0300');
$tzarry['Africa/Khartoum'] = array('+0300', '+0300');
$tzarry['Africa/Kigali'] = array('+0200', '+0200');
$tzarry['Africa/Kinshasa'] = array('+0100', '+0100');
$tzarry['Africa/Lagos'] = array('+0100', '+0100');
$tzarry['Africa/Libreville'] = array('+0100', '+0100');
$tzarry['Africa/Luanda'] = array('+0100', '+0100');
$tzarry['Africa/Lubumbashi'] = array('+0200', '+0200');
$tzarry['Africa/Lusaka'] = array('+0200', '+0200');
$tzarry['Africa/Malabo'] = array('+0100', '+0100');
$tzarry['Africa/Maputo'] = array('+0200', '+0200');
$tzarry['Africa/Maseru'] = array('+0200', '+0200');
$tzarry['Africa/Mbabane'] = array('+0200', '+0200');
$tzarry['Africa/Mogadishu'] = array('+0300', '+0300');
$tzarry['Africa/Nairobi'] = array('+0300', '+0300');
$tzarry['Africa/Ndjamena'] = array('+0100', '+0100');
$tzarry['Africa/Niamey'] = array('+0100', '+0100');
$tzarry['Africa/Porto-Novo'] = array('+0100', '+0100');
$tzarry['Africa/Tripoli'] = array('+0200', '+0200');
$tzarry['Africa/Tunis'] = array('+0100', '+0100');
$tzarry['Africa/Windhoek'] = array('+0200', '+0100');
$tzarry['America/Adak'] = array('-1000', '-0900');
$tzarry['America/Anchorage'] = array('-0900', '-0800');
$tzarry['America/Anguilla'] = array('-0400', '-0400');
$tzarry['America/Antigua'] = array('-0400', '-0400');
$tzarry['America/Araguaina'] = array('-0200', '-0300');
$tzarry['America/Aruba'] = array('-0400', '-0400');
$tzarry['America/Asuncion'] = array('-0300', '-0400');
$tzarry['America/Atka'] = array('-1000', '-0900');
$tzarry['America/Barbados'] = array('-0400', '-0400');
$tzarry['America/Belem'] = array('-0300', '-0300');
$tzarry['America/Belize'] = array('-0600', '-0600');
$tzarry['America/Boa_Vista'] = array('-0400', '-0400');
$tzarry['America/Bogota'] = array('-0500', '-0500');
$tzarry['America/Boise'] = array('-0700', '-0600');
$tzarry['America/Buenos_Aires'] = array('-0300', '-0300');
$tzarry['America/Cambridge_Bay'] = array('-0700', '-0600');
$tzarry['America/Cancun'] = array('-0600', '-0500');
$tzarry['America/Caracas'] = array('-0400', '-0400');
$tzarry['America/Catamarca'] = array('-0300', '-0300');
$tzarry['America/Cayenne'] = array('-0300', '-0300');
$tzarry['America/Cayman'] = array('-0500', '-0500');
$tzarry['America/Chicago'] = array('-0600', '-0500');
$tzarry['America/Chihuahua'] = array('-0700', '-0600');
$tzarry['America/Cordoba'] = array('-0300', '-0300');
$tzarry['America/Costa_Rica'] = array('-0600', '-0600');
$tzarry['America/Cuiaba'] = array('-0300', '-0400');
$tzarry['America/Curacao'] = array('-0400', '-0400');
$tzarry['America/Dawson'] = array('-0800', '-0700');
$tzarry['America/Dawson_Creek'] = array('-0700', '-0700');
$tzarry['America/Denver'] = array('-0700', '-0600');
$tzarry['America/Detroit'] = array('-0500', '-0400');
$tzarry['America/Dominica'] = array('-0400', '-0400');
$tzarry['America/Edmonton'] = array('-0700', '-0600');
$tzarry['America/Eirunepe'] = array('-0500', '-0500');
$tzarry['America/El_Salvador'] = array('-0600', '-0600');
$tzarry['America/Ensenada'] = array('-0800', '-0700');
$tzarry['America/Fort_Wayne'] = array('-0500', '-0500');
$tzarry['America/Fortaleza'] = array('-0300', '-0300');
$tzarry['America/Glace_Bay'] = array('-0400', '-0300');
$tzarry['America/Godthab'] = array('-0300', '-0200');
$tzarry['America/Goose_Bay'] = array('-0400', '-0300');
$tzarry['America/Grand_Turk'] = array('-0500', '-0400');
$tzarry['America/Grenada'] = array('-0400', '-0400');
$tzarry['America/Guadeloupe'] = array('-0400', '-0400');
$tzarry['America/Guatemala'] = array('-0600', '-0600');
$tzarry['America/Guayaquil'] = array('-0500', '-0500');
$tzarry['America/Guyana'] = array('-0400', '-0400');
$tzarry['America/Halifax'] = array('-0400', '-0300');
$tzarry['America/Havana'] = array('-0500', '-0400');
$tzarry['America/Hermosillo'] = array('-0700', '-0700');
$tzarry['America/Indiana/Indianapolis'] = array('-0500', '-0500');
$tzarry['America/Indiana/Knox'] = array('-0500', '-0500');
$tzarry['America/Indiana/Marengo'] = array('-0500', '-0500');
$tzarry['America/Indiana/Vevay'] = array('-0500', '-0500');
$tzarry['America/Indianapolis'] = array('-0500', '-0500');
$tzarry['America/Inuvik'] = array('-0700', '-0600');
$tzarry['America/Iqaluit'] = array('-0500', '-0400');
$tzarry['America/Jamaica'] = array('-0500', '-0500');
$tzarry['America/Jujuy'] = array('-0300', '-0300');
$tzarry['America/Juneau'] = array('-0900', '-0800');
$tzarry['America/Kentucky/Louisville'] = array('-0500', '-0400');
$tzarry['America/Kentucky/Monticello'] = array('-0500', '-0400');
$tzarry['America/Knox_IN'] = array('-0500', '-0500');
$tzarry['America/La_Paz'] = array('-0400', '-0400');
$tzarry['America/Lima'] = array('-0500', '-0500');
$tzarry['America/Los_Angeles'] = array('-0800', '-0700');
$tzarry['America/Louisville'] = array('-0500', '-0400');
$tzarry['America/Maceio'] = array('-0300', '-0300');
$tzarry['America/Managua'] = array('-0600', '-0600');
$tzarry['America/Manaus'] = array('-0400', '-0400');
$tzarry['America/Martinique'] = array('-0400', '-0400');
$tzarry['America/Mazatlan'] = array('-0700', '-0600');
$tzarry['America/Mendoza'] = array('-0300', '-0300');
$tzarry['America/Menominee'] = array('-0600', '-0500');
$tzarry['America/Merida'] = array('-0600', '-0500');
$tzarry['America/Mexico_City'] = array('-0600', '-0500');
$tzarry['America/Miquelon'] = array('-0300', '-0200');
$tzarry['America/Monterrey'] = array('-0600', '-0500');
$tzarry['America/Montevideo'] = array('-0300', '-0300');
$tzarry['America/Montreal'] = array('-0500', '-0400');
$tzarry['America/Montserrat'] = array('-0400', '-0400');
$tzarry['America/Nassau'] = array('-0500', '-0400');
$tzarry['America/New_York'] = array('-0500', '-0400');
$tzarry['America/Nipigon'] = array('-0500', '-0400');
$tzarry['America/Nome'] = array('-0900', '-0800');
$tzarry['America/Noronha'] = array('-0200', '-0200');
$tzarry['America/Panama'] = array('-0500', '-0500');
$tzarry['America/Pangnirtung'] = array('-0500', '-0400');
$tzarry['America/Paramaribo'] = array('-0300', '-0300');
$tzarry['America/Phoenix'] = array('-0700', '-0700');
$tzarry['America/Port-au-Prince'] = array('-0500', '-0500');
$tzarry['America/Port_of_Spain'] = array('-0400', '-0400');
$tzarry['America/Porto_Acre'] = array('-0500', '-0500');
$tzarry['America/Porto_Velho'] = array('-0400', '-0400');
$tzarry['America/Puerto_Rico'] = array('-0400', '-0400');
$tzarry['America/Rainy_River'] = array('-0600', '-0500');
$tzarry['America/Rankin_Inlet'] = array('-0600', '-0500');
$tzarry['America/Recife'] = array('-0300', '-0300');
$tzarry['America/Regina'] = array('-0600', '-0600');
$tzarry['America/Rio_Branco'] = array('-0500', '-0500');
$tzarry['America/Rosario'] = array('-0300', '-0300');
$tzarry['America/Santiago'] = array('-0300', '-0400');
$tzarry['America/Santo_Domingo'] = array('-0400', '-0400');
$tzarry['America/Sao_Paulo'] = array('-0200', '-0300');
$tzarry['America/Scoresbysund'] = array('-0100', '+0000');
$tzarry['America/Shiprock'] = array('-0700', '-0600');
$tzarry['America/St_Johns'] = array('-031800', '-021800');
$tzarry['America/St_Kitts'] = array('-0400', '-0400');
$tzarry['America/St_Lucia'] = array('-0400', '-0400');
$tzarry['America/St_Thomas'] = array('-0400', '-0400');
$tzarry['America/St_Vincent'] = array('-0400', '-0400');
$tzarry['America/Swift_Current'] = array('-0600', '-0600');
$tzarry['America/Tegucigalpa'] = array('-0600', '-0600');
$tzarry['America/Thule'] = array('-0400', '-0300');
$tzarry['America/Thunder_Bay'] = array('-0500', '-0400');
$tzarry['America/Tijuana'] = array('-0800', '-0700');
$tzarry['America/Tortola'] = array('-0400', '-0400');
$tzarry['America/Vancouver'] = array('-0800', '-0700');
$tzarry['America/Virgin'] = array('-0400', '-0400');
$tzarry['America/Whitehorse'] = array('-0800', '-0700');
$tzarry['America/Winnipeg'] = array('-0600', '-0500');
$tzarry['America/Yakutat'] = array('-0900', '-0800');
$tzarry['America/Yellowknife'] = array('-0700', '-0600');
$tzarry['Antarctica/Casey'] = array('+0800', '+0800');
$tzarry['Antarctica/Davis'] = array('+0700', '+0700');
$tzarry['Antarctica/DumontDUrville'] = array('+1000', '+1000');
$tzarry['Antarctica/Mawson'] = array('+0600', '+0600');
$tzarry['Antarctica/McMurdo'] = array('+1300', '+1200');
$tzarry['Antarctica/Palmer'] = array('-0300', '-0400');
$tzarry['Antarctica/South_Pole'] = array('+1300', '+1200');
$tzarry['Antarctica/Syowa'] = array('+0300', '+0300');
$tzarry['Antarctica/Vostok'] = array('+0600', '+0600');
$tzarry['Arctic/Longyearbyen'] = array('+0100', '+0200');
$tzarry['Asia/Aden'] = array('+0300', '+0300');
$tzarry['Asia/Almaty'] = array('+0600', '+0700');
$tzarry['Asia/Amman'] = array('+0200', '+0300');
$tzarry['Asia/Anadyr'] = array('+1200', '+1300');
$tzarry['Asia/Aqtau'] = array('+0400', '+0500');
$tzarry['Asia/Aqtobe'] = array('+0500', '+0600');
$tzarry['Asia/Ashgabat'] = array('+0500', '+0500');
$tzarry['Asia/Ashkhabad'] = array('+0500', '+0500');
$tzarry['Asia/Baghdad'] = array('+0300', '+0400');
$tzarry['Asia/Bahrain'] = array('+0300', '+0300');
$tzarry['Asia/Baku'] = array('+0400', '+0500');
$tzarry['Asia/Bangkok'] = array('+0700', '+0700');
$tzarry['Asia/Beirut'] = array('+0200', '+0300');
$tzarry['Asia/Bishkek'] = array('+0500', '+0600');
$tzarry['Asia/Brunei'] = array('+0800', '+0800');
$tzarry['Asia/Calcutta'] = array('+0800', '+0800');
$tzarry['Asia/Chungking'] = array('+0800', '+0800');
$tzarry['Asia/Colombo'] = array('+0600', '+0600');
$tzarry['Asia/Dacca'] = array('+0600', '+0600');
$tzarry['Asia/Damascus'] = array('+0200', '+0300');
$tzarry['Asia/Dhaka'] = array('+0600', '+0600');
$tzarry['Asia/Dili'] = array('+0900', '+0900');
$tzarry['Asia/Dubai'] = array('+0400', '+0400');
$tzarry['Asia/Dushanbe'] = array('+0500', '+0500');
$tzarry['Asia/Gaza'] = array('+0200', '+0300');
$tzarry['Asia/Harbin'] = array('+0800', '+0800');
$tzarry['Asia/Hong_Kong'] = array('+0800', '+0800');
$tzarry['Asia/Hovd'] = array('+0700', '+0700');
$tzarry['Asia/Irkutsk'] = array('+0800', '+0900');
$tzarry['Asia/Istanbul'] = array('+0200', '+0300');
$tzarry['Asia/Jakarta'] = array('+0700', '+0700');
$tzarry['Asia/Jayapura'] = array('+0900', '+0900');
$tzarry['Asia/Jerusalem'] = array('+0200', '+0300');
$tzarry['Asia/Kabul'] = array('+041800', '+041800');
$tzarry['Asia/Kamchatka'] = array('+1200', '+1300');
$tzarry['Asia/Karachi'] = array('+0500', '+0500');
$tzarry['Asia/Kashgar'] = array('+0800', '+0800');
$tzarry['Asia/Katmandu'] = array('+0700', '+0700');
$tzarry['Asia/Krasnoyarsk'] = array('+0700', '+0800');
$tzarry['Asia/Kuala_Lumpur'] = array('+0800', '+0800');
$tzarry['Asia/Kuching'] = array('+0800', '+0800');
$tzarry['Asia/Kuwait'] = array('+0300', '+0300');
$tzarry['Asia/Macao'] = array('+0800', '+0800');
$tzarry['Asia/Magadan'] = array('+1100', '+1200');
$tzarry['Asia/Manila'] = array('+0800', '+0800');
$tzarry['Asia/Muscat'] = array('+0400', '+0400');
$tzarry['Asia/Nicosia'] = array('+0200', '+0300');
$tzarry['Asia/Novosibirsk'] = array('+0600', '+0700');
$tzarry['Asia/Omsk'] = array('+0600', '+0700');
$tzarry['Asia/Phnom_Penh'] = array('+0700', '+0700');
$tzarry['Asia/Pyongyang'] = array('+0900', '+0900');
$tzarry['Asia/Qatar'] = array('+0300', '+0300');
$tzarry['Asia/Riyadh'] = array('+0300', '+0300');
$tzarry['Asia/Saigon'] = array('+0700', '+0700');
$tzarry['Asia/Samarkand'] = array('+0500', '+0500');
$tzarry['Asia/Seoul'] = array('+0900', '+0900');
$tzarry['Asia/Shanghai'] = array('+0800', '+0800');
$tzarry['Asia/Singapore'] = array('+0800', '+0800');
$tzarry['Asia/Taipei'] = array('+0800', '+0800');
$tzarry['Asia/Tashkent'] = array('+0500', '+0500');
$tzarry['Asia/Tbilisi'] = array('+0400', '+0500');
$tzarry['Asia/Tel_Aviv'] = array('+0200', '+0300');
$tzarry['Asia/Thimbu'] = array('+0600', '+0600');
$tzarry['Asia/Thimphu'] = array('+0600', '+0600');
$tzarry['Asia/Tokyo'] = array('+0900', '+0900');
$tzarry['Asia/Ujung_Pandang'] = array('+0800', '+0800');
$tzarry['Asia/Ulaanbaatar'] = array('+0800', '+0800');
$tzarry['Asia/Ulan_Bator'] = array('+0800', '+0800');
$tzarry['Asia/Urumqi'] = array('+0800', '+0800');
$tzarry['Asia/Vientiane'] = array('+0700', '+0700');
$tzarry['Asia/Vladivostok'] = array('+1000', '+1100');
$tzarry['Asia/Yakutsk'] = array('+0900', '+1000');
$tzarry['Asia/Yekaterinburg'] = array('+0500', '+0600');
$tzarry['Asia/Yerevan'] = array('+0400', '+0500');
$tzarry['Atlantic/Azores'] = array('-0100', '+0000');
$tzarry['Atlantic/Bermuda'] = array('-0400', '-0300');
$tzarry['Atlantic/Canary'] = array('+0000', '+0100');
$tzarry['Atlantic/Cape_Verde'] = array('-0100', '-0100');
$tzarry['Atlantic/Faeroe'] = array('+0000', '+0100');
$tzarry['Atlantic/Jan_Mayen'] = array('-0100', '-0100');
$tzarry['Atlantic/Madeira'] = array('+0000', '+0100');
$tzarry['Atlantic/South_Georgia'] = array('-0200', '-0200');
$tzarry['Atlantic/Stanley'] = array('-0300', '-0400');
$tzarry['Australia/ACT'] = array('+1100', '+1000');
$tzarry['Australia/Adelaide'] = array('+101800', '+091800');
$tzarry['Australia/Brisbane'] = array('+1000', '+1000');
$tzarry['Australia/Canberra'] = array('+1100', '+1000');
$tzarry['Australia/Hobart'] = array('+1100', '+1000');
$tzarry['Australia/LHI'] = array('+1100', '+101800');
$tzarry['Australia/Lindeman'] = array('+1000', '+1000');
$tzarry['Australia/Melbourne'] = array('+1100', '+1000');
$tzarry['Australia/NSW'] = array('+1100', '+1000');
$tzarry['Australia/North'] = array('+091800', '+091800');
$tzarry['Australia/Perth'] = array('+0800', '+0800');
$tzarry['Australia/Queensland'] = array('+1000', '+1000');
$tzarry['Australia/Sydney'] = array('+1100', '+1000');
$tzarry['Australia/Tasmania'] = array('+1100', '+1000');
$tzarry['Australia/Victoria'] = array('+1100', '+1000');
$tzarry['Australia/West'] = array('+0800', '+0800');
$tzarry['Brazil/Acre'] = array('-0500', '-0500');
$tzarry['Brazil/DeNoronha'] = array('-0200', '-0200');
$tzarry['Brazil/East'] = array('-0200', '-0300');
$tzarry['Brazil/West'] = array('-0400', '-0400');
$tzarry['CET'] = array('+0100', '+0200');
$tzarry['CST6CDT'] = array('-0600', '-0500');
$tzarry['Canada/Atlantic'] = array('-0400', '-0300');
$tzarry['Canada/Central'] = array('-0600', '-0500');
$tzarry['Canada/East-Saskatchewan'] = array('-0600', '-0600');
$tzarry['Canada/Eastern'] = array('-0500', '-0400');
$tzarry['Canada/Mountain'] = array('-0700', '-0600');
$tzarry['Canada/Pacific'] = array('-0800', '-0700');
$tzarry['Canada/Saskatchewan'] = array('-0600', '-0600');
$tzarry['Canada/Yukon'] = array('-0800', '-0700');
$tzarry['Chile/Continental'] = array('-0300', '-0400');
$tzarry['Chile/EasterIsland'] = array('-0500', '-0600');
$tzarry['Cuba'] = array('-0500', '-0400');
$tzarry['EET'] = array('+0200', '+0300');
$tzarry['EST'] = array('-0500', '-0500');
$tzarry['EST5EDT'] = array('-0500', '-0400');
$tzarry['Egypt'] = array('+0200', '+0300');
$tzarry['Eire'] = array('+0000', '+0100');
$tzarry['Etc/GMT+1'] = array('-0100', '-0100');
$tzarry['Etc/GMT+10'] = array('-1000', '-1000');
$tzarry['Etc/GMT+11'] = array('-1100', '-1100');
$tzarry['Etc/GMT+12'] = array('-1200', '-1200');
$tzarry['Etc/GMT+2'] = array('-0200', '-0200');
$tzarry['Etc/GMT+3'] = array('-0300', '-0300');
$tzarry['Etc/GMT+4'] = array('-0400', '-0400');
$tzarry['Etc/GMT+5'] = array('-0500', '-0500');
$tzarry['Etc/GMT+6'] = array('-0600', '-0600');
$tzarry['Etc/GMT+7'] = array('-0700', '-0700');
$tzarry['Etc/GMT+8'] = array('-0800', '-0800');
$tzarry['Etc/GMT+9'] = array('-0900', '-0900');
$tzarry['Etc/GMT-1'] = array('+0100', '+0100');
$tzarry['Etc/GMT-10'] = array('+1000', '+1000');
$tzarry['Etc/GMT-11'] = array('+1100', '+1100');
$tzarry['Etc/GMT-12'] = array('+1200', '+1200');
$tzarry['Etc/GMT-13'] = array('+1300', '+1300');
$tzarry['Etc/GMT-14'] = array('+1400', '+1400');
$tzarry['Etc/GMT-2'] = array('+0200', '+0200');
$tzarry['Etc/GMT-3'] = array('+0300', '+0300');
$tzarry['Etc/GMT-4'] = array('+0400', '+0400');
$tzarry['Etc/GMT-5'] = array('+0500', '+0500');
$tzarry['Etc/GMT-6'] = array('+0600', '+0600');
$tzarry['Etc/GMT-7'] = array('+0700', '+0700');
$tzarry['Etc/GMT-8'] = array('+0800', '+0800');
$tzarry['Etc/GMT-9'] = array('+0900', '+0900');
$tzarry['Europe/Amsterdam'] = array('+0100', '+0200');
$tzarry['Europe/Andorra'] = array('+0100', '+0200');
$tzarry['Europe/Athens'] = array('+0200', '+0300');
$tzarry['Europe/Belfast'] = array('+0000', '+0100');
$tzarry['Europe/Belgrade'] = array('+0100', '+0200');
$tzarry['Europe/Berlin'] = array('+0100', '+0200');
$tzarry['Europe/Bratislava'] = array('+0100', '+0200');
$tzarry['Europe/Brussels'] = array('+0100', '+0200');
$tzarry['Europe/Bucharest'] = array('+0200', '+0300');
$tzarry['Europe/Budapest'] = array('+0100', '+0200');
$tzarry['Europe/Chisinau'] = array('+0200', '+0300');
$tzarry['Europe/Copenhagen'] = array('+0100', '+0200');
$tzarry['Europe/Dublin'] = array('+0000', '+0100');
$tzarry['Europe/Gibraltar'] = array('+0100', '+0200');
$tzarry['Europe/Helsinki'] = array('+0200', '+0300');
$tzarry['Europe/Istanbul'] = array('+0200', '+0300');
$tzarry['Europe/Kaliningrad'] = array('+0200', '+0300');
$tzarry['Europe/Kiev'] = array('+0200', '+0300');
$tzarry['Europe/Lisbon'] = array('+0000', '+0100');
$tzarry['Europe/Ljubljana'] = array('+0100', '+0200');
$tzarry['Europe/London'] = array('+0000', '+0100');
$tzarry['Europe/Luxembourg'] = array('+0100', '+0200');
$tzarry['Europe/Madrid'] = array('+0100', '+0200');
$tzarry['Europe/Malta'] = array('+0100', '+0200');
$tzarry['Europe/Minsk'] = array('+0200', '+0300');
$tzarry['Europe/Monaco'] = array('+0100', '+0200');
$tzarry['Europe/Moscow'] = array('+0300', '+0400');
$tzarry['Europe/Nicosia'] = array('+0200', '+0300');
$tzarry['Europe/Oslo'] = array('+0100', '+0200');
$tzarry['Europe/Paris'] = array('+0100', '+0200');
$tzarry['Europe/Prague'] = array('+0100', '+0200');
$tzarry['Europe/Riga'] = array('+0200', '+0300');
$tzarry['Europe/Rome'] = array('+0100', '+0200');
$tzarry['Europe/Samara'] = array('+0400', '+0500');
$tzarry['Europe/San_Marino'] = array('+0100', '+0200');
$tzarry['Europe/Sarajevo'] = array('+0100', '+0200');
$tzarry['Europe/Simferopol'] = array('+0200', '+0300');
$tzarry['Europe/Skopje'] = array('+0100', '+0200');
$tzarry['Europe/Sofia'] = array('+0200', '+0300');
$tzarry['Europe/Stockholm'] = array('+0100', '+0200');
$tzarry['Europe/Tallinn'] = array('+0200', '+0200');
$tzarry['Europe/Tirane'] = array('+0100', '+0200');
$tzarry['Europe/Tiraspol'] = array('+0200', '+0300');
$tzarry['Europe/Uzhgorod'] = array('+0200', '+0300');
$tzarry['Europe/Vaduz'] = array('+0100', '+0200');
$tzarry['Europe/Vatican'] = array('+0100', '+0200');
$tzarry['Europe/Vienna'] = array('+0100', '+0200');
$tzarry['Europe/Vilnius'] = array('+0200', '+0200');
$tzarry['Europe/Warsaw'] = array('+0100', '+0200');
$tzarry['Europe/Zagreb'] = array('+0100', '+0200');
$tzarry['Europe/Zaporozhye'] = array('+0200', '+0300');
$tzarry['Europe/Zurich'] = array('+0100', '+0200');
$tzarry['GB'] = array('+0000', '+0100');
$tzarry['GB-Eire'] = array('+0000', '+0100');
$tzarry['HST'] = array('-1000', '-1000');
$tzarry['Hongkong'] = array('+0800', '+0800');
$tzarry['Indian/Antananarivo'] = array('+0300', '+0300');
$tzarry['Indian/Chagos'] = array('+0500', '+0500');
$tzarry['Indian/Christmas'] = array('+0700', '+0700');
$tzarry['Indian/Cocos'] = array('+061800', '+061800');
$tzarry['Indian/Comoro'] = array('+0300', '+0300');
$tzarry['Indian/Kerguelen'] = array('+0500', '+0500');
$tzarry['Indian/Mahe'] = array('+0400', '+0400');
$tzarry['Indian/Maldives'] = array('+0500', '+0500');
$tzarry['Indian/Mauritius'] = array('+0400', '+0400');
$tzarry['Indian/Mayotte'] = array('+0300', '+0300');
$tzarry['Indian/Reunion'] = array('+0400', '+0400');
$tzarry['Iran'] = array('+031800', '+041800');
$tzarry['Israel'] = array('+0200', '+0300');
$tzarry['Jamaica'] = array('-0500', '-0500');
$tzarry['Japan'] = array('+0900', '+0900');
$tzarry['Kwajalein'] = array('+1200', '+1200');
$tzarry['Libya'] = array('+0200', '+0200');
$tzarry['MET'] = array('+0100', '+0200');
$tzarry['MST'] = array('-0700', '-0700');
$tzarry['MST7MDT'] = array('-0700', '-0600');
$tzarry['Mexico/BajaNorte'] = array('-0800', '-0700');
$tzarry['Mexico/BajaSur'] = array('-0700', '-0600');
$tzarry['Mexico/General'] = array('-0600', '-0500');
$tzarry['NZ'] = array('+1300', '+1200');
$tzarry['Navajo'] = array('-0700', '-0600');
$tzarry['PRC'] = array('+0800', '+0800');
$tzarry['PST8PDT'] = array('-0800', '-0700');
$tzarry['Pacific/Apia'] = array('-1100', '-1100');
$tzarry['Pacific/Auckland'] = array('+1300', '+1200');
$tzarry['Pacific/Easter'] = array('-0500', '-0600');
$tzarry['Pacific/Efate'] = array('+1100', '+1100');
$tzarry['Pacific/Enderbury'] = array('+1300', '+1300');
$tzarry['Pacific/Fakaofo'] = array('-1000', '-1000');
$tzarry['Pacific/Fiji'] = array('+1200', '+1200');
$tzarry['Pacific/Funafuti'] = array('+1200', '+1200');
$tzarry['Pacific/Galapagos'] = array('-0600', '-0600');
$tzarry['Pacific/Gambier'] = array('-0900', '-0900');
$tzarry['Pacific/Guadalcanal'] = array('+1100', '+1100');
$tzarry['Pacific/Guam'] = array('+1000', '+1000');
$tzarry['Pacific/Honolulu'] = array('-1000', '-1000');
$tzarry['Pacific/Johnston'] = array('-1000', '-1000');
$tzarry['Pacific/Kiritimati'] = array('+1400', '+1400');
$tzarry['Pacific/Kosrae'] = array('+1100', '+1100');
$tzarry['Pacific/Kwajalein'] = array('+1200', '+1200');
$tzarry['Pacific/Majuro'] = array('+1200', '+1200');
$tzarry['Pacific/Midway'] = array('-1100', '-1100');
$tzarry['Pacific/Nauru'] = array('+1200', '+1200');
$tzarry['Pacific/Niue'] = array('-1100', '-1100');
$tzarry['Pacific/Noumea'] = array('+1100', '+1100');
$tzarry['Pacific/Pago_Pago'] = array('-1100', '-1100');
$tzarry['Pacific/Palau'] = array('+0900', '+0900');
$tzarry['Pacific/Pitcairn'] = array('-0800', '-0800');
$tzarry['Pacific/Ponape'] = array('+1100', '+1100');
$tzarry['Pacific/Port_Moresby'] = array('+1000', '+1000');
$tzarry['Pacific/Rarotonga'] = array('-1000', '-1000');
$tzarry['Pacific/Saipan'] = array('+1000', '+1000');
$tzarry['Pacific/Samoa'] = array('-1100', '-1100');
$tzarry['Pacific/Tahiti'] = array('-1000', '-1000');
$tzarry['Pacific/Tarawa'] = array('+1200', '+1200');
$tzarry['Pacific/Tongatapu'] = array('+1300', '+1300');
$tzarry['Pacific/Truk'] = array('+1000', '+1000');
$tzarry['Pacific/Wake'] = array('+1200', '+1200');
$tzarry['Pacific/Wallis'] = array('+1200', '+1200');
$tzarry['Pacific/Yap'] = array('+1000', '+1000');
$tzarry['Poland'] = array('+0100', '+0200');
$tzarry['Portugal'] = array('+0000', '+0100');
$tzarry['ROC'] = array('+0800', '+0800');
$tzarry['ROK'] = array('+0900', '+0900');
$tzarry['Singapore'] = array('+0800', '+0800');
$tzarry['SystemV/AST4'] = array('-0400', '-0400');
$tzarry['SystemV/AST4ADT'] = array('-0400', '-0300');
$tzarry['SystemV/CST6'] = array('-0600', '-0600');
$tzarry['SystemV/CST6CDT'] = array('-0600', '-0500');
$tzarry['SystemV/EST5'] = array('-0500', '-0500');
$tzarry['SystemV/EST5EDT'] = array('-0500', '-0400');
$tzarry['SystemV/HST10'] = array('-1000', '-1000');
$tzarry['SystemV/MST7'] = array('-0700', '-0700');
$tzarry['SystemV/MST7MDT'] = array('-0700', '-0600');
$tzarry['SystemV/PST8'] = array('-0800', '-0800');
$tzarry['SystemV/PST8PDT'] = array('-0800', '-0700');
$tzarry['SystemV/YST9'] = array('-0900', '-0900');
$tzarry['SystemV/YST9YDT'] = array('-0900', '-0800');
$tzarry['Turkey'] = array('+0200', '+0300');
$tzarry['US/Alaska'] = array('-0900', '-0800');
$tzarry['US/Aleutian'] = array('-1000', '-0900');
$tzarry['US/Arizona'] = array('-0700', '-0700');
$tzarry['US/Central'] = array('-0600', '-0500');
$tzarry['US/East-Indiana'] = array('-0500', '-0500');
$tzarry['US/Eastern'] = array('-0500', '-0400');
$tzarry['US/Hawaii'] = array('-1000', '-1000');
$tzarry['US/Indiana-Starke'] = array('-0500', '-0500');
$tzarry['US/Michigan'] = array('-0500', '-0400');
$tzarry['US/Mountain'] = array('-0700', '-0600');
$tzarry['US/Pacific'] = array('-0800', '-0700');
$tzarry['US/Samoa'] = array('-1100', '-1100');
$tzarry['W-SU'] = array('+0300', '+0400');
$tzarry['WET'] = array('+0000', '+0100');

class iCal_Parse {
	var $_icalobj;
	var $_alarmstatus;
	var $_crlf;
	var $_dwmversion;
	var $_iCalOutput;

	function cleanlines($strData) {
		// Windows
		$strData = str_replace("\r\n", "\n", $strData);
        
		// Mac
		$strData = str_replace("\r", "\n", $strData);

		// Linux/Unix is already \n so leave as is

		return $strData;
	}

	function converttz($tzselect) {
		$sign = substr($tzselect, 0, 1);
		$hour = substr($tzselect, 1, 2);
		$minute = substr($tzselect, 3, 2);

		$hourmins = $hour * 60;
		$resulttime = '$sign' . ($hourmins + $minute);
		return floatval($resulttime);
	}

	function parsecal($strData) {
		global $tz, $tzarry;
		$i = 0;
		$strData = $this->cleanlines($strData);

		$regex = '(\n)([ |\t])';
		$strData = preg_replace("/$regex/i", "", $strData);

		$strData = str_replace("\x00", '', $strData);
        
		// Convert remaining lines to arrays
		$lines = explode("\n", $strData);

		if (is_array($lines)) {
			foreach ($lines as $line) {
				unset ($fieldtmp, $field, $value, $prop_pos, $property);

				$line = trim($line);
				if ($line == 'BEGIN:VEVENT') {
					// New event, clean variables out here to make sure
					// we have latest info
					$this->_alarmstatus = 'closed';
				}
				elseif ($line == 'END:VEVENT') {
					// End of event
					// Now we can send back data
					$i++;

				}
				elseif ($line == 'BEGIN:VALARM') {
					$this->_alarmstatus = 'open';

				}
				elseif ($line == 'END:VALARM') {
					$this->_alarmstatus = 'closed';

				}
				else {
					// Get field data for this line
					ereg ("([^:]+):(.*)", $line, $line);
					$fieldtmp = $line[1];
					$value = $line[2];

					$field = $fieldtmp;
					// Look for a field terminator
					$position = strpos($field,';');
					if ($position <> false) {
						$field = substr($field, 0, $position);
					}
					// Uppercase the field name so that we can compare later on
					$field = strtoupper($field);
				}

				// See RFC2445 http://www.faqs.org/rfcs/rfc2445.html for field names
				switch ($field) {
					case 'DTSTART':
						$zulutime = false;
						if (substr($value, -1) == 'Z') {
							// We have a Z at the end of the parameter which means it's in UTC
							$zulutime = true;
						}
						$value = ereg_replace('T', '', $value);
						$value = ereg_replace('Z', '', $value);
						$fieldtmp = ereg_replace(';VALUE=DATE-TIME', '', $fieldtmp); 
						if ((preg_match("/^DTSTART;VALUE=DATE/i", $fieldtmp)) || (ereg ('^([0-9]{4})([0-9]{2})([0-9]{2})$', $value)))  {
							// We don't have any timezone parameters
							ereg ('([0-9]{4})([0-9]{2})([0-9]{2})', $value, $dtstart_check);
							if ($dtstart_check[1] < 1969) { 
								$dtstart_check[1] = '1990';
								$value = $dtstart_check[1] . $dtstart_check[2] . $dtstart_check[3];
							}
							$allday_start = $value;
							$start_date = $allday_start;
							$start_unixtime = strtotime($value);
						}
						else {
							// This allows us to check for a Time Zone id
							if (preg_match("/^DTSTART;TZID=/i", $fieldtmp)) {
								$tz_tmp = explode('=', $fieldtmp);
								$tz_dtstart = $tz_tmp[1];
								unset($tz_tmp);
							}
							elseif ($zulutime) {
								$tz_dtstart = 'GMT';
							}

							ereg ('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{0,2})([0-9]{0,2})', $value, $regs);
							$start_date = $regs[1] . $regs[2] . $regs[3];
							$start_time = $regs[4] . $regs[5];
							$start_unixtime = mktime($regs[4], $regs[5], 0, $regs[2], $regs[3], $regs[1]);

							// We now have the start time in seconds, but we need to validate the TZID if exists.

							if (isset($tz_dtstart)) {
								if (is_array($tzarry) && array_key_exists($tz_dtstart, $tzarry)) {
									$dlst = date('I', $start_unixtime);
									$offsettmp = $tzarry[$tz_dtstart][$dlst];
									if (empty($offsettmp)) {
										$offsettmp = $tzarry[str_replace("/", "-", $tz_dtstart)][$dlst];
									}
									if (empty($offsettmp)) {
										$offset = '0';
									}
									else {
										$offset = $this->converttz($offsettmp);
									}
								}
								else {
									$offset = '0';
								}
							}

							if (isset($this->_icalobj[$i]['calendar_tz'])) {
								if (is_array($tzarry) && array_key_exists($this->_icalobj[$i]['calendar_tz'], $tzarry)) {
									$dlst = date('I', $start_unixtime);
									$offsettmp = $tzarry[$this->_icalobj[$i]['calendar_tz']][$dlst];
									if (empty($offsettmp)) {
										$offsettmp = $tzarry[str_replace("/", "-", $this->_icalobj[$i]['calendar_tz'])][$dlst];
									}
									if (empty($offsettmp)) {
										$offset = '0';
									}
									else {
										$offset = $this->converttz($offsettmp);
									}
								}
								else {
									$offset = '0';
								}
							}
							// We now have the offset in seconds +/- so we must now convert to GMT (as we store everything in GMT to make life easier later on)
							$start_unixtime = $start_unixtime + ($offset * 60);
						}
						$this->_icalobj[$i]['dtstart'] = $start_unixtime;
						break;

					case 'DTEND':
						$zulutime = false;
						if (substr($value, -1) == 'Z') {
							// We have a Z at the end of the parameter which means it's in UTC
							$zulutime = true;
						}
						$value = ereg_replace('T', '', $value);
						$value = ereg_replace('Z', '', $value);
						$fieldtmp = ereg_replace(';VALUE=DATE-TIME', '', $fieldtmp);
						if ((preg_match("/^DTEND;VALUE=DATE/i", $fieldtmp)) || (ereg ('^([0-9]{4})([0-9]{2})([0-9]{2})$', $value)))  {
							ereg ('([0-9]{4})([0-9]{2})([0-9]{2})', $value, $dtend_check);
							if ($dtend_check[1] < 1969) { 
								$dtend_check[1] = '1990';
								$value = $dtend_check[1] . $dtend_check[2] . $dtend_check[3];
							}
							$allday_end = $value;
							$end_date = $allday_end;
							$end_unixtime = strtotime($value);
						}
						else {
							// This allows us to check for a Time Zone id
							if (preg_match("/^DTSTART;TZID=/i", $fieldtmp)) {
								$tz_tmp = explode('=', $fieldtmp);
								$tz_dtend = $tz_tmp[1];
								unset($tz_tmp);
							}
							elseif ($zulutime) {
								$tz_dtend = 'GMT';
							}

							ereg ('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{0,2})([0-9]{0,2})', $value, $regs);
							$end_date = $regs[1] . $regs[2] . $regs[3];
							$end_time = $regs[4] . $regs[5];
							$end_unixtime = mktime($regs[4], $regs[5], 0, $regs[2], $regs[3], $regs[1]);

							// We now have the start time in seconds, but we need to validate the TZID if exists.

							if (isset($tz_dtend)) {
								if (is_array($tzarry) && array_key_exists($tz_dtstart, $tzarry)) {
									$dlst = date('I', $end_unixtime);
									$offsettmp = $tzarry[$tz_dtend][$dlst];
									if (empty($offsettmp)) {
										$offsettmp = $tzarry[str_replace("/", "-", $tz_dtend)][$dlst];
									}
									if (empty($offsettmp)) {
										$offset = '0';
									}
									else {
										$offset = $this->converttz($offsettmp);
									}
								}
								else {
									$offset = '0';
								}
							}

							if (isset($this->_icalobj[$i]['calendar_tz'])) {
								if (is_array($tzarry) && array_key_exists($this->_icalobj[$i]['calendar_tz'], $tzarry)) {
									$dlst = date('I', $end_unixtime);
									$offsettmp = $tzarry[$this->_icalobj[$i]['calendar_tz']][$dlst];
									if (empty($offsettmp)) {
										$offsettmp = $tzarry[str_replace("/", "-", $this->_icalobj[$i]['calendar_tz'])][$dlst];
									}
									if (empty($offsettmp)) {
										$offset = '0';
									}
									else {
										$offset = $this->converttz($offsettmp);
									}
								}
								else {
									$offset = '0';
								}
							}

							// We now have the offset in seconds +/- so we must now convert to GMT (as we store everything in GMT to make life easier later on)
							$end_unixtime = $end_unixtime + ($offset * 60);
						}
						$this->_icalobj[$i]['dtend'] = $end_unixtime;
						break;

					case 'SUMMARY':
						$this->_icalobj[$i]['summary'] = strip_tags($value);
						break;

					case 'DESCRIPTION':
						if ($this->_alarmstatus == 'closed') {
							$this->_icalobj[$i]['description'] = strip_tags($value);
							$this->_icalobj[$i]['description'] = str_replace('\n', "\n", $this->_icalobj[$i]['description']);
							$this->_icalobj[$i]['description'] = stripslashes($this->_icalobj[$i]['description']);
						}
						break;

					case 'UID':
						$this->_icalobj[$i]['uid'] = $value;
						break;

					case 'X-WR-TIMEZONE':
						$this->_icalobj[$i]['calendar_tz'] = $value;
						break;

					case 'METHOD':
						$this->_icalobj[$i]['method'] = $value;
						break;

					case 'ATTENDEE':
						$fieldtmp = str_replace("ATTENDEE;CN=", "", $fieldtmp);
						$rsvp = false;
						if (strstr($fieldtmp, 'RSVP=TRUE')) {
							$rsvp = true;
						}
						if (strstr($fieldtmp, 'PARTSTAT=ACCEPTED')) {
							$status = 'accepted';
						}
						elseif (strstr($fieldtmp, 'PARTSTAT=DECLINED')) {
							$status = 'declined';
						}
						$value = str_replace ("mailto:", "", $value);
						$value = str_replace ("MAILTO:", "", $value);
						$this->_icalobj[$i]['attendee'][] = array ('name' => $fieldtmp, 'email' => $value, 'rsvp' => $rsvp, 'status' => $status);
						break;

					case 'ORGANIZER':
						$fieldtmp = str_replace("ORGANIZER;CN=", "", $fieldtmp);
						$value = str_replace ("mailto:", "", $value);
						$value = str_replace ("MAILTO:", "", $value);
						$this->_icalobj[$i]['organizer'][] = array ('name' => $fieldtmp, 'email' => $value);
						break;

					case 'LOCATION':
						$this->_icalobj[$i]['location'] = strip_tags($value);
						break;

					case 'URL':
						$this->_icalobj[$i]['url'] = strip_tags($value);
						break;
				}
			}
		}
	}

	function BuildiCal($sessionvars, $mode, $start, $end, $location, $summary, $description, $url, $attendees, $extras = '', $uid = '', $organizer = '') {
		if ($this->_crlf == '') {
			$this->_crlf = "\r\n";
		}

		$BuildiCal = "BEGIN:VCALENDAR" . $this->_crlf;
		$BuildiCal .= "PRODID:-//Dominion Web//DWmail " . $this->_dwmversion . " MIMEDIR//EN" . $this->_crlf;
		$BuildiCal .= "VERSION:2.0" . $this->_crlf;
		if ($mode == "reply") {
			$BuildiCal .= "METHOD:REPLY" . $this->_crlf;
		}
		else {
			$BuildiCal .= "METHOD:REQUEST" . $this->_crlf;
		}
		$BuildiCal .= "BEGIN:VEVENT" . $this->_crlf;
		if (is_array($attendees)) {
			for ($i=0; $i<sizeof($attendees); $i++) {
				$BuildiCal .= "ATTENDEE;ROLE=REQ-PARTICIPANT;";
				if (strtoupper($extras) == 'ACCEPT') {
					$BuildiCal .= "PARTSTAT=ACCEPTED;";
				}
				elseif (strtoupper($extras) == 'DECLINE') {
					$BuildiCal .= "PARTSTAT=DECLINED;";
				}
				else {
					$BuildiCal .= "PARTSTAT=NEEDS-ACTION;";
				}
				$BuildiCal .= "RSVP=TRUE:MAILTO:" . $attendees[$i] . $this->_crlf;
			}
		}
		if (!empty($organizer)) {
			$BuildiCal .= "ORGANIZER:MAILTO:" . $organizer . $this->_crlf;
		}
		else {
			$BuildiCal .= "ORGANIZER:MAILTO:" . $sessionvars['currentemailaddress'] . $this->_crlf;
		}
		$BuildiCal .= "DTSTART:" . date("Ymd", $start) . "T" . date("Hi", $start) . "00Z" . $this->_crlf;
		$BuildiCal .= "DTEND:" . date("Ymd", $end) . "T" . date("Hi", $end) . "00Z" . $this->_crlf;
		$BuildiCal .= "LOCATION:" . $location . $this->_crlf;
		$BuildiCal .= "TRANSP:OPAQUE" . $this->_crlf;
		$BuildiCal .= "SEQUENCE:0" . $this->_crlf;
		if (!empty($uid)) {
			$BuildiCal .= "UID:" . $uid . $this->_crlf;
		}
		else {
			$BuildiCal .= "UID:DWM" . str_replace(" ", "", str_replace(".", "", $this->_dwmversion)) . time() . $this->_crlf;
		}
		$BuildiCal .= "DTSTAMP:" . gmdate("Ymd\THis\Z") . $this->_crlf;
		if (!empty($description)) {
			$BuildiCal .= "DESCRIPTION:" . $this->Wrap($description, 75, $this->_crlf . " ") . $this->_crlf;
		}
		if (!empty($url)) {
			$BuildiCal .= "URL:" . $this->Wrap($url, 75, $this->_crlf . " ") . $this->_crlf;
		}
		if (!empty($summary)) {
			$BuildiCal .= "SUMMARY:" . $this->Wrap($summary, 75, $this->_crlf . " ") . $this->_crlf;
		}
		$BuildiCal .= "PRIORITY:5" . $this->_crlf;
		$BuildiCal .= "CLASS:PUBLIC" . $this->_crlf;
		$BuildiCal .= "END:VEVENT" . $this->_crlf;
		$BuildiCal .= "END:VCALENDAR" . $this->_crlf;

		$this->_iCalOutput = $BuildiCal;

		return $BuildiCal;

	}

	function iCalDownload($filename) {
		$CalSize = strlen($this->_iCalOutput);
		$FileName = str_replace("+", "_", urlencode($filename)) . ".ics";
		ob_start();

		header ("Cache-Control: "); // leave blank to avoid IE errors
		header ("Pragma: "); // leave blank to avoid IE errors
		header ("Content-type: text/calendar");

		header ("Content-Transfer-Encoding: text");
		header ("Content-Length: $CalSize");
		header ("Content-Disposition: attachment; filename=\"$FileName\"");

		header ("Content-Description: File Attachment"); 

		echo $this->_iCalOutput;

		ob_end_flush();
	}

	function Wrap($field, $count, $wraptype) {
		$field = str_replace("\r\n", "\n", $field);
		$field = str_replace("\r", "\n", $field);
		$field = str_replace("\n", "\\n", $field);
		$field = wordwrap($field, $count, $wraptype);
		return $field;
	}

}

?>
