<?php
/*
############################################################################

############################################################################
*/

class WM_IMAPConnection {
	var $_sessionvars;
	var $_mailserver;
	var $_mailbox;
	var $_n;
	var $_numberofmessages;
	var $_messagesperpage;
	var $_msgheader;
	var $_structure;
	var $_host;
	var $_crlf;
	var $_folders;
	var $_subscribed;
	var $_lastsent;
	var $_sentfolderexist;
	var $_trashfolderexist;
	var $_draftsfolderexist;
	var $_inboxfolderexist;
	var $_mailboxerror;
	var $_compatibilitymode;
	var $_IMAPSentMailFolder;
	var $_IMAPTrashFolder;
	var $_IMAPDraftsFolder;
	var $_nextarry;
	var $_charset;
	var $_folderdelimiter;
	var $_foldertree;

	function WM_IMAPConnection($sessionvars) {
		$this->_sessionvars=$sessionvars;
		$this->_compatibilitymode = $this->_sessionvars['compatibilitymode'];
		return $this->_sessionvars['mailserver'];
	}

	function WM_IMAPCheckSecurity() {
		// In versions of DWmail prior to 3.4 we checked that the client IP address
		// was the same as that stored in the session.  This can cause a problem for 
		// proxies so we have changed this to match the first three parts of an IP4 address
		//  Change to if ($this->_sessionvars['remoteip'] == $_SERVER['REMOTE_ADDR']) {
		//  to match entire IP

		$remoteexp = explode(".", $this->_sessionvars['remoteip']);
		$sessionexp = explode(".", $_SERVER['REMOTE_ADDR']);
		if (($remoteexp[0] == $sessionexp[0]) && ($remoteexp[1] == $sessionexp[1]) && ($remoteexp[2] == $sessionexp[2])) {
			$securitycheck = 1;
		}
		else {
			$securitycheck = 0;
		}
		return $securitycheck;
	}

	function WM_IMAPConnect() {
		if ($this->_sessionvars['servertype'] == "pop3" || $this->_sessionvars['servertype'] == "pop3ssl") {
			if ($this->_sessionvars['servertype'] == "pop3ssl" && $this->_sessionvars['ssl'] == 1) {
				$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber'] . "/pop3/ssl/novalidate-cert}INBOX", $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p']);
				$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber'] . "/pop3/ssl/novalidate-cert}";
			}
			else {
				if ($this->_compatibilitymode == 1) {
					$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber'] . "/pop3/notls}INBOX", $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p']);
					$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber'] . "/pop3/notls}";
				}
				else {
					$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber'] . "/pop3}INBOX", $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p']);
					$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber'] . "/pop3}";
				}
			}
		}
		else {
			if ($this->_sessionvars['servertype'] == "imapssl" && $this->_sessionvars['ssl'] == 1) {
				$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/ssl/novalidate-cert}" . $this->_sessionvars['folder'], $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p']);
				$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/ssl/novalidate-cert}";
			}
			else {
				if ($this->_compatibilitymode == 1) {
					$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/notls}" .  $this->_sessionvars['folder'], $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p']);
					$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/notls}";
				}
				else {
					$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "}" . $this->_sessionvars['folder'], $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p']);
					$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "}";
				}
			}
		}
		if ($this->_mailbox == FALSE) {
			$this->_mailboxerror = imap_errors();
		}

		return $this->_mailbox;
	}

	function WM_IMAPHalfConnect() {
		// This is for IMAP only connections
		// This connects to the IMAP server but not to a mailbox
		if ($this->_sessionvars['servertype'] == "imapssl" && $this->_sessionvars['ssl'] == 1) {
			$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/ssl/novalidate-cert}" . $this->_sessionvars['folder'], $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p'], OP_HALFOPEN);
			$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/ssl/novalidate-cert}";
		}
		else {
			if ($this->_compatibilitymode == 1) {
				$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/notls}" . $this->_sessionvars['folder'], $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p'], OP_HALFOPEN);
				$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "/imap/notls}";
			}
			else {
				$this->_mailbox = @imap_open ("{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "}" . $this->_sessionvars['folder'], $this->_sessionvars['sess_u'], $this->_sessionvars['sess_p'], OP_HALFOPEN);
				$this->_host = "{" . $this->_sessionvars['mailserver'] . ":" . $this->_sessionvars['portnumber']  . "}";
			}
		}
		return $this->_mailbox;
	}

	function WM_FolderDecode($foldername) {
		return imap_utf7_decode($foldername);
	}

	function WM_FolderEncode($foldername) {
		return imap_utf7_encode($foldername);
	}

	function WM_IMAPFolders($subscribed = 0) {

		if ($this->_sessionvars['servertype'] == "pop3") {
			return FALSE;
		}
		else {
			if ($subscribed == 0) {
				$list = imap_getmailboxes($this->_mailbox, $this->_host, "*");
			}
			else {
				$list = imap_getsubscribed($this->_mailbox, $this->_host, "*");
			}
			if (is_array($list)) {
				$folder_counter=0;
				while (list($key, $val) = each($list)) {
					if (substr(stristr($val->name,"}"), 1) == "INBOX") {
						if ($val->delimiter <> '') {
							$this->_folderdelimiter = $val->delimiter;
						}
						$this->_inboxfolderexist = 1;
					}
					if (substr(stristr($this->WM_FolderDecode($val->name),"}"), 1) == $this->_IMAPSentMailFolder) {
						// Just incase it's still blank!
						if ($val->delimiter <> '') {
							$this->_folderdelimiter = $val->delimiter;
						}
						$this->_sendfolderexist = 1;
					}
					if (substr(stristr($this->WM_FolderDecode($val->name),"}"), 1) == $this->_IMAPTrashFolder) {
						$this->_trashfolderexist = 1;
					}
					if (substr(stristr($this->WM_FolderDecode($val->name),"}"), 1) == $this->_IMAPDraftsFolder) {
						$this->_draftsfolderexist = 1;
					}
					$folderset[$folder_counter] = substr(stristr($val->name,"}"), 1); 
					$folder_counter++;
				}
				sort($folderset);
				reset($folderset);
			}
			if (is_array($folderset)) {
				$folder_counter=0;
				while (list($key, $val) = each($folderset)) {
					if ($this->_folderdelimiter == '') {
						$this->_folderdelimiter = '.';
					}
					// This is an ugly fix for a strange problem that causes inbox.inbox to be created when using folder subscriptions
					if ($val <> "INBOX" . $this->_folderdelimiter . "INBOX") {
						$currfolexp = explode($this->_folderdelimiter, $val);
						$currfolexpsize = sizeof ($currfolexp);
						if (is_array($currfolexp)) {
							for ($i=0; $i<($currfolexpsize-1); $i++) {
								if ($i <> 0) {
									$parfolder .= $this->_folderdelimiter;
								}
								$parfolder .= $currfolexp[$i];
							}
							$currfol = $currfolexp[$currfolexpsize-1];
						}
						$this->_foldertree[$parfolder][$currfol] = 1;
						unset ($currfolexp);
						unset ($currfolexpsize);
						unset ($parfolder);
						unset ($currfol);
						$folders[$folder_counter]['name'] = $this->WM_FolderDecode($val);
						$folders[$folder_counter]['id'] = $val;
require ("./includes/config.inc.php");
 if ($folders[$folder_counter]['name']=="INBOX"){$folders[$folder_counter]['name']=$Inbx;}
 if ($folders[$folder_counter]['name']=="INBOX.Drafts"){$folders[$folder_counter]['name']=$Drf;}
 if ($folders[$folder_counter]['name']=="INBOX.Trash"){$folders[$folder_counter]['name']=$Trsh;}
 if ($folders[$folder_counter]['name']=="INBOX.sent-mail"){$folders[$folder_counter]['name']=$Outbx;}

						$folder_counter++;

					}
				}
			}
			$this->_folders = $folders;
			return TRUE;
		}

	}

	function WM_IMAPSaveSent($CyrusIMAP, $SMTPmode, $IMAPSentMail, $IMAPSubscribe = 0) {
		$currentdate = date("d M Y H:i:s O");
		if (($CyrusIMAP == 1) && ($this->_crlf <> "\r\n")) {
			if ($SMTPmode <> 1) {
				$finalmessage = "To: " . $this->_lastsent['to'] . "\r\n";
				$finalmessage .= "Subject: " . $this->_lastsent['subject'] . "\r\n";
				$finalmessage .= "Date: " . $currentdate. "\r\n";
			}
			$finalmessage .= str_replace("\n", "\r\n", $this->_lastsent['header']) . "\r\n";
			$finalmessage .= str_replace("\n", "\r\n", $this->_lastsent['message']);

		}
		else {
			if ($SMTPmode <> 1) {
				$finalmessage = "To: " . $this->_lastsent['to'] . $this->_crlf;
				$finalmessage .= "Subject: " . $this->_lastsent['subject'] . $this->_crlf;
				$finalmessage .= "Date: " . $currentdate. $this->_crlf;
			}
			$finalmessage .= $this->_lastsent['header'] . $this->_crlf;
			$finalmessage .= $this->_lastsent['message'];
		}
		imap_append($this->_mailbox, $this->_host . $IMAPSentMail, $finalmessage);
		unset ($this->_lastsent);
	}

	function WM_IMAPFolderCreate($whichfolder, $inwhich = '') {
		if ($inwhich <> "") {
			$createfolder = @imap_createmailbox($this->_mailbox, $this->_host . $inwhich . $this->_folderdelimiter . $this->WM_FolderEncode($whichfolder));
		}
		else {
			$createfolder = @imap_createmailbox($this->_mailbox, $this->_host . $this->WM_FolderEncode($whichfolder));
		}
		if ($createfolder == FALSE) {
			$createfolder = imap_errors();
		}
		else {
			$createfolder = TRUE;
		}

		return $createfolder;
	}

	function WM_IMAPFolderSubscribe($whichfolder, $inwhich = '') {
		if ($inwhich <> "") {
			$subscribefolder = @imap_subscribe($this->_mailbox, $this->_host . $inwhich . $this->_folderdelimiter . $this->WM_FolderEncode($whichfolder));
		}
		else {
			$subscribefolder = @imap_subscribe($this->_mailbox, $this->_host . $this->WM_FolderEncode($whichfolder));
		}
		if ($subscribefolder == FALSE) {
			$subscribefolder = imap_errors();
		}
		else {
			$subscribefolder = TRUE;
		}

		return $subscribefolder;
	}

	function WM_IMAPFolderUnsubscribe($whichfolder) {
		$subscribefolder = @imap_unsubscribe($this->_mailbox, $this->_host . $whichfolder);
		if ($subscribefolder == FALSE) {
			$subscribefolder = imap_errors();
		}
		else {
			$subscribefolder = TRUE;
		}

		return $subscribefolder;
	}

	function WM_IMAPFolderDelete($whichfolder, $CyrusIMAP) {
		if ($whichfolder <> "") {
			$unsubscribefolder = imap_unsubscribe($this->_mailbox, $this->_host . $whichfolder);
			if ($CyrusIMAP == 1) {
				$setacl = imap_setacl ($this->_mailbox, $whichfolder, $this->_sessionvars['sess_u'], "");
			}
			$deletefolder = imap_deletemailbox($this->_mailbox, $this->_host . $whichfolder);
			if ($deletefolder == FALSE) {
				$deletefolder = imap_errors();
			}
			else {
				$deletefolder = TRUE;
			}
			return $deletefolder;
		}
		else {
			return FALSE;
		}

	}

	function WM_IMAPFolderRename($whichfolder, $tofolder) {
		if (trim($whichfolder) <> "" && trim($tofolder <> "")) {
			$lastfoldername = explode(".", $whichfolder);
			$lastfoldernamecount = sizeof ($lastfoldername);
			$parentfolder = str_replace($lastfoldername[$lastfoldernamecount-1], "", $whichfolder);

			$renamefolder = imap_renamemailbox($this->_mailbox, $this->_host . $whichfolder, $this->_host . $parentfolder . $this->WM_FolderEncode($tofolder));
			if ($renamefolder == FALSE) {
				$renamefolder = imap_errors();
			}
			else {
				$renamefolder = TRUE;
			}
			return $renamefolder;
		}
		else {
			return FALSE;
		}

	}

	function WM_IMAPMove($msgid, $destfolder, $CyrusIMAP) {
		// Why aren't we using imap_mail_move()?
		// If you don't have the IMAP devel libraries installed
		// this function still returns true even though it doesn't
		// work, so to this end we have decided to use imap_append()
		// $msgid can be an array for bulk move
		if (!is_array($msgid)) {
			$header = $this->WM_IMAPRFCHeader($msgid);
			$body = $this->WM_IMAPGetBody($msgid, -1, -1);
			if ($CyrusIMAP == 1) {
				// This may look a bit strange but what we are doing here
				// Is forcing all \r\n to \n and then grabbing all
				// \n and converting to \r\n the number of \n may be
				// greater than the number of \r\n
				$header = str_replace("\r\n", "\n", $header);
				$header = str_replace("\n", "\r\n", $header);

				$body = str_replace("\r\n", "\n", $body);
				$body = str_replace("\n", "\r\n", $body);
				$finalmessage = $header . $body;
			}
			else {
				$finalmessage = $header . $body;
			}
			$movemessage = imap_append($this->_mailbox, $this->_host . $destfolder, $finalmessage);
			if ($movemessage == TRUE) {
				$this->WM_IMAPDelete($msgid);
				$this->WM_IMAPExpungeMailbox();
			}
			return $movemessage;
		}
		else {
			$noerrors = TRUE;		
			while(list($key, $value) = each($msgid)) { 
				$header = $this->WM_IMAPRFCHeader($key);
				$body = $this->WM_IMAPGetBody($key, -1, -1);
				if ($CyrusIMAP == 1) {
					// This may look a bit strange but what we are doing here
					// Is forcing all \r\n to \n and then grabbing all
					// \n and converting to \r\n the number of \n may be
					// greater than the number of \r\n
					$header = str_replace("\r\n", "\n", $header);
					$header = str_replace("\n", "\r\n", $header);

					$body = str_replace("\r\n", "\n", $body);
					$body = str_replace("\n", "\r\n", $body);
					$finalmessage = $header . $body;
				}
				else {
					$finalmessage = $header . $body;
				}
				$movemessage = imap_append($this->_mailbox, $this->_host . urldecode($destfolder), $finalmessage);
				$tmp = imap_errors();
				if ($movemessage == TRUE) {
					$this->WM_IMAPDelete($key);
				}
				if ($movemessage == FALSE) {
					$noerrors = FALSE;
				}
			}
			$this->WM_IMAPExpungeMailbox();
			return $noerrors;
		}
	}

	function WM_IMAPCopy($destfolder, $CyrusIMAP, $header, $body) {
		if ($CyrusIMAP == 1) {
			// This may look a bit strange but what we are doing here
			// Is forcing all \r\n to \n and then grabbing all
			// \n and converting to \r\n the number of \n may be
			// greater than the number of \r\n
			$header = str_replace("\r\n", "\n", $header);
			$header = str_replace("\n", "\r\n", $header);

			$body = str_replace("\r\n", "\n", $body);
			$body = str_replace("\n", "\r\n", $body);
			$finalmessage = $header . $body;
		}
		else {
			$finalmessage = $header . $body;
		}
		$movemessage = imap_append($this->_mailbox, $this->_host . $destfolder, $finalmessage);
		return $movemessage;
	}

	function WM_IMAPMailboxInfo() {
		return imap_mailboxmsginfo($this->_mailbox);
	}

	function WM_IMAPSearch($phrase, $sort, $order) {

		$sorttype = array("SORTARRIVAL", "SORTDATE", "SORTSUBJECT", "SORTFROM", "SORTSIZE", "SORTTO");
		if (!in_array($sort, $sorttype)) {
			$sort = "SORTDATE";
		}

		if ($order <> "1") {
			$order = "0";
		}
		if ($sort == "SORTSUBJECT") {
			$sortmessages = imap_sort($this->_mailbox, SORTSUBJECT, $order, SE_NOPREFETCH | SE_UID, $phrase);
		}
		elseif ($sort == "SORTFROM") {
			$sortmessages = imap_sort($this->_mailbox, SORTFROM, $order, SE_NOPREFETCH | SE_UID, $phrase);
		}
		elseif ($sort == "SORTSIZE") {
			$sortmessages = imap_sort($this->_mailbox, SORTSIZE, $order, SE_NOPREFETCH | SE_UID, $phrase);
		}
		elseif ($sort == "SORTTO") {
			$sortmessages = imap_sort($this->_mailbox, SORTTO, $order, SE_NOPREFETCH | SE_UID, $phrase);
		}
		elseif ($sort == "SORTDATE") {
			$sortmessages = imap_sort($this->_mailbox, SORTDATE, $order, SE_NOPREFETCH | SE_UID, $phrase);
		}
		else {
			$sortmessages = imap_sort($this->_mailbox, SORTARRIVAL, $order, SE_NOPREFETCH | SE_UID, $phrase);
		}

		$size = sizeof($sortmessages); 

		$x = 0;
		for ($i = $size; $i >= 1; $i--) {
			$overview = imap_fetch_overview($this->_mailbox, $sortmessages[$i-1], FT_UID); 
			$val = $overview[0]; 
			$msg = $val->msgno; 
			$msguid = $val->uid;
			$from = $val->from; 
			$from = trim(ereg_replace('<([^>]|\n)*>', '', $from)); 
			$from = $from;
			$date = $val->date; 
			$subj = "";
			$subj2 = imap_mime_header_decode($val->subject);
			for($j=0;$j<count($subj2);$j++) {
				$subj .= $subj2[$j]->text;
			}
			$subj = strip_tags($subj);
			$subj = trim($subj);
			$subj = $subj;
			$MessageList[$x]['message_number'] = $msg;
			$MessageList[$x]['message_uid'] = $msguid;
			$MessageList[$x]['message_from'] = $from;
			$MessageList[$x]['message_title'] = $subj;
			$MessageList[$x]['message_date'] = $date;
			$x++;
		}
		return $MessageList;
		
	}

	function WM_IMAPNumMessages() {
		$this->_numberofmessages = imap_num_msg($this->_mailbox);
		return $this->_numberofmessages;
	}

	function WM_IMAPStatus($CurrentFolderID) {
		$folderstatus = imap_status($this->_mailbox, "$this->_host" . $CurrentFolderID, SA_ALL);
		if ($folderstatus) {
			return $folderstatus;
		}
		else {
			return false;
		}
	}

	function WM_IMAPClose() {
		imap_close($this->_mailbox); 
	}

	function WM_IMAPGetHeader($msgid) {
		$msgseqid = $this->GetSeqNum($msgid);
		$this->_msgheader = imap_headerinfo($this->_mailbox, $msgseqid); 
	}

	function WM_IMAPRFCHeader($msgid) {
		return imap_fetchheader($this->_mailbox, $msgid, FT_UID); 
	}

	function WM_IMAPDelete($msgid) {
		imap_delete($this->_mailbox, intval($msgid), FT_UID);
	}

	function WM_IMAPSetFlag($whichflag, $msgid) {
		// Only valid types we will allow here are
		// Seen Answered and Draft (see rfc2060)
		if ($whichflag == "\\Seen" || $whichflag == "\\Answered" || $whichflag == "\\Draft") {
			$flagstatus = imap_setflag_full($this->_mailbox, $msgid, $whichflag, ST_UID); 
			return $flagstatus;
		}
		else {
			return FALSE;
		}
	}

	function WM_IMAPClearFlag($msgid) {
		$flagstatus = imap_clearflag_full($this->_mailbox, $msgid, '\\Seen', ST_UID); 
	}

	function WM_IMAPExpungeMailbox() {
		imap_expunge($this->_mailbox); 
	}

	function WM_IMAPFullHeaders() {
		$from2 = imap_mime_header_decode($this->_msgheader->fromaddress);
		for($j=0;$j<count($from2);$j++) {
			$messageheader['fromaddress'] .= $from2[$j]->text;
		}
		$to2 = imap_mime_header_decode($this->_msgheader->toaddress);
		for($j=0;$j<count($to2);$j++) {
			$to .= $to2[$j]->text;
		}
		$cc2 = imap_mime_header_decode($this->_msgheader->ccaddress);
		for($j=0;$j<count($cc2);$j++) {
			$cc .= $cc2[$j]->text;
		}
		$bcc2 = imap_mime_header_decode($this->_msgheader->bccaddress);
		for($j=0;$j<count($bcc2);$j++) {
			$bcc .= $bcc2[$j]->text;
		}
		$sender2 = imap_mime_header_decode($this->_msgheader->senderaddress);
		for($j=0;$j<count($sender2);$j++) {
			$sender .= $sender2[$j]->text;
		}
		$messageheader['toaddress'] = $to;
		$messageheader['ccaddress'] = $cc;
		$messageheader['bccaddress'] = $bcc;
		$messageheader['senderaddress'] = $sender;
		$messageheader['reply_toaddress'] = $this->_msgheader->reply_toaddress;
		$messageheader['date'] = $this->_msgheader->date;
		$messageheader['messageid'] = $this->_msgheader->message_id;
		$messageheader['Recent'] = $this->_msgheader->Recent;
		$messageheader['Unseen'] = $this->_msgheader->Unseen;
		return $messageheader;
	}

	function WM_IMAPMsgFrom() {
		$from = $this->_msgheader->from;
		foreach ($from as $id2 => $object) {
			$from2 = imap_mime_header_decode($object->personal);
			for($j=0;$j<count($from2);$j++) {
				$fromdetails['name'] .= $from2[$j]->text;
			}
			$fromdetails['address'] = $object->mailbox . "@" . $object->host;
		}
		return $fromdetails;
	}

	function AddAttachment($type, $name, $content, $cid = '', $description = '') {
		$message = "Content-Type: " . $type . ";" . $this->_crlf;
		$message .= " name=\"" . $name . "\"" . $this->_crlf;
		$message .= "Content-Transfer-Encoding: base64" . $this->_crlf;
		if ($cid == '') {
			$message .= "Content-Disposition: attachment; filename=\"" . $name . "\"" . $this->_crlf;
		}
		if ($cid <> '') {
			$message .= "Content-ID: <" . $cid . ">" . $this->_crlf;
		}
		if ($description <> '') {
			$message .= "Content-Description: " . $description . $this->_crlf;
		}
		$message .= $this->_crlf;
		$message .= str_replace("\r\n", $this->_crlf, chunk_split(base64_encode($content))) . $this->_crlf;
		return $message;
	}

	function AddPart($type, $content, $was_html = 0) {
		require_once("./includes/mime.inc.php");
		$MIMEChecker = new MIME();
		$checkord = $MIMEChecker->check8bit($content);
		if ($checkord == TRUE) {
			$header .=  $this->_crlf . "Content-Transfer-Encoding: quoted-printable";
			$sbody = str_replace("=\r\n","=" . $this->_crlf,imap_8bit($sbody));
		}
		$message = "Content-Type: " . $type . ";" . $this->_crlf;
		$message .= "	charset=\"" . $this->_charset . "\"" . $this->_crlf;
		if ($type == 'text/plain' || $type == 'message/disposition-notification') {
			if ($was_html == 1) {
				$content = str_replace ("<BR>", "\n", $content);
				$content = str_replace ("<BR />", "\n", $content);
				$content = str_replace ("<br>", "\n", $content);
				$content = str_replace ("<br />", "\n", $content);
				$content = str_replace ("</p>", "\n\n", $content);
				$content = str_replace ("</P>", "\n\n", $content);
				$content = strip_tags ($content);
				// Convert HTMLentities back to their raw form
				$content = unhtmlentities($content);
			}
		}
		if (($type == 'text/plain' && $checkord == FALSE) || $type == 'message/disposition-notification') {
			$message .= "Content-Transfer-Encoding: 7bit" . $this->_crlf . $this->_crlf;
			$message .= $content . $this->_crlf;
		}
		else {
			$message .= "Content-Transfer-Encoding: quoted-printable" . $this->_crlf . $this->_crlf;
			$message .= str_replace("=\r\n","=" . $this->_crlf,imap_8bit($content)) . $this->_crlf;
		}
		return $message;
	}

	function AddMIME($type, $separator, $omitmime = 0, $extras = '', $omitboundary = 0, $omitcontenttype = 0) {
		$message = '';
		if ($omitmime == 0) {
			$message .= "MIME-Version: 1.0" . $this->_crlf;
		}
		if ($omitcontenttype == 0) {
			$message .= "Content-Type: " . $type . ";";
		}
		if ($extras <> '') {
			$message .= " " . $extras;
		}
		if ($omitboundary == 0) {
			$message .= " boundary=\"" . $separator . "\"" . $this->_crlf . $this->_crlf;
		}
		return $message;
	}

	function WM_IMAPSendReceipt($to, $messageid, $subject, $currentemailaddress, $SMTPmode, $msgdate = 0) {
		require_once("./includes/mime.inc.php");
		$MIMEChecker = new MIME();

		$checkord = $MIMEChecker->check8bit($subject);
		if ($checkord == TRUE) {
			$subject = $MIMEChecker->RFCEncode($subject, $this->_charset);
		}

		$AllowableChrs = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

		$separator = '__00';
		for ($i=0; $i<20; $i++) {
			$separator .= $AllowableChrs[rand(0,strlen($AllowableChrs)-1)];
		}

		$header = "From: " . $currentemailaddress . $this->_crlf;
		$header .= "Return-Path: <" . $currentemailaddress . ">" . $this->_crlf;
		if ($SMTPmode == 1) {
			if ($to <> "") {
				$header .= "To:" . $to . $this->_crlf;
			}
			$currentdate = date("d M Y H:i:s O");
			$header .= "Read: " . $subject . $this->_crlf;
			$header .= "Date: " . $currentdate . $this->_crlf;
			$header .= "Subject: Read: " . $subject . $this->_crlf;
		}
		$header .= "X-Originating-IP: [" . $this->_sessionvars['remoteip'] . "]" . $this->_crlf;
		if ($this->_sessionvars['mailserver'] == "localhost") {
			$originatingserver = $_SERVER['SERVER_NAME'];
		}
		else {
			$originatingserver = $this->_sessionvars['mailserver'];
		}
		$header .= "X-Originating-Server: [" . $originatingserver . "]" . $this->_crlf;
		$header .= "X-Mailer: DWmail 3.6.2" . $this->_crlf; 
		$header .= $this->AddMIME('multipart/report', $separator, 0, 'report-type=disposition-notification;');

		$header .= "This is a MIME message. If you are reading this text, you" . $this->_crlf;
		$header .= "might want to consider changing to a mail reader that" . $this->_crlf;
		$header .= "understands how to properly display MIME multipart messages" . $this->_crlf . $this->_crlf;

		$message .= "--$separator" . $this->_crlf;

		$plainbody = "Your message" . $this->_crlf . $this->_crlf;
		$plainbody .= "\tTo:\t" . $currentemailaddress . $this->_crlf;
		$plainbody .= "\tSubject:\t$subject" . $this->_crlf;
		$plainbody .= "\tSent:\t$msgdate" . $this->_crlf . $this->_crlf;
		$plainbody .= "was read on " . date("d/m/Y H:i") . ".";

		$message .= $this->AddPart('text/plain', $plainbody);

		$message .= "--$separator" . $this->_crlf;

		$disposbody = "Reporting-UA: " . $_SERVER['SERVER_NAME'] . "; DWmail version 3.6.2" . $this->_crlf;
		$disposbody .= "Final-Recipient: rfc822;$to" . $this->_crlf;
		$disposbody .= "Original-Message-ID: $messageid" . $this->_crlf;
		$disposbody .= "Disposition: manual-action/MDN-sent-manually; displayed" . $this->_crlf;

		$message .= $this->AddPart('message/disposition-notification', $disposbody);

		$message .= "--$separator"."--" . $this->_crlf;

		$sentemail['to'] = $to;
		$sentemail['subject'] = "Read: " . $subject;
		$sentemail['message'] = $message;
		$sentemail['header'] = $header;

		return $sentemail;
	}

	function WM_IMAPBuildEmail($sto, $cc, $bcc, $replyto, $ssubject, $sbody, $attachments, $preattachedfiles, $AttachmentNumber, $mode, $priority, $receipt, $currentemailaddress, $SMTPmode, $pname, $alias = '', $contenttype = 'text/plain', $mid = '') {
		require_once("./includes/mime.inc.php");
		$MIMEChecker = new MIME();

		$noattachments = 1;

		if ($replyto == "") {
			$replyto = $currentemailaddress;
			$replyto2 = "Reply-To: " . $currentemailaddress . $this->_crlf;
		}
		else {
			$replyto2 = "Reply-To: " . $replyto . $this->_crlf;
		}

		if (isset($pname) && ($pname <> "")) {
			$checkordpname = $MIMEChecker->check8bit($pname);
			if ($checkordpname == TRUE) {
				$pname = $MIMEChecker->RFCEncode($pname, $this->_charset);
			}
			$listemailcurrent = '"' . $pname . '" <' . $_SESSION['currentemailaddress'] . '>';
		}
		else {
			$listemailcurrent = $_SESSION['currentemailaddress'];
		}

		$checkord = $MIMEChecker->check8bit($ssubject);
		if ($checkord == TRUE) {
			$ssubject = $MIMEChecker->RFCEncode($ssubject, $this->_charset);
		}

		$messagedate = date("D, d M y H:i:s T");
		$commonheaders = "Received: from " . $this->_sessionvars['remoteip'] . " by " . $_ENV["HOSTNAME"] . " ([" . $_SERVER["SERVER_ADDR"] . "]); " . $messagedate . $this->_crlf;
		if ($alias <> '') {
			$commonheaders .= "From: " . $alias . $this->_crlf;
			$commonheaders .= "Sender: " . $listemailcurrent . $this->_crlf;
		}
		else {
			$commonheaders .= "From: " . $listemailcurrent . $this->_crlf;
		}
		$commonheaders .= "Return-Path: <" . $currentemailaddress . ">" . $this->_crlf;
		$commonheaders .= "Reply-To: " . $replyto . $this->_crlf;
		if ($cc <> "") {
			$commonheaders .= "Cc: " . $cc . $this->_crlf;
		}
		if ($bcc <> "") {
			$commonheaders .= "Bcc: " . $bcc . $this->_crlf;
		}
		if ($SMTPmode == 1) {
			if ($sto <> "") {
				$commonheaders .= "To: " . $sto . $this->_crlf;
			}
			if ($ssubject <> "") {
				$commonheaders .= "Subject: " . $ssubject . $this->_crlf;
			}
			$currentdate = date("d M Y H:i:s O");
			$commonheaders .= "Date: " . $currentdate . $this->_crlf;
		}
		$commonheaders .= "X-Originating-IP: [" . $this->_sessionvars['remoteip'] . "]" . $this->_crlf;
		$commonheaders .= "X-Originating-Server: [" . $this->_sessionvars['mailserver'] . "]" . $this->_crlf;
		$commonheaders .= "X-Mailer: DWmail 3.6.2" . $this->_crlf; 

		if ($priority == 1) {
			$commonheaders .= "X-Priority: 1 (Highest)" . $this->_crlf;
			$commonheaders .= "X-MSMail-Priority: High" . $this->_crlf;
			$commonheaders .= "Importance: High" . $this->_crlf;
		}
		elseif ($priority == 3) {
			$commonheaders .= "X-Priority: 5 (Lowest)" . $this->_crlf;
			$commonheaders .= "X-MSMail-Priority: Low" . $this->_crlf;
			$commonheaders .= "Importance: Low" . $this->_crlf;
		}
		if ($receipt <> "") {
			$commonheaders .= "Disposition-Notification-To: $replyto" . $this->_crlf;
			$commonheaders .= "Return-Receipt-To: $replyto" . $this->_crlf;
		}
		if ($mid <> "") {
			$commonheaders .= "In-Reply-To: $mid" . $this->_crlf;
		}

		$commonmime_error = "This is a MIME message. If you are reading this text, you" . $this->_crlf;
		$commonmime_error .= "might want to consider changing to a mail reader that" . $this->_crlf;
		$commonmime_error .= "understands how to properly display MIME multipart messages" . $this->_crlf . $this->_crlf;

		for ($x=0; $x<$AttachmentNumber; $x++) {
			if ($attachments[$x]['name'] <> "") {
				$noattachments = 0;
			}
		}

		if (is_array($preattachedfiles)) {
			$noattachments = 0;
		}

		$AllowableChrs = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

		$separator = '__00';
		for ($i=0; $i<20; $i++) {
			$separator .= $AllowableChrs[rand(0,strlen($AllowableChrs)-1)];
		}

		// There are four core types for sending email
		// 1) multipart/mixed for plain emails with attachments
		// 2) multipart/mixed with a subtype of multipart/alternative for HTML with attachments
		// 3) text/plain and text/html multipart email
		// 4) text/plain email

		// multipart/mixed for plain text with attachments
		if ($noattachments == 0 && $mode == "text") {

			$header = $commonheaders;
			$header .= $this->AddMIME('Multipart/Mixed', $separator);
			$header .= $commonmime_error;

			$message ="";
			$message .= "--$separator" . $this->_crlf;
			$message .= $this->AddPart('text/plain', $sbody);

			for ($x=0; $x<$AttachmentNumber; $x++) {
				if ($attachments[$x]['name'] <> "") {
					$message .= $this->_crlf . "--$separator" . $this->_crlf;
					$message .= $this->AddAttachment($attachments[$x]['type'], $attachments[$x]['name'], $attachments[$x]['contents'], $attachments[$x]['cid']);
					$filecontents == "";
				}
			}
			if (is_array($preattachedfiles)) {
				for ($x=0; $x<sizeof($preattachedfiles); $x++) {
					if ($preattachedfiles[$x]['name'] <> "") {
						$message .= $this->_crlf . "--$separator" . $this->_crlf;
						$message .= $this->AddAttachment($preattachedfiles[$x]['type'], $preattachedfiles[$x]['name'], $preattachedfiles[$x]['contents'], $preattachedfiles[$x]['cid'], $preattachedfiles[$x]['description']);
						$filecontents == "";
					}
				}
			}

			$message .= "--$separator"."--" . $this->_crlf;

			$this->_lastsent['to'] = $sto;
			$this->_lastsent['subject'] = $ssubject;
			$this->_lastsent['message'] = $message;
			$this->_lastsent['header'] = $header;

			$sentemail['to'] = $sto;
			$sentemail['subject'] = $ssubject;
			$sentemail['message'] = $message;
			$sentemail['header'] = $header;

		}

		// multipart/mixed for html with attachments
		elseif ($noattachments == 0 && $mode <> "text") {
			$header = $commonheaders;
			$header .= $this->AddMIME('Multipart/Mixed', $separator);
			$header .= $commonmime_error;

			$separator2 = '__01';
			for ($i=0; $i<20; $i++) {
				$separator2 .= $AllowableChrs[rand(0,strlen($AllowableChrs)-1)];
			}

			$message ="";
			$message .= "--$separator" . $this->_crlf;
			$message .= $this->AddMIME('multipart/alternative', $separator2, 1);

			$message .= "--$separator2" . $this->_crlf;
			$message .= $this->AddPart('text/plain', $sbody, 1);
			$message .= $this->_crlf . "--$separator2" . $this->_crlf;
			$message .= $this->AddPart('text/html', $sbody);
			$message .= "--$separator2"."--" . $this->_crlf;

			for ($x=0; $x<$AttachmentNumber; $x++) {
				if ($attachments[$x]['name'] <> "") {
					$message .= $this->_crlf . "--$separator" . $this->_crlf;
					$message .= $this->AddAttachment($attachments[$x]['type'], $attachments[$x]['name'], $attachments[$x]['contents'], $attachments[$x]['cid']);
					$filecontents == "";
				}
			}
			if (is_array($preattachedfiles)) {
				for ($x=0; $x<sizeof($preattachedfiles); $x++) {
					if ($preattachedfiles[$x]['name'] <> "") {
						$message .= $this->_crlf . "--$separator" . $this->_crlf;
						$message .= $this->AddAttachment($preattachedfiles[$x]['type'], $preattachedfiles[$x]['name'], $preattachedfiles[$x]['contents'], $preattachedfiles[$x]['cid'], $preattachedfiles[$x]['description']);
						$filecontents == "";
					}
				}
			}

			$message .= "--$separator"."--" . $this->_crlf;

			$this->_lastsent['to'] = $sto;
			$this->_lastsent['subject'] = $ssubject;
			$this->_lastsent['message'] = $message;
			$this->_lastsent['header'] = $header;

			$sentemail['to'] = $sto;
			$sentemail['subject'] = $ssubject;
			$sentemail['message'] = $message;
			$sentemail['header'] = $header;

		}

		// Send a text/plain and text/html email message
		elseif ($noattachments <> 0 && $mode <> "text") {
			$header = $commonheaders;
			$header .= $this->AddMIME('multipart/alternative', $separator);
			$header .= $commonmime_error;

			$message ="";

			$message .= "--$separator" . $this->_crlf;
			$message .= $this->AddPart('text/plain', $sbody , 1);
			$message .= $this->_crlf . "--$separator" . $this->_crlf;
			$message .= $this->AddPart('text/html', $sbody);
			$message .= "--$separator"."--" . $this->_crlf;


			$this->_lastsent['to'] = $sto;
			$this->_lastsent['subject'] = $ssubject;
			$this->_lastsent['message'] = $message;
			$this->_lastsent['header'] = $header;

			$sentemail['to'] = $sto;
			$sentemail['subject'] = $ssubject;
			$sentemail['message'] = $message;
			$sentemail['header'] = $header;
		}

		// text/plain email only
		else {
			$checkord = $MIMEChecker->check8bit($sbody);
			$header = $commonheaders;
			if ($checkord == TRUE || $contenttype <> 'text/plain') {
				$header .= $this->AddMIME('', '', $omitmime = 0, $extras = '', $omitboundary = 1, $omitcontenttype = 1);
			}
			if (empty($contenttype)) {
				$contenttype = 'text/plain';
			}
			$header .= "Content-Type: $contenttype;" . $this->_crlf;
			$header .= "	charset=\"" . $this->_charset . "\"" . $this->_crlf;
			if ($checkord == TRUE) {
				$header .=  "Content-Transfer-Encoding: quoted-printable" . $this->_crlf;
				$sbody = str_replace("=\r\n","=" . $this->_crlf,imap_8bit($sbody));
			}

			$this->_lastsent['to'] = $sto;
			$this->_lastsent['subject'] = $ssubject;
			$this->_lastsent['message'] = $sbody;
			$this->_lastsent['header'] = $header;

			$sentemail['to'] = $sto;
			$sentemail['subject'] = $ssubject;
			$sentemail['message'] = $sbody;
			$sentemail['header'] = $header;
		}
		return $sentemail;
	}

	function WM_IMAPSendMail($sentmail) {
		$sentemail2 = imap_mail($sentmail['to'], $sentmail['subject'], $sentmail['message'], $sentmail['header']);

		if ($sentemail2 == FALSE) {
			$emailreturn = imap_errors();
		}
		else {
			$emailreturn = TRUE;
		}
		return $emailreturn;
	}

	function WM_IMAPGetSubject() {
		$subj = "";
		$subj2 = imap_mime_header_decode($this->_msgheader->subject);
		for($i=0;$i<count($subj2);$i++) {
			$subj .= $subj2[$i]->text;
		}
		$subj = strip_tags($subj);
		$subj = trim($subj);
		$subj = $subj;
		return $subj;
	}

	function WM_IMAPGetBody($msgid, $partid, $subpartid, $internal = 0) {
		if ($partid >= 0) {
			if (strstr($partid, ".")) {
				$content = imap_fetchbody($this->_mailbox, $msgid, $partid, FT_UID);
			}
			elseif ($subpartid >= 0 && !strstr($partid, ".")) {
				$content = imap_fetchbody($this->_mailbox, $msgid, $partid . "." . $subpartid, FT_UID);
			}
			else {
				$content = imap_fetchbody($this->_mailbox, $msgid, $partid, FT_UID);
			}
		}
		elseif ($internal = 1) {
			$content = imap_body($this->_mailbox, $msgid, FT_UID | FT_INTERNAL);
		}
		else {
			$content = imap_body($this->_mailbox, $msgid, FT_UID);
		}
		return $content;
	}

	function WM_IMAPGetStructure($msgid) {
		$this->_structure = imap_fetchstructure($this->_mailbox, $msgid, FT_UID);
		return $this->_structure;
	}

	function WM_IMAPList($firstmessage, $lastmessage, $getnext = 0, $runfilter = 0) {
		global $DefaultCharSet;

		// Unfortunately this is the slow bit.  IMAP_SORT() retrieves all of the headers and bodies from
		// the server.  For remote or large mailboxes this can be time consuming.  If we didn't want to have sorting
		// we could just use imap_fetch_overview() with a message range which would make it much faster
		// but for functionality reasons we haven't implemented that method.

		$sorttype = array("SORTARRIVAL", "SORTDATE", "SORTSUBJECT", "SORTFROM", "SORTSIZE", "SORTTO", "THREADED");
		if (!in_array($this->_sessionvars['sort'], $sorttype)) {
			$this->_sessionvars['sort'] = "SORTDATE";
		}

		if ($this->_sessionvars['order'] <> 1) {
			$this->_sessionvars['order'] = 0;
		}
		if ($this->_sessionvars['sort'] == "SORTSUBJECT") {
			$sortmessages = imap_sort($this->_mailbox, SORTSUBJECT, $this->_sessionvars['order'], SE_UID | SE_NOPREFETCH);
		}
		elseif ($this->_sessionvars['sort'] == "SORTFROM") {
			$sortmessages = imap_sort($this->_mailbox, SORTFROM, $this->_sessionvars['order'], SE_UID | SE_NOPREFETCH);
		}
		elseif ($this->_sessionvars['sort'] == "SORTSIZE") {
			$sortmessages = imap_sort($this->_mailbox, SORTSIZE, $this->_sessionvars['order'], SE_UID | SE_NOPREFETCH);
		}
		elseif ($this->_sessionvars['sort'] == "SORTTO") {
			$sortmessages = imap_sort($this->_mailbox, SORTTO, $this->_sessionvars['order'], SE_UID | SE_NOPREFETCH);
		}
		elseif ($this->_sessionvars['sort'] == "SORTDATE") {
			$sortmessages = imap_sort($this->_mailbox, SORTDATE, $this->_sessionvars['order'], SE_UID | SE_NOPREFETCH);
		}
		elseif ($this->_sessionvars['sort'] == "THREADED") {
			$threads = @imap_thread($this->_mailbox);
			$indent = -1;
			if (is_array($threads)) {
				while (list($key, $value) = each($threads)) {
					$tree = explode(".", $key);
					if ($tree[1] == 'num') {
						$uid = $this->GetUID($value);
						if (!empty($uid)) {
							$sortmessages[$tree[0]] = $this->GetUID($value);
							$indent++;
							$sortindent[$tree[0]] = $indent;
						}
					}
					if ($tree[1] == 'branch') {
						if ($indent >= 0 ) {
							$indent--;
						}
						else {
							$indent = -1;
						}
					}
				}
			}
		}
		else {
			$sortmessages = imap_sort($this->_mailbox, SORTARRIVAL, $this->_sessionvars['order'], SE_UID | SE_NOPREFETCH);
		}
		$size = sizeof($sortmessages); 

		$MainSettings = new GlobalInit();
		$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

		// This bit actually sets up the array of messages
		if ($runfilter <> 1) {
			for ($i = $firstmessage - 1; $i < $lastmessage; $i++) {
				$overview = imap_fetch_overview($this->_mailbox, $sortmessages[$i], FT_UID);
				$val = $overview[0]; 
				$msg = $val->msgno; 
				$msguid = $val->uid;
				$from2 = imap_mime_header_decode($val->from);
				for($j=0;$j<count($from2);$j++) {
					$from .= $from2[$j]->text;
				}
				$fromshort = trim(ereg_replace('<([^>]|\n)*>', '', $from)); 
				$fromshort = $fromshort;
				$from = $from;
				$date = $val->date;
				$subj = "";
				$subj2 = imap_mime_header_decode($val->subject);
				for($j=0;$j<count($subj2);$j++) {
					$subj .= $subj2[$j]->text;
				}
				$subj = strip_tags($subj);
				$subj = trim($subj);
				$subj = $subj;
				if (is_array($sortindent)) {
					$MessageList[$x]['threadindent'] = $sortindent[$i];
				}
				$MessageList[$x]['message_number'] = $msg;
				$MessageList[$x]['message_uid'] = $msguid;
				$MessageList[$x]['message_from'] = $fromshort;
				$MessageList[$x]['message_fullfrom'] = $from;
				$MessageList[$x]['message_title'] = $subj;
				$MessageList[$x]['message_date'] = $date;
	
				unset ($from);
				$x++;
			}
		}
		else {
			for ($i = 0; $i < $size; $i++) {
				$overview = imap_fetch_overview($this->_mailbox, $sortmessages[$i], FT_UID); 
				$val = $overview[0]; 
				$msg = $val->msgno; 
				$msguid = $val->uid;
				$from2 = imap_mime_header_decode($val->from);
				for($j=0;$j<count($from2);$j++) {
					$from .= $from2[$j]->text;
				}
				$fromshort = trim(ereg_replace('<([^>]|\n)*>', '', $from)); 
				$fromshort = $fromshort;
				$from = $from;
				$date = $val->date;
				$subj = "";
				$subj2 = imap_mime_header_decode($val->subject);
				for($j=0;$j<count($subj2);$j++) {
					$subj .= $subj2[$j]->text;
				}
				$subj = strip_tags($subj);
				$subj = trim($subj);
				$subj = $subj;
				if (is_array($sortindent)) {
					$MessageList[$x]['threadindent'] = $sortindent[$i];
				}
				$MessageList[$x]['message_number'] = $msg;
				$MessageList[$x]['message_uid'] = $msguid;
				$MessageList[$x]['message_from'] = $fromshort;
				$MessageList[$x]['message_fullfrom'] = $from;
				$MessageList[$x]['message_title'] = $subj;
				$MessageList[$x]['message_date'] = $date;
	
				unset ($from);
				$x++;
			}
		}
		return $MessageList;
	}

	function GetSeqNum($uid) {
		return @imap_msgno($this->_mailbox, $uid);
	}

	function GetUID($msgno) {
		return @imap_uid($this->_mailbox, $msgno);
	}
}

?>
