<?php
/*
############################################################################

############################################################################
*/

// This include reads user options either from cookie or session
// and overwrites certain config.inc.php settings
// 
// This functionality can be disabled using $AllowUserOptions in
// config.inc.php

// ALWAYS CALL THIS FILE AFTER config.inc.php

if ($UseDatabase == 1) {
	switch ($DatabaseType) {
		case 'mysqli':
			$DBLib = 'mysqli';
			break;
		case 'postgresql':
			$DBLib = 'postgresql';
			break;
		default:
			$DBLib = 'mysql';
			break;
	}
	require_once ("./includes/db_" . $DBLib . ".inc.php");
	$MySQLConnection = new DB_Connection($MySQLServer, $MySQLUsername, $MySQLPassword, $MySQLDBName);
	$MySQLMakeConnection = $MySQLConnection->DB_MakeConnection();
}

if ($AllowUserOptions == 1) {
	if ($UseDatabase == 1) {
		// This stores and retrieves preferences from the database.
		// More options are configurable via the database and no
		// cookies are used

		if ($MySQLMakeConnection) {
			$MySQLID = $MySQLConnection->DB_CheckUser($_SESSION['currentemailaddress'], $_SESSION['sess_p']);
		}
		if (isset($MySQLID) && ($MySQLID >= 0)) {
			$useroptions = $MySQLConnection->DB_GetPrefs('standard');
			// Extended options are only available for database versions of DWmail
			$extendedoptions = $MySQLConnection->DB_GetPrefs('extended');
			// V-editor options are only available for database versions of DWmail
			$veditoroptions = $MySQLConnection->DB_GetPrefs('veditor');
		}

		if (isset($useroptions)) {
			$useroptions = $MainSettings->CheckSlashes($useroptions);
			$myoptions = unserialize($useroptions);
			if (is_array($myoptions)) {
				if (isset($myoptions['messagesperpage'])) {
					$messagesperpage = strip_tags(trim($myoptions['messagesperpage']));
				}
				if (isset($myoptions['HTMLemail'])) {
					$HTMLemail = strip_tags(trim($myoptions['HTMLemail']));
				}
				if (isset($myoptions['DefaultComposeMode'])) {
					$DefaultComposeMode = strip_tags(trim($myoptions['DefaultComposeMode']));
				}
				if (isset($myoptions['AllowReadReceipts'])) {
					$AllowReadReceipts = strip_tags(trim($myoptions['AllowReadReceipts']));
				}
				if (isset($myoptions['AllowSentMail'])) {
					$AllowSentMail = strip_tags(trim($myoptions['AllowSentMail']));
				}
				if (isset($myoptions['UseTrash'])) {
					$UseTrash = strip_tags(trim($myoptions['UseTrash']));
				}
				if (isset($myoptions['SeperateSignature'])) {
					$SeperateSignature = strip_tags(trim($myoptions['SeperateSignature']));
				}
				if (isset($myoptions['MailboxSort'])) {
					$MailboxSort = strip_tags(trim($myoptions['MailboxSort']));
				}
				if (isset($myoptions['SortOrder'])) {
					$SortOrder = strip_tags(trim($myoptions['SortOrder']));
				}
				if (isset($myoptions['tz'])) {
					$tz = strip_tags(trim($myoptions['tz']));
				}
				if (isset($myoptions['DateFormatting'])) {
					$DateFormatting = strip_tags(trim($myoptions['DateFormatting']));
				}
				if (isset($myoptions['DateFormattingb'])) {
					$DateFormattingb = strip_tags(trim($myoptions['DateFormattingb']));
				}
				if (isset($myoptions['DateFormattingFull'])) {
					$DateFormattingFull = strip_tags(trim($myoptions['DateFormattingFull']));
				}
				if (isset($myoptions['pname'])) {
					$pname = strip_tags(trim($myoptions['pname']));
				}
			}
		}

		if (isset($extendedoptions)) {
			$extendedoptions = $MainSettings->CheckSlashes($extendedoptions);
			$eoptions = unserialize($extendedoptions);
			if (is_array($eoptions)) {
				if (isset($eoptions['mboxrefresh'])) {
					$mboxrefresh = strip_tags(trim($eoptions['mboxrefresh']));
				}
				if (isset($eoptions['newmail'])) {
					$newmail = strip_tags(trim($eoptions['newmail']));
				}
				if (isset($eoptions['PlaySound'])) {
					$PlaySound = strip_tags(trim($eoptions['PlaySound']));
				}
				if (isset($eoptions['ViewPopUp'])) {
					$ViewPopUp = strip_tags(trim($eoptions['ViewPopUp']));
				}
				if (isset($eoptions['IncOrig'])) {
					$IncOrig = strip_tags(trim($eoptions['IncOrig']));
				}
				else {
					$IncOrig = 1;
				}
				if (isset($eoptions['usefilters'])) {
					$usefilters = strip_tags(trim($eoptions['usefilters']));
				}
				if (isset($eoptions['AutoPreview'])) {
					$AutoPreview = strip_tags(trim($eoptions['AutoPreview']));
				}
				if (isset($eoptions['IMAPTrash'])) {
					$IMAPTrash = strip_tags(trim($eoptions['IMAPTrash']));
				}
				if (isset($eoptions['IMAPDrafts'])) {
					$IMAPDrafts = strip_tags(trim($eoptions['IMAPDrafts']));
				}
				if (isset($eoptions['EmptyTrash'])) {
					$EmptyTrash = strip_tags(trim($eoptions['EmptyTrash']));
				}
				if (isset($eoptions['IMAPSentMail'])) {
					$IMAPSentMail = strip_tags(trim($eoptions['IMAPSentMail']));
				}
				if (isset($eoptions['InterstitialLogin'])) {
					$InterstitialLogin = strip_tags(trim($eoptions['InterstitialLogin']));
				}
				if (isset($eoptions['ReplyTo'])) {
					$ReplyTo = strip_tags(trim($eoptions['ReplyTo']));
				}
				if (isset($eoptions['DisplayBcc'])) {
					$DisplayBcc = strip_tags(trim($eoptions['DisplayBcc']));
				}
				if (isset($eoptions['DisplayRT'])) {
					$DisplayRT = strip_tags(trim($eoptions['DisplayRT']));
				}
				if (isset($eoptions['SaveRecipients'])) {
					$SaveRecipients = strip_tags(trim($eoptions['SaveRecipients']));
				}
				if (isset($eoptions['IMAPSubscriptions'])) {
					$IMAPSubscriptions = strip_tags(trim($eoptions['IMAPSubscriptions']));
				}
			}
		}

		if (isset($veditoroptions)) {
			$veditoroptions = $MainSettings->CheckSlashes($veditoroptions);
			$voptions = unserialize($veditoroptions);
			if (is_array($voptions)) {
				if (isset($voptions['c_fontface'])) {
					$ve['c_fontface'] = strip_tags(trim($voptions['c_fontface']));
				}
				if (isset($voptions['c_fontsize'])) {
					$ve['c_fontsize'] = strip_tags(trim($voptions['c_fontsize']));
				}
				if (isset($voptions['c_fontcolour'])) {
					$ve['c_fontcolour'] = strip_tags(trim($voptions['c_fontcolour']));
				}
				if (isset($voptions['r_fontface'])) {
					$ve['r_fontface'] = strip_tags(trim($voptions['r_fontface']));
				}
				if (isset($voptions['r_fontsize'])) {
					$ve['r_fontsize'] = strip_tags(trim($voptions['r_fontsize']));
				}
				if (isset($voptions['r_fontcolour'])) {
					$ve['r_fontcolour'] = strip_tags(trim($voptions['r_fontcolour']));
				}
			}
		}

	}
	else {
		// Always read from cookie if possible (if cookieupdate == 1 then we have updated
		// the cookie since the page was initialised thus we must pick the latest settings
		// from the session instead)

		// Cookie support can be disabled in the config.inc.php file

		if ($cookieupdate <> 1) {
			if ($_COOKIE['dwmailoptions']) {
				$useroptions = $_COOKIE['dwmailoptions'];
			}
		}

		// Use session settings (i.e. cookie support may be disabled in browser)
		// or we have updated the cookie on this page
		if ((($_SESSION['dwmailoptions']) && (!$_COOKIE['dwmailoptions'])) || ($cookieupdate == 1)) {
			$useroptions = $_SESSION['dwmailoptions'];
		}

		// If there is neither a session of a cookie then just leave it at default (read from config.inc.php)

		// Now do something with the options
		if (isset($useroptions)) {
			$useroptions = $MainSettings->CheckSlashes($useroptions);
			$myoptions = unserialize($useroptions);
			if (!is_array($myoptions)) {
				// something went wrong so unset user options
				setcookie ("dwmailoptions", "", time() - 3600);
				unset ($useroptions);
				unset ($myoptions);
			}
			else {
				if (isset($myoptions['messagesperpage'])) {
					$messagesperpage = strip_tags(trim($myoptions['messagesperpage']));
				}
				if (isset($myoptions['HTMLemail'])) {
					$HTMLemail = strip_tags(trim($myoptions['HTMLemail']));
				}
				if (isset($myoptions['DefaultComposeMode'])) {
					$DefaultComposeMode = strip_tags(trim($myoptions['DefaultComposeMode']));
				}
				if (isset($myoptions['AllowReadReceipts'])) {
					$AllowReadReceipts = strip_tags(trim($myoptions['AllowReadReceipts']));
				}
				if (isset($myoptions['AllowSentMail'])) {
					$AllowSentMail = strip_tags(trim($myoptions['AllowSentMail']));
				}
				if (isset($myoptions['UseTrash'])) {
					$UseTrash = strip_tags(trim($myoptions['UseTrash']));
				}
				if (isset($myoptions['SeperateSignature'])) {
					$SeperateSignature = strip_tags(trim($myoptions['SeperateSignature']));
				}
				if (isset($myoptions['MailboxSort'])) {
					$MailboxSort = strip_tags(trim($myoptions['MailboxSort']));
				}
				if (isset($myoptions['tz'])) {
					$tz = strip_tags(trim($myoptions['tz']));
				}
			}
		}
	}
}



?>
