<?php
/*
############################################################################

############################################################################
*/

class RFC822 extends WM_IMAPConnection {
	var $_sessionvars;
	var $_RFCHeader;
	var $_RFCBody;
	var $_RFCIndHeader;

	function RFC822($sessionvars) {
		$this->_sessionvars = $sessionvars;
	}

	function GetParts($header, $body) {
		$i = 1;
		$this->_RFCHeader = $header;
		$this->_RFCBody = $body;
		if ($newParts = $this->MIMESplit()) {
			while (list($key, $val) = each($newParts)) {
				$fullpart[$i] = $this->MIMEContent($val);
				$i++;
			}
		}
		else {
			$fullpart[$i] = $body;
		}
		return $fullpart;
	}

	function MIMEContent($part) {
		$breakheader = explode ("\r\n\r\n", $part);
		for ($i=1; $i<sizeof($breakheader); $i++) {
			$returnparts .= $breakheader[$i] . "\r\n\r\n";
		}

		$this->_RFCIndHeader = $breakheader[1];
		
		return $returnparts;
	}

	function MIMESplit() {
		$parts = array();
		$PN_EREG_BOUNDARY = "Content-Type:(.*)boundary=\"([^\"]+)\"";
		$PN_EREG_BOUNDARY2 = "Content-Type:(.*);boundary=([[:alnum:]]+)";

		if (eregi ($PN_EREG_BOUNDARY, $this->_RFCHeader, $regs)) {
			$boundary = $regs[2];
			$delimiterReg = "([^\r\n]*)--$boundary([^\r\n]*)";
			if (eregi ($delimiterReg, $this->_RFCBody, $results)) {
				$delimiter = $results[0];
				$parts = explode($delimiter, $this->_RFCBody);
				$parts = array_slice ($parts, 1, -1);
			}
           
			return $parts;
		}
		elseif (eregi ($PN_EREG_BOUNDARY2, $this->_RFCHeader, $regs)) {
			$boundary = $regs[2];
			$delimiterReg = "([^\r\n]*)--$boundary([^\r\n]*)";
			if (eregi ($delimiterReg, $this->_RFCBody, $results)) {
				$delimiter = $results[0];
				$parts = explode($delimiter, $this->_RFCBody);
				$parts = array_slice ($parts, 1, -1);
			}
           
			return $parts;
		}
		else {
			return false;
 		}
	}
}

function get_rfc_attachments($arr) {
	if (is_array($arr->parts)) {
		for($x=0; $x<sizeof($arr->parts); $x++) {
			if ($arr->parts[$x]->disposition == "attachment" && $arr->parts[$x]->disposition <> "inline") {
				// Get attachments with 'attachment' type defined
				$ret[$x] = $arr->parts[$x];
			}
			elseif ((($arr->parts[$x]->ctype_primary <> 'text' && $arr->parts[$x]->ctype_secondary <> 'plain') && ($arr->parts[$x]->ctype_primary <> 'text' && $arr->parts[$x]->ctype_secondary <> 'html') && ($arr->parts[$x]->ctype_primary <> 'multipart' && $arr->parts[$x]->ctype_secondary <> 'alternative') && ($arr->parts[$x]->ctype_primary <> 'multipart' && $arr->parts[$x]->ctype_secondary <> 'related') && ($arr->parts[$x]->ctype_primary <> 'message' && $arr->parts[$x]->ctype_secondary <> 'disposition-notification')  && ($arr->parts[$x]->ctype_primary <> 'multipart' && $arr->parts[$x]->ctype_secondary <> 'appledouble') ) && $arr->parts[$x]->disposition <> "attachment" && $arr->parts[$x]->disposition <> "inline" && $arr->parts[$x]->content-id == "") {
				// Get all parts that aren't text/plain or text/html and also don't have a content-disposition attached (this should catch most if not all html and txt attachments too)
				$ret[$x] = $arr->parts[$x];
			}
			elseif ($arr->parts[$x]->ctype_primary == 'message' && $arr->parts[$x]->ctype_secondary == 'rfc822') {
				$ret[$x] = $arr->parts[$x];
			}
		}
	}
	return $ret;
}

function get_rfc_embeddedattachments($arr) {
	if (is_array($arr->parts)) {
		for($x=0; $x<sizeof($arr->parts); $x++) {
			if (($arr->parts[$x]->content-id <> "" && $arr->parts[$x]->ctype_primary == 'image') || $arr->parts[$x]->disposition == "inline") {
				$ret[$x] = $arr->parts[$x];
			}
			elseif ((($arr->parts[$x]->ctype_primary == 'text' && $arr->parts[$x]->ctype_secondary == 'plain') || ($arr->parts[$x]->ctype_primary == 'text' && $arr->parts[$x]->ctype_secondary == 'xml') || ($arr->parts[$x]->ctype_primary == 'text' && $arr->parts[$x]->ctype_secondary == 'css')) && $arr->parts[$x]->content-id <> "") {
				$ret[$x] = $arr->parts[$x];
			}
		}
	}
	return $ret;
}
?>
