<?php
/*



*/
require ("./includes/global.inc.php");
require ("./includes/imap.inc.php");
require ("./includes/functions.inc.php");
require ("./includes/config.inc.php");
require ("./includes/browser.inc.php");

$MainSettings = new GlobalInit();
$TransIDEnabled = $MainSettings->INIGet('session.use_trans_sid');

session_cache_limiter($DefaultSessionCache);
session_start();

if (!$_SESSION['DefaultLang']) {
	$_SESSION['DefaultLang'] = $DefaultLang;
}
@setlocale(LC_TIME, $AvailLangs[$_SESSION['DefaultLang']]['locale']);
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/global.inc.php");
require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/options.inc.php");

$tz_arry["-720"] = "GMT -12:00 " . $lang['SOptions']['Hours'];
$tz_arry["-660"] = "GMT -11:00 " . $lang['SOptions']['Hours'];
$tz_arry["-600"] = "GMT -10:00 " . $lang['SOptions']['Hours'];
$tz_arry["-540"] = "GMT -09:00 " . $lang['SOptions']['Hours'];
$tz_arry["-480"] = "GMT -08:00 " . $lang['SOptions']['Hours'];
$tz_arry["-420"] = "GMT -07:00 " . $lang['SOptions']['Hours'];
$tz_arry["-360"] = "GMT -06:00 " . $lang['SOptions']['Hours'];
$tz_arry["-300"] = "GMT -05:00 " . $lang['SOptions']['Hours'];
$tz_arry["-240"] = "GMT -04:00 " . $lang['SOptions']['Hours'];
$tz_arry["-210"] = "GMT -03:30 " . $lang['SOptions']['Hours'];
$tz_arry["-180"] = "GMT -03:00 " . $lang['SOptions']['Hours'];
$tz_arry["-120"] = "GMT -02:00 " . $lang['SOptions']['Hours'];
$tz_arry["-60"] = "GMT -01:00 " . $lang['SOptions']['Hours'];
$tz_arry["0"] = "GMT (" . $lang['SOptions']['GMT'] . ")";
$tz_arry["+60"] = "GMT +01:00 " . $lang['SOptions']['Hours'];
$tz_arry["+120"] = "GMT +02:00 " . $lang['SOptions']['Hours'];
$tz_arry["+180"] = "GMT +03:00 " . $lang['SOptions']['Hours'];
$tz_arry["+210"] = "GMT +03:30 " . $lang['SOptions']['Hours'];
$tz_arry["+240"] = "GMT +04:00 " . $lang['SOptions']['Hours'];
$tz_arry["+270"] = "GMT +04:30 " . $lang['SOptions']['Hours'];
$tz_arry["+300"] = "GMT +05:00 " . $lang['SOptions']['Hours'];
$tz_arry["+330"] = "GMT +05:30 " . $lang['SOptions']['Hours'];
$tz_arry["+360"] = "GMT +06:00 " . $lang['SOptions']['Hours'];
$tz_arry["+420"] = "GMT +07:00 " . $lang['SOptions']['Hours'];
$tz_arry["+480"] = "GMT +08:00 " . $lang['SOptions']['Hours'];
$tz_arry["+540"] = "GMT +09:00 " . $lang['SOptions']['Hours'];
$tz_arry["+570"] = "GMT +09:30 " . $lang['SOptions']['Hours'];
$tz_arry["+600"] = "GMT +10:00 " . $lang['SOptions']['Hours'];
$tz_arry["+660"] = "GMT +11:00 " . $lang['SOptions']['Hours'];
$tz_arry["+720"] = "GMT +12:00 " . $lang['SOptions']['Hours'];


// We must split options between database mode and non database mode as it's
// functionality is quite different
if ($UseDatabase == 1) {
	require ("./includes/options.inc.php");

	$DefaultTemplate = strip_tags(trim($DefaultTemplate));

	$getFile = new fileProperties($DefaultTemplate);
	$PageHeader = $getFile->fileRead('header');
	$PageFooter = $getFile->fileRead('footer');
	$PageCopyright = $getFile->fileRead('copyright');
	$PageMenu = $getFile->fileRead('menu');

	$PageGenericMessage = $getFile->fileRead('generic_message');
	$PageGenericMessage = str_replace("[pagetitle]", " - " . $lang['SOptions']['Title'], $PageGenericMessage);

	$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
	$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

	$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

	$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
	$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
	$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
	$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
	$PageHeader = str_replace("[pagetitle]", " - " . $lang['SOptions']['Title'], $PageHeader);
	$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
	$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

	if ($AllowExternal == 1 && $UseDatabase == 1) {
		$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
		$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
		$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
		$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
	}
	else {
		$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
		$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
	}

	$genericerror = $getFile->fileRead('generic_message');
	$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

	$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
	CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

	$IMAPConnection = new WM_IMAPConnection($_SESSION);
	$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

	$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
	CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

	$mailbox = $IMAPConnection->WM_IMAPConnect();

	checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

	include ("./includes/folderpane.inc.php");
	$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
	$PageHeader = LangReplace('Generic', $PageHeader, $lang);
	$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
	$PageFooter = LangReplace('Generic', $PageFooter, $lang);
	$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

	if ($AllowUserOptions == 1) {

		if (!$_REQUEST['mode']) {
			$PageDBOptions = $getFile->fileRead('db_optionsmenu');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "display") {
			// Sort by
			$options_sortby = "<select name=\"o_sortby\"><option value=\"SORTARRIVAL\"";
			if ($MailboxSort == "SORTARRIVAL") {
				$options_sortby .= " selected=\"selected\"";
			}
			$options_sortby .= ">" . $lang['SOptions']['Sort'][1] . "</option>";

			$options_sortby .= "<option value=\"SORTDATE\"";
			if ($MailboxSort == "SORTDATE") {
				$options_sortby .= " selected=\"selected\"";
			}
			$options_sortby .= ">" . $lang['SOptions']['Sort'][2] . "</option>";

			$options_sortby .= "<option value=\"SORTSIZE\"";
			if ($MailboxSort == "SORTSIZE") {
				$options_sortby .= " selected=\"selected\"";
			}
			$options_sortby .= ">" . $lang['SOptions']['Sort'][3] . "</option>";

			$options_sortby .= "<option value=\"SORTSUBJECT\"";
			if ($MailboxSort == "SORTSUBJECT") {
				$options_sortby .= " selected=\"selected\"";
			}
			$options_sortby .= ">" . $lang['SOptions']['Sort'][4] . "</option>";

			$options_sortby .= "<option value=\"SORTFROM\"";
			if ($MailboxSort == "SORTFROM") {
				$options_sortby .= " selected=\"selected\"";
			}
			$options_sortby .= ">" . $lang['SOptions']['Sort'][5] . "</option>";

			$options_sortby .= "<option value=\"THREADED\"";
			if ($MailboxSort == "THREADED") {
				$options_sortby .= " selected=\"selected\"";
			}
			$options_sortby .= ">" . $lang['SOptions']['Sort'][6] . "</option></select>";

			// Sort order
			$options_sortorder = "<select name=\"o_sortorder\"><option value=\"1\"";
			if ($SortOrder == "1" || !isset($SortOrder)) {
				$options_sortorder .= " selected=\"selected\"";
			}
			$options_sortorder .= ">" . $lang['SOptions']['SortOrder'][1] . "</option>";

			$options_sortorder .= "<option value=\"0\"";
			if ($SortOrder == "0" && isset($SortOrder)) {
				$options_sortorder .= " selected=\"selected\"";
			}
			$options_sortorder .= ">" . $lang['SOptions']['SortOrder'][2] . "</option></select>";

			// Refresh mailbox
			$options_ref = "<select name=\"o_refresh\"><option value=\"0\"";
			if ($mboxrefresh == 0) {
				$options_ref .= " selected=\"selected\"";
			}
			$options_ref .= ">" . $lang['SOptions']['Never'] . "</option>";

			$options_ref .= "<option value=\"30\"";
			if ($mboxrefresh == 30) {
				$options_ref .= " selected=\"selected\"";
			}
			$options_ref .= ">" . $lang['SOptions']['Seconds'][1] . "</option>";

			$options_ref .= "<option value=\"60\"";
			if ($mboxrefresh == 60) {
				$options_ref .= " selected=\"selected\"";
			}
			$options_ref .= ">" . $lang['SOptions']['Seconds'][2] . "</option>";

			$options_ref .= "<option value=\"120\"";
			if ($mboxrefresh == 120) {
				$options_ref .= " selected=\"selected\"";
			}
			$options_ref .= ">" . $lang['SOptions']['Seconds'][3] . "</option>";

			$options_ref .= "<option value=\"300\"";
			if ($mboxrefresh == 300) {
				$options_ref .= " selected=\"selected\"";
			}
			$options_ref .= ">" . $lang['SOptions']['Seconds'][4] . "</option>";

			$options_ref .= "<option value=\"600\"";
			if ($mboxrefresh == 600) {
				$options_ref .= " selected=\"selected\"";
			}
			$options_ref .= ">" . $lang['SOptions']['Seconds'][5] . "</option></select>";

			// Refresh mailbox
			$options_new = "<select name=\"o_new\"><option value=\"0\"";
			if ($newmail == 0 || !isset($newmail)) {
				$options_new .= " selected=\"selected\"";
			}
			$options_new .= ">" . $lang['SOptions']['Never'] . "</option>";

			$options_new .= "<option value=\"30\"";
			if ($newmail == 30) {
				$options_new .= " selected=\"selected\"";
			}
			$options_new .= ">" . $lang['SOptions']['Seconds'][1] . "</option>";

			$options_new .= "<option value=\"60\"";
			if ($newmail == 60) {
				$options_new .= " selected=\"selected\"";
			}
			$options_new .= ">" . $lang['SOptions']['Seconds'][2] . "</option>";

			$options_new .= "<option value=\"120\"";
			if ($newmail == 120) {
				$options_new .= " selected=\"selected\"";
			}
			$options_new .= ">" . $lang['SOptions']['Seconds'][3] . "</option>";

			$options_new .= "<option value=\"300\"";
			if ($newmail == 300) {
				$options_new .= " selected=\"selected\"";
			}
			$options_new .= ">" . $lang['SOptions']['Seconds'][4] . "</option>";

			$options_new .= "<option value=\"600\"";
			if ($newmail == 600) {
				$options_new .= " selected=\"selected\"";
			}
			$options_new .= ">" . $lang['SOptions']['Seconds'][5] . "</option></select>";

			// Play new mail sound
			$options_playsound = "<input type=\"radio\" name=\"o_playsound\" id=\"ps_1\" value=\"1\"";
			if (!isset($PlaySound) || $PlaySound == 1) {
				$options_playsound .= " checked=\"checked\"";
			}
			$options_playsound .= " /> <label for=\"ps_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_playsound .= "<input type=\"radio\" name=\"o_playsound\" id=\"ps_0\" value=\"0\"";
			if (isset($PlaySound) && $PlaySound == 0) {
				$options_playsound .= " checked=\"checked\"";
			}
			$options_playsound .= " /> <label for=\"ps_0\">" . $lang['YesNo'][2] . "</label>";

			$PageDBOptions = $getFile->fileRead('db_optionsdisplay');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_messagesperpage]", $messagesperpage, $PageDBOptions);
			$PageDBOptions = str_replace("[options_sortby]", $options_sortby, $PageDBOptions);
			$PageDBOptions = str_replace("[options_sortorder]", $options_sortorder, $PageDBOptions);
			$PageDBOptions = str_replace("[options_refresh]", $options_ref, $PageDBOptions);
			$PageDBOptions = str_replace("[options_newmail]", $options_new, $PageDBOptions);
			$PageDBOptions = str_replace("[options_playsound]", $options_playsound, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "display_save") {
			$myoptions['messagesperpage'] = $_POST['o_messagesperpage'];
			$myoptions['MailboxSort'] = $_POST['o_sortby'];
			$myoptions['SortOrder'] = $_POST['o_sortorder'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
			$_SESSION['dwmailoptions'] = serialize($myoptions);

			$eoptions['newmail'] = $_POST['o_new'];
			$eoptions['mboxrefresh'] = $_POST['o_refresh'];
			$eoptions['PlaySound'] = $_POST['o_playsound'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
			$_SESSION['extoptions'] = serialize($eoptions);

			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}
		if ($_REQUEST['mode'] == "messages") {
			// View HTML message mode
			$options_html = "<select name=\"o_html\"><option value=\"1\"";
			if ($HTMLemail == 1) {
				$options_html .= " selected=\"selected\"";
			}
			$options_html .= ">" . $lang['SOptions']['View'][1] . "</option>";

			$options_html .= "<option value=\"5\"";
			if ($HTMLemail == 5) {
				$options_html .= " selected=\"selected\"";
			}
			$options_html .= ">" . $lang['SOptions']['View'][2] . "</option>";

			$options_html .= "<option value=\"2\"";
			if ($HTMLemail == 2) {
				$options_html .= " selected=\"selected\"";
			}
			$options_html .= ">" . $lang['SOptions']['View'][3] . "</option>";

			$options_html .= "<option value=\"3\"";
			if ($HTMLemail == 3) {
				$options_html .= " selected=\"selected\"";
			}
			$options_html .= ">" . $lang['SOptions']['View'][4] . "</option>";

			$options_html .= "<option value=\"4\"";
			if ($HTMLemail == 4) {
				$options_html .= " selected=\"selected\"";
			}
			$options_html .= ">" . $lang['SOptions']['View'][5] . "</option></select>";

			// Auto-Preview images
			$options_autopreview = "<input type=\"radio\" name=\"o_autopreview\" id=\"ap_1\" value=\"1\"";
			if ($AutoPreview == 1) {
				$options_autopreview .= " checked=\"checked\"";
			}
			$options_autopreview .= " /> <label for=\"ap_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_autopreview .= "<input type=\"radio\" name=\"o_autopreview\" id=\"ap_0\" value=\"0\"";
			if ($AutoPreview == 0) {
				$options_autopreview .= " checked=\"checked\"";
			}
			$options_autopreview .= " /> <label for=\"ap_0\">" . $lang['YesNo'][2] . "</label>";

			// New Window
			$options_window = "<input type=\"radio\" name=\"o_viewpopup\" id=\"vp_1\" value=\"1\"";
			if ($ViewPopUp == 1 && isset($ViewPopUp)) {
				$options_window .= " checked=\"checked\"";
			}
			$options_window .= " /> <label for=\"vp_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_window .= "<input type=\"radio\" name=\"o_viewpopup\" id=\"vp_0\" value=\"0\"";
			if ($ViewPopUp == 0 or !isset($ViewPopUp)) {
				$options_window .= " checked=\"checked\"";
			}
			$options_window .= " /> <label for=\"vp_0\">" . $lang['YesNo'][2] . "</label>";

			// Seperate signature
			$options_sig = "<input type=\"radio\" name=\"o_signature\" id=\"ss_1\" value=\"1\"";
			if ($SeperateSignature == 1) {
				$options_sig .= " checked=\"checked\"";
			}
			$options_sig .= " /> <label for=\"ss_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_sig .= "<input type=\"radio\" name=\"o_signature\" id=\"ss_0\" value=\"0\"";
			if ($SeperateSignature == 0) {
				$options_sig .= " checked=\"checked\"";
			}
			$options_sig .= " /> <label for=\"ss_0\">" . $lang['YesNo'][2] . "</label>";

			// Read receipts
			$options_read = "<input type=\"radio\" name=\"o_read\" id=\"rr_1\" value=\"1\"";
			if ($AllowReadReceipts == 1) {
				$options_read .= " checked=\"checked\"";
			}
			$options_read .= " /> <label for=\"rr_1\">" . $lang['SOptions']['ViewReadReceiptsOptions'][1] . "</label><br />";

			$options_read .= "<input type=\"radio\" name=\"o_read\" id=\"rr_0\" value=\"0\"";
			if ($AllowReadReceipts == 0) {
				$options_read .= " checked=\"checked\"";
			}
			$options_read .= " /> <label for=\"rr_0\">" . $lang['SOptions']['ViewReadReceiptsOptions'][2] . "</label>";

			$PageDBOptions = $getFile->fileRead('db_optionsmessages');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_html]", $options_html, $PageDBOptions);
			$PageDBOptions = str_replace("[options_seperatesignature]", $options_sig, $PageDBOptions);
			$PageDBOptions = str_replace("[options_popupview]", $options_window, $PageDBOptions);
			$PageDBOptions = str_replace("[options_autopreview]", $options_autopreview, $PageDBOptions);
			$PageDBOptions = str_replace("[options_readreceipts]", $options_read, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "messages_save") {
			$myoptions['HTMLemail'] = $_POST['o_html'];
			$myoptions['SeperateSignature'] = $_POST['o_signature'];
			$myoptions['AllowReadReceipts'] = $_POST['o_read'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
			$_SESSION['dwmailoptions'] = serialize($myoptions);

			$eoptions['ViewPopUp'] = $_POST['o_viewpopup'];
			$eoptions['AutoPreview'] = $_POST['o_autopreview'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
			$_SESSION['extoptions'] = serialize($eoptions);

			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}
		if ($_REQUEST['mode'] == "personal") {
			$GetSignature = trim($MySQLConnection->DB_GetPrefs('signature'));
			$GetSignature = stripslashes($GetSignature);
			$GetSignature = strip_tags($GetSignature);

			$AliasList = $MySQLConnection->DB_GetAliasList();
			if (is_array($AliasList)) {
				while(list($key, $value) = each($AliasList)) { 
					$options_alias .= "<option value=\"$key\">" . $lang['SOptions']['AliasEdit'] . ' ' . $AliasList[$key]['name'] . ' &lt;' . $AliasList[$key]['email'] . '&gt;';
				}
			}

			$PageDBOptions = $getFile->fileRead('db_optionspersonal');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_pname]", str_replace('"', "", $pname), $PageDBOptions);
			$PageDBOptions = str_replace("[options_email]", $_SESSION['currentemailaddress'], $PageDBOptions);
			$PageDBOptions = str_replace("[options_signature]", $GetSignature, $PageDBOptions);
			$PageDBOptions = str_replace("[AliasList]", $options_alias, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "personal_save") {
			$myoptions['pname'] = str_replace('"', "", strip_tags(stripslashes($_POST['o_pname'])));
			$GetSignature = trim(strip_tags(stripslashes($_POST['o_signature'])));
			$GetSignature = addslashes($GetSignature);
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
			if ($GetSignature <> "") {
				$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs($GetSignature, 'signature');
			}
			else {
				$MySQLUpdate = $MySQLConnection->DB_DeletePrefs('signature');
			}
			$_SESSION['dwmailoptions'] = serialize($myoptions);
			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}
		if ($_REQUEST['mode'] == "alias") {

			if ($_POST['o_alias'] <> 'new') {
				$AliasList = $MySQLConnection->DB_GetAliasList();
				$selectedalias = $AliasList[$_POST['o_alias']];
			}

			$PageDBOptions = $getFile->fileRead('db_optionsalias');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_name]", str_replace('"', "", $selectedalias['name']), $PageDBOptions);
			$PageDBOptions = str_replace("[options_email]", $selectedalias['email'], $PageDBOptions);
			$PageDBOptions = str_replace("[options_aliasid]", $_POST['o_alias'], $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "alias_save") {
			if ($_POST['o_aliasemail'] <> '') {
				$AliasName = trim(strip_tags(stripslashes($_POST['o_aliasname'])));
				$AliasName = addslashes($AliasName);
				$AliasEmail = trim(strip_tags(stripslashes($_POST['o_aliasemail'])));
				$AliasEmail = addslashes($AliasEmail);
				if ($_POST['id'] == '' && $_POST['update'] <> '') {
					$AliasList = $MySQLConnection->DB_SaveAlias($AliasEmail, $AliasName);
				}
				elseif ($_POST['id'] <> '' && $_POST['update'] <> '') {
					$AliasList = $MySQLConnection->DB_SaveAlias($AliasEmail, $AliasName, $_POST['id']);
				}
				elseif ($_POST['id'] <> '' && $_POST['delete'] <> '') {
					$AliasList = $MySQLConnection->DB_DeleteAlias($_POST['id']);
				}
			}
			header("Location: ./options.php?mode=personal&" . strip_tags(SID)); 
			exit;

		}
		if ($_REQUEST['mode'] == "timedate" || $_REQUEST['mode'] == "timezone") {

			// Timezone
			$options_tz = "<select name=\"o_tz\">";
			while(list($key, $value) = each($tz_arry)) {
				$GMTTime = gmdate("D, d M Y H:i:s \G\M\T");
				$GMTTS = strtotime ($GMTTime);
				$localtimestamp = $GMTTS + ($key * 60);
				$localtime_hours = strftime ("%I:%M %p", $localtimestamp);
				$options_tz .= "<option value=\"$key\"";
				if ($tz == $key) {
					$options_tz .= " selected=\"selected\"";
				}
				$options_tz .= ">$value ($localtime_hours)</option>";
			}
			$options_tz .= "</select>";

			$GMTTime = gmdate("D, d M Y H:i:s \G\M\T");
			$GMTTS = strtotime ($GMTTime);
			$localtimestamp = $GMTTS + ($tz * 60);

			$localtime_date = strftime ("%d/%m/%y", $localtimestamp);
			$options_dshort = "<select name=\"o_dateformatshort\">";
			$options_dshort .= "<option value=\"d/m/y\"";
			if ($DateFormatting == 'd/m/y') {
				$options_dshort .= " selected=\"selected\"";
			}
			$options_dshort .= ">DD/MM/YY ($localtime_date)</option>";

			$localtime_date = strftime ("%m/%d/%y", $localtimestamp);
			$options_dshort .= "<option value=\"m/d/y\"";
			if ($DateFormatting == 'm/d/y') {
				$options_dshort .= " selected=\"selected\"";
			}
			$options_dshort .= ">MM/DD/YY ($localtime_date)</option>";

			$localtime_date = strftime ("%d/%m/%Y", $localtimestamp);
			$options_dshort .= "<option value=\"d/m/Y\"";
			if ($DateFormatting == 'd/m/Y') {
				$options_dshort .= " selected=\"selected\"";
			}
			$options_dshort .= ">DD/MM/YYYY ($localtime_date)</option>";

			$localtime_date = strftime ("%m/%d/%Y", $localtimestamp);
			$options_dshort .= "<option value=\"d/m/Y\"";
			if ($DateFormatting == 'm/d/Y') {
				$options_dshort .= " selected=\"selected\"";
			}
			$options_dshort .= ">MM/DD/YYYY ($localtime_date)</option>";

			$localtime_date = strftime ("%y/%m/%d", $localtimestamp);
			$options_dshort .= "<option value=\"y/m/d\"";
			if ($DateFormatting == 'y/m/d') {
				$options_dshort .= " selected=\"selected\"";
			}
			$options_dshort .= ">YY/MM/DD ($localtime_date)</option>";

			$localtime_date = strftime ("%Y/%m/%d", $localtimestamp);
			$options_dshort .= "<option value=\"Y/m/d\"";
			if ($DateFormatting == 'Y/m/d') {
				$options_dshort .= " selected=\"selected\"";
			}
			$options_dshort .= ">YYYY/MM/DD ($localtime_date)</option></select>";

			$localtime_date = strftime ("%a, %d %B %Y %H:%M:%S", $localtimestamp);
			$options_dlong = "<select name=\"o_dateformatlong\">";
			$options_dlong .= "<option value=\"%a, %d %B %Y %H:%M:%S\"";
			if ($DateFormatting == '%a, %d %B %Y %H:%M:%S') {
				$options_dlong .= " selected=\"selected\"";
			}
			$options_dlong .= ">$localtime_date</option>";

			$localtime_date = strftime ("%a, %d %B %Y %I:%M:%S %p", $localtimestamp);
			$options_dlong .= "<option value=\"%a, %d %B %Y %I:%M:%S %p\"";
			if ($DateFormatting == '%a, %d %B %Y %I:%M:%S %p') {
				$options_dlong .= " selected=\"selected\"";
			}
			$options_dlong .= ">$localtime_date</option>";

			$localtime_date = strftime ("%A, %d %B %Y %H:%M:%S", $localtimestamp);
			$options_dlong .= "<option value=\"%A, %d %B %Y %H:%M:%S\"";
			if ($DateFormatting == '%A, %d %B %Y %H:%M:%S') {
				$options_dlong .= " selected=\"selected\"";
			}
			$options_dlong .= ">$localtime_date</option>";

			$localtime_date = strftime ("%A, %d %B %Y %I:%M:%S %p", $localtimestamp);
			$options_dlong .= "<option value=\"%A, %d %B %Y %I:%M:%S %p\"";
			if ($DateFormatting == '%A, %d %B %Y %I:%M:%S %p') {
				$options_dlong .= " selected=\"selected\"";
			}
			$options_dlong .= ">$localtime_date</option>";

			$localtime_date = strftime ("%d %B %Y %H:%M:%S", $localtimestamp);
			$options_dlong .= "<option value=\"%d %B %Y %H:%M:%S\"";
			if ($DateFormatting == '%d %B %Y %H:%M:%S') {
				$options_dlong .= " selected=\"selected\"";
			}
			$options_dlong .= ">$localtime_date</option>";

			$localtime_date = strftime ("%d %B %Y %I:%M:%S %p", $localtimestamp);
			$options_dlong .= "<option value=\"%d %B %Y %I:%M:%S %p\"";
			if ($DateFormatting == '%d %B %Y %I:%M:%S %p') {
				$options_dlong .= " selected=\"selected\"";
			}
			$options_dlong .= ">$localtime_date</option>";
			$options_dlong .= "</select>";


			$PageDBOptions = $getFile->fileRead('db_optionstimedate');

			$PageDBOptions = str_replace("[options_dateformatshort]", $options_dshort, $PageDBOptions);
			$PageDBOptions = str_replace("[options_dateformatlong]", $options_dlong, $PageDBOptions);

			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_timezone]", $options_tz, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "timedate_save") {
			$dfmap['Y/m/d'] = "%Y/%m/%d";
			$dfmap['y/m/d'] = "%y/%m/%d";
			$dfmap['m/d/Y'] = "%m/%d/%Y";
			$dfmap['d/m/Y'] = "%d/%m/%Y";
			$dfmap['d/m/y'] = "%d/%m/%y";
			$dfmap['m/d/y'] = "%m/%d/%y";

			$DateFormattingc = $dfmap[$_POST['o_dateformatshort']];
			if ($DateFormattingc == "") {
				$DateFormattingc = $DateFormattingb;
			}
			$DateFormattingb = $DateFormattingc;

			$myoptions['tz'] = $_POST['o_tz'];
			$myoptions['DateFormatting'] = str_replace('"', "", strip_tags(stripslashes($_POST['o_dateformatshort'])));
			$myoptions['DateFormattingb'] = $DateFormattingb;
			$myoptions['DateFormattingFull'] = str_replace('"', "", strip_tags(stripslashes($_POST['o_dateformatlong'])));
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
			$_SESSION['dwmailoptions'] = serialize($myoptions);
			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}
		if ($_REQUEST['mode'] == "reset") {
			$PageDBOptions = $getFile->fileRead('db_optionsreset');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "reset_save") {
			$MySQLUpdate = $MySQLConnection->DB_DeletePrefs('all');
			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}
		if ($_REQUEST['mode'] == "remap") {
			$PageDBOptions = $getFile->fileRead('db_optionsrestore');
			$PageDBOptions = str_replace("[options_currentemail]", $_SESSION['currentemailaddress'], $PageDBOptions);
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "remap_save") {
			// Find old profile
			$oldemail = strip_tags(stripslashes($_POST['o_oldemail']));
			$oldpassword = strip_tags(stripslashes($_POST['o_oldpassword']));
			$OldProfileID = $MySQLConnection->DB_FindProfile($oldemail, $oldpassword);

			$PageGenericMessage = $getFile->fileRead('generic_message');
			$PageGenericMessage = str_replace("[pagetitle]", " - " . $lang['SOptions']['TitleRestore'], $PageGenericMessage);
			if ($OldProfileID == false) {
				// Oops we couldn't find this profile
				$returnmessage = "<p align=\"center\">" . $lang['SOptions']['RestoreError'] . "</p>";
			}
			elseif ($OldProfileID == $MySQLConnection->_DBUserID) {
				// Same profile
				$returnmessage = "<p align=\"center\">" . $lang['SOptions']['RestoreSameProfileError'] . "</p>";
			}
			else {
				// Found an account so now we need to import it

				// First we need to DROP the existing user preferences and re-import with the new ones
				$StandardPrefs = $MySQLConnection->DB_GetPrefs('standard', $OldProfileID);
				$ExtendedPrefs = $MySQLConnection->DB_GetPrefs('extended', $OldProfileID);
				$SignaturePrefs = $MySQLConnection->DB_GetPrefs('signature', $OldProfileID);
				$VEditorPrefs = $MySQLConnection->DB_GetPrefs('veditor', $OldProfileID);

				$DropCurrPrefs = $MySQLConnection->DB_DeletePrefs('all');

				$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs($StandardPrefs, 'standard');
				$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs($ExtendedPrefs, 'extended');
				$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs($SignaturePrefs, 'signature');
				$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs($VEditorPrefs, 'veditor');

				$MySQLUpdate = $MySQLConnection->DB_CopyCalendar($OldProfileID);
				$MySQLUpdate = $MySQLConnection->DB_CopyContacts($OldProfileID);
				$returnmessage = "<p align=\"center\">" . $lang['SOptions']['RestoreSuccess'] . "</p>";
			}
			$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;
			echo $PageGenericMessage;

		}
		if ($_REQUEST['mode'] == "folders") {
			if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
				$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
				$folders = $IMAPConnection->_folders;
				sort($folders);
			}

			// Trash
			$options_trash = "<input type=\"radio\" name=\"o_trash\" id=\"ts_1\" value=\"1\"";
			if ($UseTrash == 1) {
				$options_trash .= " checked=\"checked\"";
			}
			$options_trash .= " /> <label for=\"ts_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_trash .= "<input type=\"radio\" name=\"o_trash\" id=\"ts_0\" value=\"0\"";
			if ($UseTrash == 0) {
				$options_trash .= " checked=\"checked\"";
			}
			$options_trash .= " /> <label for=\"ts_0\">" . $lang['YesNo'][2] . "</label>";

			// Trash Folder
			$options_trashfolder = "<select name=\"o_trashfolder\"><option value=\"$IMAPTrash\" selected=\"selected\">$IMAPTrash</option><option value=\"$IMAPTrash\">------</option>";
			if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
				for($i=0; $i<count($folders); $i++) {
					if ($folders[$i]['id'] <> "INBOX") {
						$options_trashfolder .= "<option value=\"" . $folders[$i]['name'] . "\"";
						$options_trashfolder .= ">" . $folders[$i]['name'] ."</option>\n";
					}
				}
			}
			$options_trashfolder .= "</select>";

			// Drafts Folder
			$options_draftsfolder = "<select name=\"o_draftsfolder\"><option value=\"$IMAPDrafts\" selected=\"selected\">$IMAPDrafts</option><option value=\"$IMAPDrafts\">------</option>";
			if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
				for($i=0; $i<count($folders); $i++) {
					if ($folders[$i]['id'] <> "INBOX") {
						$options_draftsfolder .= "<option value=\"" . $folders[$i]['name'] . "\"";
						$options_draftsfolder .= ">" . $folders[$i]['name'] ."</option>\n";
					}
				}
			}
			$options_draftsfolder .= "</select>";

			// Empty Trash Automatically
			$options_emptytrash = "<input type=\"radio\" name=\"o_emptytrash\" id=\"et_1\" value=\"1\"";
			if ($EmptyTrash == 1) {
				$options_emptytrash .= " checked=\"checked\"";
			}
			$options_emptytrash .= " /> <label for=\"et_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_emptytrash .= "<input type=\"radio\" name=\"o_emptytrash\" id=\"et_0\" value=\"0\"";
			if (!isset($EmptyTrash) || $EmptyTrash == 0) {
				$options_emptytrash .= " checked=\"checked\"";
			}
			$options_emptytrash .= " /> <label for=\"et_0\">" . $lang['YesNo'][2] . "</label>";

			// Save sent
			$options_sent = "<input type=\"radio\" name=\"o_sent\" id=\"sn_1\" value=\"1\"";
			if ($AllowSentMail == 1) {
				$options_sent .= " checked=\"checked\"";
			}
			$options_sent .= " /> <label for=\"sn_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_sent .= "<input type=\"radio\" name=\"o_sent\" id=\"sn_0\" value=\"0\"";
			if ($AllowSentMail == 0) {
				$options_sent .= " checked=\"checked\"";
			}
			$options_sent .= " /> <label for=\"sn_0\">" . $lang['YesNo'][2] . "</label>";

			// Sent Items Folder
			$options_sentfolder = "<select name=\"o_sentfolder\"><option value=\"$IMAPSentMail\" selected=\"selected\">$IMAPSentMail</option><option value=\"$IMAPSentMail\">------</option>";
			if ($_SESSION['servertype'] == "imap" || $_SESSION['servertype'] == "imapssl") {
				for($i=0; $i<count($folders); $i++) {
					if ($folders[$i]['id'] <> "INBOX") {
						$options_sentfolder .= "<option value=\"" . $folders[$i]['name'] . "\"";
						$options_sentfolder .= ">" . $folders[$i]['name'] ."</option>\n";
					}
				}
			}
			$options_sentfolder .= "</select>";

			// Folder subscriptions
			$options_subs = "<input type=\"radio\" name=\"o_subs\" id=\"sb_1\" value=\"1\"";
			if ($IMAPSubscriptions == 1) {
				$options_subs .= " checked=\"checked\"";
			}
			$options_subs .= " /> <label for=\"sb_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_subs .= "<input type=\"radio\" name=\"o_subs\" id=\"sb_0\" value=\"0\"";
			if ($IMAPSubscriptions == 0) {
				$options_subs .= " checked=\"checked\"";
			}
			$options_subs .= " /> <label for=\"sb_0\">" . $lang['YesNo'][2] . "</label>";

			$PageDBOptions = $getFile->fileRead('db_optionsfolder');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_sentmail]", $options_sent, $PageDBOptions);
			$PageDBOptions = str_replace("[options_trash]", $options_trash, $PageDBOptions);
			$PageDBOptions = str_replace("[options_trashfolder]", $options_trashfolder, $PageDBOptions);
			$PageDBOptions = str_replace("[options_draftsfolder]", $options_draftsfolder, $PageDBOptions);
			$PageDBOptions = str_replace("[options_emptytrash]", $options_emptytrash, $PageDBOptions);
			$PageDBOptions = str_replace("[options_sentmailfolder]", $options_sentfolder, $PageDBOptions);
			$PageDBOptions = str_replace("[options_subscriptions]", $options_subs, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "folders_save") {
			$myoptions['AllowSentMail'] = $_POST['o_sent'];
			$myoptions['UseTrash'] = $_POST['o_trash'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
			$_SESSION['dwmailoptions'] = serialize($myoptions);

			$eoptions['IMAPTrash'] = $_POST['o_trashfolder'];
			$eoptions['IMAPDrafts'] = $_POST['o_draftsfolder'];
			$eoptions['EmptyTrash'] = $_POST['o_emptytrash'];
			$eoptions['IMAPSentMail'] = $_POST['o_sentfolder'];
			$eoptions['IMAPSubscriptions'] = $_POST['o_subs'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
			$_SESSION['extoptions'] = serialize($eoptions);

			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}

		if ($_REQUEST['mode'] == "login") {

			// Interstitial Page
			$options_interstitial = "<input type=\"radio\" name=\"o_interstitial\" id=\"in_1\" value=\"1\"";
			if ($InterstitialLogin == 1) {
				$options_interstitial .= " checked=\"checked\"";
			}
			$options_interstitial .= " /> <label for=\"in_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_interstitial .= "<input type=\"radio\" name=\"o_interstitial\" id=\"in_0\" value=\"0\"";
			if ($InterstitialLogin == 0) {
				$options_interstitial .= " checked=\"checked\"";
			}
			$options_interstitial .= " /> <label for=\"in_0\">" . $lang['YesNo'][2] . "</label>";

			$PageDBOptions = $getFile->fileRead('db_optionslogin');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_interstitial]", $options_interstitial, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "login_save") {
			$eoptions['InterstitialLogin'] = $_POST['o_interstitial'];
			$eoptions['UseLoginTime'] = $_POST['o_logintime'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
			$_SESSION['extoptions'] = serialize($eoptions);

			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}

		if ($_REQUEST['mode'] == "compose") {
			require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/compose.inc.php");
			$PageDBOptions = $getFile->fileRead('db_optionscompose');

			// Compose mode
			$options_compose = "<select name=\"o_compose\"><option value=\"text\"";
			if ($DefaultComposeMode == "text") {
				$options_compose .= " selected=\"selected\"";
			}
			$options_compose .= ">" . $lang['SCompose']['ComposePlain'] . "</option>";

			$options_compose .= "<option value=\"html\"";
			if ($DefaultComposeMode == "html") {
				$options_compose .= " selected=\"selected\"";
			}
			$options_compose .= ">" . $lang['SCompose']['ComposeHTML'] . "</option>";

			if ($allowbrowser == 1) {
				$options_compose .= "<option value=\"wysiwyg\"";
				if ($DefaultComposeMode == "wysiwyg") {
					$options_compose .= " selected=\"selected\"";
				}
				$options_compose .= ">" . $lang['SCompose']['ComposeWYSIWYG'] . "</option>";
			}
			$options_compose .= "</select>";

			// Include original message
			$options_original = "<input type=\"radio\" name=\"o_includeoriginal\" id=\"io_1\" value=\"1\"";
			if ($IncOrig == 1 or !isset($IncOrig)) {
				$options_original .= " checked=\"checked\"";
			}
			$options_original .= " /> <label for=\"io_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_original .= "<input type=\"radio\" name=\"o_includeoriginal\" id=\"io_0\" value=\"0\"";
			if ($IncOrig == 0 && isset($IncOrig)) {
				$options_original .= " checked=\"checked\"";
			}
			$options_original .= " /> <label for=\"io_0\">" . $lang['YesNo'][2] . "</label>";

			// WYSIWYG Font Configuration
			$options_composefont = "<select name=\"o_composefont\"><option value=\"Arial, Helvetica, sans-serif\"";
			if ($ve['c_fontface'] == "Arial, Helvetica, sans-serif" or !isset($ve['c_fontface'])) {
				$options_composefont .= " selected=\"selected\"";
			}
			$options_composefont .= ">Arial, Helvetica, sans-serif</option><option value=\"Times New Roman, Times, serif\"";
			if ($ve['c_fontface'] == "Times New Roman, Times, serif") {
				$options_composefont .= " selected=\"selected\"";
			}
			$options_composefont .= ">Times New Roman, Times, serif</option><option value=\"Courier New, Courier, mono\"";
			if ($ve['c_fontface'] == "Courier New, Courier, mono") {
				$options_composefont .= " selected=\"selected\"";
			}
			$options_composefont .= ">Courier New, Courier, mono</option><option value=\"Georgia, Times New Roman, Times, serif\"";
			if ($ve['c_fontface'] == "Georgia, Times New Roman, Times, serif") {
				$options_composefont .= " selected=\"selected\"";
			}
			$options_composefont .= ">Georgia, Times New Roman, Times, serif</option><option value=\"Verdana, Arial, Helvetica, sans-serif\"";
			if ($ve['c_fontface'] == "Verdana, Arial, Helvetica, sans-serif") {
				$options_composefont .= " selected=\"selected\"";
			}
			$options_composefont .= ">Verdana, Arial, Helvetica, sans-serif</option><option value=\"Geneva, Arial, Helvetica, sans-serif\"";
			if ($ve['c_fontface'] == "Geneva, Arial, Helvetica, sans-serif") {
				$options_composefont .= " selected=\"selected\"";
			}
			$options_composefont .= ">Geneva, Arial, Helvetica, sans-serif</option></select>";

			$options_composesize = "<select name=\"o_composesize\"><option value=\"1\"";
			if ($ve['c_fontsize'] == "1") {
				$options_composesize .= " selected=\"selected\"";
			}
			$options_composesize .= ">1</option><option value=\"2\"";
			if ($ve['c_fontsize'] == "2" or !isset($ve['c_fontsize'])) {
				$options_composesize .= " selected=\"selected\"";
			}
			$options_composesize .= ">2</option><option value=\"3\"";
			if ($ve['c_fontsize'] == "3") {
				$options_composesize .= " selected=\"selected\"";
			}
			$options_composesize .= ">3</option><option value=\"4\"";
			if ($ve['c_fontsize'] == "4") {
				$options_composesize .= " selected=\"selected\"";
			}
			$options_composesize .= ">4</option><option value=\"5\"";
			if ($ve['c_fontsize'] == "5") {
				$options_composesize .= " selected=\"selected\"";
			}
			$options_composesize .= ">5</option><option value=\"6\"";
			if ($ve['c_fontsize'] == "6") {
				$options_composesize .= " selected=\"selected\"";
			}
			$options_composesize .= ">6</option></select>";

			$options_composecolour = "<input type=\"text\" id=\"o_composecolour\" name=\"o_composecolour\" value=\"";
			if (!isset($ve['c_fontcolour'])) {
				$options_composecolour2 = "#000000";
			}
			else {
				$options_composecolour2 = $ve['c_fontcolour'];
			}
			$options_composecolour .= $options_composecolour2. "\"";
			if (strstr($PageDBOptions, '[composecolour]')) {
				$options_composecolour .= " onfocus=\"document.getElementById('composecolour').style.background = document.getElementById('o_composecolour').value;\" onblur=\"document.getElementById('composecolour').style.background = document.getElementById('o_composecolour').value;\"";
			}
			$options_composecolour .= " />";

			$options_replyfont = "<select name=\"o_replyfont\"><option value=\"Arial, Helvetica, sans-serif\"";
			if ($ve['r_fontface'] == "Arial, Helvetica, sans-serif" or !isset($ve['r_fontface'])) {
				$options_replyfont .= " selected=\"selected\"";
			}
			$options_replyfont .= ">Arial, Helvetica, sans-serif</option><option value=\"Times New Roman, Times, serif\"";
			if ($ve['r_fontface'] == "Times New Roman, Times, serif") {
				$options_replyfont .= " selected=\"selected\"";
			}
			$options_replyfont .= ">Times New Roman, Times, serif</option><option value=\"Courier New, Courier, mono\"";
			if ($ve['r_fontface'] == "Courier New, Courier, mono") {
				$options_replyfont .= " selected=\"selected\"";
			}
			$options_replyfont .= ">Courier New, Courier, mono</option><option value=\"Georgia, Times New Roman, Times, serif\"";
			if ($ve['r_fontface'] == "Georgia, Times New Roman, Times, serif") {
				$options_replyfont .= " selected=\"selected\"";
			}
			$options_replyfont .= ">Georgia, Times New Roman, Times, serif</option><option value=\"Verdana, Arial, Helvetica, sans-serif\"";
			if ($ve['r_fontface'] == "Verdana, Arial, Helvetica, sans-serif") {
				$options_replyfont .= " selected=\"selected\"";
			}
			$options_replyfont .= ">Verdana, Arial, Helvetica, sans-serif</option><option value=\"Geneva, Arial, Helvetica, sans-serif\"";
			if ($ve['r_fontface'] == "Geneva, Arial, Helvetica, sans-serif") {
				$options_replyfont .= " selected=\"selected\"";
			}
			$options_replyfont .= ">Geneva, Arial, Helvetica, sans-serif</option></select>";

			$options_replysize = "<select name=\"o_replysize\"><option value=\"1\"";
			if ($ve['r_replysize'] == "1") {
				$options_replysize .= " selected=\"selected\"";
			}
			$options_replysize .= ">1</option><option value=\"2\"";
			if ($ve['r_fontsize'] == "2" or !isset($ve['r_fontsize'])) {
				$options_replysize .= " selected=\"selected\"";
			}
			$options_replysize .= ">2</option><option value=\"3\"";
			if ($ve['r_fontsize'] == "3") {
				$options_replysize .= " selected=\"selected\"";
			}
			$options_replysize .= ">3</option><option value=\"4\"";
			if ($ve['r_fontsize'] == "4") {
				$options_replysize .= " selected=\"selected\"";
			}
			$options_replysize .= ">4</option><option value=\"5\"";
			if ($ve['r_fontsize'] == "5") {
				$options_replysize .= " selected=\"selected\"";
			}
			$options_replysize .= ">5</option><option value=\"6\"";
			if ($ve['r_fontsize'] == "6") {
				$options_replysize .= " selected=\"selected\"";
			}
			$options_replysize .= ">6</option></select>";

			$options_replycolour = "<input type=\"text\" id=\"o_replycolour\" name=\"o_replycolour\" value=\"";
			if (!isset($ve['r_fontcolour'])) {
				$options_replycolour2 = "#0000CC";
			}
			else {
				$options_replycolour2 = $ve['r_fontcolour'];
			}
			$options_replycolour .= $options_replycolour2. "\"";
			if (strstr($PageDBOptions, '[replycolour]')) {
				$options_replycolour .= " onfocus=\"document.getElementById('replycolour').style.background = document.getElementById('o_replycolour').value;\" onblur=\"document.getElementById('replycolour').style.background = document.getElementById('o_replycolour').value;\"";
			}
			$options_replycolour .= " />";


			if (!isset($ReplyTo) || $ReplyTo == "") {
				$ReplyTo = $_SESSION['currentemailaddress'];
			}

			// Display Reply To field
			$options_rt = "<input type=\"radio\" name=\"o_displayrt\" id=\"rt_1\" value=\"1\"";
			if ($DisplayRT == 1 or !isset($DisplayRT)) {
				$options_rt .= " checked=\"checked\"";
			}
			$options_rt .= " /> <label for=\"rt_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_rt .= "<input type=\"radio\" name=\"o_displayrt\" id=\"rt_0\" value=\"0\"";
			if ($DisplayRT == 0 && isset($DisplayRT)) {
				$options_rt .= " checked=\"checked\"";
			}
			$options_rt .= " /> <label for=\"rt_0\">" . $lang['YesNo'][2] . "</label>";

			// Display Bcc field
			$options_bcc = "<input type=\"radio\" name=\"o_displaybcc\" id=\"bcc_1\" value=\"1\"";
			if ($DisplayBcc == 1 or !isset($DisplayBcc)) {
				$options_bcc .= " checked=\"checked\"";
			}
			$options_bcc .= " /> <label for=\"bcc_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_bcc .= "<input type=\"radio\" name=\"o_displaybcc\" id=\"bcc_0\" value=\"0\"";
			if ($DisplayBcc == 0 && isset($DisplayBcc)) {
				$options_bcc .= " checked=\"checked\"";
			}
			$options_bcc .= " /> <label for=\"bcc_0\">" . $lang['YesNo'][2] . "</label>";

			// Save recipients
			$options_sr = "<input type=\"radio\" name=\"o_saverecipients\" id=\"sr_1\" value=\"1\"";
			if ($SaveRecipients == 1 && isset($SaveRecipients)) {
				$options_sr .= " checked=\"checked\"";
			}
			$options_sr .= " /> <label for=\"sr_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_sr .= "<input type=\"radio\" name=\"o_saverecipients\" id=\"sr_0\" value=\"0\"";
			if ($SaveRecipients == 0 or !isset($SaveRecipients)) {
				$options_sr .= " checked=\"checked\"";
			}
			$options_sr .= " /> <label for=\"sr_0\">" . $lang['YesNo'][2] . "</label>";

			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_composemode]", $options_compose, $PageDBOptions);
			$PageDBOptions = str_replace("[options_includeoriginal]", $options_original, $PageDBOptions);
			$PageDBOptions = str_replace("[options_wysiwyg_composefontface]", $options_composefont, $PageDBOptions);
			$PageDBOptions = str_replace("[options_wysiwyg_composefontsize]", $options_composesize, $PageDBOptions);
			$PageDBOptions = str_replace("[options_wysiwyg_composefontcolour]", $options_composecolour, $PageDBOptions);
			$PageDBOptions = str_replace("[options_wysiwyg_replyfontface]", $options_replyfont, $PageDBOptions);
			$PageDBOptions = str_replace("[options_wysiwyg_replyfontsize]", $options_replysize, $PageDBOptions);
			$PageDBOptions = str_replace("[options_wysiwyg_replyfontcolour]", $options_replycolour, $PageDBOptions);
			$PageDBOptions = str_replace("[replycolour]", $options_replycolour2, $PageDBOptions);
			$PageDBOptions = str_replace("[composecolour]", $options_composecolour2, $PageDBOptions);
			$PageDBOptions = str_replace("[options_replyto]", str_replace('"', "", $ReplyTo), $PageDBOptions);
			$PageDBOptions = str_replace("[options_displayreplyto]", $options_rt, $PageDBOptions);
			$PageDBOptions = str_replace("[options_displaybcc]", $options_bcc, $PageDBOptions);
			$PageDBOptions = str_replace("[options_saverecipients]", $options_sr, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}
		if ($_REQUEST['mode'] == "compose_save") {
			$myoptions['DefaultComposeMode'] = $_POST['o_compose'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($myoptions), 'standard');
			$_SESSION['dwmailoptions'] = serialize($myoptions);

			$eoptions['IncOrig'] = $_POST['o_includeoriginal'];
			$eoptions['SaveRecipients'] = $_POST['o_saverecipients'];
			$eoptions['DisplayBcc'] = $_POST['o_displaybcc'];
			$eoptions['DisplayRT'] = $_POST['o_displayrt'];
			$eoptions['ReplyTo'] = $_POST['o_replyto'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
			$_SESSION['extoptions'] = serialize($eoptions);

			$voptions['c_fontface'] = strip_tags($_POST['o_composefont']);
			$voptions['c_fontsize'] = strip_tags($_POST['o_composesize']);
			$voptions['c_fontcolour'] = strip_tags($_POST['o_composecolour']);
			$voptions['r_fontface'] = strip_tags($_POST['o_replyfont']);
			$voptions['r_fontsize'] = strip_tags($_POST['o_replysize']);
			$voptions['r_fontcolour'] = strip_tags($_POST['o_replycolour']);
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($voptions), 'veditor');
			$_SESSION['veoptions'] = serialize($voptions);

			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}

		if ($_REQUEST['mode'] == "filters") {
			require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/compose.inc.php");

			// filters mode
			$options_filters = "<input type=\"radio\" name=\"o_filters\" id=\"fl_1\" value=\"1\"";
			if ($usefilters == 1) {
				$options_filters .= " checked=\"checked\"";
			}
			$options_filters .= " /> <label for=\"fl_1\">" . $lang['YesNo'][1] . "</label><br />";

			$options_filters .= "<input type=\"radio\" name=\"o_filters\" id=\"fl_0\" value=\"0\"";
			if ($usefilters == 0) {
				$options_filters .= " checked=\"checked\"";
			}
			$options_filters .= " /> <label for=\"fl_0\">" . $lang['YesNo'][2] . "</label>";

			$options_filtersto = "<input type=\"checkbox\" name=\"o_filtersto\" value=\"1\" />";
			$options_filterscc = "<input type=\"checkbox\" name=\"o_filterscc\" value=\"1\" />";
			$options_filtersfrom = "<input type=\"checkbox\" name=\"o_filtersfrom\" value=\"1\" />";
			$options_filterssubject = "<input type=\"checkbox\" name=\"o_filterssubject\" value=\"1\" />";
			$options_filtersbody = "<input type=\"checkbox\" name=\"o_filtersbody\" value=\"1\" />";

			$options_needle = "<input type=\"text\" maxsize=\"255\" size=\"70\" name=\"o_filterssearch\" />";

			$options_filtersdelete = "<input type=\"radio\" name=\"o_filtersaction\" value=\"delete\" checked=\"checked\" />";
			$options_filtersmove = "<input type=\"radio\" name=\"o_filtersaction\" value=\"move\" />";

			$options_folders = "<select name=\"o_folders\"><option value=\"\">-- " . $lang['SOptions']['FilderSelFolder'] . " --</option>";
			$folderget = $IMAPConnection->WM_IMAPFolders($IMAPSubscriptions);
			$folders = $IMAPConnection->_folders;
			if (is_array($folders)) {
				sort($folders);
				for($i=0; $i<count($folders); $i++) {
					if ($folders[$i]['name'] <> "INBOX") {
						$options_folders .= "<option value=\"" . $folders[$i]['id'] . "\">" . str_replace("INBOX.", " - ", $folders[$i]['name']) . "</option>\n";
					}
				}
			}
			$options_folders .= "</select>";

			$PageDBOptionsList = $getFile->fileRead('db_optionsfilterslist');
			$MySQLFilterList = $MySQLConnection->DB_GetFilters();

			if (is_array($MySQLFilterList)) {
				while(list($key, $value) = each($MySQLFilterList)) { 
					if ($MySQLFilterList[$key]['action'] == 0) {
						$filtername =$lang['SOptions']['FilterDeleteMess'] . ' ';
					}
					else {
						$filtername = $lang['SOptions']['FilterMoveMess'] . " <b>" . urldecode($MySQLFilterList[$key]['folder']) . "</b> ";
					}
					$filtername .= $lang['SOptions']['FilterWhere'] . ' ';
					if ($MySQLFilterList[$key]['to'] == 1) {
						$filtername .= "<b>" . $lang['SCompose']['To'] . ":</b> ";
					}
					if ($MySQLFilterList[$key]['cc'] == 1) {
						$filtername .= "<b>" . $lang['SCompose']['Cc'] . ":</b> ";
					}
					if ($MySQLFilterList[$key]['from'] == 1) {
						$filtername .= "<b>" . $lang['SCompose']['From'] . ":</b> ";
					}
					if ($MySQLFilterList[$key]['subject'] == 1) {
						$filtername .= "<b>" . $lang['SCompose']['Subject'] . ":</b> ";
					}
					if ($MySQLFilterList[$key]['body'] == 1) {
						$filtername .= "<b>" . $lang['SCompose']['Body'] . ":</b> ";
					}
					$filtername .= $lang['SOptions']['FilterContains'] . " <b>" . $MySQLFilterList[$key]['needle'] . "</b>";

					$CurrentFilter = str_replace ("[options_filterid]", $key, $PageDBOptionsList);
					$CurrentFilter = str_replace ("[options_filtername]", $filtername, $CurrentFilter);

					$FullFilters .= $CurrentFilter;
				}
			}

			$PageDBOptions = $getFile->fileRead('db_optionsfilters');
			$PageDBOptions = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageDBOptions);
			$PageDBOptions = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageDBOptions);
			$PageDBOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageDBOptions);
			$PageDBOptions = str_replace("[options_filters]", $options_filters, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filterto]", $options_filtersto, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filtercc]", $options_filterscc, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filterfrom]", $options_filtersfrom, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filtersubject]", $options_filterssubject, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filterbody]", $options_filtersbody, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filtersearch]", $options_needle, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filterdelete]", $options_filtersdelete, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filtermove]", $options_filtersmove, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filterfolders]", $options_folders, $PageDBOptions);
			$PageDBOptions = str_replace("[options_filterlist]", $FullFilters, $PageDBOptions);
			header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
			echo $PageHeader;

			$PageDBOptions = LangReplace('SOptions', $PageDBOptions, $lang);
			echo $PageDBOptions;
		}

		if ($_REQUEST['mode'] == "filters_save") {
			$eoptions['usefilters'] = $_POST['o_filters'];
			$MySQLUpdate = $MySQLConnection->DB_UpdatePrefs(serialize($eoptions), 'extended');
			$_SESSION['extoptions'] = serialize($eoptions);

			header("Location: ./options.php?" . strip_tags(SID)); 
			exit;
		}

		if ($_REQUEST['mode'] == "filters_create") {
			$needle = strip_tags(stripslashes($_POST['o_filterssearch']));
			$haystack['to'] = $_POST['o_filtersto'];
			$haystack['cc'] = $_POST['o_filterscc'];
			$haystack['from'] = $_POST['o_filtersfrom'];
			$haystack['subject'] = $_POST['o_filterssubject'];
			$haystack['body'] = $_POST['o_filtersbody'];
			$actionpost = $_POST['o_filtersaction'];
			if ($actionpost == "delete") {
				$action = 0;
			}
			else {
				$action = 1;
			}
			$ofolder = $_POST['o_folders'];

			if ($haystack['to'] <> 1 && $haystack['cc'] <> 1 && $haystack['from'] <> 1 && $haystack['subject'] <> 1 && $haystack['body'] <> 1) {
				$errordetail .= "<li>" . $lang['SOptions']['FilterSearchError'] . "</li>";
			}
			if ($needle == "") {
				$errordetail .= "<li>" . $lang['SOptions']['FilterFieldError'] . "</li>";
			}
			if ($action == 1 && $ofolder == "") {
				$errordetail .= "<li>" . $lang['SOptions']['FilterMoveError'] . "</li>";
			}

			if ($errordetail) {
				$PageGenericMessage = $getFile->fileRead('generic_message');
				$PageGenericMessage = str_replace("[pagetitle]", " - " . $lang['SOptions']['TitleFilter'], $PageGenericMessage);
				$returnmessage = "<p>" . $lang['SOptions']['FilterCreateError'] . ":</p><ul>" . $errordetail . "</ul>";
				$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

				header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
				echo $PageHeader;
				echo $PageGenericMessage;
			}
			else {
				$MySQLUpdate = $MySQLConnection->DB_SaveFilter($needle, $haystack, $action, $ofolder);
				header("Location: ./options.php?mode=filters&" . strip_tags(SID)); 
				exit;
			}
		}

		if ($_REQUEST['mode'] == "filters_delete") {
			$selectedfilter = $_POST['selectedfilter'];
			if (!$selectedfilter) {
				$PageGenericMessage = $getFile->fileRead('generic_message');
				$PageGenericMessage = str_replace("[pagetitle]", " - " . $lang['SOptions']['TitleFilter'], $PageGenericMessage);
				$returnmessage = "<p>" . $lang['SOptions']['FilterDeleteError'] . "</p>";
				$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);

				header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
				echo $PageHeader;
				echo $PageGenericMessage;
			}
			else {
				$MySQLDelete = $MySQLConnection->DB_DeleteFilter($selectedfilter);

				header("Location: ./options.php?mode=filters&" . strip_tags(SID)); 
				exit;
			}
		}

	}
	$IMAPConnection->WM_IMAPClose();

	echo $PageFooter;
}
else {
	if ($_POST['restore']) {
		unset ($_SESSION['dwmailoptions']);
			setcookie ("dwmailoptions", "", time() - 3600);	
			$cookieupdate = 1;
	}
	if ($_POST['update']) {
		$myoptions['messagesperpage'] = $_POST['o_messagesperpage'];
		$myoptions['HTMLemail'] = $_POST['o_html'];
		$myoptions['DefaultComposeMode'] = $_POST['o_compose'];
		$myoptions['AllowReadReceipts'] = $_POST['o_read'];
		$myoptions['AllowSentMail'] = $_POST['o_sent'];
		$myoptions['UseTrash'] = $_POST['o_trash'];
		$myoptions['SeperateSignature'] = $_POST['o_signature'];
		$myoptions['MailboxSort'] = $_POST['o_sortby'];
		$myoptions['tz'] = $_POST['o_tz'];

		if ($AllowCookies == 1) {
			$expiretime = 3600 * 8760;
			setcookie ("dwmailoptions", serialize($myoptions), time()+$expiretime);
		}
		$_SESSION['dwmailoptions'] = serialize($myoptions);
		$cookieupdate = 1;
	}

	require ("./includes/options.inc.php");

	$DefaultTemplate = strip_tags(trim($DefaultTemplate));

	$getFile = new fileProperties($DefaultTemplate);
	$PageHeader = $getFile->fileRead('header');
	$PageFooter = $getFile->fileRead('footer');
	$PageCopyright = $getFile->fileRead('copyright');
	$PageOptions = $getFile->fileRead('options');
	$PageMenu = $getFile->fileRead('menu');

	$PageGenericMessage = $getFile->fileRead('generic_message');
	$PageGenericMessage = str_replace("[pagetitle]", " - " . $lang['SOptions']['Title'], $PageGenericMessage);

	$PageMenu = str_replace("[session]", $MainSettings->SessAppend_noecho($TransIDEnabled, 1), $PageMenu);
	$PageMenu = str_replace("[session_append]", $MainSettings->SessAppend_noecho($TransIDEnabled, 0), $PageMenu);

	$PageMenu = str_replace("[emailaddress]", $_SESSION['currentemailaddress'], $PageMenu);

	$PageHeader = str_replace("[mainmenu]", $PageMenu, $PageHeader);
	$PageHeader = str_replace("[header_refresh]", "", $PageHeader);
	$PageHeader = str_replace("[charset]", $_SESSION['DefaultCharSet'], $PageHeader);
	$PageHeader = str_replace("[lang]", $_SESSION['DefaultLang'], $PageHeader);
	$PageHeader = str_replace("[pagetitle]", $lang['SOptions']['Title'], $PageHeader);
	$PageFooter = str_replace("[mainmenu]", $PageMenu, $PageFooter);
	$PageFooter = str_replace("[copyright]", $PageCopyright, $PageFooter);

	if ($AllowExternal == 1 && $UseDatabase == 1) {
		$PageHeader = str_replace("[ifexternal]", "", $PageHeader);
		$PageHeader = str_replace("[/ifexternal]", "", $PageHeader);
		$PageFooter = str_replace("[ifexternal]", "", $PageFooter);
		$PageFooter = str_replace("[/ifexternal]", "", $PageFooter);
	}
	else {
		$PageHeader = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageHeader);
		$PageFooter = preg_replace("/(\[)(ifexternal)(])(\r\n)*(.*)(\[\/ifexternal\])/siU", "", $PageFooter);
	}

	$genericerror = $getFile->fileRead('generic_message');
	$genericerror = str_replace ('[pagetitle]', $lang['SErrors']['Title'], $genericerror);

	$error_session = str_replace ('[pagemessage]', $lang['SErrors']['Session'], $genericerror);
	CheckValidSession($_SESSION, $PageFooter, $error_session, $PageHeader, $lang);

	$IMAPConnection = new WM_IMAPConnection($_SESSION);
	$securitycheck = $IMAPConnection->WM_IMAPCheckSecurity();

	$error_ipfailuresession = str_replace ('[pagemessage]', $lang['SErrors']['IP'], $genericerror);
	CheckSessionSecurity($securitycheck, $PageFooter, $error_ipfailure, $PageHeader, $lang);

	$mailbox = $IMAPConnection->WM_IMAPConnect();

	checkmailbox_active($mailbox, $IMAPConnection, $PageHeader, $DefaultTemplate, $PageFooter, $getFile, $lang, $genericerror);

	include ("./includes/folderpane.inc.php");
	$PageHeader = str_replace ("[folders]", $PageFolderPane, $PageHeader);
	$PageHeader = LangReplace('Generic', $PageHeader, $lang);
	$PageHeader = LangReplace('SFolderPane', $PageHeader, $lang);
	$PageFooter = LangReplace('Generic', $PageFooter, $lang);
	$PageFooter = LangReplace('SFolderPane', $PageFooter, $lang);

	require ("./lang/" . strip_tags(str_replace("..", "", trim($_SESSION['DefaultLang']))) . "/compose.inc.php");

	header ("Content-Type: text/html; charset=" . $_SESSION['DefaultCharSet']);
	echo $PageHeader;

	$IMAPConnection->WM_IMAPClose();

	if ($AllowUserOptions == 1) {

		// Trash
		$options_trash = "<select name=\"o_trash\"><option value=\"1\"";
		if ($UseTrash == 1) {
			$options_trash .= " selected=\"selected\"";
		}
		$options_trash .= ">" . $lang['YesNo'][1] . "</option>";

		$options_trash .= "<option value=\"0\"";
		if ($UseTrash == 0) {
			$options_trash .= " selected=\"selected\"";
		}
		$options_trash .= ">" . $lang['YesNo'][2] . "</option></select>";

		// Sort by
		$options_sortby = "<select name=\"o_sortby\"><option value=\"SORTARRIVAL\"";
		if ($MailboxSort == "SORTARRIVAL") {
			$options_sortby .= " selected=\"selected\"";
		}
		$options_sortby .= ">" . $lang['SOptions']['Sort'][1] . "</option>";

		$options_sortby .= "<option value=\"SORTDATE\"";
		if ($MailboxSort == "SORTDATE") {
			$options_sortby .= " selected=\"selected\"";
		}
		$options_sortby .= ">" . $lang['SOptions']['Sort'][2] . "</option>";

		$options_sortby .= "<option value=\"SORTSIZE\"";
		if ($MailboxSort == "SORTSIZE") {
			$options_sortby .= " selected=\"selected\"";
		}
		$options_sortby .= ">" . $lang['SOptions']['Sort'][3] . "</option>";

		$options_sortby .= "<option value=\"SORTSUBJECT\"";
		if ($MailboxSort == "SORTSUBJECT") {
			$options_sortby .= " selected=\"selected\"";
		}
		$options_sortby .= ">" . $lang['SOptions']['Sort'][4] . "</option>";

		$options_sortby .= "<option value=\"SORTFROM\"";
		if ($MailboxSort == "SORTFROM") {
			$options_sortby .= " selected=\"selected\"";
		}
		$options_sortby .= ">" . $lang['SOptions']['Sort'][5] . "</option></select>";

		// Timezone
		$options_tz = "<select name=\"o_tz\">";
		while(list($key, $value) = each($tz_arry)) { 
			$options_tz .= "<option value=\"$key\"";
			if ($tz == $key) {
				$options_tz .= " selected=\"selected\"";
			}
			$options_tz .= ">$value</option>";
		}
		$options_tz .= "</select>";

		// Compose mode
		$options_compose = "<select name=\"o_compose\"><option value=\"text\"";
		if ($DefaultComposeMode == "text") {
			$options_compose .= " selected=\"selected\"";
		}
		$options_compose .= ">" . $lang['SCompose']['ComposePlain'] . "</option>";

		$options_compose .= "<option value=\"html\"";
		if ($DefaultComposeMode == "html") {
			$options_compose .= " selected=\"selected\"";
		}
		$options_compose .= ">" . $lang['SCompose']['ComposeHTML'] . "</option>";

		if ($allowbrowser == 1) {
			$options_compose .= "<option value=\"veditor\"";
			if ($DefaultComposeMode == "veditor") {
				$options_compose .= " selected=\"selected\"";
			}
			$options_compose .= ">" . $lang['SCompose']['ComposeWYSIWYG'] . "</option>";
		}
		$options_compose .= "</select>";

		// Save sent
		$options_sent = "<select name=\"o_sent\"><option value=1";
		if ($AllowSentMail == 1) {
			$options_sent .= " selected=\"selected\"";
		}
		$options_sent .= ">" . $lang['YesNo'][1] . "</option>";

		$options_sent .= "<option value=\"0\"";
		if ($AllowSentMail == 0) {
			$options_sent .= " selected=\"selected\"";
		}
		$options_sent .= ">" . $lang['YesNo'][2] . "</option></select>";

		// View HTML message mode
		$options_html = "<select name=\"o_html\"><option value=\"1\"";
		if ($HTMLemail == 1) {
			$options_html .= " selected=\"selected\"";
		}
		$options_html .= ">" . $lang['SOptions']['View'][1] . "</option>";

		$options_html .= "<option value=\"5\"";
		if ($HTMLemail == 5) {
			$options_html .= " selected=\"selected\"";
		}
		$options_html .= ">" . $lang['SOptions']['View'][2] . "</option>";

		$options_html .= "<option value=\"2\"";
		if ($HTMLemail == 2) {
			$options_html .= " selected=\"selected\"";
		}
		$options_html .= ">" . $lang['SOptions']['View'][3] . "</option>";

		$options_html .= "<option value=\"3\"";
		if ($HTMLemail == 3) {
			$options_html .= " selected=\"selected\"";
		}
		$options_html .= ">" . $lang['SOptions']['View'][4] . "</option>";

		$options_html .= "<option value=\"4\"";
		if ($HTMLemail == 4) {
			$options_html .= " selected=\"selected\"";
		}
		$options_html .= ">" . $lang['SOptions']['View'][5] . "</option></select>";

		// Read receipts
		$options_read = "<select name=\"o_read\"><option value=\"1\"";
		if ($AllowReadReceipts == 1) {
			$options_read .= " selected=\"selected\"";
		}
		$options_read .= ">" . $lang['YesNo'][1] . "</option>";

		$options_read .= "<option value=\"0\"";
		if ($AllowReadReceipts == 0) {
			$options_read .= " selected=\"selected\"";
		}
		$options_read .= ">" . $lang['YesNo'][2] . "</option></select>";

		// Seperate signature
		$options_sig = "<select name=\"o_signature\"><option value=\"1\"";
		if ($SeperateSignature == 1) {
			$options_sig .= " selected=\"selected\"";
		}
		$options_sig .= ">" . $lang['YesNo'][1] . "</option>";

		$options_sig .= "<option value=\"0\"";
		if ($SeperateSignature == 0) {
			$options_sig .= " selected=\"selected\"";
		}
		$options_sig .= ">" . $lang['YesNo'][2] . "</option></select>";

		$PageOptions = str_replace("[session_form]", $MainSettings->SessAppend_form($TransIDEnabled), $PageOptions);
		$PageOptions = str_replace("[options_messagesperpage]", $messagesperpage, $PageOptions);
		$PageOptions = str_replace("[options_trash]", $options_trash, $PageOptions);
		$PageOptions = str_replace("[options_sortby]", $options_sortby, $PageOptions);
		$PageOptions = str_replace("[options_composemode]", $options_compose, $PageOptions);
		$PageOptions = str_replace("[options_sentmail]", $options_sent, $PageOptions);
		$PageOptions = str_replace("[options_html]", $options_html, $PageOptions);
		$PageOptions = str_replace("[options_readreceipts]", $options_read, $PageOptions);
		$PageOptions = str_replace("[options_seperatesignature]", $options_sig, $PageOptions);
		$PageOptions = str_replace("[options_timezone]", $options_tz, $PageOptions);

		$PageOptions = LangReplace('SOptions', $PageOptions, $lang);
		echo $PageOptions;
		echo $PageFooter;
	}
	else {
		$returnmessage = $lang['SErrors']['Options'];
		$PageGenericMessage = str_replace("[pagemessage]", $returnmessage, $PageGenericMessage);
		echo $PageGenericMessage;
		echo $PageFooter;
	}
}
?>